# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FhirServiceArgs', 'FhirService']

@pulumi.input_type
class FhirServiceArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['FhirServiceAuthenticationArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 access_policy_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configuration_export_storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_login_server_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cors: Optional[pulumi.Input['FhirServiceCorsArgs']] = None,
                 identity: Optional[pulumi.Input['FhirServiceIdentityArgs']] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FhirService resource.
        :param pulumi.Input['FhirServiceAuthenticationArgs'] authentication: An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which to create the Healthcare FHIR Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the id of the Healthcare Workspace where the Healthcare FHIR Service should exist. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] access_policy_object_ids: A list of the access policies of the service instance.
        :param pulumi.Input[_builtins.str] configuration_export_storage_account_name: Specifies the name of the storage account which the operation configuration information is exported to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] container_registry_login_server_urls: A list of azure container registry settings used for convert data operation of the service instance.
        :param pulumi.Input['FhirServiceCorsArgs'] cors: A `cors` block as defined below.
        :param pulumi.Input['FhirServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: Specifies the kind of the Healthcare FHIR Service. Possible values are: `fhir-Stu3` and `fhir-R4`. Defaults to `fhir-R4`. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare FHIR Service should be created. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare FHIR Service. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]] oci_artifacts: [A list](https://www.terraform.io/docs/configuration/attr-as-blocks.html) of `oci_artifact` objects as defined below to describe [OCI artifacts for export](https://learn.microsoft.com/en-gb/azure/healthcare-apis/fhir/de-identified-export).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare FHIR Service.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if access_policy_object_ids is not None:
            pulumi.set(__self__, "access_policy_object_ids", access_policy_object_ids)
        if configuration_export_storage_account_name is not None:
            pulumi.set(__self__, "configuration_export_storage_account_name", configuration_export_storage_account_name)
        if container_registry_login_server_urls is not None:
            pulumi.set(__self__, "container_registry_login_server_urls", container_registry_login_server_urls)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oci_artifacts is not None:
            pulumi.set(__self__, "oci_artifacts", oci_artifacts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['FhirServiceAuthenticationArgs']:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['FhirServiceAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group in which to create the Healthcare FHIR Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the id of the Healthcare Workspace where the Healthcare FHIR Service should exist. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicyObjectIds")
    def access_policy_object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the access policies of the service instance.
        """
        return pulumi.get(self, "access_policy_object_ids")

    @access_policy_object_ids.setter
    def access_policy_object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "access_policy_object_ids", value)

    @_builtins.property
    @pulumi.getter(name="configurationExportStorageAccountName")
    def configuration_export_storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the storage account which the operation configuration information is exported to.
        """
        return pulumi.get(self, "configuration_export_storage_account_name")

    @configuration_export_storage_account_name.setter
    def configuration_export_storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_export_storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryLoginServerUrls")
    def container_registry_login_server_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of azure container registry settings used for convert data operation of the service instance.
        """
        return pulumi.get(self, "container_registry_login_server_urls")

    @container_registry_login_server_urls.setter
    def container_registry_login_server_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "container_registry_login_server_urls", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['FhirServiceCorsArgs']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['FhirServiceCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FhirServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FhirServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the kind of the Healthcare FHIR Service. Possible values are: `fhir-Stu3` and `fhir-R4`. Defaults to `fhir-R4`. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Healthcare FHIR Service should be created. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare FHIR Service. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ociArtifacts")
    def oci_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]]]:
        """
        [A list](https://www.terraform.io/docs/configuration/attr-as-blocks.html) of `oci_artifact` objects as defined below to describe [OCI artifacts for export](https://learn.microsoft.com/en-gb/azure/healthcare-apis/fhir/de-identified-export).
        """
        return pulumi.get(self, "oci_artifacts")

    @oci_artifacts.setter
    def oci_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]]]):
        pulumi.set(self, "oci_artifacts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Healthcare FHIR Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FhirServiceState:
    def __init__(__self__, *,
                 access_policy_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authentication: Optional[pulumi.Input['FhirServiceAuthenticationArgs']] = None,
                 configuration_export_storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_login_server_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cors: Optional[pulumi.Input['FhirServiceCorsArgs']] = None,
                 identity: Optional[pulumi.Input['FhirServiceIdentityArgs']] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FhirService resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] access_policy_object_ids: A list of the access policies of the service instance.
        :param pulumi.Input['FhirServiceAuthenticationArgs'] authentication: An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] configuration_export_storage_account_name: Specifies the name of the storage account which the operation configuration information is exported to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] container_registry_login_server_urls: A list of azure container registry settings used for convert data operation of the service instance.
        :param pulumi.Input['FhirServiceCorsArgs'] cors: A `cors` block as defined below.
        :param pulumi.Input['FhirServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: Specifies the kind of the Healthcare FHIR Service. Possible values are: `fhir-Stu3` and `fhir-R4`. Defaults to `fhir-R4`. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare FHIR Service should be created. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare FHIR Service. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]] oci_artifacts: [A list](https://www.terraform.io/docs/configuration/attr-as-blocks.html) of `oci_artifact` objects as defined below to describe [OCI artifacts for export](https://learn.microsoft.com/en-gb/azure/healthcare-apis/fhir/de-identified-export).
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public networks access is enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which to create the Healthcare FHIR Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare FHIR Service.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the id of the Healthcare Workspace where the Healthcare FHIR Service should exist. Changing this forces a new Healthcare FHIR Service to be created.
        """
        if access_policy_object_ids is not None:
            pulumi.set(__self__, "access_policy_object_ids", access_policy_object_ids)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if configuration_export_storage_account_name is not None:
            pulumi.set(__self__, "configuration_export_storage_account_name", configuration_export_storage_account_name)
        if container_registry_login_server_urls is not None:
            pulumi.set(__self__, "container_registry_login_server_urls", container_registry_login_server_urls)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oci_artifacts is not None:
            pulumi.set(__self__, "oci_artifacts", oci_artifacts)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="accessPolicyObjectIds")
    def access_policy_object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the access policies of the service instance.
        """
        return pulumi.get(self, "access_policy_object_ids")

    @access_policy_object_ids.setter
    def access_policy_object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "access_policy_object_ids", value)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['FhirServiceAuthenticationArgs']]:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['FhirServiceAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="configurationExportStorageAccountName")
    def configuration_export_storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the storage account which the operation configuration information is exported to.
        """
        return pulumi.get(self, "configuration_export_storage_account_name")

    @configuration_export_storage_account_name.setter
    def configuration_export_storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_export_storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryLoginServerUrls")
    def container_registry_login_server_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of azure container registry settings used for convert data operation of the service instance.
        """
        return pulumi.get(self, "container_registry_login_server_urls")

    @container_registry_login_server_urls.setter
    def container_registry_login_server_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "container_registry_login_server_urls", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['FhirServiceCorsArgs']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['FhirServiceCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FhirServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FhirServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the kind of the Healthcare FHIR Service. Possible values are: `fhir-Stu3` and `fhir-R4`. Defaults to `fhir-R4`. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Healthcare FHIR Service should be created. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare FHIR Service. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ociArtifacts")
    def oci_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]]]:
        """
        [A list](https://www.terraform.io/docs/configuration/attr-as-blocks.html) of `oci_artifact` objects as defined below to describe [OCI artifacts for export](https://learn.microsoft.com/en-gb/azure/healthcare-apis/fhir/de-identified-export).
        """
        return pulumi.get(self, "oci_artifacts")

    @oci_artifacts.setter
    def oci_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FhirServiceOciArtifactArgs']]]]):
        pulumi.set(self, "oci_artifacts", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public networks access is enabled.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group in which to create the Healthcare FHIR Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Healthcare FHIR Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id of the Healthcare Workspace where the Healthcare FHIR Service should exist. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:healthcare/fhirService:FhirService")
class FhirService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authentication: Optional[pulumi.Input[Union['FhirServiceAuthenticationArgs', 'FhirServiceAuthenticationArgsDict']]] = None,
                 configuration_export_storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_login_server_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cors: Optional[pulumi.Input[Union['FhirServiceCorsArgs', 'FhirServiceCorsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FhirServiceIdentityArgs', 'FhirServiceIdentityArgsDict']]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirServiceOciArtifactArgs', 'FhirServiceOciArtifactArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Healthcare FHIR (Fast Healthcare Interoperability Resources) Service

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        current = azure.core.get_client_config()
        example_workspace = azure.healthcare.Workspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_fhir_service = azure.healthcare.FhirService("example",
            name="tfexfhir",
            location="east us",
            resource_group_name="tfex-resource_group",
            workspace_id=example_workspace.id,
            kind="fhir-R4",
            authentication={
                "authority": "https://login.microsoftonline.com/tenantId",
                "audience": "https://tfexfhir.fhir.azurehealthcareapis.com",
            },
            access_policy_object_ids=[current.object_id],
            identity={
                "type": "SystemAssigned",
            },
            container_registry_login_server_urls=["tfex-container_registry_login_server"],
            cors={
                "allowed_origins": [
                    "https://tfex.com:123",
                    "https://tfex1.com:3389",
                ],
                "allowed_headers": ["*"],
                "allowed_methods": [
                    "GET",
                    "DELETE",
                    "PUT",
                ],
                "max_age_in_seconds": 3600,
                "credentials_allowed": True,
            },
            configuration_export_storage_account_name="storage_account_name")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HealthcareApis` - 2022-12-01

        ## Import

        Healthcare FHIR Service can be imported using the resource`id`, e.g.

        ```sh
        $ pulumi import azure:healthcare/fhirService:FhirService example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.HealthcareApis/workspaces/workspace1/fhirServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] access_policy_object_ids: A list of the access policies of the service instance.
        :param pulumi.Input[Union['FhirServiceAuthenticationArgs', 'FhirServiceAuthenticationArgsDict']] authentication: An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] configuration_export_storage_account_name: Specifies the name of the storage account which the operation configuration information is exported to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] container_registry_login_server_urls: A list of azure container registry settings used for convert data operation of the service instance.
        :param pulumi.Input[Union['FhirServiceCorsArgs', 'FhirServiceCorsArgsDict']] cors: A `cors` block as defined below.
        :param pulumi.Input[Union['FhirServiceIdentityArgs', 'FhirServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: Specifies the kind of the Healthcare FHIR Service. Possible values are: `fhir-Stu3` and `fhir-R4`. Defaults to `fhir-R4`. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare FHIR Service should be created. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare FHIR Service. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FhirServiceOciArtifactArgs', 'FhirServiceOciArtifactArgsDict']]]] oci_artifacts: [A list](https://www.terraform.io/docs/configuration/attr-as-blocks.html) of `oci_artifact` objects as defined below to describe [OCI artifacts for export](https://learn.microsoft.com/en-gb/azure/healthcare-apis/fhir/de-identified-export).
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which to create the Healthcare FHIR Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare FHIR Service.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the id of the Healthcare Workspace where the Healthcare FHIR Service should exist. Changing this forces a new Healthcare FHIR Service to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FhirServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Healthcare FHIR (Fast Healthcare Interoperability Resources) Service

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        current = azure.core.get_client_config()
        example_workspace = azure.healthcare.Workspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_fhir_service = azure.healthcare.FhirService("example",
            name="tfexfhir",
            location="east us",
            resource_group_name="tfex-resource_group",
            workspace_id=example_workspace.id,
            kind="fhir-R4",
            authentication={
                "authority": "https://login.microsoftonline.com/tenantId",
                "audience": "https://tfexfhir.fhir.azurehealthcareapis.com",
            },
            access_policy_object_ids=[current.object_id],
            identity={
                "type": "SystemAssigned",
            },
            container_registry_login_server_urls=["tfex-container_registry_login_server"],
            cors={
                "allowed_origins": [
                    "https://tfex.com:123",
                    "https://tfex1.com:3389",
                ],
                "allowed_headers": ["*"],
                "allowed_methods": [
                    "GET",
                    "DELETE",
                    "PUT",
                ],
                "max_age_in_seconds": 3600,
                "credentials_allowed": True,
            },
            configuration_export_storage_account_name="storage_account_name")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HealthcareApis` - 2022-12-01

        ## Import

        Healthcare FHIR Service can be imported using the resource`id`, e.g.

        ```sh
        $ pulumi import azure:healthcare/fhirService:FhirService example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.HealthcareApis/workspaces/workspace1/fhirServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param FhirServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FhirServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authentication: Optional[pulumi.Input[Union['FhirServiceAuthenticationArgs', 'FhirServiceAuthenticationArgsDict']]] = None,
                 configuration_export_storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_login_server_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cors: Optional[pulumi.Input[Union['FhirServiceCorsArgs', 'FhirServiceCorsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FhirServiceIdentityArgs', 'FhirServiceIdentityArgsDict']]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirServiceOciArtifactArgs', 'FhirServiceOciArtifactArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FhirServiceArgs.__new__(FhirServiceArgs)

            __props__.__dict__["access_policy_object_ids"] = access_policy_object_ids
            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["configuration_export_storage_account_name"] = configuration_export_storage_account_name
            __props__.__dict__["container_registry_login_server_urls"] = container_registry_login_server_urls
            __props__.__dict__["cors"] = cors
            __props__.__dict__["identity"] = identity
            __props__.__dict__["kind"] = kind
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["oci_artifacts"] = oci_artifacts
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["public_network_access_enabled"] = None
        super(FhirService, __self__).__init__(
            'azure:healthcare/fhirService:FhirService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authentication: Optional[pulumi.Input[Union['FhirServiceAuthenticationArgs', 'FhirServiceAuthenticationArgsDict']]] = None,
            configuration_export_storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            container_registry_login_server_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cors: Optional[pulumi.Input[Union['FhirServiceCorsArgs', 'FhirServiceCorsArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['FhirServiceIdentityArgs', 'FhirServiceIdentityArgsDict']]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FhirServiceOciArtifactArgs', 'FhirServiceOciArtifactArgsDict']]]]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FhirService':
        """
        Get an existing FhirService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] access_policy_object_ids: A list of the access policies of the service instance.
        :param pulumi.Input[Union['FhirServiceAuthenticationArgs', 'FhirServiceAuthenticationArgsDict']] authentication: An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] configuration_export_storage_account_name: Specifies the name of the storage account which the operation configuration information is exported to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] container_registry_login_server_urls: A list of azure container registry settings used for convert data operation of the service instance.
        :param pulumi.Input[Union['FhirServiceCorsArgs', 'FhirServiceCorsArgsDict']] cors: A `cors` block as defined below.
        :param pulumi.Input[Union['FhirServiceIdentityArgs', 'FhirServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: Specifies the kind of the Healthcare FHIR Service. Possible values are: `fhir-Stu3` and `fhir-R4`. Defaults to `fhir-R4`. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare FHIR Service should be created. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare FHIR Service. Changing this forces a new Healthcare FHIR Service to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FhirServiceOciArtifactArgs', 'FhirServiceOciArtifactArgsDict']]]] oci_artifacts: [A list](https://www.terraform.io/docs/configuration/attr-as-blocks.html) of `oci_artifact` objects as defined below to describe [OCI artifacts for export](https://learn.microsoft.com/en-gb/azure/healthcare-apis/fhir/de-identified-export).
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public networks access is enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which to create the Healthcare FHIR Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare FHIR Service.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the id of the Healthcare Workspace where the Healthcare FHIR Service should exist. Changing this forces a new Healthcare FHIR Service to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FhirServiceState.__new__(_FhirServiceState)

        __props__.__dict__["access_policy_object_ids"] = access_policy_object_ids
        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["configuration_export_storage_account_name"] = configuration_export_storage_account_name
        __props__.__dict__["container_registry_login_server_urls"] = container_registry_login_server_urls
        __props__.__dict__["cors"] = cors
        __props__.__dict__["identity"] = identity
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["oci_artifacts"] = oci_artifacts
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_id"] = workspace_id
        return FhirService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicyObjectIds")
    def access_policy_object_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the access policies of the service instance.
        """
        return pulumi.get(self, "access_policy_object_ids")

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.FhirServiceAuthentication']:
        """
        An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter(name="configurationExportStorageAccountName")
    def configuration_export_storage_account_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the storage account which the operation configuration information is exported to.
        """
        return pulumi.get(self, "configuration_export_storage_account_name")

    @_builtins.property
    @pulumi.getter(name="containerRegistryLoginServerUrls")
    def container_registry_login_server_urls(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of azure container registry settings used for convert data operation of the service instance.
        """
        return pulumi.get(self, "container_registry_login_server_urls")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional['outputs.FhirServiceCors']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.FhirServiceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the kind of the Healthcare FHIR Service. Possible values are: `fhir-Stu3` and `fhir-R4`. Defaults to `fhir-R4`. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Healthcare FHIR Service should be created. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Healthcare FHIR Service. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ociArtifacts")
    def oci_artifacts(self) -> pulumi.Output[Optional[Sequence['outputs.FhirServiceOciArtifact']]]:
        """
        [A list](https://www.terraform.io/docs/configuration/attr-as-blocks.html) of `oci_artifact` objects as defined below to describe [OCI artifacts for export](https://learn.microsoft.com/en-gb/azure/healthcare-apis/fhir/de-identified-export).
        """
        return pulumi.get(self, "oci_artifacts")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether public networks access is enabled.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group in which to create the Healthcare FHIR Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Healthcare FHIR Service.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the id of the Healthcare Workspace where the Healthcare FHIR Service should exist. Changing this forces a new Healthcare FHIR Service to be created.
        """
        return pulumi.get(self, "workspace_id")

