# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CacheBlobNfsTargetArgs', 'CacheBlobNfsTarget']

@pulumi.input_type
class CacheBlobNfsTargetArgs:
    def __init__(__self__, *,
                 cache_name: pulumi.Input[_builtins.str],
                 namespace_path: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 storage_container_id: pulumi.Input[_builtins.str],
                 usage_model: pulumi.Input[_builtins.str],
                 access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a CacheBlobNfsTarget resource.
        :param pulumi.Input[_builtins.str] cache_name: The name of the HPC Cache, which the HPC Cache Blob NFS Target will be added to. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] namespace_path: The client-facing file path of the HPC Cache Blob NFS Target.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the HPC Cache Blob NFS Target should exist. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] storage_container_id: The Resource Manager ID of the Storage Container used as the HPC Cache Blob NFS Target. Changing this forces a new resource to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache Blob NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.str] access_policy_name: The name of the access policy applied to this target. Defaults to `default`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this HPC Cache Blob NFS Target. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        pulumi.set(__self__, "cache_name", cache_name)
        pulumi.set(__self__, "namespace_path", namespace_path)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_container_id", storage_container_id)
        pulumi.set(__self__, "usage_model", usage_model)
        if access_policy_name is not None:
            pulumi.set(__self__, "access_policy_name", access_policy_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if verification_timer_in_seconds is not None:
            pulumi.set(__self__, "verification_timer_in_seconds", verification_timer_in_seconds)
        if write_back_timer_in_seconds is not None:
            pulumi.set(__self__, "write_back_timer_in_seconds", write_back_timer_in_seconds)

    @_builtins.property
    @pulumi.getter(name="cacheName")
    def cache_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the HPC Cache, which the HPC Cache Blob NFS Target will be added to. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "cache_name")

    @cache_name.setter
    def cache_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cache_name", value)

    @_builtins.property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> pulumi.Input[_builtins.str]:
        """
        The client-facing file path of the HPC Cache Blob NFS Target.
        """
        return pulumi.get(self, "namespace_path")

    @namespace_path.setter
    def namespace_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_path", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the HPC Cache Blob NFS Target should exist. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Resource Manager ID of the Storage Container used as the HPC Cache Blob NFS Target. Changing this forces a new resource to be created.

        > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        """
        return pulumi.get(self, "storage_container_id")

    @storage_container_id.setter
    def storage_container_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container_id", value)

    @_builtins.property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> pulumi.Input[_builtins.str]:
        """
        The type of usage of the HPC Cache Blob NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "usage_model", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicyName")
    def access_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the access policy applied to this target. Defaults to `default`.
        """
        return pulumi.get(self, "access_policy_name")

    @access_policy_name.setter
    def access_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this HPC Cache Blob NFS Target. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="verificationTimerInSeconds")
    def verification_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "verification_timer_in_seconds")

    @verification_timer_in_seconds.setter
    def verification_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "verification_timer_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="writeBackTimerInSeconds")
    def write_back_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "write_back_timer_in_seconds")

    @write_back_timer_in_seconds.setter
    def write_back_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_back_timer_in_seconds", value)


@pulumi.input_type
class _CacheBlobNfsTargetState:
    def __init__(__self__, *,
                 access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_path: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CacheBlobNfsTarget resources.
        :param pulumi.Input[_builtins.str] access_policy_name: The name of the access policy applied to this target. Defaults to `default`.
        :param pulumi.Input[_builtins.str] cache_name: The name of the HPC Cache, which the HPC Cache Blob NFS Target will be added to. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this HPC Cache Blob NFS Target. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] namespace_path: The client-facing file path of the HPC Cache Blob NFS Target.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the HPC Cache Blob NFS Target should exist. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] storage_container_id: The Resource Manager ID of the Storage Container used as the HPC Cache Blob NFS Target. Changing this forces a new resource to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache Blob NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        if access_policy_name is not None:
            pulumi.set(__self__, "access_policy_name", access_policy_name)
        if cache_name is not None:
            pulumi.set(__self__, "cache_name", cache_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_path is not None:
            pulumi.set(__self__, "namespace_path", namespace_path)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if storage_container_id is not None:
            pulumi.set(__self__, "storage_container_id", storage_container_id)
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)
        if verification_timer_in_seconds is not None:
            pulumi.set(__self__, "verification_timer_in_seconds", verification_timer_in_seconds)
        if write_back_timer_in_seconds is not None:
            pulumi.set(__self__, "write_back_timer_in_seconds", write_back_timer_in_seconds)

    @_builtins.property
    @pulumi.getter(name="accessPolicyName")
    def access_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the access policy applied to this target. Defaults to `default`.
        """
        return pulumi.get(self, "access_policy_name")

    @access_policy_name.setter
    def access_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="cacheName")
    def cache_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the HPC Cache, which the HPC Cache Blob NFS Target will be added to. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "cache_name")

    @cache_name.setter
    def cache_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this HPC Cache Blob NFS Target. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client-facing file path of the HPC Cache Blob NFS Target.
        """
        return pulumi.get(self, "namespace_path")

    @namespace_path.setter
    def namespace_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_path", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the HPC Cache Blob NFS Target should exist. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Resource Manager ID of the Storage Container used as the HPC Cache Blob NFS Target. Changing this forces a new resource to be created.

        > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        """
        return pulumi.get(self, "storage_container_id")

    @storage_container_id.setter
    def storage_container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_id", value)

    @_builtins.property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of usage of the HPC Cache Blob NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_model", value)

    @_builtins.property
    @pulumi.getter(name="verificationTimerInSeconds")
    def verification_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "verification_timer_in_seconds")

    @verification_timer_in_seconds.setter
    def verification_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "verification_timer_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="writeBackTimerInSeconds")
    def write_back_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "write_back_timer_in_seconds")

    @write_back_timer_in_seconds.setter
    def write_back_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_back_timer_in_seconds", value)


@pulumi.type_token("azure:hpc/cacheBlobNfsTarget:CacheBlobNfsTarget")
class CacheBlobNfsTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_path: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Blob NFSv3 Target within a HPC Cache.

        !> **Note:** The `hpc.CacheBlobNfsTarget` resource has been deprecated because the service is retiring on 2025-09-30. This resource will be removed in v5.0 of the AzureRM Provider. See https://aka.ms/hpccacheretirement for more information.

        > **Note:** By request of the service team the provider no longer automatically registers the `Microsoft.StorageCache` Resource Provider for this resource. To register it you can run `az provider register --namespace 'Microsoft.StorageCache'`.

        > **Note:** This resource depends on the NFSv3 enabled Storage Account, which has some prerequisites need to meet. Please checkout: <https://docs.microsoft.com/azure/storage/blobs/network-file-system-protocol-support-how-to?tabs=azure-powershell>.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure
        import pulumi_azuread as azuread
        import pulumi_std as std

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"])
        example = azuread.get_service_principal(display_name="HPC Cache Resource Provider")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_kind="StorageV2",
            account_replication_type="LRS",
            is_hns_enabled=True,
            nfsv3_enabled=True,
            enable_https_traffic_only=False,
            network_rules={
                "default_action": "Deny",
                "virtual_network_subnet_ids": [example_subnet.id],
            })
        # Due to https://github.com/hashicorp/terraform-provider-azurerm/issues/2977 and the fact
        # that the NFSv3 enabled storage account can't allow public network access - otherwise the NFSv3 protocol will fail,
        # we have to use the ARM template to deploy the storage container as a workaround.
        # Once the issue above got resolved, we can instead use the azurerm_storage_container resource.
        storage_containers = azure.core.ResourceGroupTemplateDeployment("storage-containers",
            name="example-deployment",
            resource_group_name=example_account.resource_group_name,
            deployment_mode="Incremental",
            parameters_content=pulumi.Output.json_dumps({
                "location": {
                    "value": example_account.location,
                },
                "storageAccountName": {
                    "value": example_account.name,
                },
                "containerName": {
                    "value": "example-container",
                },
            }),
            template_content=\"\"\"{
          \\"$schema\\": \\"https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#\\",
          \\"contentVersion\\": \\"1.0.0.0\\",
          \\"parameters\\": {
            \\"storageAccountName\\": {
              \\"type\\": \\"String\\"
            },
            \\"containerName\\": {
              \\"type\\": \\"String\\"
            },
            \\"location\\": {
              \\"type\\": \\"String\\"
            }
          },
          \\"resources\\": [
            {
              \\"type\\": \\"Microsoft.Storage/storageAccounts\\",
              \\"apiVersion\\": \\"2019-06-01\\",
              \\"name\\": \\"[parameters('storageAccountName')]\\",
              \\"location\\": \\"[parameters('location')]\\",
              \\"sku\\": {
                \\"name\\": \\"Standard_LRS\\",
                \\"tier\\": \\"Standard\\"
              },
              \\"kind\\": \\"StorageV2\\",
              \\"properties\\": {
                \\"accessTier\\": \\"Hot\\"
              },
              \\"resources\\": [
                {
                  \\"type\\": \\"blobServices/containers\\",
                  \\"apiVersion\\": \\"2019-06-01\\",
                  \\"name\\": \\"[concat('default/', parameters('containerName'))]\\",
                  \\"dependsOn\\": [
                    \\"[parameters('storageAccountName')]\\"
                  ]
                }
              ]
            }
          ],

          \\"outputs\\": {
            \\"id\\": {
              \\"type\\": \\"String\\",
              \\"value\\": \\"[resourceId('Microsoft.Storage/storageAccounts/blobServices/containers', parameters('storageAccountName'), 'default', parameters('containerName'))]\\"
            }
          }
        }
        \"\"\")
        example_storage_account_contrib = azure.authorization.Assignment("example_storage_account_contrib",
            scope=example_account.id,
            role_definition_name="Storage Account Contributor",
            principal_id=example.object_id)
        example_storage_blob_data_contrib = azure.authorization.Assignment("example_storage_blob_data_contrib",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example.object_id)
        example_cache = azure.hpc.Cache("example",
            name="example-hpc-cache",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            cache_size_in_gb=3072,
            subnet_id=example_subnet.id,
            sku_name="Standard_2G")
        example_cache_blob_nfs_target = azure.hpc.CacheBlobNfsTarget("example",
            name="example-hpc-target",
            resource_group_name=example_resource_group.name,
            cache_name=example_cache.name,
            storage_container_id=std.jsondecode_output(input=storage_containers.output_content).apply(lambda invoke: invoke.result["id"]["value"]),
            namespace_path="/p1",
            usage_model="READ_HEAVY_INFREQ")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageCache` - 2023-05-01

        ## Import

        HPC Cache Blob NFS Targets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hpc/cacheBlobNfsTarget:CacheBlobNfsTarget example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StorageCache/caches/cache1/storageTargets/target1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy_name: The name of the access policy applied to this target. Defaults to `default`.
        :param pulumi.Input[_builtins.str] cache_name: The name of the HPC Cache, which the HPC Cache Blob NFS Target will be added to. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this HPC Cache Blob NFS Target. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] namespace_path: The client-facing file path of the HPC Cache Blob NFS Target.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the HPC Cache Blob NFS Target should exist. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] storage_container_id: The Resource Manager ID of the Storage Container used as the HPC Cache Blob NFS Target. Changing this forces a new resource to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache Blob NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CacheBlobNfsTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Blob NFSv3 Target within a HPC Cache.

        !> **Note:** The `hpc.CacheBlobNfsTarget` resource has been deprecated because the service is retiring on 2025-09-30. This resource will be removed in v5.0 of the AzureRM Provider. See https://aka.ms/hpccacheretirement for more information.

        > **Note:** By request of the service team the provider no longer automatically registers the `Microsoft.StorageCache` Resource Provider for this resource. To register it you can run `az provider register --namespace 'Microsoft.StorageCache'`.

        > **Note:** This resource depends on the NFSv3 enabled Storage Account, which has some prerequisites need to meet. Please checkout: <https://docs.microsoft.com/azure/storage/blobs/network-file-system-protocol-support-how-to?tabs=azure-powershell>.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure
        import pulumi_azuread as azuread
        import pulumi_std as std

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"])
        example = azuread.get_service_principal(display_name="HPC Cache Resource Provider")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_kind="StorageV2",
            account_replication_type="LRS",
            is_hns_enabled=True,
            nfsv3_enabled=True,
            enable_https_traffic_only=False,
            network_rules={
                "default_action": "Deny",
                "virtual_network_subnet_ids": [example_subnet.id],
            })
        # Due to https://github.com/hashicorp/terraform-provider-azurerm/issues/2977 and the fact
        # that the NFSv3 enabled storage account can't allow public network access - otherwise the NFSv3 protocol will fail,
        # we have to use the ARM template to deploy the storage container as a workaround.
        # Once the issue above got resolved, we can instead use the azurerm_storage_container resource.
        storage_containers = azure.core.ResourceGroupTemplateDeployment("storage-containers",
            name="example-deployment",
            resource_group_name=example_account.resource_group_name,
            deployment_mode="Incremental",
            parameters_content=pulumi.Output.json_dumps({
                "location": {
                    "value": example_account.location,
                },
                "storageAccountName": {
                    "value": example_account.name,
                },
                "containerName": {
                    "value": "example-container",
                },
            }),
            template_content=\"\"\"{
          \\"$schema\\": \\"https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#\\",
          \\"contentVersion\\": \\"1.0.0.0\\",
          \\"parameters\\": {
            \\"storageAccountName\\": {
              \\"type\\": \\"String\\"
            },
            \\"containerName\\": {
              \\"type\\": \\"String\\"
            },
            \\"location\\": {
              \\"type\\": \\"String\\"
            }
          },
          \\"resources\\": [
            {
              \\"type\\": \\"Microsoft.Storage/storageAccounts\\",
              \\"apiVersion\\": \\"2019-06-01\\",
              \\"name\\": \\"[parameters('storageAccountName')]\\",
              \\"location\\": \\"[parameters('location')]\\",
              \\"sku\\": {
                \\"name\\": \\"Standard_LRS\\",
                \\"tier\\": \\"Standard\\"
              },
              \\"kind\\": \\"StorageV2\\",
              \\"properties\\": {
                \\"accessTier\\": \\"Hot\\"
              },
              \\"resources\\": [
                {
                  \\"type\\": \\"blobServices/containers\\",
                  \\"apiVersion\\": \\"2019-06-01\\",
                  \\"name\\": \\"[concat('default/', parameters('containerName'))]\\",
                  \\"dependsOn\\": [
                    \\"[parameters('storageAccountName')]\\"
                  ]
                }
              ]
            }
          ],

          \\"outputs\\": {
            \\"id\\": {
              \\"type\\": \\"String\\",
              \\"value\\": \\"[resourceId('Microsoft.Storage/storageAccounts/blobServices/containers', parameters('storageAccountName'), 'default', parameters('containerName'))]\\"
            }
          }
        }
        \"\"\")
        example_storage_account_contrib = azure.authorization.Assignment("example_storage_account_contrib",
            scope=example_account.id,
            role_definition_name="Storage Account Contributor",
            principal_id=example.object_id)
        example_storage_blob_data_contrib = azure.authorization.Assignment("example_storage_blob_data_contrib",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example.object_id)
        example_cache = azure.hpc.Cache("example",
            name="example-hpc-cache",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            cache_size_in_gb=3072,
            subnet_id=example_subnet.id,
            sku_name="Standard_2G")
        example_cache_blob_nfs_target = azure.hpc.CacheBlobNfsTarget("example",
            name="example-hpc-target",
            resource_group_name=example_resource_group.name,
            cache_name=example_cache.name,
            storage_container_id=std.jsondecode_output(input=storage_containers.output_content).apply(lambda invoke: invoke.result["id"]["value"]),
            namespace_path="/p1",
            usage_model="READ_HEAVY_INFREQ")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageCache` - 2023-05-01

        ## Import

        HPC Cache Blob NFS Targets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hpc/cacheBlobNfsTarget:CacheBlobNfsTarget example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StorageCache/caches/cache1/storageTargets/target1
        ```

        :param str resource_name: The name of the resource.
        :param CacheBlobNfsTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CacheBlobNfsTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_path: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CacheBlobNfsTargetArgs.__new__(CacheBlobNfsTargetArgs)

            __props__.__dict__["access_policy_name"] = access_policy_name
            if cache_name is None and not opts.urn:
                raise TypeError("Missing required property 'cache_name'")
            __props__.__dict__["cache_name"] = cache_name
            __props__.__dict__["name"] = name
            if namespace_path is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_path'")
            __props__.__dict__["namespace_path"] = namespace_path
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if storage_container_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_id'")
            __props__.__dict__["storage_container_id"] = storage_container_id
            if usage_model is None and not opts.urn:
                raise TypeError("Missing required property 'usage_model'")
            __props__.__dict__["usage_model"] = usage_model
            __props__.__dict__["verification_timer_in_seconds"] = verification_timer_in_seconds
            __props__.__dict__["write_back_timer_in_seconds"] = write_back_timer_in_seconds
        super(CacheBlobNfsTarget, __self__).__init__(
            'azure:hpc/cacheBlobNfsTarget:CacheBlobNfsTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            cache_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_path: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
            usage_model: Optional[pulumi.Input[_builtins.str]] = None,
            verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'CacheBlobNfsTarget':
        """
        Get an existing CacheBlobNfsTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy_name: The name of the access policy applied to this target. Defaults to `default`.
        :param pulumi.Input[_builtins.str] cache_name: The name of the HPC Cache, which the HPC Cache Blob NFS Target will be added to. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this HPC Cache Blob NFS Target. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] namespace_path: The client-facing file path of the HPC Cache Blob NFS Target.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the HPC Cache Blob NFS Target should exist. Changing this forces a new HPC Cache Blob NFS Target to be created.
        :param pulumi.Input[_builtins.str] storage_container_id: The Resource Manager ID of the Storage Container used as the HPC Cache Blob NFS Target. Changing this forces a new resource to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache Blob NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CacheBlobNfsTargetState.__new__(_CacheBlobNfsTargetState)

        __props__.__dict__["access_policy_name"] = access_policy_name
        __props__.__dict__["cache_name"] = cache_name
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_path"] = namespace_path
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["storage_container_id"] = storage_container_id
        __props__.__dict__["usage_model"] = usage_model
        __props__.__dict__["verification_timer_in_seconds"] = verification_timer_in_seconds
        __props__.__dict__["write_back_timer_in_seconds"] = write_back_timer_in_seconds
        return CacheBlobNfsTarget(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicyName")
    def access_policy_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the access policy applied to this target. Defaults to `default`.
        """
        return pulumi.get(self, "access_policy_name")

    @_builtins.property
    @pulumi.getter(name="cacheName")
    def cache_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the HPC Cache, which the HPC Cache Blob NFS Target will be added to. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "cache_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this HPC Cache Blob NFS Target. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> pulumi.Output[_builtins.str]:
        """
        The client-facing file path of the HPC Cache Blob NFS Target.
        """
        return pulumi.get(self, "namespace_path")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the HPC Cache Blob NFS Target should exist. Changing this forces a new HPC Cache Blob NFS Target to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Resource Manager ID of the Storage Container used as the HPC Cache Blob NFS Target. Changing this forces a new resource to be created.

        > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        """
        return pulumi.get(self, "storage_container_id")

    @_builtins.property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> pulumi.Output[_builtins.str]:
        """
        The type of usage of the HPC Cache Blob NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        """
        return pulumi.get(self, "usage_model")

    @_builtins.property
    @pulumi.getter(name="verificationTimerInSeconds")
    def verification_timer_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "verification_timer_in_seconds")

    @_builtins.property
    @pulumi.getter(name="writeBackTimerInSeconds")
    def write_back_timer_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "write_back_timer_in_seconds")

