# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointCosmosdbAccountArgs', 'EndpointCosmosdbAccount']

@pulumi.input_type
class EndpointCosmosdbAccountArgs:
    def __init__(__self__, *,
                 container_name: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 endpoint_uri: pulumi.Input[_builtins.str],
                 iothub_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_template: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EndpointCosmosdbAccount resource.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB Container in the Cosmos DB Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB Database in the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: The URI of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub to create the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Cosmos DB Account has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the Cosmos DB Account endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the Cosmos DB Account endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_name: The name of the partition key associated with the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] partition_key_template: The template for generating a synthetic partition key value for use within the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] primary_key: The primary key of the Cosmos DB Account.
               
               > **Note:** `primary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] secondary_key: The secondary key of the Cosmos DB Account.
               
               > **Note:** `secondary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "iothub_id", iothub_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_key_name is not None:
            pulumi.set(__self__, "partition_key_name", partition_key_name)
        if partition_key_template is not None:
            pulumi.set(__self__, "partition_key_template", partition_key_template)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB Container in the Cosmos DB Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB Database in the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the IoT Hub to create the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group under which the Cosmos DB Account has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type used to authenticate against the Cosmos DB Account endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the Cosmos DB Account endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyName")
    def partition_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the partition key associated with the Cosmos DB Container.
        """
        return pulumi.get(self, "partition_key_name")

    @partition_key_name.setter
    def partition_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key_name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyTemplate")
    def partition_key_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template for generating a synthetic partition key value for use within the Cosmos DB Container.
        """
        return pulumi.get(self, "partition_key_template")

    @partition_key_template.setter
    def partition_key_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key_template", value)

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary key of the Cosmos DB Account.

        > **Note:** `primary_key` must and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary key of the Cosmos DB Account.

        > **Note:** `secondary_key` must and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _EndpointCosmosdbAccountState:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_template: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EndpointCosmosdbAccount resources.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the Cosmos DB Account endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB Container in the Cosmos DB Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB Database in the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: The URI of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the Cosmos DB Account endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub to create the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_name: The name of the partition key associated with the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] partition_key_template: The template for generating a synthetic partition key value for use within the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] primary_key: The primary key of the Cosmos DB Account.
               
               > **Note:** `primary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Cosmos DB Account has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_key: The secondary key of the Cosmos DB Account.
               
               > **Note:** `secondary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if iothub_id is not None:
            pulumi.set(__self__, "iothub_id", iothub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_key_name is not None:
            pulumi.set(__self__, "partition_key_name", partition_key_name)
        if partition_key_template is not None:
            pulumi.set(__self__, "partition_key_template", partition_key_template)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type used to authenticate against the Cosmos DB Account endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB Container in the Cosmos DB Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB Database in the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the Cosmos DB Account endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IoT Hub to create the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyName")
    def partition_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the partition key associated with the Cosmos DB Container.
        """
        return pulumi.get(self, "partition_key_name")

    @partition_key_name.setter
    def partition_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key_name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyTemplate")
    def partition_key_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template for generating a synthetic partition key value for use within the Cosmos DB Container.
        """
        return pulumi.get(self, "partition_key_template")

    @partition_key_template.setter
    def partition_key_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key_template", value)

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary key of the Cosmos DB Account.

        > **Note:** `primary_key` must and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group under which the Cosmos DB Account has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary key of the Cosmos DB Account.

        > **Note:** `secondary_key` must and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("azure:iot/endpointCosmosdbAccount:EndpointCosmosdbAccount")
class EndpointCosmosdbAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_template: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an IotHub Cosmos DB Account Endpoint

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="exampleIothub",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "B1",
                "capacity": 1,
            },
            tags={
                "purpose": "example",
            })
        example_account = azure.cosmosdb.Account("example",
            name="cosmosdb-account",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="cosmos-sql-db",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="example-container",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            database_name=example_sql_database.name,
            partition_key_path="/definition/id")
        example_endpoint_cosmosdb_account = azure.iot.EndpointCosmosdbAccount("example",
            name="example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            container_name=example_sql_container.name,
            database_name=example_sql_database.name,
            endpoint_uri=example_account.endpoint,
            primary_key=example_account.primary_key,
            secondary_key=example_account.secondary_key)
        ```

        ## Import

        IoTHub Cosmos DB Account Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/endpointCosmosdbAccount:EndpointCosmosdbAccount endpoint1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/endpoints/cosmosDBAccountEndpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the Cosmos DB Account endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB Container in the Cosmos DB Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB Database in the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: The URI of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the Cosmos DB Account endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub to create the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_name: The name of the partition key associated with the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] partition_key_template: The template for generating a synthetic partition key value for use within the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] primary_key: The primary key of the Cosmos DB Account.
               
               > **Note:** `primary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Cosmos DB Account has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_key: The secondary key of the Cosmos DB Account.
               
               > **Note:** `secondary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointCosmosdbAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub Cosmos DB Account Endpoint

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="exampleIothub",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "B1",
                "capacity": 1,
            },
            tags={
                "purpose": "example",
            })
        example_account = azure.cosmosdb.Account("example",
            name="cosmosdb-account",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="cosmos-sql-db",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="example-container",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            database_name=example_sql_database.name,
            partition_key_path="/definition/id")
        example_endpoint_cosmosdb_account = azure.iot.EndpointCosmosdbAccount("example",
            name="example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            container_name=example_sql_container.name,
            database_name=example_sql_database.name,
            endpoint_uri=example_account.endpoint,
            primary_key=example_account.primary_key,
            secondary_key=example_account.secondary_key)
        ```

        ## Import

        IoTHub Cosmos DB Account Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/endpointCosmosdbAccount:EndpointCosmosdbAccount endpoint1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/endpoints/cosmosDBAccountEndpoint1
        ```

        :param str resource_name: The name of the resource.
        :param EndpointCosmosdbAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointCosmosdbAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_template: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointCosmosdbAccountArgs.__new__(EndpointCosmosdbAccountArgs)

            __props__.__dict__["authentication_type"] = authentication_type
            if container_name is None and not opts.urn:
                raise TypeError("Missing required property 'container_name'")
            __props__.__dict__["container_name"] = container_name
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if endpoint_uri is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_uri'")
            __props__.__dict__["endpoint_uri"] = endpoint_uri
            __props__.__dict__["identity_id"] = identity_id
            if iothub_id is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_id'")
            __props__.__dict__["iothub_id"] = iothub_id
            __props__.__dict__["name"] = name
            __props__.__dict__["partition_key_name"] = partition_key_name
            __props__.__dict__["partition_key_template"] = partition_key_template
            __props__.__dict__["primary_key"] = None if primary_key is None else pulumi.Output.secret(primary_key)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["secondary_key"] = None if secondary_key is None else pulumi.Output.secret(secondary_key)
            __props__.__dict__["subscription_id"] = subscription_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryKey", "secondaryKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EndpointCosmosdbAccount, __self__).__init__(
            'azure:iot/endpointCosmosdbAccount:EndpointCosmosdbAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            container_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
            identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            partition_key_template: Optional[pulumi.Input[_builtins.str]] = None,
            primary_key: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EndpointCosmosdbAccount':
        """
        Get an existing EndpointCosmosdbAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the Cosmos DB Account endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB Container in the Cosmos DB Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB Database in the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: The URI of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the Cosmos DB Account endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub to create the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_name: The name of the partition key associated with the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] partition_key_template: The template for generating a synthetic partition key value for use within the Cosmos DB Container.
        :param pulumi.Input[_builtins.str] primary_key: The primary key of the Cosmos DB Account.
               
               > **Note:** `primary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Cosmos DB Account has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_key: The secondary key of the Cosmos DB Account.
               
               > **Note:** `secondary_key` must and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointCosmosdbAccountState.__new__(_EndpointCosmosdbAccountState)

        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["container_name"] = container_name
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["endpoint_uri"] = endpoint_uri
        __props__.__dict__["identity_id"] = identity_id
        __props__.__dict__["iothub_id"] = iothub_id
        __props__.__dict__["name"] = name
        __props__.__dict__["partition_key_name"] = partition_key_name
        __props__.__dict__["partition_key_template"] = partition_key_template
        __props__.__dict__["primary_key"] = primary_key
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_key"] = secondary_key
        __props__.__dict__["subscription_id"] = subscription_id
        return EndpointCosmosdbAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type used to authenticate against the Cosmos DB Account endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB Container in the Cosmos DB Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB Database in the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "endpoint_uri")

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the Cosmos DB Account endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IoT Hub to create the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partitionKeyName")
    def partition_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the partition key associated with the Cosmos DB Container.
        """
        return pulumi.get(self, "partition_key_name")

    @_builtins.property
    @pulumi.getter(name="partitionKeyTemplate")
    def partition_key_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The template for generating a synthetic partition key value for use within the Cosmos DB Container.
        """
        return pulumi.get(self, "partition_key_template")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The primary key of the Cosmos DB Account.

        > **Note:** `primary_key` must and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group under which the Cosmos DB Account has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secondary key of the Cosmos DB Account.

        > **Note:** `secondary_key` must and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "secondary_key")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

