# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointServicebusQueueArgs', 'EndpointServicebusQueue']

@pulumi.input_type
class EndpointServicebusQueueArgs:
    def __init__(__self__, *,
                 iothub_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_path: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EndpointServicebusQueue resource.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Service Bus Queue has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the Service Bus Queue endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Service Bus endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] entity_path: Name of the Service Bus Queue. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the Service Bus Queue endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        pulumi.set(__self__, "iothub_id", iothub_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group under which the Service Bus Queue has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type used to authenticate against the Service Bus Queue endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI of the Service Bus endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Service Bus Queue. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "entity_path")

    @entity_path.setter
    def entity_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_path", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the User Managed Identity used to authenticate against the Service Bus Queue endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _EndpointServicebusQueueState:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_path: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EndpointServicebusQueue resources.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the Service Bus Queue endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Service Bus endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] entity_path: Name of the Service Bus Queue. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the Service Bus Queue endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Service Bus Queue has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if iothub_id is not None:
            pulumi.set(__self__, "iothub_id", iothub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type used to authenticate against the Service Bus Queue endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI of the Service Bus endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Service Bus Queue. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "entity_path")

    @entity_path.setter
    def entity_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_path", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the User Managed Identity used to authenticate against the Service Bus Queue endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group under which the Service Bus Queue has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("azure:iot/endpointServicebusQueue:EndpointServicebusQueue")
class EndpointServicebusQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_path: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an IotHub ServiceBus Queue Endpoint

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="exampleNamespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_queue = azure.servicebus.Queue("example",
            name="exampleQueue",
            namespace_id=example_namespace.id,
            enable_partitioning=True)
        example_queue_authorization_rule = azure.servicebus.QueueAuthorizationRule("example",
            name="exampleRule",
            queue_id=example_queue.id,
            listen=False,
            send=True,
            manage=False)
        example_io_t_hub = azure.iot.IoTHub("example",
            name="exampleIothub",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "B1",
                "capacity": 1,
            },
            tags={
                "purpose": "example",
            })
        example_endpoint_servicebus_queue = azure.iot.EndpointServicebusQueue("example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            name="example",
            connection_string=example_queue_authorization_rule.primary_connection_string)
        ```

        ## Import

        IoTHub ServiceBus Queue Endpoint can be imported using the `resource id`, e.g.

        g

        ```sh
        $ pulumi import azure:iot/endpointServicebusQueue:EndpointServicebusQueue servicebus_queue1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/endpoints/servicebusqueue_endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the Service Bus Queue endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Service Bus endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] entity_path: Name of the Service Bus Queue. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the Service Bus Queue endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Service Bus Queue has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointServicebusQueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub ServiceBus Queue Endpoint

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="exampleNamespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_queue = azure.servicebus.Queue("example",
            name="exampleQueue",
            namespace_id=example_namespace.id,
            enable_partitioning=True)
        example_queue_authorization_rule = azure.servicebus.QueueAuthorizationRule("example",
            name="exampleRule",
            queue_id=example_queue.id,
            listen=False,
            send=True,
            manage=False)
        example_io_t_hub = azure.iot.IoTHub("example",
            name="exampleIothub",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "B1",
                "capacity": 1,
            },
            tags={
                "purpose": "example",
            })
        example_endpoint_servicebus_queue = azure.iot.EndpointServicebusQueue("example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            name="example",
            connection_string=example_queue_authorization_rule.primary_connection_string)
        ```

        ## Import

        IoTHub ServiceBus Queue Endpoint can be imported using the `resource id`, e.g.

        g

        ```sh
        $ pulumi import azure:iot/endpointServicebusQueue:EndpointServicebusQueue servicebus_queue1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/endpoints/servicebusqueue_endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param EndpointServicebusQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointServicebusQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_path: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointServicebusQueueArgs.__new__(EndpointServicebusQueueArgs)

            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["connection_string"] = None if connection_string is None else pulumi.Output.secret(connection_string)
            __props__.__dict__["endpoint_uri"] = endpoint_uri
            __props__.__dict__["entity_path"] = entity_path
            __props__.__dict__["identity_id"] = identity_id
            if iothub_id is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_id'")
            __props__.__dict__["iothub_id"] = iothub_id
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["subscription_id"] = subscription_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EndpointServicebusQueue, __self__).__init__(
            'azure:iot/endpointServicebusQueue:EndpointServicebusQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
            entity_path: Optional[pulumi.Input[_builtins.str]] = None,
            identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EndpointServicebusQueue':
        """
        Get an existing EndpointServicebusQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: Type used to authenticate against the Service Bus Queue endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Service Bus endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] entity_path: Name of the Service Bus Queue. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        :param pulumi.Input[_builtins.str] identity_id: ID of the User Managed Identity used to authenticate against the Service Bus Queue endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the Service Bus Queue has been created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the endpoint.
               
               > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointServicebusQueueState.__new__(_EndpointServicebusQueueState)

        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["endpoint_uri"] = endpoint_uri
        __props__.__dict__["entity_path"] = entity_path
        __props__.__dict__["identity_id"] = identity_id
        __props__.__dict__["iothub_id"] = iothub_id
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subscription_id"] = subscription_id
        return EndpointServicebusQueue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type used to authenticate against the Service Bus Queue endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The connection string for the endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URI of the Service Bus endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "endpoint_uri")

    @_builtins.property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the Service Bus Queue. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased`.
        """
        return pulumi.get(self, "entity_path")

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the User Managed Identity used to authenticate against the Service Bus Queue endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the Iot Hub. If not specified when `authentication_type` is `identityBased`, System Assigned Managed Identity of the Iot Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The IoTHub ID for the endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group under which the Service Bus Queue has been created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The subscription ID for the endpoint.

        > **Note:** When `subscription_id` isn't specified it will be set to the subscription ID of the IoT Hub resource.
        """
        return pulumi.get(self, "subscription_id")

