# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSharedAccessPolicyResult',
    'AwaitableGetSharedAccessPolicyResult',
    'get_shared_access_policy',
    'get_shared_access_policy_output',
]

@pulumi.output_type
class GetSharedAccessPolicyResult:
    """
    A collection of values returned by getSharedAccessPolicy.
    """
    def __init__(__self__, id=None, iothub_name=None, name=None, primary_connection_string=None, primary_key=None, resource_group_name=None, secondary_connection_string=None, secondary_key=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iothub_name and not isinstance(iothub_name, str):
            raise TypeError("Expected argument 'iothub_name' to be a str")
        pulumi.set(__self__, "iothub_name", iothub_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_connection_string and not isinstance(primary_connection_string, str):
            raise TypeError("Expected argument 'primary_connection_string' to be a str")
        pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if primary_key and not isinstance(primary_key, str):
            raise TypeError("Expected argument 'primary_key' to be a str")
        pulumi.set(__self__, "primary_key", primary_key)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_connection_string and not isinstance(secondary_connection_string, str):
            raise TypeError("Expected argument 'secondary_connection_string' to be a str")
        pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if secondary_key and not isinstance(secondary_key, str):
            raise TypeError("Expected argument 'secondary_key' to be a str")
        pulumi.set(__self__, "secondary_key", secondary_key)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iothubName")
    def iothub_name(self) -> _builtins.str:
        return pulumi.get(self, "iothub_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> _builtins.str:
        """
        The primary connection string of the Shared Access Policy.
        """
        return pulumi.get(self, "primary_connection_string")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> _builtins.str:
        """
        The primary key used to create the authentication token.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> _builtins.str:
        """
        The secondary connection string of the Shared Access Policy.
        """
        return pulumi.get(self, "secondary_connection_string")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> _builtins.str:
        """
        The secondary key used to create the authentication token.
        """
        return pulumi.get(self, "secondary_key")


class AwaitableGetSharedAccessPolicyResult(GetSharedAccessPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSharedAccessPolicyResult(
            id=self.id,
            iothub_name=self.iothub_name,
            name=self.name,
            primary_connection_string=self.primary_connection_string,
            primary_key=self.primary_key,
            resource_group_name=self.resource_group_name,
            secondary_connection_string=self.secondary_connection_string,
            secondary_key=self.secondary_key)


def get_shared_access_policy(iothub_name: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             resource_group_name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSharedAccessPolicyResult:
    """
    Use this data source to access information about an existing IotHub Shared Access Policy

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.iot.get_shared_access_policy(name="example",
        resource_group_name=example_azurerm_resource_group["name"],
        iothub_name=example_azurerm_iothub["name"])
    ```


    :param _builtins.str iothub_name: The name of the IoTHub to which this Shared Access Policy belongs.
    :param _builtins.str name: Specifies the name of the IotHub Shared Access Policy resource.
    :param _builtins.str resource_group_name: The name of the resource group under which the IotHub Shared Access Policy resource has to be created.
    """
    __args__ = dict()
    __args__['iothubName'] = iothub_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:iot/getSharedAccessPolicy:getSharedAccessPolicy', __args__, opts=opts, typ=GetSharedAccessPolicyResult).value

    return AwaitableGetSharedAccessPolicyResult(
        id=pulumi.get(__ret__, 'id'),
        iothub_name=pulumi.get(__ret__, 'iothub_name'),
        name=pulumi.get(__ret__, 'name'),
        primary_connection_string=pulumi.get(__ret__, 'primary_connection_string'),
        primary_key=pulumi.get(__ret__, 'primary_key'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_connection_string=pulumi.get(__ret__, 'secondary_connection_string'),
        secondary_key=pulumi.get(__ret__, 'secondary_key'))
def get_shared_access_policy_output(iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    name: Optional[pulumi.Input[_builtins.str]] = None,
                                    resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSharedAccessPolicyResult]:
    """
    Use this data source to access information about an existing IotHub Shared Access Policy

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.iot.get_shared_access_policy(name="example",
        resource_group_name=example_azurerm_resource_group["name"],
        iothub_name=example_azurerm_iothub["name"])
    ```


    :param _builtins.str iothub_name: The name of the IoTHub to which this Shared Access Policy belongs.
    :param _builtins.str name: Specifies the name of the IotHub Shared Access Policy resource.
    :param _builtins.str resource_group_name: The name of the resource group under which the IotHub Shared Access Policy resource has to be created.
    """
    __args__ = dict()
    __args__['iothubName'] = iothub_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:iot/getSharedAccessPolicy:getSharedAccessPolicy', __args__, opts=opts, typ=GetSharedAccessPolicyResult)
    return __ret__.apply(lambda __response__: GetSharedAccessPolicyResult(
        id=pulumi.get(__response__, 'id'),
        iothub_name=pulumi.get(__response__, 'iothub_name'),
        name=pulumi.get(__response__, 'name'),
        primary_connection_string=pulumi.get(__response__, 'primary_connection_string'),
        primary_key=pulumi.get(__response__, 'primary_key'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_connection_string=pulumi.get(__response__, 'secondary_connection_string'),
        secondary_key=pulumi.get(__response__, 'secondary_key')))
