# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IoTHubArgs', 'IoTHub']

@pulumi.input_type
class IoTHubArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input['IoTHubSkuArgs'],
                 cloud_to_device: Optional[pulumi.Input['IoTHubCloudToDeviceArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]]] = None,
                 enrichments: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEnrichmentArgs']]]] = None,
                 event_hub_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 event_hub_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_route: Optional[pulumi.Input['IoTHubFallbackRouteArgs']] = None,
                 file_upload: Optional[pulumi.Input['IoTHubFileUploadArgs']] = None,
                 identity: Optional[pulumi.Input['IoTHubIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubRouteArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IoTHub resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input['IoTHubSkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]] endpoints: An `endpoint` block as defined below.
        :param pulumi.Input[_builtins.int] event_hub_partition_count: The number of device-to-cloud partitions used by backing event hubs. Must be between `2` and `128`. Defaults to `4`.
        :param pulumi.Input[_builtins.int] event_hub_retention_in_days: The event hub retention to use in days. Must be between `1` and `7`. Defaults to `1`.
        :param pulumi.Input['IoTHubFallbackRouteArgs'] fallback_route: A `fallback_route` block as defined below. If the fallback route is enabled, messages that don't match any of the supplied routes are automatically sent to this route. Defaults to messages/events.
               
               > **Note:** If `fallback_route` isn't explicitly specified, the fallback route wouldn't be enabled by default.
        :param pulumi.Input['IoTHubFileUploadArgs'] file_upload: A `file_upload` block as defined below.
        :param pulumi.Input['IoTHubIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: If false, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]] network_rule_sets: A `network_rule_set` block as defined below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if cloud_to_device is not None:
            pulumi.set(__self__, "cloud_to_device", cloud_to_device)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enrichments is not None:
            pulumi.set(__self__, "enrichments", enrichments)
        if event_hub_partition_count is not None:
            pulumi.set(__self__, "event_hub_partition_count", event_hub_partition_count)
        if event_hub_retention_in_days is not None:
            pulumi.set(__self__, "event_hub_retention_in_days", event_hub_retention_in_days)
        if fallback_route is not None:
            pulumi.set(__self__, "fallback_route", fallback_route)
        if file_upload is not None:
            pulumi.set(__self__, "file_upload", file_upload)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rule_sets is not None:
            pulumi.set(__self__, "network_rule_sets", network_rule_sets)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group under which the IotHub resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['IoTHubSkuArgs']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['IoTHubSkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="cloudToDevice")
    def cloud_to_device(self) -> Optional[pulumi.Input['IoTHubCloudToDeviceArgs']]:
        return pulumi.get(self, "cloud_to_device")

    @cloud_to_device.setter
    def cloud_to_device(self, value: Optional[pulumi.Input['IoTHubCloudToDeviceArgs']]):
        pulumi.set(self, "cloud_to_device", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]]]:
        """
        An `endpoint` block as defined below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    def enrichments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEnrichmentArgs']]]]:
        return pulumi.get(self, "enrichments")

    @enrichments.setter
    def enrichments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEnrichmentArgs']]]]):
        pulumi.set(self, "enrichments", value)

    @_builtins.property
    @pulumi.getter(name="eventHubPartitionCount")
    def event_hub_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of device-to-cloud partitions used by backing event hubs. Must be between `2` and `128`. Defaults to `4`.
        """
        return pulumi.get(self, "event_hub_partition_count")

    @event_hub_partition_count.setter
    def event_hub_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "event_hub_partition_count", value)

    @_builtins.property
    @pulumi.getter(name="eventHubRetentionInDays")
    def event_hub_retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The event hub retention to use in days. Must be between `1` and `7`. Defaults to `1`.
        """
        return pulumi.get(self, "event_hub_retention_in_days")

    @event_hub_retention_in_days.setter
    def event_hub_retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "event_hub_retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="fallbackRoute")
    def fallback_route(self) -> Optional[pulumi.Input['IoTHubFallbackRouteArgs']]:
        """
        A `fallback_route` block as defined below. If the fallback route is enabled, messages that don't match any of the supplied routes are automatically sent to this route. Defaults to messages/events.

        > **Note:** If `fallback_route` isn't explicitly specified, the fallback route wouldn't be enabled by default.
        """
        return pulumi.get(self, "fallback_route")

    @fallback_route.setter
    def fallback_route(self, value: Optional[pulumi.Input['IoTHubFallbackRouteArgs']]):
        pulumi.set(self, "fallback_route", value)

    @_builtins.property
    @pulumi.getter(name="fileUpload")
    def file_upload(self) -> Optional[pulumi.Input['IoTHubFileUploadArgs']]:
        """
        A `file_upload` block as defined below.
        """
        return pulumi.get(self, "file_upload")

    @file_upload.setter
    def file_upload(self, value: Optional[pulumi.Input['IoTHubFileUploadArgs']]):
        pulumi.set(self, "file_upload", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['IoTHubIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['IoTHubIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If false, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the IotHub resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleSets")
    def network_rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]]]:
        """
        A `network_rule_set` block as defined below.
        """
        return pulumi.get(self, "network_rule_sets")

    @network_rule_sets.setter
    def network_rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]]]):
        pulumi.set(self, "network_rule_sets", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubRouteArgs']]]]:
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IoTHubState:
    def __init__(__self__, *,
                 cloud_to_device: Optional[pulumi.Input['IoTHubCloudToDeviceArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]]] = None,
                 enrichments: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEnrichmentArgs']]]] = None,
                 event_hub_events_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 event_hub_events_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 event_hub_events_path: Optional[pulumi.Input[_builtins.str]] = None,
                 event_hub_operations_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 event_hub_operations_path: Optional[pulumi.Input[_builtins.str]] = None,
                 event_hub_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 event_hub_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_route: Optional[pulumi.Input['IoTHubFallbackRouteArgs']] = None,
                 file_upload: Optional[pulumi.Input['IoTHubFileUploadArgs']] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['IoTHubIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubRouteArgs']]]] = None,
                 shared_access_policies: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubSharedAccessPolicyArgs']]]] = None,
                 sku: Optional[pulumi.Input['IoTHubSkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IoTHub resources.
        :param pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]] endpoints: An `endpoint` block as defined below.
        :param pulumi.Input[_builtins.str] event_hub_events_endpoint: The EventHub compatible endpoint for events data
        :param pulumi.Input[_builtins.str] event_hub_events_namespace: The EventHub namespace for events data
        :param pulumi.Input[_builtins.str] event_hub_events_path: The EventHub compatible path for events data
        :param pulumi.Input[_builtins.str] event_hub_operations_endpoint: The EventHub compatible endpoint for operational data
        :param pulumi.Input[_builtins.str] event_hub_operations_path: The EventHub compatible path for operational data
        :param pulumi.Input[_builtins.int] event_hub_partition_count: The number of device-to-cloud partitions used by backing event hubs. Must be between `2` and `128`. Defaults to `4`.
        :param pulumi.Input[_builtins.int] event_hub_retention_in_days: The event hub retention to use in days. Must be between `1` and `7`. Defaults to `1`.
        :param pulumi.Input['IoTHubFallbackRouteArgs'] fallback_route: A `fallback_route` block as defined below. If the fallback route is enabled, messages that don't match any of the supplied routes are automatically sent to this route. Defaults to messages/events.
               
               > **Note:** If `fallback_route` isn't explicitly specified, the fallback route wouldn't be enabled by default.
        :param pulumi.Input['IoTHubFileUploadArgs'] file_upload: A `file_upload` block as defined below.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the IotHub Resource.
        :param pulumi.Input['IoTHubIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: If false, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]] network_rule_sets: A `network_rule_set` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['IoTHubSharedAccessPolicyArgs']]] shared_access_policies: One or more `shared_access_policy` blocks as defined below.
        :param pulumi.Input['IoTHubSkuArgs'] sku: A `sku` block as defined below.
        """
        if cloud_to_device is not None:
            pulumi.set(__self__, "cloud_to_device", cloud_to_device)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enrichments is not None:
            pulumi.set(__self__, "enrichments", enrichments)
        if event_hub_events_endpoint is not None:
            pulumi.set(__self__, "event_hub_events_endpoint", event_hub_events_endpoint)
        if event_hub_events_namespace is not None:
            pulumi.set(__self__, "event_hub_events_namespace", event_hub_events_namespace)
        if event_hub_events_path is not None:
            pulumi.set(__self__, "event_hub_events_path", event_hub_events_path)
        if event_hub_operations_endpoint is not None:
            pulumi.set(__self__, "event_hub_operations_endpoint", event_hub_operations_endpoint)
        if event_hub_operations_path is not None:
            pulumi.set(__self__, "event_hub_operations_path", event_hub_operations_path)
        if event_hub_partition_count is not None:
            pulumi.set(__self__, "event_hub_partition_count", event_hub_partition_count)
        if event_hub_retention_in_days is not None:
            pulumi.set(__self__, "event_hub_retention_in_days", event_hub_retention_in_days)
        if fallback_route is not None:
            pulumi.set(__self__, "fallback_route", fallback_route)
        if file_upload is not None:
            pulumi.set(__self__, "file_upload", file_upload)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rule_sets is not None:
            pulumi.set(__self__, "network_rule_sets", network_rule_sets)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if shared_access_policies is not None:
            pulumi.set(__self__, "shared_access_policies", shared_access_policies)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cloudToDevice")
    def cloud_to_device(self) -> Optional[pulumi.Input['IoTHubCloudToDeviceArgs']]:
        return pulumi.get(self, "cloud_to_device")

    @cloud_to_device.setter
    def cloud_to_device(self, value: Optional[pulumi.Input['IoTHubCloudToDeviceArgs']]):
        pulumi.set(self, "cloud_to_device", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]]]:
        """
        An `endpoint` block as defined below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    def enrichments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEnrichmentArgs']]]]:
        return pulumi.get(self, "enrichments")

    @enrichments.setter
    def enrichments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubEnrichmentArgs']]]]):
        pulumi.set(self, "enrichments", value)

    @_builtins.property
    @pulumi.getter(name="eventHubEventsEndpoint")
    def event_hub_events_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EventHub compatible endpoint for events data
        """
        return pulumi.get(self, "event_hub_events_endpoint")

    @event_hub_events_endpoint.setter
    def event_hub_events_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_hub_events_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="eventHubEventsNamespace")
    def event_hub_events_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EventHub namespace for events data
        """
        return pulumi.get(self, "event_hub_events_namespace")

    @event_hub_events_namespace.setter
    def event_hub_events_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_hub_events_namespace", value)

    @_builtins.property
    @pulumi.getter(name="eventHubEventsPath")
    def event_hub_events_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EventHub compatible path for events data
        """
        return pulumi.get(self, "event_hub_events_path")

    @event_hub_events_path.setter
    def event_hub_events_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_hub_events_path", value)

    @_builtins.property
    @pulumi.getter(name="eventHubOperationsEndpoint")
    def event_hub_operations_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EventHub compatible endpoint for operational data
        """
        return pulumi.get(self, "event_hub_operations_endpoint")

    @event_hub_operations_endpoint.setter
    def event_hub_operations_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_hub_operations_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="eventHubOperationsPath")
    def event_hub_operations_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EventHub compatible path for operational data
        """
        return pulumi.get(self, "event_hub_operations_path")

    @event_hub_operations_path.setter
    def event_hub_operations_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_hub_operations_path", value)

    @_builtins.property
    @pulumi.getter(name="eventHubPartitionCount")
    def event_hub_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of device-to-cloud partitions used by backing event hubs. Must be between `2` and `128`. Defaults to `4`.
        """
        return pulumi.get(self, "event_hub_partition_count")

    @event_hub_partition_count.setter
    def event_hub_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "event_hub_partition_count", value)

    @_builtins.property
    @pulumi.getter(name="eventHubRetentionInDays")
    def event_hub_retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The event hub retention to use in days. Must be between `1` and `7`. Defaults to `1`.
        """
        return pulumi.get(self, "event_hub_retention_in_days")

    @event_hub_retention_in_days.setter
    def event_hub_retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "event_hub_retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="fallbackRoute")
    def fallback_route(self) -> Optional[pulumi.Input['IoTHubFallbackRouteArgs']]:
        """
        A `fallback_route` block as defined below. If the fallback route is enabled, messages that don't match any of the supplied routes are automatically sent to this route. Defaults to messages/events.

        > **Note:** If `fallback_route` isn't explicitly specified, the fallback route wouldn't be enabled by default.
        """
        return pulumi.get(self, "fallback_route")

    @fallback_route.setter
    def fallback_route(self, value: Optional[pulumi.Input['IoTHubFallbackRouteArgs']]):
        pulumi.set(self, "fallback_route", value)

    @_builtins.property
    @pulumi.getter(name="fileUpload")
    def file_upload(self) -> Optional[pulumi.Input['IoTHubFileUploadArgs']]:
        """
        A `file_upload` block as defined below.
        """
        return pulumi.get(self, "file_upload")

    @file_upload.setter
    def file_upload(self, value: Optional[pulumi.Input['IoTHubFileUploadArgs']]):
        pulumi.set(self, "file_upload", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the IotHub Resource.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['IoTHubIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['IoTHubIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If false, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the IotHub resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleSets")
    def network_rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]]]:
        """
        A `network_rule_set` block as defined below.
        """
        return pulumi.get(self, "network_rule_sets")

    @network_rule_sets.setter
    def network_rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetArgs']]]]):
        pulumi.set(self, "network_rule_sets", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group under which the IotHub resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubRouteArgs']]]]:
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicies")
    def shared_access_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubSharedAccessPolicyArgs']]]]:
        """
        One or more `shared_access_policy` blocks as defined below.
        """
        return pulumi.get(self, "shared_access_policies")

    @shared_access_policies.setter
    def shared_access_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubSharedAccessPolicyArgs']]]]):
        pulumi.set(self, "shared_access_policies", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['IoTHubSkuArgs']]:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['IoTHubSkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:iot/ioTHub:IoTHub")
class IoTHub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_to_device: Optional[pulumi.Input[Union['IoTHubCloudToDeviceArgs', 'IoTHubCloudToDeviceArgsDict']]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEndpointArgs', 'IoTHubEndpointArgsDict']]]]] = None,
                 enrichments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEnrichmentArgs', 'IoTHubEnrichmentArgsDict']]]]] = None,
                 event_hub_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 event_hub_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_route: Optional[pulumi.Input[Union['IoTHubFallbackRouteArgs', 'IoTHubFallbackRouteArgsDict']]] = None,
                 file_upload: Optional[pulumi.Input[Union['IoTHubFileUploadArgs', 'IoTHubFileUploadArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['IoTHubIdentityArgs', 'IoTHubIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubNetworkRuleSetArgs', 'IoTHubNetworkRuleSetArgsDict']]]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubRouteArgs', 'IoTHubRouteArgsDict']]]]] = None,
                 sku: Optional[pulumi.Input[Union['IoTHubSkuArgs', 'IoTHubSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an IotHub

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        > **Note:** Routes can be defined either directly on the `iot.IoTHub` resource, or using the `iot.Route` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        > **Note:** Enrichments can be defined either directly on the `iot.IoTHub` resource, or using the `iot.Enrichment` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        > **Note:** Fallback route can be defined either directly on the `iot.IoTHub` resource, or using the `iot.FallbackRoute` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        > **Note:** File upload can be defined either directly on the `iot.IoTHub` resource, or using the `iot.FileUpload` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="examplecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_event_hub = azure.eventhub.EventHub("example",
            name="example-eventhub",
            resource_group_name=example.name,
            namespace_name=example_event_hub_namespace.name,
            partition_count=2,
            message_retention=1)
        example_authorization_rule = azure.eventhub.AuthorizationRule("example",
            resource_group_name=example.name,
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            name="acctest",
            send=True)
        example_io_t_hub = azure.iot.IoTHub("example",
            name="Example-IoTHub",
            resource_group_name=example.name,
            location=example.location,
            local_authentication_enabled=False,
            sku={
                "name": "S1",
                "capacity": 1,
            },
            endpoints=[
                {
                    "type": "AzureIotHub.StorageContainer",
                    "connection_string": example_account.primary_blob_connection_string,
                    "name": "export",
                    "batch_frequency_in_seconds": 60,
                    "max_chunk_size_in_bytes": 10485760,
                    "container_name": example_container.name,
                    "encoding": "Avro",
                    "file_name_format": "{iothub}/{partition}_{YYYY}_{MM}_{DD}_{HH}_{mm}",
                },
                {
                    "type": "AzureIotHub.EventHub",
                    "connection_string": example_authorization_rule.primary_connection_string,
                    "name": "export2",
                },
            ],
            routes=[
                {
                    "name": "export",
                    "source": "DeviceMessages",
                    "condition": "true",
                    "endpoint_names": ["export"],
                    "enabled": True,
                },
                {
                    "name": "export2",
                    "source": "DeviceMessages",
                    "condition": "true",
                    "endpoint_names": ["export2"],
                    "enabled": True,
                },
            ],
            enrichments=[{
                "key": "tenant",
                "value": "$twin.tags.Tenant",
                "endpoint_names": [
                    "export",
                    "export2",
                ],
            }],
            cloud_to_device={
                "max_delivery_count": 30,
                "default_ttl": "PT1H",
                "feedbacks": [{
                    "time_to_live": "PT1H10M",
                    "max_delivery_count": 15,
                    "lock_duration": "PT30S",
                }],
            },
            tags={
                "purpose": "testing",
            })
        ```

        ## Import

        IoTHubs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/ioTHub:IoTHub hub1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEndpointArgs', 'IoTHubEndpointArgsDict']]]] endpoints: An `endpoint` block as defined below.
        :param pulumi.Input[_builtins.int] event_hub_partition_count: The number of device-to-cloud partitions used by backing event hubs. Must be between `2` and `128`. Defaults to `4`.
        :param pulumi.Input[_builtins.int] event_hub_retention_in_days: The event hub retention to use in days. Must be between `1` and `7`. Defaults to `1`.
        :param pulumi.Input[Union['IoTHubFallbackRouteArgs', 'IoTHubFallbackRouteArgsDict']] fallback_route: A `fallback_route` block as defined below. If the fallback route is enabled, messages that don't match any of the supplied routes are automatically sent to this route. Defaults to messages/events.
               
               > **Note:** If `fallback_route` isn't explicitly specified, the fallback route wouldn't be enabled by default.
        :param pulumi.Input[Union['IoTHubFileUploadArgs', 'IoTHubFileUploadArgsDict']] file_upload: A `file_upload` block as defined below.
        :param pulumi.Input[Union['IoTHubIdentityArgs', 'IoTHubIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: If false, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IoTHubNetworkRuleSetArgs', 'IoTHubNetworkRuleSetArgsDict']]]] network_rule_sets: A `network_rule_set` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['IoTHubSkuArgs', 'IoTHubSkuArgsDict']] sku: A `sku` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IoTHubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub

        > **Note:** Endpoints can be defined either directly on the `iot.IoTHub` resource, or using the `azurerm_iothub_endpoint_*` resources - but the two ways of defining the endpoints cannot be used together. If both are used against the same IoTHub, spurious changes will occur. Also, defining a `azurerm_iothub_endpoint_*` resource and another endpoint of a different type directly on the `iot.IoTHub` resource is not supported.

        > **Note:** Routes can be defined either directly on the `iot.IoTHub` resource, or using the `iot.Route` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        > **Note:** Enrichments can be defined either directly on the `iot.IoTHub` resource, or using the `iot.Enrichment` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        > **Note:** Fallback route can be defined either directly on the `iot.IoTHub` resource, or using the `iot.FallbackRoute` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        > **Note:** File upload can be defined either directly on the `iot.IoTHub` resource, or using the `iot.FileUpload` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="examplecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_event_hub = azure.eventhub.EventHub("example",
            name="example-eventhub",
            resource_group_name=example.name,
            namespace_name=example_event_hub_namespace.name,
            partition_count=2,
            message_retention=1)
        example_authorization_rule = azure.eventhub.AuthorizationRule("example",
            resource_group_name=example.name,
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            name="acctest",
            send=True)
        example_io_t_hub = azure.iot.IoTHub("example",
            name="Example-IoTHub",
            resource_group_name=example.name,
            location=example.location,
            local_authentication_enabled=False,
            sku={
                "name": "S1",
                "capacity": 1,
            },
            endpoints=[
                {
                    "type": "AzureIotHub.StorageContainer",
                    "connection_string": example_account.primary_blob_connection_string,
                    "name": "export",
                    "batch_frequency_in_seconds": 60,
                    "max_chunk_size_in_bytes": 10485760,
                    "container_name": example_container.name,
                    "encoding": "Avro",
                    "file_name_format": "{iothub}/{partition}_{YYYY}_{MM}_{DD}_{HH}_{mm}",
                },
                {
                    "type": "AzureIotHub.EventHub",
                    "connection_string": example_authorization_rule.primary_connection_string,
                    "name": "export2",
                },
            ],
            routes=[
                {
                    "name": "export",
                    "source": "DeviceMessages",
                    "condition": "true",
                    "endpoint_names": ["export"],
                    "enabled": True,
                },
                {
                    "name": "export2",
                    "source": "DeviceMessages",
                    "condition": "true",
                    "endpoint_names": ["export2"],
                    "enabled": True,
                },
            ],
            enrichments=[{
                "key": "tenant",
                "value": "$twin.tags.Tenant",
                "endpoint_names": [
                    "export",
                    "export2",
                ],
            }],
            cloud_to_device={
                "max_delivery_count": 30,
                "default_ttl": "PT1H",
                "feedbacks": [{
                    "time_to_live": "PT1H10M",
                    "max_delivery_count": 15,
                    "lock_duration": "PT30S",
                }],
            },
            tags={
                "purpose": "testing",
            })
        ```

        ## Import

        IoTHubs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/ioTHub:IoTHub hub1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1
        ```

        :param str resource_name: The name of the resource.
        :param IoTHubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IoTHubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_to_device: Optional[pulumi.Input[Union['IoTHubCloudToDeviceArgs', 'IoTHubCloudToDeviceArgsDict']]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEndpointArgs', 'IoTHubEndpointArgsDict']]]]] = None,
                 enrichments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEnrichmentArgs', 'IoTHubEnrichmentArgsDict']]]]] = None,
                 event_hub_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 event_hub_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_route: Optional[pulumi.Input[Union['IoTHubFallbackRouteArgs', 'IoTHubFallbackRouteArgsDict']]] = None,
                 file_upload: Optional[pulumi.Input[Union['IoTHubFileUploadArgs', 'IoTHubFileUploadArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['IoTHubIdentityArgs', 'IoTHubIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubNetworkRuleSetArgs', 'IoTHubNetworkRuleSetArgsDict']]]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubRouteArgs', 'IoTHubRouteArgsDict']]]]] = None,
                 sku: Optional[pulumi.Input[Union['IoTHubSkuArgs', 'IoTHubSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IoTHubArgs.__new__(IoTHubArgs)

            __props__.__dict__["cloud_to_device"] = cloud_to_device
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["enrichments"] = enrichments
            __props__.__dict__["event_hub_partition_count"] = event_hub_partition_count
            __props__.__dict__["event_hub_retention_in_days"] = event_hub_retention_in_days
            __props__.__dict__["fallback_route"] = fallback_route
            __props__.__dict__["file_upload"] = file_upload
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["min_tls_version"] = min_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["network_rule_sets"] = network_rule_sets
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["routes"] = routes
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["event_hub_events_endpoint"] = None
            __props__.__dict__["event_hub_events_namespace"] = None
            __props__.__dict__["event_hub_events_path"] = None
            __props__.__dict__["event_hub_operations_endpoint"] = None
            __props__.__dict__["event_hub_operations_path"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["shared_access_policies"] = None
            __props__.__dict__["type"] = None
        super(IoTHub, __self__).__init__(
            'azure:iot/ioTHub:IoTHub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_to_device: Optional[pulumi.Input[Union['IoTHubCloudToDeviceArgs', 'IoTHubCloudToDeviceArgsDict']]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEndpointArgs', 'IoTHubEndpointArgsDict']]]]] = None,
            enrichments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEnrichmentArgs', 'IoTHubEnrichmentArgsDict']]]]] = None,
            event_hub_events_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            event_hub_events_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            event_hub_events_path: Optional[pulumi.Input[_builtins.str]] = None,
            event_hub_operations_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            event_hub_operations_path: Optional[pulumi.Input[_builtins.str]] = None,
            event_hub_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
            event_hub_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            fallback_route: Optional[pulumi.Input[Union['IoTHubFallbackRouteArgs', 'IoTHubFallbackRouteArgsDict']]] = None,
            file_upload: Optional[pulumi.Input[Union['IoTHubFileUploadArgs', 'IoTHubFileUploadArgsDict']]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['IoTHubIdentityArgs', 'IoTHubIdentityArgsDict']]] = None,
            local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            min_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubNetworkRuleSetArgs', 'IoTHubNetworkRuleSetArgsDict']]]]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubRouteArgs', 'IoTHubRouteArgsDict']]]]] = None,
            shared_access_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IoTHubSharedAccessPolicyArgs', 'IoTHubSharedAccessPolicyArgsDict']]]]] = None,
            sku: Optional[pulumi.Input[Union['IoTHubSkuArgs', 'IoTHubSkuArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'IoTHub':
        """
        Get an existing IoTHub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IoTHubEndpointArgs', 'IoTHubEndpointArgsDict']]]] endpoints: An `endpoint` block as defined below.
        :param pulumi.Input[_builtins.str] event_hub_events_endpoint: The EventHub compatible endpoint for events data
        :param pulumi.Input[_builtins.str] event_hub_events_namespace: The EventHub namespace for events data
        :param pulumi.Input[_builtins.str] event_hub_events_path: The EventHub compatible path for events data
        :param pulumi.Input[_builtins.str] event_hub_operations_endpoint: The EventHub compatible endpoint for operational data
        :param pulumi.Input[_builtins.str] event_hub_operations_path: The EventHub compatible path for operational data
        :param pulumi.Input[_builtins.int] event_hub_partition_count: The number of device-to-cloud partitions used by backing event hubs. Must be between `2` and `128`. Defaults to `4`.
        :param pulumi.Input[_builtins.int] event_hub_retention_in_days: The event hub retention to use in days. Must be between `1` and `7`. Defaults to `1`.
        :param pulumi.Input[Union['IoTHubFallbackRouteArgs', 'IoTHubFallbackRouteArgsDict']] fallback_route: A `fallback_route` block as defined below. If the fallback route is enabled, messages that don't match any of the supplied routes are automatically sent to this route. Defaults to messages/events.
               
               > **Note:** If `fallback_route` isn't explicitly specified, the fallback route wouldn't be enabled by default.
        :param pulumi.Input[Union['IoTHubFileUploadArgs', 'IoTHubFileUploadArgsDict']] file_upload: A `file_upload` block as defined below.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the IotHub Resource.
        :param pulumi.Input[Union['IoTHubIdentityArgs', 'IoTHubIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: If false, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IoTHubNetworkRuleSetArgs', 'IoTHubNetworkRuleSetArgsDict']]]] network_rule_sets: A `network_rule_set` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IoTHubSharedAccessPolicyArgs', 'IoTHubSharedAccessPolicyArgsDict']]]] shared_access_policies: One or more `shared_access_policy` blocks as defined below.
        :param pulumi.Input[Union['IoTHubSkuArgs', 'IoTHubSkuArgsDict']] sku: A `sku` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IoTHubState.__new__(_IoTHubState)

        __props__.__dict__["cloud_to_device"] = cloud_to_device
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["enrichments"] = enrichments
        __props__.__dict__["event_hub_events_endpoint"] = event_hub_events_endpoint
        __props__.__dict__["event_hub_events_namespace"] = event_hub_events_namespace
        __props__.__dict__["event_hub_events_path"] = event_hub_events_path
        __props__.__dict__["event_hub_operations_endpoint"] = event_hub_operations_endpoint
        __props__.__dict__["event_hub_operations_path"] = event_hub_operations_path
        __props__.__dict__["event_hub_partition_count"] = event_hub_partition_count
        __props__.__dict__["event_hub_retention_in_days"] = event_hub_retention_in_days
        __props__.__dict__["fallback_route"] = fallback_route
        __props__.__dict__["file_upload"] = file_upload
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["min_tls_version"] = min_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["network_rule_sets"] = network_rule_sets
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["routes"] = routes
        __props__.__dict__["shared_access_policies"] = shared_access_policies
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return IoTHub(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudToDevice")
    def cloud_to_device(self) -> pulumi.Output['outputs.IoTHubCloudToDevice']:
        return pulumi.get(self, "cloud_to_device")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.IoTHubEndpoint']]:
        """
        An `endpoint` block as defined below.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def enrichments(self) -> pulumi.Output[Sequence['outputs.IoTHubEnrichment']]:
        return pulumi.get(self, "enrichments")

    @_builtins.property
    @pulumi.getter(name="eventHubEventsEndpoint")
    def event_hub_events_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The EventHub compatible endpoint for events data
        """
        return pulumi.get(self, "event_hub_events_endpoint")

    @_builtins.property
    @pulumi.getter(name="eventHubEventsNamespace")
    def event_hub_events_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The EventHub namespace for events data
        """
        return pulumi.get(self, "event_hub_events_namespace")

    @_builtins.property
    @pulumi.getter(name="eventHubEventsPath")
    def event_hub_events_path(self) -> pulumi.Output[_builtins.str]:
        """
        The EventHub compatible path for events data
        """
        return pulumi.get(self, "event_hub_events_path")

    @_builtins.property
    @pulumi.getter(name="eventHubOperationsEndpoint")
    def event_hub_operations_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The EventHub compatible endpoint for operational data
        """
        return pulumi.get(self, "event_hub_operations_endpoint")

    @_builtins.property
    @pulumi.getter(name="eventHubOperationsPath")
    def event_hub_operations_path(self) -> pulumi.Output[_builtins.str]:
        """
        The EventHub compatible path for operational data
        """
        return pulumi.get(self, "event_hub_operations_path")

    @_builtins.property
    @pulumi.getter(name="eventHubPartitionCount")
    def event_hub_partition_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of device-to-cloud partitions used by backing event hubs. Must be between `2` and `128`. Defaults to `4`.
        """
        return pulumi.get(self, "event_hub_partition_count")

    @_builtins.property
    @pulumi.getter(name="eventHubRetentionInDays")
    def event_hub_retention_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The event hub retention to use in days. Must be between `1` and `7`. Defaults to `1`.
        """
        return pulumi.get(self, "event_hub_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="fallbackRoute")
    def fallback_route(self) -> pulumi.Output['outputs.IoTHubFallbackRoute']:
        """
        A `fallback_route` block as defined below. If the fallback route is enabled, messages that don't match any of the supplied routes are automatically sent to this route. Defaults to messages/events.

        > **Note:** If `fallback_route` isn't explicitly specified, the fallback route wouldn't be enabled by default.
        """
        return pulumi.get(self, "fallback_route")

    @_builtins.property
    @pulumi.getter(name="fileUpload")
    def file_upload(self) -> pulumi.Output[Optional['outputs.IoTHubFileUpload']]:
        """
        A `file_upload` block as defined below.
        """
        return pulumi.get(self, "file_upload")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the IotHub Resource.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.IoTHubIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If false, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "min_tls_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the IotHub resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkRuleSets")
    def network_rule_sets(self) -> pulumi.Output[Optional[Sequence['outputs.IoTHubNetworkRuleSet']]]:
        """
        A `network_rule_set` block as defined below.
        """
        return pulumi.get(self, "network_rule_sets")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group under which the IotHub resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Sequence['outputs.IoTHubRoute']]:
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicies")
    def shared_access_policies(self) -> pulumi.Output[Sequence['outputs.IoTHubSharedAccessPolicy']]:
        """
        One or more `shared_access_policy` blocks as defined below.
        """
        return pulumi.get(self, "shared_access_policies")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.IoTHubSku']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

