# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificatesResult',
    'AwaitableGetCertificatesResult',
    'get_certificates',
    'get_certificates_output',
]

@pulumi.output_type
class GetCertificatesResult:
    """
    A collection of values returned by getCertificates.
    """
    def __init__(__self__, certificates=None, id=None, include_pending=None, key_vault_id=None, names=None):
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_pending and not isinstance(include_pending, bool):
            raise TypeError("Expected argument 'include_pending' to be a bool")
        pulumi.set(__self__, "include_pending", include_pending)
        if key_vault_id and not isinstance(key_vault_id, str):
            raise TypeError("Expected argument 'key_vault_id' to be a str")
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetCertificatesCertificateResult']:
        """
        One or more `certificates` blocks as defined below.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includePending")
    def include_pending(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_pending")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The Key Vault ID.
        """
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        List containing names of certificates that exist in this Key Vault.
        """
        return pulumi.get(self, "names")


class AwaitableGetCertificatesResult(GetCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificatesResult(
            certificates=self.certificates,
            id=self.id,
            include_pending=self.include_pending,
            key_vault_id=self.key_vault_id,
            names=self.names)


def get_certificates(include_pending: Optional[_builtins.bool] = None,
                     key_vault_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificatesResult:
    """
    Use this data source to retrieve a list of certificate names from an existing Key Vault.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure
    import pulumi_std as std

    example = azure.keyvault.get_certificates(key_vault_id=existing["id"])
    example_get_certificate = {__key: azure.keyvault.get_certificate(name=__key,
        key_vault_id=existing["id"]) for __key, __value in std.toset(input=example.names).result}
    ```


    :param _builtins.bool include_pending: Specifies whether to include certificates which are not completely provisioned. Defaults to true.
    :param _builtins.str key_vault_id: Specifies the ID of the Key Vault instance to fetch certificate names from, available on the `keyvault.KeyVault` Data Source / Resource.
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    """
    __args__ = dict()
    __args__['includePending'] = include_pending
    __args__['keyVaultId'] = key_vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:keyvault/getCertificates:getCertificates', __args__, opts=opts, typ=GetCertificatesResult).value

    return AwaitableGetCertificatesResult(
        certificates=pulumi.get(__ret__, 'certificates'),
        id=pulumi.get(__ret__, 'id'),
        include_pending=pulumi.get(__ret__, 'include_pending'),
        key_vault_id=pulumi.get(__ret__, 'key_vault_id'),
        names=pulumi.get(__ret__, 'names'))
def get_certificates_output(include_pending: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                            key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificatesResult]:
    """
    Use this data source to retrieve a list of certificate names from an existing Key Vault.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure
    import pulumi_std as std

    example = azure.keyvault.get_certificates(key_vault_id=existing["id"])
    example_get_certificate = {__key: azure.keyvault.get_certificate(name=__key,
        key_vault_id=existing["id"]) for __key, __value in std.toset(input=example.names).result}
    ```


    :param _builtins.bool include_pending: Specifies whether to include certificates which are not completely provisioned. Defaults to true.
    :param _builtins.str key_vault_id: Specifies the ID of the Key Vault instance to fetch certificate names from, available on the `keyvault.KeyVault` Data Source / Resource.
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    """
    __args__ = dict()
    __args__['includePending'] = include_pending
    __args__['keyVaultId'] = key_vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:keyvault/getCertificates:getCertificates', __args__, opts=opts, typ=GetCertificatesResult)
    return __ret__.apply(lambda __response__: GetCertificatesResult(
        certificates=pulumi.get(__response__, 'certificates'),
        id=pulumi.get(__response__, 'id'),
        include_pending=pulumi.get(__response__, 'include_pending'),
        key_vault_id=pulumi.get(__response__, 'key_vault_id'),
        names=pulumi.get(__response__, 'names')))
