# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedHardwareSecurityModuleArgs', 'ManagedHardwareSecurityModule']

@pulumi.input_type
class ManagedHardwareSecurityModuleArgs:
    def __init__(__self__, *,
                 admin_object_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_domain_key_vault_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_domain_quorum: Optional[pulumi.Input[_builtins.int]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ManagedHardwareSecurityModule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] admin_object_ids: Specifies a list of administrators object IDs for the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault Managed Hardware Security Module. Possible value is `Standard_B1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID that should be used for authenticating requests to the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs'] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether traffic from public networks is permitted. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault Managed Hardware Security Module? Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_domain_key_vault_certificate_ids: A list of KeyVault certificates resource IDs (minimum of three and up to a maximum of 10) to activate this Managed HSM. More information see [activate-your-managed-hsm](https://learn.microsoft.com/azure/key-vault/managed-hsm/quick-create-cli#activate-your-managed-hsm)
        :param pulumi.Input[_builtins.int] security_domain_quorum: Specifies the minimum number of shares required to decrypt the security domain for recovery. This is required when `security_domain_key_vault_certificate_ids` is specified. Valid values are between 2 and 10.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` days. Defaults to `90`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "admin_object_ids", admin_object_ids)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if security_domain_key_vault_certificate_ids is not None:
            pulumi.set(__self__, "security_domain_key_vault_certificate_ids", security_domain_key_vault_certificate_ids)
        if security_domain_quorum is not None:
            pulumi.set(__self__, "security_domain_quorum", security_domain_quorum)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="adminObjectIds")
    def admin_object_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of administrators object IDs for the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_object_ids")

    @admin_object_ids.setter
    def admin_object_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "admin_object_ids", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the SKU used for this Key Vault Managed Hardware Security Module. Possible value is `Standard_B1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure Active Directory Tenant ID that should be used for authenticating requests to the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether traffic from public networks is permitted. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Purge Protection enabled for this Key Vault Managed Hardware Security Module? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="securityDomainKeyVaultCertificateIds")
    def security_domain_key_vault_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of KeyVault certificates resource IDs (minimum of three and up to a maximum of 10) to activate this Managed HSM. More information see [activate-your-managed-hsm](https://learn.microsoft.com/azure/key-vault/managed-hsm/quick-create-cli#activate-your-managed-hsm)
        """
        return pulumi.get(self, "security_domain_key_vault_certificate_ids")

    @security_domain_key_vault_certificate_ids.setter
    def security_domain_key_vault_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_domain_key_vault_certificate_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityDomainQuorum")
    def security_domain_quorum(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of shares required to decrypt the security domain for recovery. This is required when `security_domain_key_vault_certificate_ids` is specified. Valid values are between 2 and 10.
        """
        return pulumi.get(self, "security_domain_quorum")

    @security_domain_quorum.setter
    def security_domain_quorum(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "security_domain_quorum", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` days. Defaults to `90`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "soft_delete_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ManagedHardwareSecurityModuleState:
    def __init__(__self__, *,
                 admin_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hsm_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_domain_encrypted_data: Optional[pulumi.Input[_builtins.str]] = None,
                 security_domain_key_vault_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_domain_quorum: Optional[pulumi.Input[_builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedHardwareSecurityModule resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] admin_object_ids: Specifies a list of administrators object IDs for the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hsm_uri: The URI of the Key Vault Managed Hardware Security Module, used for performing operations on keys.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs'] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether traffic from public networks is permitted. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault Managed Hardware Security Module? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] security_domain_encrypted_data: This attribute can be used for disaster recovery or when creating another Managed HSM that shares the same security domain.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_domain_key_vault_certificate_ids: A list of KeyVault certificates resource IDs (minimum of three and up to a maximum of 10) to activate this Managed HSM. More information see [activate-your-managed-hsm](https://learn.microsoft.com/azure/key-vault/managed-hsm/quick-create-cli#activate-your-managed-hsm)
        :param pulumi.Input[_builtins.int] security_domain_quorum: Specifies the minimum number of shares required to decrypt the security domain for recovery. This is required when `security_domain_key_vault_certificate_ids` is specified. Valid values are between 2 and 10.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault Managed Hardware Security Module. Possible value is `Standard_B1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` days. Defaults to `90`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID that should be used for authenticating requests to the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        if admin_object_ids is not None:
            pulumi.set(__self__, "admin_object_ids", admin_object_ids)
        if hsm_uri is not None:
            pulumi.set(__self__, "hsm_uri", hsm_uri)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if security_domain_encrypted_data is not None:
            pulumi.set(__self__, "security_domain_encrypted_data", security_domain_encrypted_data)
        if security_domain_key_vault_certificate_ids is not None:
            pulumi.set(__self__, "security_domain_key_vault_certificate_ids", security_domain_key_vault_certificate_ids)
        if security_domain_quorum is not None:
            pulumi.set(__self__, "security_domain_quorum", security_domain_quorum)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="adminObjectIds")
    def admin_object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of administrators object IDs for the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_object_ids")

    @admin_object_ids.setter
    def admin_object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "admin_object_ids", value)

    @_builtins.property
    @pulumi.getter(name="hsmUri")
    def hsm_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the Key Vault Managed Hardware Security Module, used for performing operations on keys.
        """
        return pulumi.get(self, "hsm_uri")

    @hsm_uri.setter
    def hsm_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hsm_uri", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['ManagedHardwareSecurityModuleNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether traffic from public networks is permitted. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Purge Protection enabled for this Key Vault Managed Hardware Security Module? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityDomainEncryptedData")
    def security_domain_encrypted_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This attribute can be used for disaster recovery or when creating another Managed HSM that shares the same security domain.
        """
        return pulumi.get(self, "security_domain_encrypted_data")

    @security_domain_encrypted_data.setter
    def security_domain_encrypted_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_domain_encrypted_data", value)

    @_builtins.property
    @pulumi.getter(name="securityDomainKeyVaultCertificateIds")
    def security_domain_key_vault_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of KeyVault certificates resource IDs (minimum of three and up to a maximum of 10) to activate this Managed HSM. More information see [activate-your-managed-hsm](https://learn.microsoft.com/azure/key-vault/managed-hsm/quick-create-cli#activate-your-managed-hsm)
        """
        return pulumi.get(self, "security_domain_key_vault_certificate_ids")

    @security_domain_key_vault_certificate_ids.setter
    def security_domain_key_vault_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_domain_key_vault_certificate_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityDomainQuorum")
    def security_domain_quorum(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of shares required to decrypt the security domain for recovery. This is required when `security_domain_key_vault_certificate_ids` is specified. Valid values are between 2 and 10.
        """
        return pulumi.get(self, "security_domain_quorum")

    @security_domain_quorum.setter
    def security_domain_quorum(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "security_domain_quorum", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the SKU used for this Key Vault Managed Hardware Security Module. Possible value is `Standard_B1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` days. Defaults to `90`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "soft_delete_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory Tenant ID that should be used for authenticating requests to the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:keyvault/managedHardwareSecurityModule:ManagedHardwareSecurityModule")
class ManagedHardwareSecurityModule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['ManagedHardwareSecurityModuleNetworkAclsArgs', 'ManagedHardwareSecurityModuleNetworkAclsArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_domain_key_vault_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_domain_quorum: Optional[pulumi.Input[_builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Key Vault Managed Hardware Security Module.

        > **Note:** The Azure Provider includes a Feature Toggle which will purge a Key Vault Managed Hardware Security Module resource on destroy, rather than the default soft-delete. See `purge_soft_deleted_hardware_security_modules_on_destroy` for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_managed_hardware_security_module = azure.keyvault.ManagedHardwareSecurityModule("example",
            name="exampleKVHsm",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Standard_B1",
            purge_protection_enabled=False,
            soft_delete_retention_days=90,
            tenant_id=current.tenant_id,
            admin_object_ids=[current.object_id],
            tags={
                "Env": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.KeyVault` - 2023-07-01

        ## Import

        Key Vault Managed Hardware Security Module can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedHardwareSecurityModule:ManagedHardwareSecurityModule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/managedHSMs/hsm1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] admin_object_ids: Specifies a list of administrators object IDs for the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ManagedHardwareSecurityModuleNetworkAclsArgs', 'ManagedHardwareSecurityModuleNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether traffic from public networks is permitted. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault Managed Hardware Security Module? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_domain_key_vault_certificate_ids: A list of KeyVault certificates resource IDs (minimum of three and up to a maximum of 10) to activate this Managed HSM. More information see [activate-your-managed-hsm](https://learn.microsoft.com/azure/key-vault/managed-hsm/quick-create-cli#activate-your-managed-hsm)
        :param pulumi.Input[_builtins.int] security_domain_quorum: Specifies the minimum number of shares required to decrypt the security domain for recovery. This is required when `security_domain_key_vault_certificate_ids` is specified. Valid values are between 2 and 10.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault Managed Hardware Security Module. Possible value is `Standard_B1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` days. Defaults to `90`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID that should be used for authenticating requests to the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedHardwareSecurityModuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Key Vault Managed Hardware Security Module.

        > **Note:** The Azure Provider includes a Feature Toggle which will purge a Key Vault Managed Hardware Security Module resource on destroy, rather than the default soft-delete. See `purge_soft_deleted_hardware_security_modules_on_destroy` for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_managed_hardware_security_module = azure.keyvault.ManagedHardwareSecurityModule("example",
            name="exampleKVHsm",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Standard_B1",
            purge_protection_enabled=False,
            soft_delete_retention_days=90,
            tenant_id=current.tenant_id,
            admin_object_ids=[current.object_id],
            tags={
                "Env": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.KeyVault` - 2023-07-01

        ## Import

        Key Vault Managed Hardware Security Module can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedHardwareSecurityModule:ManagedHardwareSecurityModule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/managedHSMs/hsm1
        ```

        :param str resource_name: The name of the resource.
        :param ManagedHardwareSecurityModuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedHardwareSecurityModuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['ManagedHardwareSecurityModuleNetworkAclsArgs', 'ManagedHardwareSecurityModuleNetworkAclsArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_domain_key_vault_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_domain_quorum: Optional[pulumi.Input[_builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedHardwareSecurityModuleArgs.__new__(ManagedHardwareSecurityModuleArgs)

            if admin_object_ids is None and not opts.urn:
                raise TypeError("Missing required property 'admin_object_ids'")
            __props__.__dict__["admin_object_ids"] = admin_object_ids
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_acls"] = network_acls
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["security_domain_key_vault_certificate_ids"] = security_domain_key_vault_certificate_ids
            __props__.__dict__["security_domain_quorum"] = security_domain_quorum
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["hsm_uri"] = None
            __props__.__dict__["security_domain_encrypted_data"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["securityDomainEncryptedData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedHardwareSecurityModule, __self__).__init__(
            'azure:keyvault/managedHardwareSecurityModule:ManagedHardwareSecurityModule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hsm_uri: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_acls: Optional[pulumi.Input[Union['ManagedHardwareSecurityModuleNetworkAclsArgs', 'ManagedHardwareSecurityModuleNetworkAclsArgsDict']]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_domain_encrypted_data: Optional[pulumi.Input[_builtins.str]] = None,
            security_domain_key_vault_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_domain_quorum: Optional[pulumi.Input[_builtins.int]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedHardwareSecurityModule':
        """
        Get an existing ManagedHardwareSecurityModule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] admin_object_ids: Specifies a list of administrators object IDs for the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hsm_uri: The URI of the Key Vault Managed Hardware Security Module, used for performing operations on keys.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ManagedHardwareSecurityModuleNetworkAclsArgs', 'ManagedHardwareSecurityModuleNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether traffic from public networks is permitted. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault Managed Hardware Security Module? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] security_domain_encrypted_data: This attribute can be used for disaster recovery or when creating another Managed HSM that shares the same security domain.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_domain_key_vault_certificate_ids: A list of KeyVault certificates resource IDs (minimum of three and up to a maximum of 10) to activate this Managed HSM. More information see [activate-your-managed-hsm](https://learn.microsoft.com/azure/key-vault/managed-hsm/quick-create-cli#activate-your-managed-hsm)
        :param pulumi.Input[_builtins.int] security_domain_quorum: Specifies the minimum number of shares required to decrypt the security domain for recovery. This is required when `security_domain_key_vault_certificate_ids` is specified. Valid values are between 2 and 10.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault Managed Hardware Security Module. Possible value is `Standard_B1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` days. Defaults to `90`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID that should be used for authenticating requests to the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedHardwareSecurityModuleState.__new__(_ManagedHardwareSecurityModuleState)

        __props__.__dict__["admin_object_ids"] = admin_object_ids
        __props__.__dict__["hsm_uri"] = hsm_uri
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_acls"] = network_acls
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["security_domain_encrypted_data"] = security_domain_encrypted_data
        __props__.__dict__["security_domain_key_vault_certificate_ids"] = security_domain_key_vault_certificate_ids
        __props__.__dict__["security_domain_quorum"] = security_domain_quorum
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        return ManagedHardwareSecurityModule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminObjectIds")
    def admin_object_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of administrators object IDs for the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_object_ids")

    @_builtins.property
    @pulumi.getter(name="hsmUri")
    def hsm_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the Key Vault Managed Hardware Security Module, used for performing operations on keys.
        """
        return pulumi.get(self, "hsm_uri")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> pulumi.Output['outputs.ManagedHardwareSecurityModuleNetworkAcls']:
        """
        A `network_acls` block as defined below.
        """
        return pulumi.get(self, "network_acls")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether traffic from public networks is permitted. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Purge Protection enabled for this Key Vault Managed Hardware Security Module? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "purge_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Key Vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="securityDomainEncryptedData")
    def security_domain_encrypted_data(self) -> pulumi.Output[_builtins.str]:
        """
        This attribute can be used for disaster recovery or when creating another Managed HSM that shares the same security domain.
        """
        return pulumi.get(self, "security_domain_encrypted_data")

    @_builtins.property
    @pulumi.getter(name="securityDomainKeyVaultCertificateIds")
    def security_domain_key_vault_certificate_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of KeyVault certificates resource IDs (minimum of three and up to a maximum of 10) to activate this Managed HSM. More information see [activate-your-managed-hsm](https://learn.microsoft.com/azure/key-vault/managed-hsm/quick-create-cli#activate-your-managed-hsm)
        """
        return pulumi.get(self, "security_domain_key_vault_certificate_ids")

    @_builtins.property
    @pulumi.getter(name="securityDomainQuorum")
    def security_domain_quorum(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the minimum number of shares required to decrypt the security domain for recovery. This is required when `security_domain_key_vault_certificate_ids` is specified. Valid values are between 2 and 10.
        """
        return pulumi.get(self, "security_domain_quorum")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the SKU used for this Key Vault Managed Hardware Security Module. Possible value is `Standard_B1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` days. Defaults to `90`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Active Directory Tenant ID that should be used for authenticating requests to the key vault Managed Hardware Security Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

