# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedHardwareSecurityModuleRoleAssignmentArgs', 'ManagedHardwareSecurityModuleRoleAssignment']

@pulumi.input_type
class ManagedHardwareSecurityModuleRoleAssignmentArgs:
    def __init__(__self__, *,
                 managed_hsm_id: pulumi.Input[_builtins.str],
                 principal_id: pulumi.Input[_builtins.str],
                 role_definition_id: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedHardwareSecurityModuleRoleAssignment resource.
        :param pulumi.Input[_builtins.str] managed_hsm_id: The ID of a Managed Hardware Security Module resource. Changing this forces a new Managed Hardware Security Module to be created.
               *
        :param pulumi.Input[_builtins.str] principal_id: The principal ID to be assigned to this role. It can point to a user, service principal, or security group. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] role_definition_id: The resource ID of the role definition to assign. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope to create the role assignment. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] name: The name in GUID notation which should be used for this Managed Hardware Security Module Role Assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        pulumi.set(__self__, "managed_hsm_id", managed_hsm_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        pulumi.set(__self__, "scope", scope)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="managedHsmId")
    def managed_hsm_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of a Managed Hardware Security Module resource. Changing this forces a new Managed Hardware Security Module to be created.
        *
        """
        return pulumi.get(self, "managed_hsm_id")

    @managed_hsm_id.setter
    def managed_hsm_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_hsm_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The principal ID to be assigned to this role. It can point to a user, service principal, or security group. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the role definition to assign. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the scope to create the role assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name in GUID notation which should be used for this Managed Hardware Security Module Role Assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ManagedHardwareSecurityModuleRoleAssignmentState:
    def __init__(__self__, *,
                 managed_hsm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedHardwareSecurityModuleRoleAssignment resources.
        :param pulumi.Input[_builtins.str] managed_hsm_id: The ID of a Managed Hardware Security Module resource. Changing this forces a new Managed Hardware Security Module to be created.
               *
        :param pulumi.Input[_builtins.str] name: The name in GUID notation which should be used for this Managed Hardware Security Module Role Assignment. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] principal_id: The principal ID to be assigned to this role. It can point to a user, service principal, or security group. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] resource_id: (Deprecated) The resource id of created assignment resource.
        :param pulumi.Input[_builtins.str] role_definition_id: The resource ID of the role definition to assign. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope to create the role assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        if managed_hsm_id is not None:
            pulumi.set(__self__, "managed_hsm_id", managed_hsm_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="managedHsmId")
    def managed_hsm_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Managed Hardware Security Module resource. Changing this forces a new Managed Hardware Security Module to be created.
        *
        """
        return pulumi.get(self, "managed_hsm_id")

    @managed_hsm_id.setter
    def managed_hsm_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_hsm_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name in GUID notation which should be used for this Managed Hardware Security Module Role Assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The principal ID to be assigned to this role. It can point to a user, service principal, or security group. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The resource id of created assignment resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the role definition to assign. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope to create the role assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("azure:keyvault/managedHardwareSecurityModuleRoleAssignment:ManagedHardwareSecurityModuleRoleAssignment")
class ManagedHardwareSecurityModuleRoleAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_hsm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Managed Hardware Security Module Role Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        user = azure.keyvault.get_managed_hardware_security_module_role_definition(managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
            name="21dbd100-6940-42c2-9190-5d6cb909625b")
        example = azure.keyvault.ManagedHardwareSecurityModuleRoleAssignment("example",
            name="a9dbe818-56e7-5878-c0ce-a1477692c1d6",
            managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
            scope=user.scope,
            role_definition_id=user.resource_manager_id,
            principal_id=current["objectId"])
        ```

        ## Import

        Managed Hardware Security Modules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedHardwareSecurityModuleRoleAssignment:ManagedHardwareSecurityModuleRoleAssignment example https://0000.managedhsm.azure.net///RoleAssignment/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_hsm_id: The ID of a Managed Hardware Security Module resource. Changing this forces a new Managed Hardware Security Module to be created.
               *
        :param pulumi.Input[_builtins.str] name: The name in GUID notation which should be used for this Managed Hardware Security Module Role Assignment. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] principal_id: The principal ID to be assigned to this role. It can point to a user, service principal, or security group. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] role_definition_id: The resource ID of the role definition to assign. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope to create the role assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedHardwareSecurityModuleRoleAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Managed Hardware Security Module Role Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        user = azure.keyvault.get_managed_hardware_security_module_role_definition(managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
            name="21dbd100-6940-42c2-9190-5d6cb909625b")
        example = azure.keyvault.ManagedHardwareSecurityModuleRoleAssignment("example",
            name="a9dbe818-56e7-5878-c0ce-a1477692c1d6",
            managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
            scope=user.scope,
            role_definition_id=user.resource_manager_id,
            principal_id=current["objectId"])
        ```

        ## Import

        Managed Hardware Security Modules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedHardwareSecurityModuleRoleAssignment:ManagedHardwareSecurityModuleRoleAssignment example https://0000.managedhsm.azure.net///RoleAssignment/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ManagedHardwareSecurityModuleRoleAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedHardwareSecurityModuleRoleAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_hsm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedHardwareSecurityModuleRoleAssignmentArgs.__new__(ManagedHardwareSecurityModuleRoleAssignmentArgs)

            if managed_hsm_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_hsm_id'")
            __props__.__dict__["managed_hsm_id"] = managed_hsm_id
            __props__.__dict__["name"] = name
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if role_definition_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_definition_id'")
            __props__.__dict__["role_definition_id"] = role_definition_id
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["resource_id"] = None
        super(ManagedHardwareSecurityModuleRoleAssignment, __self__).__init__(
            'azure:keyvault/managedHardwareSecurityModuleRoleAssignment:ManagedHardwareSecurityModuleRoleAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_hsm_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedHardwareSecurityModuleRoleAssignment':
        """
        Get an existing ManagedHardwareSecurityModuleRoleAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_hsm_id: The ID of a Managed Hardware Security Module resource. Changing this forces a new Managed Hardware Security Module to be created.
               *
        :param pulumi.Input[_builtins.str] name: The name in GUID notation which should be used for this Managed Hardware Security Module Role Assignment. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] principal_id: The principal ID to be assigned to this role. It can point to a user, service principal, or security group. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] resource_id: (Deprecated) The resource id of created assignment resource.
        :param pulumi.Input[_builtins.str] role_definition_id: The resource ID of the role definition to assign. Changing this forces a new Managed Hardware Security Module to be created.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope to create the role assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedHardwareSecurityModuleRoleAssignmentState.__new__(_ManagedHardwareSecurityModuleRoleAssignmentState)

        __props__.__dict__["managed_hsm_id"] = managed_hsm_id
        __props__.__dict__["name"] = name
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["role_definition_id"] = role_definition_id
        __props__.__dict__["scope"] = scope
        return ManagedHardwareSecurityModuleRoleAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="managedHsmId")
    def managed_hsm_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of a Managed Hardware Security Module resource. Changing this forces a new Managed Hardware Security Module to be created.
        *
        """
        return pulumi.get(self, "managed_hsm_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name in GUID notation which should be used for this Managed Hardware Security Module Role Assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The principal ID to be assigned to this role. It can point to a user, service principal, or security group. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Deprecated) The resource id of created assignment resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the role definition to assign. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the scope to create the role assignment. Changing this forces a new Managed Hardware Security Module to be created.
        """
        return pulumi.get(self, "scope")

