# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CosmosdbDataConnectionArgs', 'CosmosdbDataConnection']

@pulumi.input_type
class CosmosdbDataConnectionArgs:
    def __init__(__self__, *,
                 cosmosdb_container_id: pulumi.Input[_builtins.str],
                 kusto_database_id: pulumi.Input[_builtins.str],
                 managed_identity_id: pulumi.Input[_builtins.str],
                 table_name: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retrieval_start_date: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CosmosdbDataConnection resource.
        :param pulumi.Input[_builtins.str] cosmosdb_container_id: The name of an existing container in the Cosmos DB database. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] kusto_database_id: The name of the database in the Kusto cluster. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] table_name: The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Explorer should exist. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] mapping_rule_name: The name of an existing mapping rule to use when ingesting the retrieved data. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] name: The name of the data connection. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] retrieval_start_date: If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        pulumi.set(__self__, "cosmosdb_container_id", cosmosdb_container_id)
        pulumi.set(__self__, "kusto_database_id", kusto_database_id)
        pulumi.set(__self__, "managed_identity_id", managed_identity_id)
        pulumi.set(__self__, "table_name", table_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mapping_rule_name is not None:
            pulumi.set(__self__, "mapping_rule_name", mapping_rule_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retrieval_start_date is not None:
            pulumi.set(__self__, "retrieval_start_date", retrieval_start_date)

    @_builtins.property
    @pulumi.getter(name="cosmosdbContainerId")
    def cosmosdb_container_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name of an existing container in the Cosmos DB database. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "cosmosdb_container_id")

    @cosmosdb_container_id.setter
    def cosmosdb_container_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cosmosdb_container_id", value)

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseId")
    def kusto_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the database in the Kusto cluster. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "kusto_database_id")

    @kusto_database_id.setter
    def kusto_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kusto_database_id", value)

    @_builtins.property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "managed_identity_id")

    @managed_identity_id.setter
    def managed_identity_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[_builtins.str]:
        """
        The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Data Explorer should exist. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mappingRuleName")
    def mapping_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of an existing mapping rule to use when ingesting the retrieved data. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "mapping_rule_name")

    @mapping_rule_name.setter
    def mapping_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mapping_rule_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the data connection. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retrievalStartDate")
    def retrieval_start_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "retrieval_start_date")

    @retrieval_start_date.setter
    def retrieval_start_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retrieval_start_date", value)


@pulumi.input_type
class _CosmosdbDataConnectionState:
    def __init__(__self__, *,
                 cosmosdb_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retrieval_start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CosmosdbDataConnection resources.
        :param pulumi.Input[_builtins.str] cosmosdb_container_id: The name of an existing container in the Cosmos DB database. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] kusto_database_id: The name of the database in the Kusto cluster. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Explorer should exist. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] mapping_rule_name: The name of an existing mapping rule to use when ingesting the retrieved data. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] name: The name of the data connection. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] retrieval_start_date: If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] table_name: The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        if cosmosdb_container_id is not None:
            pulumi.set(__self__, "cosmosdb_container_id", cosmosdb_container_id)
        if kusto_database_id is not None:
            pulumi.set(__self__, "kusto_database_id", kusto_database_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_identity_id is not None:
            pulumi.set(__self__, "managed_identity_id", managed_identity_id)
        if mapping_rule_name is not None:
            pulumi.set(__self__, "mapping_rule_name", mapping_rule_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retrieval_start_date is not None:
            pulumi.set(__self__, "retrieval_start_date", retrieval_start_date)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @_builtins.property
    @pulumi.getter(name="cosmosdbContainerId")
    def cosmosdb_container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of an existing container in the Cosmos DB database. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "cosmosdb_container_id")

    @cosmosdb_container_id.setter
    def cosmosdb_container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cosmosdb_container_id", value)

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseId")
    def kusto_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database in the Kusto cluster. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "kusto_database_id")

    @kusto_database_id.setter
    def kusto_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kusto_database_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Data Explorer should exist. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "managed_identity_id")

    @managed_identity_id.setter
    def managed_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="mappingRuleName")
    def mapping_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of an existing mapping rule to use when ingesting the retrieved data. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "mapping_rule_name")

    @mapping_rule_name.setter
    def mapping_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mapping_rule_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the data connection. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retrievalStartDate")
    def retrieval_start_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "retrieval_start_date")

    @retrieval_start_date.setter
    def retrieval_start_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retrieval_start_date", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)


@pulumi.type_token("azure:kusto/cosmosdbDataConnection:CosmosdbDataConnection")
class CosmosdbDataConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cosmosdb_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retrieval_start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Kusto / Cosmos Database Data Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="exampleRG",
            location="West Europe")
        builtin = azure.authorization.get_role_definition(role_definition_id="fbdf93bf-df7d-467e-a4d2-9458aa1360c8")
        example_cluster = azure.kusto.Cluster("example",
            name="examplekc",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_assignment = azure.authorization.Assignment("example",
            scope=example_resource_group.id,
            role_definition_name=builtin.name,
            principal_id=example_cluster.identity.principal_id)
        example_account = azure.cosmosdb.Account("example",
            name="example-ca",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Session",
                "max_interval_in_seconds": 5,
                "max_staleness_prefix": 100,
            },
            geo_locations=[{
                "location": example_resource_group.location,
                "failover_priority": 0,
            }])
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="examplecosmosdbsqldb",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="examplecosmosdbsqlcon",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            database_name=example_sql_database.name,
            partition_key_path="/part",
            throughput=400)
        example = azure.cosmosdb.get_sql_role_definition_output(role_definition_id="00000000-0000-0000-0000-000000000001",
            resource_group_name=example_resource_group.name,
            account_name=example_account.name)
        example_sql_role_assignment = azure.cosmosdb.SqlRoleAssignment("example",
            resource_group_name=example_resource_group.name,
            account_name=example_account.name,
            role_definition_id=example.id,
            principal_id=example_cluster.identity.principal_id,
            scope=example_account.id)
        example_database = azure.kusto.Database("example",
            name="examplekd",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            cluster_name=example_cluster.name)
        example_script = azure.kusto.Script("example",
            name="create-table-script",
            database_id=example_database.id,
            script_content=\"\"\".create table TestTable(Id:string, Name:string, _ts:long, _timestamp:datetime)
        .create table TestTable ingestion json mapping \\"TestMapping\\"
        '['
        '    {\\"column\\":\\"Id\\",\\"path\\":\\"$.id\\"},'
        '    {\\"column\\":\\"Name\\",\\"path\\":\\"$.name\\"},'
        '    {\\"column\\":\\"_ts\\",\\"path\\":\\"$._ts\\"},'
        '    {\\"column\\":\\"_timestamp\\",\\"path\\":\\"$._ts\\", \\"transform\\":\\"DateTimeFromUnixSeconds\\"}'
        ']'
        .alter table TestTable policy ingestionbatching \\"{'MaximumBatchingTimeSpan': '0:0:10', 'MaximumNumberOfItems': 10000}\\"
        \"\"\")
        example_cosmosdb_data_connection = azure.kusto.CosmosdbDataConnection("example",
            name="examplekcdcd",
            location=example_resource_group.location,
            cosmosdb_container_id=example_sql_container.id,
            kusto_database_id=example_database.id,
            managed_identity_id=example_cluster.id,
            table_name="TestTable",
            mapping_rule_name="TestMapping",
            retrieval_start_date="2023-06-26T12:00:00.6554616Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto` - 2024-04-13

        ## Import

        Kusto / Cosmos Database Data Connection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/cosmosdbDataConnection:CosmosdbDataConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/databases/database1/dataConnections/dataConnection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cosmosdb_container_id: The name of an existing container in the Cosmos DB database. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] kusto_database_id: The name of the database in the Kusto cluster. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Explorer should exist. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] mapping_rule_name: The name of an existing mapping rule to use when ingesting the retrieved data. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] name: The name of the data connection. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] retrieval_start_date: If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] table_name: The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CosmosdbDataConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kusto / Cosmos Database Data Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="exampleRG",
            location="West Europe")
        builtin = azure.authorization.get_role_definition(role_definition_id="fbdf93bf-df7d-467e-a4d2-9458aa1360c8")
        example_cluster = azure.kusto.Cluster("example",
            name="examplekc",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_assignment = azure.authorization.Assignment("example",
            scope=example_resource_group.id,
            role_definition_name=builtin.name,
            principal_id=example_cluster.identity.principal_id)
        example_account = azure.cosmosdb.Account("example",
            name="example-ca",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Session",
                "max_interval_in_seconds": 5,
                "max_staleness_prefix": 100,
            },
            geo_locations=[{
                "location": example_resource_group.location,
                "failover_priority": 0,
            }])
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="examplecosmosdbsqldb",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="examplecosmosdbsqlcon",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            database_name=example_sql_database.name,
            partition_key_path="/part",
            throughput=400)
        example = azure.cosmosdb.get_sql_role_definition_output(role_definition_id="00000000-0000-0000-0000-000000000001",
            resource_group_name=example_resource_group.name,
            account_name=example_account.name)
        example_sql_role_assignment = azure.cosmosdb.SqlRoleAssignment("example",
            resource_group_name=example_resource_group.name,
            account_name=example_account.name,
            role_definition_id=example.id,
            principal_id=example_cluster.identity.principal_id,
            scope=example_account.id)
        example_database = azure.kusto.Database("example",
            name="examplekd",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            cluster_name=example_cluster.name)
        example_script = azure.kusto.Script("example",
            name="create-table-script",
            database_id=example_database.id,
            script_content=\"\"\".create table TestTable(Id:string, Name:string, _ts:long, _timestamp:datetime)
        .create table TestTable ingestion json mapping \\"TestMapping\\"
        '['
        '    {\\"column\\":\\"Id\\",\\"path\\":\\"$.id\\"},'
        '    {\\"column\\":\\"Name\\",\\"path\\":\\"$.name\\"},'
        '    {\\"column\\":\\"_ts\\",\\"path\\":\\"$._ts\\"},'
        '    {\\"column\\":\\"_timestamp\\",\\"path\\":\\"$._ts\\", \\"transform\\":\\"DateTimeFromUnixSeconds\\"}'
        ']'
        .alter table TestTable policy ingestionbatching \\"{'MaximumBatchingTimeSpan': '0:0:10', 'MaximumNumberOfItems': 10000}\\"
        \"\"\")
        example_cosmosdb_data_connection = azure.kusto.CosmosdbDataConnection("example",
            name="examplekcdcd",
            location=example_resource_group.location,
            cosmosdb_container_id=example_sql_container.id,
            kusto_database_id=example_database.id,
            managed_identity_id=example_cluster.id,
            table_name="TestTable",
            mapping_rule_name="TestMapping",
            retrieval_start_date="2023-06-26T12:00:00.6554616Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto` - 2024-04-13

        ## Import

        Kusto / Cosmos Database Data Connection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/cosmosdbDataConnection:CosmosdbDataConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/databases/database1/dataConnections/dataConnection1
        ```

        :param str resource_name: The name of the resource.
        :param CosmosdbDataConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CosmosdbDataConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cosmosdb_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retrieval_start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CosmosdbDataConnectionArgs.__new__(CosmosdbDataConnectionArgs)

            if cosmosdb_container_id is None and not opts.urn:
                raise TypeError("Missing required property 'cosmosdb_container_id'")
            __props__.__dict__["cosmosdb_container_id"] = cosmosdb_container_id
            if kusto_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'kusto_database_id'")
            __props__.__dict__["kusto_database_id"] = kusto_database_id
            __props__.__dict__["location"] = location
            if managed_identity_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_identity_id'")
            __props__.__dict__["managed_identity_id"] = managed_identity_id
            __props__.__dict__["mapping_rule_name"] = mapping_rule_name
            __props__.__dict__["name"] = name
            __props__.__dict__["retrieval_start_date"] = retrieval_start_date
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
        super(CosmosdbDataConnection, __self__).__init__(
            'azure:kusto/cosmosdbDataConnection:CosmosdbDataConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cosmosdb_container_id: Optional[pulumi.Input[_builtins.str]] = None,
            kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            retrieval_start_date: Optional[pulumi.Input[_builtins.str]] = None,
            table_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'CosmosdbDataConnection':
        """
        Get an existing CosmosdbDataConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cosmosdb_container_id: The name of an existing container in the Cosmos DB database. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] kusto_database_id: The name of the database in the Kusto cluster. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Explorer should exist. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] mapping_rule_name: The name of an existing mapping rule to use when ingesting the retrieved data. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] name: The name of the data connection. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] retrieval_start_date: If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. Changing this forces a new Kusto Cosmos DB Connection to be created.
        :param pulumi.Input[_builtins.str] table_name: The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CosmosdbDataConnectionState.__new__(_CosmosdbDataConnectionState)

        __props__.__dict__["cosmosdb_container_id"] = cosmosdb_container_id
        __props__.__dict__["kusto_database_id"] = kusto_database_id
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_identity_id"] = managed_identity_id
        __props__.__dict__["mapping_rule_name"] = mapping_rule_name
        __props__.__dict__["name"] = name
        __props__.__dict__["retrieval_start_date"] = retrieval_start_date
        __props__.__dict__["table_name"] = table_name
        return CosmosdbDataConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cosmosdbContainerId")
    def cosmosdb_container_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of an existing container in the Cosmos DB database. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "cosmosdb_container_id")

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseId")
    def kusto_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database in the Kusto cluster. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "kusto_database_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Data Explorer should exist. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "managed_identity_id")

    @_builtins.property
    @pulumi.getter(name="mappingRuleName")
    def mapping_rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of an existing mapping rule to use when ingesting the retrieved data. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "mapping_rule_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the data connection. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retrievalStartDate")
    def retrieval_start_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "retrieval_start_date")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. Changing this forces a new Kusto Cosmos DB Connection to be created.
        """
        return pulumi.get(self, "table_name")

