# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResult',
    'AwaitableGetResult',
    'get',
    'get_output',
]

@pulumi.output_type
class GetResult:
    """
    A collection of values returned by get.
    """
    def __init__(__self__, data_plane_uri=None, description=None, encryptions=None, id=None, identities=None, location=None, name=None, resource_group_name=None, tags=None):
        if data_plane_uri and not isinstance(data_plane_uri, str):
            raise TypeError("Expected argument 'data_plane_uri' to be a str")
        pulumi.set(__self__, "data_plane_uri", data_plane_uri)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if encryptions and not isinstance(encryptions, list):
            raise TypeError("Expected argument 'encryptions' to be a list")
        pulumi.set(__self__, "encryptions", encryptions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dataPlaneUri")
    def data_plane_uri(self) -> _builtins.str:
        """
        Resource data plane URI.
        """
        return pulumi.get(self, "data_plane_uri")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> Sequence['outputs.GetEncryptionResult']:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryptions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Load Test exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Load Test Service.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResult(GetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResult(
            data_plane_uri=self.data_plane_uri,
            description=self.description,
            encryptions=self.encryptions,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get(name: Optional[_builtins.str] = None,
        resource_group_name: Optional[_builtins.str] = None,
        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResult:
    """
    Use this data source to access information about a Load Test Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.loadtest.get(resource_group_name="example-resources",
        name="example-load-test")
    pulumi.export("loadTestId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.LoadTestService` - 2022-12-01


    :param _builtins.str name: The name of the Load Test Service.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Load Test Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:loadtest/get:get', __args__, opts=opts, typ=GetResult).value

    return AwaitableGetResult(
        data_plane_uri=pulumi.get(__ret__, 'data_plane_uri'),
        description=pulumi.get(__ret__, 'description'),
        encryptions=pulumi.get(__ret__, 'encryptions'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_output(name: Optional[pulumi.Input[_builtins.str]] = None,
               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResult]:
    """
    Use this data source to access information about a Load Test Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.loadtest.get(resource_group_name="example-resources",
        name="example-load-test")
    pulumi.export("loadTestId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.LoadTestService` - 2022-12-01


    :param _builtins.str name: The name of the Load Test Service.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Load Test Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:loadtest/get:get', __args__, opts=opts, typ=GetResult)
    return __ret__.apply(lambda __response__: GetResult(
        data_plane_uri=pulumi.get(__response__, 'data_plane_uri'),
        description=pulumi.get(__response__, 'description'),
        encryptions=pulumi.get(__response__, 'encryptions'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
