# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationAccountCertificateArgs', 'IntegrationAccountCertificate']

@pulumi.input_type
class IntegrationAccountCertificateArgs:
    def __init__(__self__, *,
                 integration_account_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 key_vault_key: Optional[pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs']] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IntegrationAccountCertificate resource.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Certificate should exist. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs'] key_vault_key: A `key_vault_key` block as documented below.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Logic App Integration Account Certificate.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Certificate. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate for the Logic App Integration Account Certificate.
        """
        pulumi.set(__self__, "integration_account_name", integration_account_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if key_vault_key is not None:
            pulumi.set(__self__, "key_vault_key", key_vault_key)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)

    @_builtins.property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @integration_account_name.setter
    def integration_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "integration_account_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account Certificate should exist. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKey")
    def key_vault_key(self) -> Optional[pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs']]:
        """
        A `key_vault_key` block as documented below.
        """
        return pulumi.get(self, "key_vault_key")

    @key_vault_key.setter
    def key_vault_key(self, value: Optional[pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs']]):
        pulumi.set(self, "key_vault_key", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON mapping of any Metadata for this Logic App Integration Account Certificate.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account Certificate. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public certificate for the Logic App Integration Account Certificate.
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_certificate", value)


@pulumi.input_type
class _IntegrationAccountCertificateState:
    def __init__(__self__, *,
                 integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key: Optional[pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs']] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationAccountCertificate resources.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs'] key_vault_key: A `key_vault_key` block as documented below.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Logic App Integration Account Certificate.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Certificate. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate for the Logic App Integration Account Certificate.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Certificate should exist. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        if integration_account_name is not None:
            pulumi.set(__self__, "integration_account_name", integration_account_name)
        if key_vault_key is not None:
            pulumi.set(__self__, "key_vault_key", key_vault_key)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @integration_account_name.setter
    def integration_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_account_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKey")
    def key_vault_key(self) -> Optional[pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs']]:
        """
        A `key_vault_key` block as documented below.
        """
        return pulumi.get(self, "key_vault_key")

    @key_vault_key.setter
    def key_vault_key(self, value: Optional[pulumi.Input['IntegrationAccountCertificateKeyVaultKeyArgs']]):
        pulumi.set(self, "key_vault_key", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON mapping of any Metadata for this Logic App Integration Account Certificate.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account Certificate. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public certificate for the Logic App Integration Account Certificate.
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_certificate", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Logic App Integration Account Certificate should exist. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:logicapps/integrationAccountCertificate:IntegrationAccountCertificate")
class IntegrationAccountCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key: Optional[pulumi.Input[Union['IntegrationAccountCertificateKeyVaultKeyArgs', 'IntegrationAccountCertificateKeyVaultKeyArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Logic App Integration Account Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_integration_account = azure.logicapps.IntegrationAccount("example",
            name="example-ia",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        example_integration_account_certificate = azure.logicapps.IntegrationAccountCertificate("example",
            name="example-iac",
            resource_group_name=example.name,
            integration_account_name=example_integration_account.name,
            public_certificate="MIIDbzCCAlegAwIBAgIJAIzjRD36sIbbMA0GCSqGSIb3DQEBCwUAME0xCzAJBgNVBAYTAlVTMRMwEQYDVQQIDApTb21lLVN0YXRlMRIwEAYDVQQKDAl0ZXJyYWZvcm0xFTATBgNVBAMMDHRlcnJhZm9ybS5pbzAgFw0xNzA0MjEyMDA1MjdaGA8yMTE3MDMyODIwMDUyN1owTTELMAkGA1UEBhMCVVMxEzARBgNVBAgMClNvbWUtU3RhdGUxEjAQBgNVBAoMCXRlcnJhZm9ybTEVMBMGA1UEAwwMdGVycmFmb3JtLmlvMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3L9L5szT4+FLykTFNyyPjy/k3BQTYAfRQzP2dhnsuUKm3cdPC0NyZ+wEXIUGhoDO2YG6EYChOl8fsDqDOjloSUGKqYw++nlpHIuUgJx8IxxG2XkALCjFU7EmF+w7kn76d0ezpEIYxnLP+KG2DVornoEt1aLhv1MLmpgEZZPhDbMSLhSYWeTVRMayXLwqtfgnDumQSB+8d/1JuJqrSI4pD12JozVThzb6hsjfb6RMX4epPmrGn0PbTPEEA6awmsxBCXB0s13nNQt/O0hLM2agwvAyozilQV+s616Ckgk6DJoUkqZhDy7vPYMIRSr98fBws6zkrV6tTLjmD8xAvobePQIDAQABo1AwTjAdBgNVHQ4EFgQUXIqO421zMMmbcRRX9wctZFCQuPIwHwYDVR0jBBgwFoAUXIqO421zMMmbcRRX9wctZFCQuPIwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAQEAr82NeT3BYJOKLlUL6Om5LjUF66ewcJjG9ltdvyQwVneMcq7t5UAPxgChzqNRVk4da8PzkXpjBJyWezHupdJNX3XqeUk2kSxqQ6/gmhqvfI3y7djrwoO6jvMEY26WqtkTNORWDP3THJJVimC3zV+KMU5UBVrEzhOVhHSU709lBP75o0BBn3xGsPqSq9k8IotIFfyAc6a+XP3+ZMpvh7wqAUml7vWa5wlcXExCx39h1balfDSLGNC4swWPCp9AMnQR0p+vMay9hNP1Eh+9QYUai14d5KS3cFV+KxE1cJR5HD/iLltnnOEbpMsB0eVOZWkFvE7Y5lW0oVSAfin5TwTJMQ==")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic` - 2019-05-01

        ## Import

        Logic App Integration Account Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccountCertificate:IntegrationAccountCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1/certificates/certificate1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input[Union['IntegrationAccountCertificateKeyVaultKeyArgs', 'IntegrationAccountCertificateKeyVaultKeyArgsDict']] key_vault_key: A `key_vault_key` block as documented below.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Logic App Integration Account Certificate.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Certificate. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate for the Logic App Integration Account Certificate.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Certificate should exist. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationAccountCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Logic App Integration Account Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_integration_account = azure.logicapps.IntegrationAccount("example",
            name="example-ia",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        example_integration_account_certificate = azure.logicapps.IntegrationAccountCertificate("example",
            name="example-iac",
            resource_group_name=example.name,
            integration_account_name=example_integration_account.name,
            public_certificate="MIIDbzCCAlegAwIBAgIJAIzjRD36sIbbMA0GCSqGSIb3DQEBCwUAME0xCzAJBgNVBAYTAlVTMRMwEQYDVQQIDApTb21lLVN0YXRlMRIwEAYDVQQKDAl0ZXJyYWZvcm0xFTATBgNVBAMMDHRlcnJhZm9ybS5pbzAgFw0xNzA0MjEyMDA1MjdaGA8yMTE3MDMyODIwMDUyN1owTTELMAkGA1UEBhMCVVMxEzARBgNVBAgMClNvbWUtU3RhdGUxEjAQBgNVBAoMCXRlcnJhZm9ybTEVMBMGA1UEAwwMdGVycmFmb3JtLmlvMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3L9L5szT4+FLykTFNyyPjy/k3BQTYAfRQzP2dhnsuUKm3cdPC0NyZ+wEXIUGhoDO2YG6EYChOl8fsDqDOjloSUGKqYw++nlpHIuUgJx8IxxG2XkALCjFU7EmF+w7kn76d0ezpEIYxnLP+KG2DVornoEt1aLhv1MLmpgEZZPhDbMSLhSYWeTVRMayXLwqtfgnDumQSB+8d/1JuJqrSI4pD12JozVThzb6hsjfb6RMX4epPmrGn0PbTPEEA6awmsxBCXB0s13nNQt/O0hLM2agwvAyozilQV+s616Ckgk6DJoUkqZhDy7vPYMIRSr98fBws6zkrV6tTLjmD8xAvobePQIDAQABo1AwTjAdBgNVHQ4EFgQUXIqO421zMMmbcRRX9wctZFCQuPIwHwYDVR0jBBgwFoAUXIqO421zMMmbcRRX9wctZFCQuPIwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAQEAr82NeT3BYJOKLlUL6Om5LjUF66ewcJjG9ltdvyQwVneMcq7t5UAPxgChzqNRVk4da8PzkXpjBJyWezHupdJNX3XqeUk2kSxqQ6/gmhqvfI3y7djrwoO6jvMEY26WqtkTNORWDP3THJJVimC3zV+KMU5UBVrEzhOVhHSU709lBP75o0BBn3xGsPqSq9k8IotIFfyAc6a+XP3+ZMpvh7wqAUml7vWa5wlcXExCx39h1balfDSLGNC4swWPCp9AMnQR0p+vMay9hNP1Eh+9QYUai14d5KS3cFV+KxE1cJR5HD/iLltnnOEbpMsB0eVOZWkFvE7Y5lW0oVSAfin5TwTJMQ==")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic` - 2019-05-01

        ## Import

        Logic App Integration Account Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccountCertificate:IntegrationAccountCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1/certificates/certificate1
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationAccountCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationAccountCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key: Optional[pulumi.Input[Union['IntegrationAccountCertificateKeyVaultKeyArgs', 'IntegrationAccountCertificateKeyVaultKeyArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationAccountCertificateArgs.__new__(IntegrationAccountCertificateArgs)

            if integration_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'integration_account_name'")
            __props__.__dict__["integration_account_name"] = integration_account_name
            __props__.__dict__["key_vault_key"] = key_vault_key
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["public_certificate"] = public_certificate
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(IntegrationAccountCertificate, __self__).__init__(
            'azure:logicapps/integrationAccountCertificate:IntegrationAccountCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_key: Optional[pulumi.Input[Union['IntegrationAccountCertificateKeyVaultKeyArgs', 'IntegrationAccountCertificateKeyVaultKeyArgsDict']]] = None,
            metadata: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'IntegrationAccountCertificate':
        """
        Get an existing IntegrationAccountCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input[Union['IntegrationAccountCertificateKeyVaultKeyArgs', 'IntegrationAccountCertificateKeyVaultKeyArgsDict']] key_vault_key: A `key_vault_key` block as documented below.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Logic App Integration Account Certificate.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Certificate. Changing this forces a new Logic App Integration Account Certificate to be created.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate for the Logic App Integration Account Certificate.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Certificate should exist. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationAccountCertificateState.__new__(_IntegrationAccountCertificateState)

        __props__.__dict__["integration_account_name"] = integration_account_name
        __props__.__dict__["key_vault_key"] = key_vault_key
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["public_certificate"] = public_certificate
        __props__.__dict__["resource_group_name"] = resource_group_name
        return IntegrationAccountCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @_builtins.property
    @pulumi.getter(name="keyVaultKey")
    def key_vault_key(self) -> pulumi.Output[Optional['outputs.IntegrationAccountCertificateKeyVaultKey']]:
        """
        A `key_vault_key` block as documented below.
        """
        return pulumi.get(self, "key_vault_key")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON mapping of any Metadata for this Logic App Integration Account Certificate.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Logic App Integration Account Certificate. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The public certificate for the Logic App Integration Account Certificate.
        """
        return pulumi.get(self, "public_certificate")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account Certificate should exist. Changing this forces a new Logic App Integration Account Certificate to be created.
        """
        return pulumi.get(self, "resource_group_name")

