# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ManagedRedisCustomerManagedKeyArgs',
    'ManagedRedisCustomerManagedKeyArgsDict',
    'ManagedRedisDefaultDatabaseArgs',
    'ManagedRedisDefaultDatabaseArgsDict',
    'ManagedRedisDefaultDatabaseModuleArgs',
    'ManagedRedisDefaultDatabaseModuleArgsDict',
    'ManagedRedisIdentityArgs',
    'ManagedRedisIdentityArgsDict',
]

MYPY = False

if not MYPY:
    class ManagedRedisCustomerManagedKeyArgsDict(TypedDict):
        key_vault_key_id: pulumi.Input[_builtins.str]
        """
        The ID of the key vault key used for encryption. For example: `https://example-vault-name.vault.azure.net/keys/example-key-name/a1b2c3d4`.
        """
        user_assigned_identity_id: pulumi.Input[_builtins.str]
        """
        The ID of the User Assigned Identity that has access to the Key Vault Key.
        """
elif False:
    ManagedRedisCustomerManagedKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedRedisCustomerManagedKeyArgs:
    def __init__(__self__, *,
                 key_vault_key_id: pulumi.Input[_builtins.str],
                 user_assigned_identity_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the key vault key used for encryption. For example: `https://example-vault-name.vault.azure.net/keys/example-key-name/a1b2c3d4`.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The ID of the User Assigned Identity that has access to the Key Vault Key.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the key vault key used for encryption. For example: `https://example-vault-name.vault.azure.net/keys/example-key-name/a1b2c3d4`.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the User Assigned Identity that has access to the Key Vault Key.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_assigned_identity_id", value)


if not MYPY:
    class ManagedRedisDefaultDatabaseArgsDict(TypedDict):
        access_keys_authentication_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether access key authentication is enabled for the database. Defaults to `false`.
        """
        client_protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`.
        """
        clustering_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Clustering policy specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        eviction_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the Redis eviction policy. Possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Defaults to `VolatileLRU`.
        """
        geo_replication_group_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the geo-replication group. If provided, a geo-replication group will be created for this database with itself as the only member. Use `azurerm_managed_redis_database_geo_replication` resource to manage group membership, linking and unlinking. All databases to be linked have to have the same group name. Refer to the [Managed Redis geo-replication documentation](https://learn.microsoft.com/azure/redis/how-to-active-geo-replication) for more information. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        modules: NotRequired[pulumi.Input[Sequence[pulumi.Input['ManagedRedisDefaultDatabaseModuleArgsDict']]]]
        """
        A `module` block as defined below. Refer to [the modules documentation](https://learn.microsoft.com/azure/redis/redis-modules) to learn more.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        TCP port of the database endpoint.
        """
        primary_access_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Primary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
        secondary_access_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Secondary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
elif False:
    ManagedRedisDefaultDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedRedisDefaultDatabaseArgs:
    def __init__(__self__, *,
                 access_keys_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 clustering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_replication_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRedisDefaultDatabaseModuleArgs']]]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] access_keys_authentication_enabled: Whether access key authentication is enabled for the database. Defaults to `false`.
        :param pulumi.Input[_builtins.str] client_protocol: Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`.
        :param pulumi.Input[_builtins.str] clustering_policy: Clustering policy specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the Redis eviction policy. Possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Defaults to `VolatileLRU`.
        :param pulumi.Input[_builtins.str] geo_replication_group_name: The name of the geo-replication group. If provided, a geo-replication group will be created for this database with itself as the only member. Use `azurerm_managed_redis_database_geo_replication` resource to manage group membership, linking and unlinking. All databases to be linked have to have the same group name. Refer to the [Managed Redis geo-replication documentation](https://learn.microsoft.com/azure/redis/how-to-active-geo-replication) for more information. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRedisDefaultDatabaseModuleArgs']]] modules: A `module` block as defined below. Refer to [the modules documentation](https://learn.microsoft.com/azure/redis/redis-modules) to learn more.
        :param pulumi.Input[_builtins.int] port: TCP port of the database endpoint.
        :param pulumi.Input[_builtins.str] primary_access_key: The Primary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        :param pulumi.Input[_builtins.str] secondary_access_key: The Secondary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
        if access_keys_authentication_enabled is not None:
            pulumi.set(__self__, "access_keys_authentication_enabled", access_keys_authentication_enabled)
        if client_protocol is not None:
            pulumi.set(__self__, "client_protocol", client_protocol)
        if clustering_policy is not None:
            pulumi.set(__self__, "clustering_policy", clustering_policy)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if geo_replication_group_name is not None:
            pulumi.set(__self__, "geo_replication_group_name", geo_replication_group_name)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)

    @_builtins.property
    @pulumi.getter(name="accessKeysAuthenticationEnabled")
    def access_keys_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether access key authentication is enabled for the database. Defaults to `false`.
        """
        return pulumi.get(self, "access_keys_authentication_enabled")

    @access_keys_authentication_enabled.setter
    def access_keys_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_keys_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`.
        """
        return pulumi.get(self, "client_protocol")

    @client_protocol.setter
    def client_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_protocol", value)

    @_builtins.property
    @pulumi.getter(name="clusteringPolicy")
    def clustering_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Clustering policy specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        return pulumi.get(self, "clustering_policy")

    @clustering_policy.setter
    def clustering_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clustering_policy", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Redis eviction policy. Possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Defaults to `VolatileLRU`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="geoReplicationGroupName")
    def geo_replication_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the geo-replication group. If provided, a geo-replication group will be created for this database with itself as the only member. Use `azurerm_managed_redis_database_geo_replication` resource to manage group membership, linking and unlinking. All databases to be linked have to have the same group name. Refer to the [Managed Redis geo-replication documentation](https://learn.microsoft.com/azure/redis/how-to-active-geo-replication) for more information. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        return pulumi.get(self, "geo_replication_group_name")

    @geo_replication_group_name.setter
    def geo_replication_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geo_replication_group_name", value)

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRedisDefaultDatabaseModuleArgs']]]]:
        """
        A `module` block as defined below. Refer to [the modules documentation](https://learn.microsoft.com/azure/redis/redis-modules) to learn more.
        """
        return pulumi.get(self, "modules")

    @modules.setter
    def modules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRedisDefaultDatabaseModuleArgs']]]]):
        pulumi.set(self, "modules", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP port of the database endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)


if not MYPY:
    class ManagedRedisDefaultDatabaseModuleArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        args: NotRequired[pulumi.Input[_builtins.str]]
        """
        Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.

        > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Version of the module to be used.
        """
elif False:
    ManagedRedisDefaultDatabaseModuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedRedisDefaultDatabaseModuleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 args: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        :param pulumi.Input[_builtins.str] args: Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
               
               > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication.
        :param pulumi.Input[_builtins.str] version: Version of the module to be used.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.

        > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the module to be used.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class ManagedRedisIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Managed Redis instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Managed Redis instance.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ManagedRedisIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedRedisIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Managed Redis instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Managed Redis instance.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Managed Redis instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Managed Redis instance.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


