# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GeoReplicationArgs', 'GeoReplication']

@pulumi.input_type
class GeoReplicationArgs:
    def __init__(__self__, *,
                 linked_managed_redis_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 managed_redis_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a GeoReplication resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_managed_redis_ids: A set of other Managed Redis IDs to link together in the geo-replication group. The ID of this Managed Redis is always included by default and does not need to be provided here. Can contain up to 4 Managed Redis IDs, making up a group of 5 in total. All Managed Redis must have the same `geo_replication_group_name` configured. Once linked, the geo-replication state of all Managed Redis will be updated.
        :param pulumi.Input[_builtins.str] managed_redis_id: The ID of the Managed Redis through which geo-replication group will be managed. Linking is reciprocal, if A is linked to B, both A and B will have the same linking state. There is no need to have duplicate `managedredis.GeoReplication` resources for each. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "linked_managed_redis_ids", linked_managed_redis_ids)
        pulumi.set(__self__, "managed_redis_id", managed_redis_id)

    @_builtins.property
    @pulumi.getter(name="linkedManagedRedisIds")
    def linked_managed_redis_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A set of other Managed Redis IDs to link together in the geo-replication group. The ID of this Managed Redis is always included by default and does not need to be provided here. Can contain up to 4 Managed Redis IDs, making up a group of 5 in total. All Managed Redis must have the same `geo_replication_group_name` configured. Once linked, the geo-replication state of all Managed Redis will be updated.
        """
        return pulumi.get(self, "linked_managed_redis_ids")

    @linked_managed_redis_ids.setter
    def linked_managed_redis_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "linked_managed_redis_ids", value)

    @_builtins.property
    @pulumi.getter(name="managedRedisId")
    def managed_redis_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Managed Redis through which geo-replication group will be managed. Linking is reciprocal, if A is linked to B, both A and B will have the same linking state. There is no need to have duplicate `managedredis.GeoReplication` resources for each. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_redis_id")

    @managed_redis_id.setter
    def managed_redis_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_redis_id", value)


@pulumi.input_type
class _GeoReplicationState:
    def __init__(__self__, *,
                 linked_managed_redis_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 managed_redis_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GeoReplication resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_managed_redis_ids: A set of other Managed Redis IDs to link together in the geo-replication group. The ID of this Managed Redis is always included by default and does not need to be provided here. Can contain up to 4 Managed Redis IDs, making up a group of 5 in total. All Managed Redis must have the same `geo_replication_group_name` configured. Once linked, the geo-replication state of all Managed Redis will be updated.
        :param pulumi.Input[_builtins.str] managed_redis_id: The ID of the Managed Redis through which geo-replication group will be managed. Linking is reciprocal, if A is linked to B, both A and B will have the same linking state. There is no need to have duplicate `managedredis.GeoReplication` resources for each. Changing this forces a new resource to be created.
        """
        if linked_managed_redis_ids is not None:
            pulumi.set(__self__, "linked_managed_redis_ids", linked_managed_redis_ids)
        if managed_redis_id is not None:
            pulumi.set(__self__, "managed_redis_id", managed_redis_id)

    @_builtins.property
    @pulumi.getter(name="linkedManagedRedisIds")
    def linked_managed_redis_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of other Managed Redis IDs to link together in the geo-replication group. The ID of this Managed Redis is always included by default and does not need to be provided here. Can contain up to 4 Managed Redis IDs, making up a group of 5 in total. All Managed Redis must have the same `geo_replication_group_name` configured. Once linked, the geo-replication state of all Managed Redis will be updated.
        """
        return pulumi.get(self, "linked_managed_redis_ids")

    @linked_managed_redis_ids.setter
    def linked_managed_redis_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "linked_managed_redis_ids", value)

    @_builtins.property
    @pulumi.getter(name="managedRedisId")
    def managed_redis_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Managed Redis through which geo-replication group will be managed. Linking is reciprocal, if A is linked to B, both A and B will have the same linking state. There is no need to have duplicate `managedredis.GeoReplication` resources for each. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_redis_id")

    @managed_redis_id.setter
    def managed_redis_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_redis_id", value)


@pulumi.type_token("azure:managedredis/geoReplication:GeoReplication")
class GeoReplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linked_managed_redis_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 managed_redis_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Managed Redis Geo-Replication by linking and unlinking databases in a geo-replication group.

        > **Note:** This resource manages the geo-replication group membership for Managed Redis databases. All databases to be linked must have `geo_replication_group_name` provided with the same value. Linking will [discard cache data and cause temporary outage](https://learn.microsoft.com/azure/redis/how-to-active-geo-replication#add-an-existing-instance-to-an-active-geo-replication-group).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-managedredis",
            location="West Europe")
        amr1 = azure.managedredis.ManagedRedis("amr1",
            name="example-managedredis-amr1",
            resource_group_name=example.name,
            location="West Europe",
            sku_name="Balanced_B3",
            default_database={
                "geo_replication_group_name": "example-geo-group",
            })
        amr2 = azure.managedredis.ManagedRedis("amr2",
            name="example-managedredis-amr2",
            resource_group_name=example.name,
            location="Central US",
            sku_name="Balanced_B3",
            default_database={
                "geo_replication_group_name": "example-geo-group",
            })
        example_geo_replication = azure.managedredis.GeoReplication("example",
            managed_redis_id=amr1.id,
            linked_managed_redis_ids=[amr2.id])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2025-07-01

        ## Import

        Managed Redis Database Geo-Replication can be imported using the Managed Redis `resource id`, e.g.

        ```sh
        $ pulumi import azure:managedredis/geoReplication:GeoReplication example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redisEnterprise/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_managed_redis_ids: A set of other Managed Redis IDs to link together in the geo-replication group. The ID of this Managed Redis is always included by default and does not need to be provided here. Can contain up to 4 Managed Redis IDs, making up a group of 5 in total. All Managed Redis must have the same `geo_replication_group_name` configured. Once linked, the geo-replication state of all Managed Redis will be updated.
        :param pulumi.Input[_builtins.str] managed_redis_id: The ID of the Managed Redis through which geo-replication group will be managed. Linking is reciprocal, if A is linked to B, both A and B will have the same linking state. There is no need to have duplicate `managedredis.GeoReplication` resources for each. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GeoReplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Managed Redis Geo-Replication by linking and unlinking databases in a geo-replication group.

        > **Note:** This resource manages the geo-replication group membership for Managed Redis databases. All databases to be linked must have `geo_replication_group_name` provided with the same value. Linking will [discard cache data and cause temporary outage](https://learn.microsoft.com/azure/redis/how-to-active-geo-replication#add-an-existing-instance-to-an-active-geo-replication-group).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-managedredis",
            location="West Europe")
        amr1 = azure.managedredis.ManagedRedis("amr1",
            name="example-managedredis-amr1",
            resource_group_name=example.name,
            location="West Europe",
            sku_name="Balanced_B3",
            default_database={
                "geo_replication_group_name": "example-geo-group",
            })
        amr2 = azure.managedredis.ManagedRedis("amr2",
            name="example-managedredis-amr2",
            resource_group_name=example.name,
            location="Central US",
            sku_name="Balanced_B3",
            default_database={
                "geo_replication_group_name": "example-geo-group",
            })
        example_geo_replication = azure.managedredis.GeoReplication("example",
            managed_redis_id=amr1.id,
            linked_managed_redis_ids=[amr2.id])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2025-07-01

        ## Import

        Managed Redis Database Geo-Replication can be imported using the Managed Redis `resource id`, e.g.

        ```sh
        $ pulumi import azure:managedredis/geoReplication:GeoReplication example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redisEnterprise/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param GeoReplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GeoReplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linked_managed_redis_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 managed_redis_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GeoReplicationArgs.__new__(GeoReplicationArgs)

            if linked_managed_redis_ids is None and not opts.urn:
                raise TypeError("Missing required property 'linked_managed_redis_ids'")
            __props__.__dict__["linked_managed_redis_ids"] = linked_managed_redis_ids
            if managed_redis_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_redis_id'")
            __props__.__dict__["managed_redis_id"] = managed_redis_id
        super(GeoReplication, __self__).__init__(
            'azure:managedredis/geoReplication:GeoReplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            linked_managed_redis_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            managed_redis_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GeoReplication':
        """
        Get an existing GeoReplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_managed_redis_ids: A set of other Managed Redis IDs to link together in the geo-replication group. The ID of this Managed Redis is always included by default and does not need to be provided here. Can contain up to 4 Managed Redis IDs, making up a group of 5 in total. All Managed Redis must have the same `geo_replication_group_name` configured. Once linked, the geo-replication state of all Managed Redis will be updated.
        :param pulumi.Input[_builtins.str] managed_redis_id: The ID of the Managed Redis through which geo-replication group will be managed. Linking is reciprocal, if A is linked to B, both A and B will have the same linking state. There is no need to have duplicate `managedredis.GeoReplication` resources for each. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GeoReplicationState.__new__(_GeoReplicationState)

        __props__.__dict__["linked_managed_redis_ids"] = linked_managed_redis_ids
        __props__.__dict__["managed_redis_id"] = managed_redis_id
        return GeoReplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="linkedManagedRedisIds")
    def linked_managed_redis_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of other Managed Redis IDs to link together in the geo-replication group. The ID of this Managed Redis is always included by default and does not need to be provided here. Can contain up to 4 Managed Redis IDs, making up a group of 5 in total. All Managed Redis must have the same `geo_replication_group_name` configured. Once linked, the geo-replication state of all Managed Redis will be updated.
        """
        return pulumi.get(self, "linked_managed_redis_ids")

    @_builtins.property
    @pulumi.getter(name="managedRedisId")
    def managed_redis_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Managed Redis through which geo-replication group will be managed. Linking is reciprocal, if A is linked to B, both A and B will have the same linking state. There is no need to have duplicate `managedredis.GeoReplication` resources for each. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_redis_id")

