# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResult',
    'AwaitableGetResult',
    'get',
    'get_output',
]

@pulumi.output_type
class GetResult:
    """
    A collection of values returned by get.
    """
    def __init__(__self__, customer_managed_keys=None, default_databases=None, high_availability_enabled=None, hostname=None, id=None, identities=None, location=None, name=None, public_network_access=None, resource_group_name=None, sku_name=None, tags=None):
        if customer_managed_keys and not isinstance(customer_managed_keys, list):
            raise TypeError("Expected argument 'customer_managed_keys' to be a list")
        pulumi.set(__self__, "customer_managed_keys", customer_managed_keys)
        if default_databases and not isinstance(default_databases, list):
            raise TypeError("Expected argument 'default_databases' to be a list")
        pulumi.set(__self__, "default_databases", default_databases)
        if high_availability_enabled and not isinstance(high_availability_enabled, bool):
            raise TypeError("Expected argument 'high_availability_enabled' to be a bool")
        pulumi.set(__self__, "high_availability_enabled", high_availability_enabled)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_network_access and not isinstance(public_network_access, str):
            raise TypeError("Expected argument 'public_network_access' to be a str")
        pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeys")
    def customer_managed_keys(self) -> Sequence['outputs.GetCustomerManagedKeyResult']:
        """
        A `customer_managed_key` block as defined below.
        """
        return pulumi.get(self, "customer_managed_keys")

    @_builtins.property
    @pulumi.getter(name="defaultDatabases")
    def default_databases(self) -> Sequence['outputs.GetDefaultDatabaseResult']:
        """
        A `default_database` block as defined below.
        """
        return pulumi.get(self, "default_databases")

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnabled")
    def high_availability_enabled(self) -> _builtins.bool:
        """
        Whether high availability is enabled for the Managed Redis instance.
        """
        return pulumi.get(self, "high_availability_enabled")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The DNS hostname of the Managed Redis instance.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Managed Redis instance exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Redis module.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> _builtins.str:
        """
        The public network access setting for the Managed Redis instance.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The SKU name of the Managed Redis instance.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Managed Redis instance.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResult(GetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResult(
            customer_managed_keys=self.customer_managed_keys,
            default_databases=self.default_databases,
            high_availability_enabled=self.high_availability_enabled,
            hostname=self.hostname,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            public_network_access=self.public_network_access,
            resource_group_name=self.resource_group_name,
            sku_name=self.sku_name,
            tags=self.tags)


def get(name: Optional[_builtins.str] = None,
        resource_group_name: Optional[_builtins.str] = None,
        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResult:
    """
    Use this data source to access information about an existing Managed Redis instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.managedredis.get(name="example-managed-redis",
        resource_group_name="example-resources")
    pulumi.export("managedRedisHostname", example.hostname)
    pulumi.export("managedRedisPrimaryAccessKey", example.default_databases[0].primary_access_key)
    pulumi.export("managedRedisSecondaryAccessKey", example.default_databases[0].secondary_access_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Cache` - 2025-07-01


    :param _builtins.str name: The name of the Managed Redis instance.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Managed Redis instance exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:managedredis/get:get', __args__, opts=opts, typ=GetResult).value

    return AwaitableGetResult(
        customer_managed_keys=pulumi.get(__ret__, 'customer_managed_keys'),
        default_databases=pulumi.get(__ret__, 'default_databases'),
        high_availability_enabled=pulumi.get(__ret__, 'high_availability_enabled'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        public_network_access=pulumi.get(__ret__, 'public_network_access'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_output(name: Optional[pulumi.Input[_builtins.str]] = None,
               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResult]:
    """
    Use this data source to access information about an existing Managed Redis instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.managedredis.get(name="example-managed-redis",
        resource_group_name="example-resources")
    pulumi.export("managedRedisHostname", example.hostname)
    pulumi.export("managedRedisPrimaryAccessKey", example.default_databases[0].primary_access_key)
    pulumi.export("managedRedisSecondaryAccessKey", example.default_databases[0].secondary_access_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Cache` - 2025-07-01


    :param _builtins.str name: The name of the Managed Redis instance.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Managed Redis instance exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:managedredis/get:get', __args__, opts=opts, typ=GetResult)
    return __ret__.apply(lambda __response__: GetResult(
        customer_managed_keys=pulumi.get(__response__, 'customer_managed_keys'),
        default_databases=pulumi.get(__response__, 'default_databases'),
        high_availability_enabled=pulumi.get(__response__, 'high_availability_enabled'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        public_network_access=pulumi.get(__response__, 'public_network_access'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        tags=pulumi.get(__response__, 'tags')))
