# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedRedisArgs', 'ManagedRedis']

@pulumi.input_type
class ManagedRedisArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 customer_managed_key: Optional[pulumi.Input['ManagedRedisCustomerManagedKeyArgs']] = None,
                 default_database: Optional[pulumi.Input['ManagedRedisDefaultDatabaseArgs']] = None,
                 high_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ManagedRedisIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ManagedRedis resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Redis instance should exist. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] sku_name: The features and specification of the Managed Redis instance to deploy. Refer to [the documentation](https://learn.microsoft.com/rest/api/redis/redisenterprisecache/redis-enterprise/create?view=rest-redis-redisenterprisecache-2025-04-01&tabs=HTTP#skuname) for valid values. `Balanced_B3` SKU or higher is required for geo-replication. Changing this forces a new Managed Redis instance to be created.
               
               > **Note:** `Enterprise_` and `EnterpriseFlash_` prefixed SKUs were previously used by Redis Enterprise, and [not supported by Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).
        :param pulumi.Input['ManagedRedisCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input['ManagedRedisDefaultDatabaseArgs'] default_database: A `default_database` block as defined below. A Managed Redis instance will not be functional without a database. This block is intentionally optional to allow removal and re-creation of the database for troubleshooting purposes. A default database can be created or deleted in-place, however most properties will trigger an entire cluster replacement if changed.
        :param pulumi.Input[_builtins.bool] high_availability_enabled: Whether to enable high availability for the Managed Redis instance. Defaults to `true`. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input['ManagedRedisIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Redis instance should exist. Refer to "Redis Cache" on the [product availability documentation](https://azure.microsoft.com/explore/global-infrastructure/products-by-region/table) for supported locations. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Redis instance. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The public network access setting for the Managed Redis instance. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Managed Redis instance.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if default_database is not None:
            pulumi.set(__self__, "default_database", default_database)
        if high_availability_enabled is not None:
            pulumi.set(__self__, "high_availability_enabled", high_availability_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Managed Redis instance should exist. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The features and specification of the Managed Redis instance to deploy. Refer to [the documentation](https://learn.microsoft.com/rest/api/redis/redisenterprisecache/redis-enterprise/create?view=rest-redis-redisenterprisecache-2025-04-01&tabs=HTTP#skuname) for valid values. `Balanced_B3` SKU or higher is required for geo-replication. Changing this forces a new Managed Redis instance to be created.

        > **Note:** `Enterprise_` and `EnterpriseFlash_` prefixed SKUs were previously used by Redis Enterprise, and [not supported by Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['ManagedRedisCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['ManagedRedisCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> Optional[pulumi.Input['ManagedRedisDefaultDatabaseArgs']]:
        """
        A `default_database` block as defined below. A Managed Redis instance will not be functional without a database. This block is intentionally optional to allow removal and re-creation of the database for troubleshooting purposes. A default database can be created or deleted in-place, however most properties will trigger an entire cluster replacement if changed.
        """
        return pulumi.get(self, "default_database")

    @default_database.setter
    def default_database(self, value: Optional[pulumi.Input['ManagedRedisDefaultDatabaseArgs']]):
        pulumi.set(self, "default_database", value)

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnabled")
    def high_availability_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable high availability for the Managed Redis instance. Defaults to `true`. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "high_availability_enabled")

    @high_availability_enabled.setter
    def high_availability_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_availability_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ManagedRedisIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ManagedRedisIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Managed Redis instance should exist. Refer to "Redis Cache" on the [product availability documentation](https://azure.microsoft.com/explore/global-infrastructure/products-by-region/table) for supported locations. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Managed Redis instance. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public network access setting for the Managed Redis instance. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Managed Redis instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ManagedRedisState:
    def __init__(__self__, *,
                 customer_managed_key: Optional[pulumi.Input['ManagedRedisCustomerManagedKeyArgs']] = None,
                 default_database: Optional[pulumi.Input['ManagedRedisDefaultDatabaseArgs']] = None,
                 high_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ManagedRedisIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ManagedRedis resources.
        :param pulumi.Input['ManagedRedisCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input['ManagedRedisDefaultDatabaseArgs'] default_database: A `default_database` block as defined below. A Managed Redis instance will not be functional without a database. This block is intentionally optional to allow removal and re-creation of the database for troubleshooting purposes. A default database can be created or deleted in-place, however most properties will trigger an entire cluster replacement if changed.
        :param pulumi.Input[_builtins.bool] high_availability_enabled: Whether to enable high availability for the Managed Redis instance. Defaults to `true`. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] hostname: DNS name of the cluster endpoint.
        :param pulumi.Input['ManagedRedisIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Redis instance should exist. Refer to "Redis Cache" on the [product availability documentation](https://azure.microsoft.com/explore/global-infrastructure/products-by-region/table) for supported locations. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Redis instance. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The public network access setting for the Managed Redis instance. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Redis instance should exist. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] sku_name: The features and specification of the Managed Redis instance to deploy. Refer to [the documentation](https://learn.microsoft.com/rest/api/redis/redisenterprisecache/redis-enterprise/create?view=rest-redis-redisenterprisecache-2025-04-01&tabs=HTTP#skuname) for valid values. `Balanced_B3` SKU or higher is required for geo-replication. Changing this forces a new Managed Redis instance to be created.
               
               > **Note:** `Enterprise_` and `EnterpriseFlash_` prefixed SKUs were previously used by Redis Enterprise, and [not supported by Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Managed Redis instance.
        """
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if default_database is not None:
            pulumi.set(__self__, "default_database", default_database)
        if high_availability_enabled is not None:
            pulumi.set(__self__, "high_availability_enabled", high_availability_enabled)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['ManagedRedisCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['ManagedRedisCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> Optional[pulumi.Input['ManagedRedisDefaultDatabaseArgs']]:
        """
        A `default_database` block as defined below. A Managed Redis instance will not be functional without a database. This block is intentionally optional to allow removal and re-creation of the database for troubleshooting purposes. A default database can be created or deleted in-place, however most properties will trigger an entire cluster replacement if changed.
        """
        return pulumi.get(self, "default_database")

    @default_database.setter
    def default_database(self, value: Optional[pulumi.Input['ManagedRedisDefaultDatabaseArgs']]):
        pulumi.set(self, "default_database", value)

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnabled")
    def high_availability_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable high availability for the Managed Redis instance. Defaults to `true`. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "high_availability_enabled")

    @high_availability_enabled.setter
    def high_availability_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_availability_enabled", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS name of the cluster endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ManagedRedisIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ManagedRedisIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Managed Redis instance should exist. Refer to "Redis Cache" on the [product availability documentation](https://azure.microsoft.com/explore/global-infrastructure/products-by-region/table) for supported locations. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Managed Redis instance. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public network access setting for the Managed Redis instance. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Managed Redis instance should exist. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The features and specification of the Managed Redis instance to deploy. Refer to [the documentation](https://learn.microsoft.com/rest/api/redis/redisenterprisecache/redis-enterprise/create?view=rest-redis-redisenterprisecache-2025-04-01&tabs=HTTP#skuname) for valid values. `Balanced_B3` SKU or higher is required for geo-replication. Changing this forces a new Managed Redis instance to be created.

        > **Note:** `Enterprise_` and `EnterpriseFlash_` prefixed SKUs were previously used by Redis Enterprise, and [not supported by Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Managed Redis instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:managedredis/managedRedis:ManagedRedis")
class ManagedRedis(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['ManagedRedisCustomerManagedKeyArgs', 'ManagedRedisCustomerManagedKeyArgsDict']]] = None,
                 default_database: Optional[pulumi.Input[Union['ManagedRedisDefaultDatabaseArgs', 'ManagedRedisDefaultDatabaseArgsDict']]] = None,
                 high_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ManagedRedisIdentityArgs', 'ManagedRedisIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a [Managed Redis](https://learn.microsoft.com/azure/redis/overview). This resource supersedes redis.EnterpriseCluster and redis.EnterpriseDatabase resources. Please refer to the migration guide for more information on migrating from Redis Enterprise to Managed Redis: [Migrating from Redis Enterprise to Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_managed_redis = azure.managedredis.ManagedRedis("example",
            name="example-managed-redis",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Balanced_B3",
            default_database={
                "geo_replication_group_name": "myGeoGroup",
            })
        ```

        ### With Customer Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True,
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "Recover",
                        "Update",
                        "GetRotationPolicy",
                        "SetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="managedrediscmk",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ])
        example_managed_redis = azure.managedredis.ManagedRedis("example",
            name="example-managed-redis",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Balanced_B3",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            customer_managed_key={
                "key_vault_key_id": example_key.id,
                "user_assigned_identity_id": example_user_assigned_identity.id,
            },
            default_database={
                "geo_replication_group_name": "myGeoGroup",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2025-07-01

        ## Import

        Managed Redis instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:managedredis/managedRedis:ManagedRedis example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redisEnterprise/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagedRedisCustomerManagedKeyArgs', 'ManagedRedisCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input[Union['ManagedRedisDefaultDatabaseArgs', 'ManagedRedisDefaultDatabaseArgsDict']] default_database: A `default_database` block as defined below. A Managed Redis instance will not be functional without a database. This block is intentionally optional to allow removal and re-creation of the database for troubleshooting purposes. A default database can be created or deleted in-place, however most properties will trigger an entire cluster replacement if changed.
        :param pulumi.Input[_builtins.bool] high_availability_enabled: Whether to enable high availability for the Managed Redis instance. Defaults to `true`. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[Union['ManagedRedisIdentityArgs', 'ManagedRedisIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Redis instance should exist. Refer to "Redis Cache" on the [product availability documentation](https://azure.microsoft.com/explore/global-infrastructure/products-by-region/table) for supported locations. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Redis instance. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The public network access setting for the Managed Redis instance. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Redis instance should exist. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] sku_name: The features and specification of the Managed Redis instance to deploy. Refer to [the documentation](https://learn.microsoft.com/rest/api/redis/redisenterprisecache/redis-enterprise/create?view=rest-redis-redisenterprisecache-2025-04-01&tabs=HTTP#skuname) for valid values. `Balanced_B3` SKU or higher is required for geo-replication. Changing this forces a new Managed Redis instance to be created.
               
               > **Note:** `Enterprise_` and `EnterpriseFlash_` prefixed SKUs were previously used by Redis Enterprise, and [not supported by Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Managed Redis instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedRedisArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a [Managed Redis](https://learn.microsoft.com/azure/redis/overview). This resource supersedes redis.EnterpriseCluster and redis.EnterpriseDatabase resources. Please refer to the migration guide for more information on migrating from Redis Enterprise to Managed Redis: [Migrating from Redis Enterprise to Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_managed_redis = azure.managedredis.ManagedRedis("example",
            name="example-managed-redis",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Balanced_B3",
            default_database={
                "geo_replication_group_name": "myGeoGroup",
            })
        ```

        ### With Customer Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True,
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "Recover",
                        "Update",
                        "GetRotationPolicy",
                        "SetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="managedrediscmk",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ])
        example_managed_redis = azure.managedredis.ManagedRedis("example",
            name="example-managed-redis",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Balanced_B3",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            customer_managed_key={
                "key_vault_key_id": example_key.id,
                "user_assigned_identity_id": example_user_assigned_identity.id,
            },
            default_database={
                "geo_replication_group_name": "myGeoGroup",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2025-07-01

        ## Import

        Managed Redis instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:managedredis/managedRedis:ManagedRedis example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redisEnterprise/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ManagedRedisArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedRedisArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['ManagedRedisCustomerManagedKeyArgs', 'ManagedRedisCustomerManagedKeyArgsDict']]] = None,
                 default_database: Optional[pulumi.Input[Union['ManagedRedisDefaultDatabaseArgs', 'ManagedRedisDefaultDatabaseArgsDict']]] = None,
                 high_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ManagedRedisIdentityArgs', 'ManagedRedisIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedRedisArgs.__new__(ManagedRedisArgs)

            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["default_database"] = default_database
            __props__.__dict__["high_availability_enabled"] = high_availability_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["hostname"] = None
        super(ManagedRedis, __self__).__init__(
            'azure:managedredis/managedRedis:ManagedRedis',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customer_managed_key: Optional[pulumi.Input[Union['ManagedRedisCustomerManagedKeyArgs', 'ManagedRedisCustomerManagedKeyArgsDict']]] = None,
            default_database: Optional[pulumi.Input[Union['ManagedRedisDefaultDatabaseArgs', 'ManagedRedisDefaultDatabaseArgsDict']]] = None,
            high_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ManagedRedisIdentityArgs', 'ManagedRedisIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ManagedRedis':
        """
        Get an existing ManagedRedis resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagedRedisCustomerManagedKeyArgs', 'ManagedRedisCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input[Union['ManagedRedisDefaultDatabaseArgs', 'ManagedRedisDefaultDatabaseArgsDict']] default_database: A `default_database` block as defined below. A Managed Redis instance will not be functional without a database. This block is intentionally optional to allow removal and re-creation of the database for troubleshooting purposes. A default database can be created or deleted in-place, however most properties will trigger an entire cluster replacement if changed.
        :param pulumi.Input[_builtins.bool] high_availability_enabled: Whether to enable high availability for the Managed Redis instance. Defaults to `true`. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] hostname: DNS name of the cluster endpoint.
        :param pulumi.Input[Union['ManagedRedisIdentityArgs', 'ManagedRedisIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Redis instance should exist. Refer to "Redis Cache" on the [product availability documentation](https://azure.microsoft.com/explore/global-infrastructure/products-by-region/table) for supported locations. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Redis instance. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The public network access setting for the Managed Redis instance. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Redis instance should exist. Changing this forces a new Managed Redis instance to be created.
        :param pulumi.Input[_builtins.str] sku_name: The features and specification of the Managed Redis instance to deploy. Refer to [the documentation](https://learn.microsoft.com/rest/api/redis/redisenterprisecache/redis-enterprise/create?view=rest-redis-redisenterprisecache-2025-04-01&tabs=HTTP#skuname) for valid values. `Balanced_B3` SKU or higher is required for geo-replication. Changing this forces a new Managed Redis instance to be created.
               
               > **Note:** `Enterprise_` and `EnterpriseFlash_` prefixed SKUs were previously used by Redis Enterprise, and [not supported by Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Managed Redis instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedRedisState.__new__(_ManagedRedisState)

        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["default_database"] = default_database
        __props__.__dict__["high_availability_enabled"] = high_availability_enabled
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        return ManagedRedis(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional['outputs.ManagedRedisCustomerManagedKey']]:
        """
        A `customer_managed_key` block as defined below.
        """
        return pulumi.get(self, "customer_managed_key")

    @_builtins.property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> pulumi.Output[Optional['outputs.ManagedRedisDefaultDatabase']]:
        """
        A `default_database` block as defined below. A Managed Redis instance will not be functional without a database. This block is intentionally optional to allow removal and re-creation of the database for troubleshooting purposes. A default database can be created or deleted in-place, however most properties will trigger an entire cluster replacement if changed.
        """
        return pulumi.get(self, "default_database")

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnabled")
    def high_availability_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable high availability for the Managed Redis instance. Defaults to `true`. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "high_availability_enabled")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        DNS name of the cluster endpoint.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ManagedRedisIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Managed Redis instance should exist. Refer to "Redis Cache" on the [product availability documentation](https://azure.microsoft.com/explore/global-infrastructure/products-by-region/table) for supported locations. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Managed Redis instance. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The public network access setting for the Managed Redis instance. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Managed Redis instance should exist. Changing this forces a new Managed Redis instance to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The features and specification of the Managed Redis instance to deploy. Refer to [the documentation](https://learn.microsoft.com/rest/api/redis/redisenterprisecache/redis-enterprise/create?view=rest-redis-redisenterprisecache-2025-04-01&tabs=HTTP#skuname) for valid values. `Balanced_B3` SKU or higher is required for geo-replication. Changing this forces a new Managed Redis instance to be created.

        > **Note:** `Enterprise_` and `EnterpriseFlash_` prefixed SKUs were previously used by Redis Enterprise, and [not supported by Managed Redis](https://learn.microsoft.com/azure/redis/migrate/migrate-overview).
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Managed Redis instance.
        """
        return pulumi.get(self, "tags")

