# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ManagedRedisCustomerManagedKey',
    'ManagedRedisDefaultDatabase',
    'ManagedRedisDefaultDatabaseModule',
    'ManagedRedisIdentity',
    'GetCustomerManagedKeyResult',
    'GetDefaultDatabaseResult',
    'GetDefaultDatabaseModuleResult',
    'GetIdentityResult',
]

@pulumi.output_type
class ManagedRedisCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRedisCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRedisCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRedisCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_key_id: _builtins.str,
                 user_assigned_identity_id: _builtins.str):
        """
        :param _builtins.str key_vault_key_id: The ID of the key vault key used for encryption. For example: `https://example-vault-name.vault.azure.net/keys/example-key-name/a1b2c3d4`.
        :param _builtins.str user_assigned_identity_id: The ID of the User Assigned Identity that has access to the Key Vault Key.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The ID of the key vault key used for encryption. For example: `https://example-vault-name.vault.azure.net/keys/example-key-name/a1b2c3d4`.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> _builtins.str:
        """
        The ID of the User Assigned Identity that has access to the Key Vault Key.
        """
        return pulumi.get(self, "user_assigned_identity_id")


@pulumi.output_type
class ManagedRedisDefaultDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeysAuthenticationEnabled":
            suggest = "access_keys_authentication_enabled"
        elif key == "clientProtocol":
            suggest = "client_protocol"
        elif key == "clusteringPolicy":
            suggest = "clustering_policy"
        elif key == "evictionPolicy":
            suggest = "eviction_policy"
        elif key == "geoReplicationGroupName":
            suggest = "geo_replication_group_name"
        elif key == "primaryAccessKey":
            suggest = "primary_access_key"
        elif key == "secondaryAccessKey":
            suggest = "secondary_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRedisDefaultDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRedisDefaultDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRedisDefaultDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_keys_authentication_enabled: Optional[_builtins.bool] = None,
                 client_protocol: Optional[_builtins.str] = None,
                 clustering_policy: Optional[_builtins.str] = None,
                 eviction_policy: Optional[_builtins.str] = None,
                 geo_replication_group_name: Optional[_builtins.str] = None,
                 modules: Optional[Sequence['outputs.ManagedRedisDefaultDatabaseModule']] = None,
                 port: Optional[_builtins.int] = None,
                 primary_access_key: Optional[_builtins.str] = None,
                 secondary_access_key: Optional[_builtins.str] = None):
        """
        :param _builtins.bool access_keys_authentication_enabled: Whether access key authentication is enabled for the database. Defaults to `false`.
        :param _builtins.str client_protocol: Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`.
        :param _builtins.str clustering_policy: Clustering policy specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        :param _builtins.str eviction_policy: Specifies the Redis eviction policy. Possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Defaults to `VolatileLRU`.
        :param _builtins.str geo_replication_group_name: The name of the geo-replication group. If provided, a geo-replication group will be created for this database with itself as the only member. Use `azurerm_managed_redis_database_geo_replication` resource to manage group membership, linking and unlinking. All databases to be linked have to have the same group name. Refer to the [Managed Redis geo-replication documentation](https://learn.microsoft.com/azure/redis/how-to-active-geo-replication) for more information. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        :param Sequence['ManagedRedisDefaultDatabaseModuleArgs'] modules: A `module` block as defined below. Refer to [the modules documentation](https://learn.microsoft.com/azure/redis/redis-modules) to learn more.
        :param _builtins.int port: TCP port of the database endpoint.
        :param _builtins.str primary_access_key: The Primary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        :param _builtins.str secondary_access_key: The Secondary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
        if access_keys_authentication_enabled is not None:
            pulumi.set(__self__, "access_keys_authentication_enabled", access_keys_authentication_enabled)
        if client_protocol is not None:
            pulumi.set(__self__, "client_protocol", client_protocol)
        if clustering_policy is not None:
            pulumi.set(__self__, "clustering_policy", clustering_policy)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if geo_replication_group_name is not None:
            pulumi.set(__self__, "geo_replication_group_name", geo_replication_group_name)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)

    @_builtins.property
    @pulumi.getter(name="accessKeysAuthenticationEnabled")
    def access_keys_authentication_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether access key authentication is enabled for the database. Defaults to `false`.
        """
        return pulumi.get(self, "access_keys_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> Optional[_builtins.str]:
        """
        Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`.
        """
        return pulumi.get(self, "client_protocol")

    @_builtins.property
    @pulumi.getter(name="clusteringPolicy")
    def clustering_policy(self) -> Optional[_builtins.str]:
        """
        Clustering policy specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        return pulumi.get(self, "clustering_policy")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[_builtins.str]:
        """
        Specifies the Redis eviction policy. Possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Defaults to `VolatileLRU`.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="geoReplicationGroupName")
    def geo_replication_group_name(self) -> Optional[_builtins.str]:
        """
        The name of the geo-replication group. If provided, a geo-replication group will be created for this database with itself as the only member. Use `azurerm_managed_redis_database_geo_replication` resource to manage group membership, linking and unlinking. All databases to be linked have to have the same group name. Refer to the [Managed Redis geo-replication documentation](https://learn.microsoft.com/azure/redis/how-to-active-geo-replication) for more information. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        return pulumi.get(self, "geo_replication_group_name")

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[Sequence['outputs.ManagedRedisDefaultDatabaseModule']]:
        """
        A `module` block as defined below. Refer to [the modules documentation](https://learn.microsoft.com/azure/redis/redis-modules) to learn more.
        """
        return pulumi.get(self, "modules")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the database endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[_builtins.str]:
        """
        The Primary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[_builtins.str]:
        """
        The Secondary Access Key for the Managed Redis Database Instance. Only exported if `access_keys_authentication_enabled` is set to `true`.
        """
        return pulumi.get(self, "secondary_access_key")


@pulumi.output_type
class ManagedRedisDefaultDatabaseModule(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 args: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        :param _builtins.str args: Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
               
               > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication.
        :param _builtins.str version: Version of the module to be used.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[_builtins.str]:
        """
        Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new database to be created, data will be lost and Managed Redis will be unavailable during the operation.

        > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the module to be used.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagedRedisIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRedisIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRedisIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRedisIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Managed Redis instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Managed Redis instance.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Managed Redis instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Managed Redis instance.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GetCustomerManagedKeyResult(dict):
    def __init__(__self__, *,
                 key_vault_key_id: _builtins.str,
                 user_assigned_identity_id: _builtins.str):
        """
        :param _builtins.str key_vault_key_id: The ID of the key vault key used for encryption.
        :param _builtins.str user_assigned_identity_id: The ID of the User Assigned Identity that has access to the Key Vault Key.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The ID of the key vault key used for encryption.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> _builtins.str:
        """
        The ID of the User Assigned Identity that has access to the Key Vault Key.
        """
        return pulumi.get(self, "user_assigned_identity_id")


@pulumi.output_type
class GetDefaultDatabaseResult(dict):
    def __init__(__self__, *,
                 access_keys_authentication_enabled: _builtins.bool,
                 client_protocol: _builtins.str,
                 clustering_policy: _builtins.str,
                 eviction_policy: _builtins.str,
                 geo_replication_group_name: _builtins.str,
                 geo_replication_linked_database_ids: Sequence[_builtins.str],
                 modules: Sequence['outputs.GetDefaultDatabaseModuleResult'],
                 port: _builtins.int,
                 primary_access_key: _builtins.str,
                 secondary_access_key: _builtins.str):
        """
        :param _builtins.bool access_keys_authentication_enabled: Whether access key authentication is enabled for the database.
        :param _builtins.str client_protocol: The client protocol used by the database (either `Encrypted` or `Plaintext`).
        :param _builtins.str clustering_policy: The clustering policy used by the database.
        :param _builtins.str eviction_policy: The Redis eviction policy used by the database.
        :param _builtins.str geo_replication_group_name: The name of the geo-replication group.
        :param Sequence[_builtins.str] geo_replication_linked_database_ids: A list of linked database IDs for geo-replication.
        :param Sequence['GetDefaultDatabaseModuleArgs'] modules: A list of `module` blocks as defined below.
        :param _builtins.int port: The TCP port of the database endpoint.
        :param _builtins.str primary_access_key: The Primary Access Key for the Managed Redis Database instance.
        :param _builtins.str secondary_access_key: The Secondary Access Key for the Managed Redis Database instance.
        """
        pulumi.set(__self__, "access_keys_authentication_enabled", access_keys_authentication_enabled)
        pulumi.set(__self__, "client_protocol", client_protocol)
        pulumi.set(__self__, "clustering_policy", clustering_policy)
        pulumi.set(__self__, "eviction_policy", eviction_policy)
        pulumi.set(__self__, "geo_replication_group_name", geo_replication_group_name)
        pulumi.set(__self__, "geo_replication_linked_database_ids", geo_replication_linked_database_ids)
        pulumi.set(__self__, "modules", modules)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "primary_access_key", primary_access_key)
        pulumi.set(__self__, "secondary_access_key", secondary_access_key)

    @_builtins.property
    @pulumi.getter(name="accessKeysAuthenticationEnabled")
    def access_keys_authentication_enabled(self) -> _builtins.bool:
        """
        Whether access key authentication is enabled for the database.
        """
        return pulumi.get(self, "access_keys_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> _builtins.str:
        """
        The client protocol used by the database (either `Encrypted` or `Plaintext`).
        """
        return pulumi.get(self, "client_protocol")

    @_builtins.property
    @pulumi.getter(name="clusteringPolicy")
    def clustering_policy(self) -> _builtins.str:
        """
        The clustering policy used by the database.
        """
        return pulumi.get(self, "clustering_policy")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> _builtins.str:
        """
        The Redis eviction policy used by the database.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="geoReplicationGroupName")
    def geo_replication_group_name(self) -> _builtins.str:
        """
        The name of the geo-replication group.
        """
        return pulumi.get(self, "geo_replication_group_name")

    @_builtins.property
    @pulumi.getter(name="geoReplicationLinkedDatabaseIds")
    def geo_replication_linked_database_ids(self) -> Sequence[_builtins.str]:
        """
        A list of linked database IDs for geo-replication.
        """
        return pulumi.get(self, "geo_replication_linked_database_ids")

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Sequence['outputs.GetDefaultDatabaseModuleResult']:
        """
        A list of `module` blocks as defined below.
        """
        return pulumi.get(self, "modules")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The TCP port of the database endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> _builtins.str:
        """
        The Primary Access Key for the Managed Redis Database instance.
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> _builtins.str:
        """
        The Secondary Access Key for the Managed Redis Database instance.
        """
        return pulumi.get(self, "secondary_access_key")


@pulumi.output_type
class GetDefaultDatabaseModuleResult(dict):
    def __init__(__self__, *,
                 args: _builtins.str,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str args: The configuration options for the module.
        :param _builtins.str name: The name of the Managed Redis instance.
        :param _builtins.str version: The version of the module.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def args(self) -> _builtins.str:
        """
        The configuration options for the module.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Managed Redis instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the module.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs assigned to the Managed Redis instance.
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on the Managed Redis instance.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on the Managed Redis instance.
        :param _builtins.str type: The type of Managed Service Identity configured on the Managed Redis instance.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        A list of User Assigned Managed Identity IDs assigned to the Managed Redis instance.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on the Managed Redis instance.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on the Managed Redis instance.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Service Identity configured on the Managed Redis instance.
        """
        return pulumi.get(self, "type")


