# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGroupTemplateDeploymentResult',
    'AwaitableGetGroupTemplateDeploymentResult',
    'get_group_template_deployment',
    'get_group_template_deployment_output',
]

@pulumi.output_type
class GetGroupTemplateDeploymentResult:
    """
    A collection of values returned by getGroupTemplateDeployment.
    """
    def __init__(__self__, id=None, management_group_id=None, name=None, output_content=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if management_group_id and not isinstance(management_group_id, str):
            raise TypeError("Expected argument 'management_group_id' to be a str")
        pulumi.set(__self__, "management_group_id", management_group_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_content and not isinstance(output_content, str):
            raise TypeError("Expected argument 'output_content' to be a str")
        pulumi.set(__self__, "output_content", output_content)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> _builtins.str:
        return pulumi.get(self, "management_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputContent")
    def output_content(self) -> _builtins.str:
        """
        The JSON Content of the Outputs of the ARM Template Deployment.
        """
        return pulumi.get(self, "output_content")


class AwaitableGetGroupTemplateDeploymentResult(GetGroupTemplateDeploymentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupTemplateDeploymentResult(
            id=self.id,
            management_group_id=self.management_group_id,
            name=self.name,
            output_content=self.output_content)


def get_group_template_deployment(management_group_id: Optional[_builtins.str] = None,
                                  name: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupTemplateDeploymentResult:
    """
    Use this data source to access information about an existing Management Group Template Deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure
    import pulumi_std as std

    example = azure.management.get_group_template_deployment(name="existing",
        management_group_id="00000000-0000-0000-000000000000")
    pulumi.export("id", example.id)
    pulumi.export("exampleOutput", std.jsondecode(input=example.output_content).result["exampleOutput"]["value"])
    ```


    :param _builtins.str management_group_id: The ID of the Management Group to which this template was applied.
    :param _builtins.str name: The name of this Management Group Template Deployment.
    """
    __args__ = dict()
    __args__['managementGroupId'] = management_group_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:management/getGroupTemplateDeployment:getGroupTemplateDeployment', __args__, opts=opts, typ=GetGroupTemplateDeploymentResult).value

    return AwaitableGetGroupTemplateDeploymentResult(
        id=pulumi.get(__ret__, 'id'),
        management_group_id=pulumi.get(__ret__, 'management_group_id'),
        name=pulumi.get(__ret__, 'name'),
        output_content=pulumi.get(__ret__, 'output_content'))
def get_group_template_deployment_output(management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         name: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupTemplateDeploymentResult]:
    """
    Use this data source to access information about an existing Management Group Template Deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure
    import pulumi_std as std

    example = azure.management.get_group_template_deployment(name="existing",
        management_group_id="00000000-0000-0000-000000000000")
    pulumi.export("id", example.id)
    pulumi.export("exampleOutput", std.jsondecode(input=example.output_content).result["exampleOutput"]["value"])
    ```


    :param _builtins.str management_group_id: The ID of the Management Group to which this template was applied.
    :param _builtins.str name: The name of this Management Group Template Deployment.
    """
    __args__ = dict()
    __args__['managementGroupId'] = management_group_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:management/getGroupTemplateDeployment:getGroupTemplateDeployment', __args__, opts=opts, typ=GetGroupTemplateDeploymentResult)
    return __ret__.apply(lambda __response__: GetGroupTemplateDeploymentResult(
        id=pulumi.get(__response__, 'id'),
        management_group_id=pulumi.get(__response__, 'management_group_id'),
        name=pulumi.get(__response__, 'name'),
        output_content=pulumi.get(__response__, 'output_content')))
