# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CreatorArgs', 'Creator']

@pulumi.input_type
class CreatorArgs:
    def __init__(__self__, *,
                 maps_account_id: pulumi.Input[_builtins.str],
                 storage_units: pulumi.Input[_builtins.int],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Creator resource.
        :param pulumi.Input[_builtins.str] maps_account_id: The ID of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_units: The storage units to be allocated. Integer values from 1 to 100, inclusive.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Maps Creator should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Maps Creator.
        """
        pulumi.set(__self__, "maps_account_id", maps_account_id)
        pulumi.set(__self__, "storage_units", storage_units)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="mapsAccountId")
    def maps_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure Maps Creator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maps_account_id")

    @maps_account_id.setter
    def maps_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "maps_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageUnits")
    def storage_units(self) -> pulumi.Input[_builtins.int]:
        """
        The storage units to be allocated. Integer values from 1 to 100, inclusive.
        """
        return pulumi.get(self, "storage_units")

    @storage_units.setter
    def storage_units(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "storage_units", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Maps Creator should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Maps Creator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Maps Creator.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CreatorState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maps_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_units: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Creator resources.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Maps Creator should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] maps_account_id: The ID of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_units: The storage units to be allocated. Integer values from 1 to 100, inclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Maps Creator.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maps_account_id is not None:
            pulumi.set(__self__, "maps_account_id", maps_account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_units is not None:
            pulumi.set(__self__, "storage_units", storage_units)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Maps Creator should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mapsAccountId")
    def maps_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Maps Creator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maps_account_id")

    @maps_account_id.setter
    def maps_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maps_account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Maps Creator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="storageUnits")
    def storage_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage units to be allocated. Integer values from 1 to 100, inclusive.
        """
        return pulumi.get(self, "storage_units")

    @storage_units.setter
    def storage_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_units", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Maps Creator.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:maps/creator:Creator")
class Creator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maps_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_units: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Maps Creator.

        > **Note:** The `maps.Creator` resource has been deprecated because the service is retiring from 2024-09-23 and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.maps.Account("example",
            name="example-maps-account",
            resource_group_name=example.name,
            sku_name="G2",
            tags={
                "environment": "Test",
            })
        example_creator = azure.maps.Creator("example",
            name="example-maps-creator",
            maps_account_id=example_account.id,
            location=example.location,
            storage_units=1,
            tags={
                "environment": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Maps` - 2023-06-01

        ## Import

        An Azure Maps Creators can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:maps/creator:Creator example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Maps/accounts/account1/creators/creator1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Maps Creator should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] maps_account_id: The ID of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_units: The storage units to be allocated. Integer values from 1 to 100, inclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Maps Creator.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CreatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Maps Creator.

        > **Note:** The `maps.Creator` resource has been deprecated because the service is retiring from 2024-09-23 and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.maps.Account("example",
            name="example-maps-account",
            resource_group_name=example.name,
            sku_name="G2",
            tags={
                "environment": "Test",
            })
        example_creator = azure.maps.Creator("example",
            name="example-maps-creator",
            maps_account_id=example_account.id,
            location=example.location,
            storage_units=1,
            tags={
                "environment": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Maps` - 2023-06-01

        ## Import

        An Azure Maps Creators can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:maps/creator:Creator example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Maps/accounts/account1/creators/creator1
        ```

        :param str resource_name: The name of the resource.
        :param CreatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CreatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maps_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_units: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CreatorArgs.__new__(CreatorArgs)

            __props__.__dict__["location"] = location
            if maps_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'maps_account_id'")
            __props__.__dict__["maps_account_id"] = maps_account_id
            __props__.__dict__["name"] = name
            if storage_units is None and not opts.urn:
                raise TypeError("Missing required property 'storage_units'")
            __props__.__dict__["storage_units"] = storage_units
            __props__.__dict__["tags"] = tags
        super(Creator, __self__).__init__(
            'azure:maps/creator:Creator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maps_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_units: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Creator':
        """
        Get an existing Creator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Maps Creator should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] maps_account_id: The ID of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Maps Creator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_units: The storage units to be allocated. Integer values from 1 to 100, inclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Maps Creator.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CreatorState.__new__(_CreatorState)

        __props__.__dict__["location"] = location
        __props__.__dict__["maps_account_id"] = maps_account_id
        __props__.__dict__["name"] = name
        __props__.__dict__["storage_units"] = storage_units
        __props__.__dict__["tags"] = tags
        return Creator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Azure Maps Creator should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mapsAccountId")
    def maps_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure Maps Creator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maps_account_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Maps Creator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageUnits")
    def storage_units(self) -> pulumi.Output[_builtins.int]:
        """
        The storage units to be allocated. Integer values from 1 to 100, inclusive.
        """
        return pulumi.get(self, "storage_units")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Maps Creator.
        """
        return pulumi.get(self, "tags")

