# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkAttachedDataNetworkResult',
    'AwaitableGetNetworkAttachedDataNetworkResult',
    'get_network_attached_data_network',
    'get_network_attached_data_network_output',
]

@pulumi.output_type
class GetNetworkAttachedDataNetworkResult:
    """
    A collection of values returned by getNetworkAttachedDataNetwork.
    """
    def __init__(__self__, dns_addresses=None, id=None, location=None, mobile_network_data_network_name=None, mobile_network_packet_core_data_plane_id=None, network_address_port_translations=None, tags=None, user_equipment_address_pool_prefixes=None, user_equipment_static_address_pool_prefixes=None, user_plane_access_ipv4_address=None, user_plane_access_ipv4_gateway=None, user_plane_access_ipv4_subnet=None, user_plane_access_name=None):
        if dns_addresses and not isinstance(dns_addresses, list):
            raise TypeError("Expected argument 'dns_addresses' to be a list")
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mobile_network_data_network_name and not isinstance(mobile_network_data_network_name, str):
            raise TypeError("Expected argument 'mobile_network_data_network_name' to be a str")
        pulumi.set(__self__, "mobile_network_data_network_name", mobile_network_data_network_name)
        if mobile_network_packet_core_data_plane_id and not isinstance(mobile_network_packet_core_data_plane_id, str):
            raise TypeError("Expected argument 'mobile_network_packet_core_data_plane_id' to be a str")
        pulumi.set(__self__, "mobile_network_packet_core_data_plane_id", mobile_network_packet_core_data_plane_id)
        if network_address_port_translations and not isinstance(network_address_port_translations, list):
            raise TypeError("Expected argument 'network_address_port_translations' to be a list")
        pulumi.set(__self__, "network_address_port_translations", network_address_port_translations)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_equipment_address_pool_prefixes and not isinstance(user_equipment_address_pool_prefixes, list):
            raise TypeError("Expected argument 'user_equipment_address_pool_prefixes' to be a list")
        pulumi.set(__self__, "user_equipment_address_pool_prefixes", user_equipment_address_pool_prefixes)
        if user_equipment_static_address_pool_prefixes and not isinstance(user_equipment_static_address_pool_prefixes, list):
            raise TypeError("Expected argument 'user_equipment_static_address_pool_prefixes' to be a list")
        pulumi.set(__self__, "user_equipment_static_address_pool_prefixes", user_equipment_static_address_pool_prefixes)
        if user_plane_access_ipv4_address and not isinstance(user_plane_access_ipv4_address, str):
            raise TypeError("Expected argument 'user_plane_access_ipv4_address' to be a str")
        pulumi.set(__self__, "user_plane_access_ipv4_address", user_plane_access_ipv4_address)
        if user_plane_access_ipv4_gateway and not isinstance(user_plane_access_ipv4_gateway, str):
            raise TypeError("Expected argument 'user_plane_access_ipv4_gateway' to be a str")
        pulumi.set(__self__, "user_plane_access_ipv4_gateway", user_plane_access_ipv4_gateway)
        if user_plane_access_ipv4_subnet and not isinstance(user_plane_access_ipv4_subnet, str):
            raise TypeError("Expected argument 'user_plane_access_ipv4_subnet' to be a str")
        pulumi.set(__self__, "user_plane_access_ipv4_subnet", user_plane_access_ipv4_subnet)
        if user_plane_access_name and not isinstance(user_plane_access_name, str):
            raise TypeError("Expected argument 'user_plane_access_name' to be a str")
        pulumi.set(__self__, "user_plane_access_name", user_plane_access_name)

    @_builtins.property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Sequence[_builtins.str]:
        """
        The DNS servers to signal to UEs to use for this attached data network.
        """
        return pulumi.get(self, "dns_addresses")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Mobile Network Attached Data Network should exist.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkDataNetworkName")
    def mobile_network_data_network_name(self) -> _builtins.str:
        return pulumi.get(self, "mobile_network_data_network_name")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkPacketCoreDataPlaneId")
    def mobile_network_packet_core_data_plane_id(self) -> _builtins.str:
        return pulumi.get(self, "mobile_network_packet_core_data_plane_id")

    @_builtins.property
    @pulumi.getter(name="networkAddressPortTranslations")
    def network_address_port_translations(self) -> Sequence['outputs.GetNetworkAttachedDataNetworkNetworkAddressPortTranslationResult']:
        """
        A `network_address_port_translation` block as defined below.
        """
        return pulumi.get(self, "network_address_port_translations")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userEquipmentAddressPoolPrefixes")
    def user_equipment_address_pool_prefixes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "user_equipment_address_pool_prefixes")

    @_builtins.property
    @pulumi.getter(name="userEquipmentStaticAddressPoolPrefixes")
    def user_equipment_static_address_pool_prefixes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "user_equipment_static_address_pool_prefixes")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Address")
    def user_plane_access_ipv4_address(self) -> _builtins.str:
        """
        The IPv4 address for the user data plane interface.
        """
        return pulumi.get(self, "user_plane_access_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Gateway")
    def user_plane_access_ipv4_gateway(self) -> _builtins.str:
        """
        The default IPv4 gateway for the user data plane interface.
        """
        return pulumi.get(self, "user_plane_access_ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Subnet")
    def user_plane_access_ipv4_subnet(self) -> _builtins.str:
        """
        The IPv4 subnet for the user data plane interface.
        """
        return pulumi.get(self, "user_plane_access_ipv4_subnet")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessName")
    def user_plane_access_name(self) -> _builtins.str:
        """
        The logical name for thie user data plane interface.
        """
        return pulumi.get(self, "user_plane_access_name")


class AwaitableGetNetworkAttachedDataNetworkResult(GetNetworkAttachedDataNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkAttachedDataNetworkResult(
            dns_addresses=self.dns_addresses,
            id=self.id,
            location=self.location,
            mobile_network_data_network_name=self.mobile_network_data_network_name,
            mobile_network_packet_core_data_plane_id=self.mobile_network_packet_core_data_plane_id,
            network_address_port_translations=self.network_address_port_translations,
            tags=self.tags,
            user_equipment_address_pool_prefixes=self.user_equipment_address_pool_prefixes,
            user_equipment_static_address_pool_prefixes=self.user_equipment_static_address_pool_prefixes,
            user_plane_access_ipv4_address=self.user_plane_access_ipv4_address,
            user_plane_access_ipv4_gateway=self.user_plane_access_ipv4_gateway,
            user_plane_access_ipv4_subnet=self.user_plane_access_ipv4_subnet,
            user_plane_access_name=self.user_plane_access_name)


def get_network_attached_data_network(mobile_network_data_network_name: Optional[_builtins.str] = None,
                                      mobile_network_packet_core_data_plane_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkAttachedDataNetworkResult:
    """
    Use this data source to access information about an existing Mobile Network Attached Data Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network_packet_core_control_plane(name="example-mnpccp",
        resource_group_name="example-rg")
    example_get_network_attached_data_network = azure.mobile.get_network_attached_data_network(mobile_network_data_network_name=example.name,
        mobile_network_packet_core_data_plane_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork` - 2022-11-01


    :param _builtins.str mobile_network_data_network_name: The Name of the `mobile.NetworkDataNetwork` this resource belongs to.
    :param _builtins.str mobile_network_packet_core_data_plane_id: The ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to.
    """
    __args__ = dict()
    __args__['mobileNetworkDataNetworkName'] = mobile_network_data_network_name
    __args__['mobileNetworkPacketCoreDataPlaneId'] = mobile_network_packet_core_data_plane_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mobile/getNetworkAttachedDataNetwork:getNetworkAttachedDataNetwork', __args__, opts=opts, typ=GetNetworkAttachedDataNetworkResult).value

    return AwaitableGetNetworkAttachedDataNetworkResult(
        dns_addresses=pulumi.get(__ret__, 'dns_addresses'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        mobile_network_data_network_name=pulumi.get(__ret__, 'mobile_network_data_network_name'),
        mobile_network_packet_core_data_plane_id=pulumi.get(__ret__, 'mobile_network_packet_core_data_plane_id'),
        network_address_port_translations=pulumi.get(__ret__, 'network_address_port_translations'),
        tags=pulumi.get(__ret__, 'tags'),
        user_equipment_address_pool_prefixes=pulumi.get(__ret__, 'user_equipment_address_pool_prefixes'),
        user_equipment_static_address_pool_prefixes=pulumi.get(__ret__, 'user_equipment_static_address_pool_prefixes'),
        user_plane_access_ipv4_address=pulumi.get(__ret__, 'user_plane_access_ipv4_address'),
        user_plane_access_ipv4_gateway=pulumi.get(__ret__, 'user_plane_access_ipv4_gateway'),
        user_plane_access_ipv4_subnet=pulumi.get(__ret__, 'user_plane_access_ipv4_subnet'),
        user_plane_access_name=pulumi.get(__ret__, 'user_plane_access_name'))
def get_network_attached_data_network_output(mobile_network_data_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                                             mobile_network_packet_core_data_plane_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkAttachedDataNetworkResult]:
    """
    Use this data source to access information about an existing Mobile Network Attached Data Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network_packet_core_control_plane(name="example-mnpccp",
        resource_group_name="example-rg")
    example_get_network_attached_data_network = azure.mobile.get_network_attached_data_network(mobile_network_data_network_name=example.name,
        mobile_network_packet_core_data_plane_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork` - 2022-11-01


    :param _builtins.str mobile_network_data_network_name: The Name of the `mobile.NetworkDataNetwork` this resource belongs to.
    :param _builtins.str mobile_network_packet_core_data_plane_id: The ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to.
    """
    __args__ = dict()
    __args__['mobileNetworkDataNetworkName'] = mobile_network_data_network_name
    __args__['mobileNetworkPacketCoreDataPlaneId'] = mobile_network_packet_core_data_plane_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mobile/getNetworkAttachedDataNetwork:getNetworkAttachedDataNetwork', __args__, opts=opts, typ=GetNetworkAttachedDataNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkAttachedDataNetworkResult(
        dns_addresses=pulumi.get(__response__, 'dns_addresses'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        mobile_network_data_network_name=pulumi.get(__response__, 'mobile_network_data_network_name'),
        mobile_network_packet_core_data_plane_id=pulumi.get(__response__, 'mobile_network_packet_core_data_plane_id'),
        network_address_port_translations=pulumi.get(__response__, 'network_address_port_translations'),
        tags=pulumi.get(__response__, 'tags'),
        user_equipment_address_pool_prefixes=pulumi.get(__response__, 'user_equipment_address_pool_prefixes'),
        user_equipment_static_address_pool_prefixes=pulumi.get(__response__, 'user_equipment_static_address_pool_prefixes'),
        user_plane_access_ipv4_address=pulumi.get(__response__, 'user_plane_access_ipv4_address'),
        user_plane_access_ipv4_gateway=pulumi.get(__response__, 'user_plane_access_ipv4_gateway'),
        user_plane_access_ipv4_subnet=pulumi.get(__response__, 'user_plane_access_ipv4_subnet'),
        user_plane_access_name=pulumi.get(__response__, 'user_plane_access_name')))
