# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAttachedDataNetworkArgs', 'NetworkAttachedDataNetwork']

@pulumi.input_type
class NetworkAttachedDataNetworkArgs:
    def __init__(__self__, *,
                 dns_addresses: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 mobile_network_data_network_name: pulumi.Input[_builtins.str],
                 mobile_network_packet_core_data_plane_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_port_translation: Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_static_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkAttachedDataNetwork resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: Specifies the DNS servers to signal to UEs to use for this attached data network.
        :param pulumi.Input[_builtins.str] mobile_network_data_network_name: Specifies the name of the `mobile.NetworkDataNetwork` which the Attached Data Network belongs to, Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] mobile_network_packet_core_data_plane_id: Specifies the ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Attached Data Network should exist. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs'] network_address_port_translation: A `network_address_port_translation` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefix`. If you define both, they must be of the same size.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_static_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource. At least one of `user_equipment_address_pool_prefix` and `user_equipment_static_address_pool_prefixes`. If you define both, they must be of the same size.
               
               > **Note:** At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefixes` must be specified.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_address: The IPv4 address for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_gateway: The default IPv4 gateway for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_subnet: The IPv4 subnet for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_name: Specifies the logical name for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        pulumi.set(__self__, "mobile_network_data_network_name", mobile_network_data_network_name)
        pulumi.set(__self__, "mobile_network_packet_core_data_plane_id", mobile_network_packet_core_data_plane_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if network_address_port_translation is not None:
            pulumi.set(__self__, "network_address_port_translation", network_address_port_translation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_equipment_address_pool_prefixes is not None:
            pulumi.set(__self__, "user_equipment_address_pool_prefixes", user_equipment_address_pool_prefixes)
        if user_equipment_static_address_pool_prefixes is not None:
            pulumi.set(__self__, "user_equipment_static_address_pool_prefixes", user_equipment_static_address_pool_prefixes)
        if user_plane_access_ipv4_address is not None:
            pulumi.set(__self__, "user_plane_access_ipv4_address", user_plane_access_ipv4_address)
        if user_plane_access_ipv4_gateway is not None:
            pulumi.set(__self__, "user_plane_access_ipv4_gateway", user_plane_access_ipv4_gateway)
        if user_plane_access_ipv4_subnet is not None:
            pulumi.set(__self__, "user_plane_access_ipv4_subnet", user_plane_access_ipv4_subnet)
        if user_plane_access_name is not None:
            pulumi.set(__self__, "user_plane_access_name", user_plane_access_name)

    @_builtins.property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the DNS servers to signal to UEs to use for this attached data network.
        """
        return pulumi.get(self, "dns_addresses")

    @dns_addresses.setter
    def dns_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "dns_addresses", value)

    @_builtins.property
    @pulumi.getter(name="mobileNetworkDataNetworkName")
    def mobile_network_data_network_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the `mobile.NetworkDataNetwork` which the Attached Data Network belongs to, Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "mobile_network_data_network_name")

    @mobile_network_data_network_name.setter
    def mobile_network_data_network_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mobile_network_data_network_name", value)

    @_builtins.property
    @pulumi.getter(name="mobileNetworkPacketCoreDataPlaneId")
    def mobile_network_packet_core_data_plane_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to. Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "mobile_network_packet_core_data_plane_id")

    @mobile_network_packet_core_data_plane_id.setter
    def mobile_network_packet_core_data_plane_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mobile_network_packet_core_data_plane_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Attached Data Network should exist. Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="networkAddressPortTranslation")
    def network_address_port_translation(self) -> Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs']]:
        """
        A `network_address_port_translation` block as defined below.
        """
        return pulumi.get(self, "network_address_port_translation")

    @network_address_port_translation.setter
    def network_address_port_translation(self, value: Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs']]):
        pulumi.set(self, "network_address_port_translation", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userEquipmentAddressPoolPrefixes")
    def user_equipment_address_pool_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefix`. If you define both, they must be of the same size.
        """
        return pulumi.get(self, "user_equipment_address_pool_prefixes")

    @user_equipment_address_pool_prefixes.setter
    def user_equipment_address_pool_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_equipment_address_pool_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="userEquipmentStaticAddressPoolPrefixes")
    def user_equipment_static_address_pool_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource. At least one of `user_equipment_address_pool_prefix` and `user_equipment_static_address_pool_prefixes`. If you define both, they must be of the same size.

        > **Note:** At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefixes` must be specified.
        """
        return pulumi.get(self, "user_equipment_static_address_pool_prefixes")

    @user_equipment_static_address_pool_prefixes.setter
    def user_equipment_static_address_pool_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_equipment_static_address_pool_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Address")
    def user_plane_access_ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_address")

    @user_plane_access_ipv4_address.setter
    def user_plane_access_ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Gateway")
    def user_plane_access_ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default IPv4 gateway for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_gateway")

    @user_plane_access_ipv4_gateway.setter
    def user_plane_access_ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Subnet")
    def user_plane_access_ipv4_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 subnet for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_subnet")

    @user_plane_access_ipv4_subnet.setter
    def user_plane_access_ipv4_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_ipv4_subnet", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessName")
    def user_plane_access_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the logical name for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_name")

    @user_plane_access_name.setter
    def user_plane_access_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_name", value)


@pulumi.input_type
class _NetworkAttachedDataNetworkState:
    def __init__(__self__, *,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_data_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_packet_core_data_plane_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_port_translation: Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_static_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkAttachedDataNetwork resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: Specifies the DNS servers to signal to UEs to use for this attached data network.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Attached Data Network should exist. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] mobile_network_data_network_name: Specifies the name of the `mobile.NetworkDataNetwork` which the Attached Data Network belongs to, Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] mobile_network_packet_core_data_plane_id: Specifies the ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs'] network_address_port_translation: A `network_address_port_translation` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefix`. If you define both, they must be of the same size.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_static_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource. At least one of `user_equipment_address_pool_prefix` and `user_equipment_static_address_pool_prefixes`. If you define both, they must be of the same size.
               
               > **Note:** At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefixes` must be specified.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_address: The IPv4 address for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_gateway: The default IPv4 gateway for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_subnet: The IPv4 subnet for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_name: Specifies the logical name for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        if dns_addresses is not None:
            pulumi.set(__self__, "dns_addresses", dns_addresses)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mobile_network_data_network_name is not None:
            pulumi.set(__self__, "mobile_network_data_network_name", mobile_network_data_network_name)
        if mobile_network_packet_core_data_plane_id is not None:
            pulumi.set(__self__, "mobile_network_packet_core_data_plane_id", mobile_network_packet_core_data_plane_id)
        if network_address_port_translation is not None:
            pulumi.set(__self__, "network_address_port_translation", network_address_port_translation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_equipment_address_pool_prefixes is not None:
            pulumi.set(__self__, "user_equipment_address_pool_prefixes", user_equipment_address_pool_prefixes)
        if user_equipment_static_address_pool_prefixes is not None:
            pulumi.set(__self__, "user_equipment_static_address_pool_prefixes", user_equipment_static_address_pool_prefixes)
        if user_plane_access_ipv4_address is not None:
            pulumi.set(__self__, "user_plane_access_ipv4_address", user_plane_access_ipv4_address)
        if user_plane_access_ipv4_gateway is not None:
            pulumi.set(__self__, "user_plane_access_ipv4_gateway", user_plane_access_ipv4_gateway)
        if user_plane_access_ipv4_subnet is not None:
            pulumi.set(__self__, "user_plane_access_ipv4_subnet", user_plane_access_ipv4_subnet)
        if user_plane_access_name is not None:
            pulumi.set(__self__, "user_plane_access_name", user_plane_access_name)

    @_builtins.property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the DNS servers to signal to UEs to use for this attached data network.
        """
        return pulumi.get(self, "dns_addresses")

    @dns_addresses.setter
    def dns_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_addresses", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Attached Data Network should exist. Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mobileNetworkDataNetworkName")
    def mobile_network_data_network_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the `mobile.NetworkDataNetwork` which the Attached Data Network belongs to, Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "mobile_network_data_network_name")

    @mobile_network_data_network_name.setter
    def mobile_network_data_network_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile_network_data_network_name", value)

    @_builtins.property
    @pulumi.getter(name="mobileNetworkPacketCoreDataPlaneId")
    def mobile_network_packet_core_data_plane_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to. Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "mobile_network_packet_core_data_plane_id")

    @mobile_network_packet_core_data_plane_id.setter
    def mobile_network_packet_core_data_plane_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile_network_packet_core_data_plane_id", value)

    @_builtins.property
    @pulumi.getter(name="networkAddressPortTranslation")
    def network_address_port_translation(self) -> Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs']]:
        """
        A `network_address_port_translation` block as defined below.
        """
        return pulumi.get(self, "network_address_port_translation")

    @network_address_port_translation.setter
    def network_address_port_translation(self, value: Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs']]):
        pulumi.set(self, "network_address_port_translation", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userEquipmentAddressPoolPrefixes")
    def user_equipment_address_pool_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefix`. If you define both, they must be of the same size.
        """
        return pulumi.get(self, "user_equipment_address_pool_prefixes")

    @user_equipment_address_pool_prefixes.setter
    def user_equipment_address_pool_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_equipment_address_pool_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="userEquipmentStaticAddressPoolPrefixes")
    def user_equipment_static_address_pool_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource. At least one of `user_equipment_address_pool_prefix` and `user_equipment_static_address_pool_prefixes`. If you define both, they must be of the same size.

        > **Note:** At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefixes` must be specified.
        """
        return pulumi.get(self, "user_equipment_static_address_pool_prefixes")

    @user_equipment_static_address_pool_prefixes.setter
    def user_equipment_static_address_pool_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_equipment_static_address_pool_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Address")
    def user_plane_access_ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_address")

    @user_plane_access_ipv4_address.setter
    def user_plane_access_ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Gateway")
    def user_plane_access_ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default IPv4 gateway for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_gateway")

    @user_plane_access_ipv4_gateway.setter
    def user_plane_access_ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Subnet")
    def user_plane_access_ipv4_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 subnet for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_subnet")

    @user_plane_access_ipv4_subnet.setter
    def user_plane_access_ipv4_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_ipv4_subnet", value)

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessName")
    def user_plane_access_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the logical name for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_name")

    @user_plane_access_name.setter
    def user_plane_access_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_plane_access_name", value)


@pulumi.type_token("azure:mobile/networkAttachedDataNetwork:NetworkAttachedDataNetwork")
class NetworkAttachedDataNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_data_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_packet_core_data_plane_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_port_translation: Optional[pulumi.Input[Union['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs', 'NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_static_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Mobile Network Attached Data Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_device = azure.databoxedge.Device("example",
            name="example-device",
            resource_group_name=example.name,
            location=example.location,
            sku_name="EdgeP_Base-Standard")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            resource_group_name=example.name,
            location=example.location,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_packet_core_control_plane = azure.mobile.NetworkPacketCoreControlPlane("example",
            name="example-mnpccp",
            resource_group_name=example.name,
            location="West Europe",
            sku="G0",
            mobile_network_id=example_network.id,
            control_plane_access_name="default-interface",
            control_plane_access_ipv4_address="192.168.1.199",
            control_plane_access_ipv4_gateway="192.168.1.1",
            control_plane_access_ipv4_subnet="192.168.1.0/25",
            platform={
                "type": "AKS-HCI",
                "edge_device_id": example_device.id,
            })
        example_network_packet_core_data_plane = azure.mobile.NetworkPacketCoreDataPlane("example",
            name="example-mnpcdp",
            mobile_network_packet_core_control_plane_id=example_network_packet_core_control_plane.id,
            location=example.location,
            user_plane_access_name="default-interface",
            user_plane_access_ipv4_address="192.168.1.199",
            user_plane_access_ipv4_gateway="192.168.1.1",
            user_plane_access_ipv4_subnet="192.168.1.0/25")
        example_network_data_network = azure.mobile.NetworkDataNetwork("example",
            name="example-data-network",
            mobile_network_id=example_network.id,
            location=example.location)
        example_network_attached_data_network = azure.mobile.NetworkAttachedDataNetwork("example",
            mobile_network_data_network_name=example_network_data_network.name,
            mobile_network_packet_core_data_plane_id=example_network_packet_core_data_plane.id,
            location=example.location,
            dns_addresses=["1.1.1.1"],
            user_equipment_address_pool_prefixes=["2.4.1.0/24"],
            user_equipment_static_address_pool_prefixes=["2.4.2.0/24"],
            user_plane_access_name="test",
            user_plane_access_ipv4_address="10.204.141.4",
            user_plane_access_ipv4_gateway="10.204.141.1",
            user_plane_access_ipv4_subnet="10.204.141.0/24",
            network_address_port_translation={
                "pinhole_maximum_number": 65536,
                "icmp_pinhole_timeout_in_seconds": 30,
                "tcp_pinhole_timeout_in_seconds": 100,
                "udp_pinhole_timeout_in_seconds": 39,
                "port_range": {
                    "maximum": 49999,
                    "minimum": 1024,
                },
                "tcp_port_reuse_minimum_hold_time_in_seconds": 120,
                "udp_tcp_port_reuse_minimum_hold_time_in_seconds": 60,
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork` - 2022-11-01

        ## Import

        Mobile Network Attached Data Network can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkAttachedDataNetwork:NetworkAttachedDataNetwork example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/packetCoreControlPlane1/packetCoreDataPlanes/packetCoreDataPlane1/attachedDataNetworks/attachedDataNetwork1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: Specifies the DNS servers to signal to UEs to use for this attached data network.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Attached Data Network should exist. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] mobile_network_data_network_name: Specifies the name of the `mobile.NetworkDataNetwork` which the Attached Data Network belongs to, Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] mobile_network_packet_core_data_plane_id: Specifies the ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[Union['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs', 'NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict']] network_address_port_translation: A `network_address_port_translation` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefix`. If you define both, they must be of the same size.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_static_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource. At least one of `user_equipment_address_pool_prefix` and `user_equipment_static_address_pool_prefixes`. If you define both, they must be of the same size.
               
               > **Note:** At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefixes` must be specified.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_address: The IPv4 address for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_gateway: The default IPv4 gateway for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_subnet: The IPv4 subnet for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_name: Specifies the logical name for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAttachedDataNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Mobile Network Attached Data Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_device = azure.databoxedge.Device("example",
            name="example-device",
            resource_group_name=example.name,
            location=example.location,
            sku_name="EdgeP_Base-Standard")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            resource_group_name=example.name,
            location=example.location,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_packet_core_control_plane = azure.mobile.NetworkPacketCoreControlPlane("example",
            name="example-mnpccp",
            resource_group_name=example.name,
            location="West Europe",
            sku="G0",
            mobile_network_id=example_network.id,
            control_plane_access_name="default-interface",
            control_plane_access_ipv4_address="192.168.1.199",
            control_plane_access_ipv4_gateway="192.168.1.1",
            control_plane_access_ipv4_subnet="192.168.1.0/25",
            platform={
                "type": "AKS-HCI",
                "edge_device_id": example_device.id,
            })
        example_network_packet_core_data_plane = azure.mobile.NetworkPacketCoreDataPlane("example",
            name="example-mnpcdp",
            mobile_network_packet_core_control_plane_id=example_network_packet_core_control_plane.id,
            location=example.location,
            user_plane_access_name="default-interface",
            user_plane_access_ipv4_address="192.168.1.199",
            user_plane_access_ipv4_gateway="192.168.1.1",
            user_plane_access_ipv4_subnet="192.168.1.0/25")
        example_network_data_network = azure.mobile.NetworkDataNetwork("example",
            name="example-data-network",
            mobile_network_id=example_network.id,
            location=example.location)
        example_network_attached_data_network = azure.mobile.NetworkAttachedDataNetwork("example",
            mobile_network_data_network_name=example_network_data_network.name,
            mobile_network_packet_core_data_plane_id=example_network_packet_core_data_plane.id,
            location=example.location,
            dns_addresses=["1.1.1.1"],
            user_equipment_address_pool_prefixes=["2.4.1.0/24"],
            user_equipment_static_address_pool_prefixes=["2.4.2.0/24"],
            user_plane_access_name="test",
            user_plane_access_ipv4_address="10.204.141.4",
            user_plane_access_ipv4_gateway="10.204.141.1",
            user_plane_access_ipv4_subnet="10.204.141.0/24",
            network_address_port_translation={
                "pinhole_maximum_number": 65536,
                "icmp_pinhole_timeout_in_seconds": 30,
                "tcp_pinhole_timeout_in_seconds": 100,
                "udp_pinhole_timeout_in_seconds": 39,
                "port_range": {
                    "maximum": 49999,
                    "minimum": 1024,
                },
                "tcp_port_reuse_minimum_hold_time_in_seconds": 120,
                "udp_tcp_port_reuse_minimum_hold_time_in_seconds": 60,
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork` - 2022-11-01

        ## Import

        Mobile Network Attached Data Network can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkAttachedDataNetwork:NetworkAttachedDataNetwork example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/packetCoreControlPlane1/packetCoreDataPlanes/packetCoreDataPlane1/attachedDataNetworks/attachedDataNetwork1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAttachedDataNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAttachedDataNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_data_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_packet_core_data_plane_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_port_translation: Optional[pulumi.Input[Union['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs', 'NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_static_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 user_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAttachedDataNetworkArgs.__new__(NetworkAttachedDataNetworkArgs)

            if dns_addresses is None and not opts.urn:
                raise TypeError("Missing required property 'dns_addresses'")
            __props__.__dict__["dns_addresses"] = dns_addresses
            __props__.__dict__["location"] = location
            if mobile_network_data_network_name is None and not opts.urn:
                raise TypeError("Missing required property 'mobile_network_data_network_name'")
            __props__.__dict__["mobile_network_data_network_name"] = mobile_network_data_network_name
            if mobile_network_packet_core_data_plane_id is None and not opts.urn:
                raise TypeError("Missing required property 'mobile_network_packet_core_data_plane_id'")
            __props__.__dict__["mobile_network_packet_core_data_plane_id"] = mobile_network_packet_core_data_plane_id
            __props__.__dict__["network_address_port_translation"] = network_address_port_translation
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_equipment_address_pool_prefixes"] = user_equipment_address_pool_prefixes
            __props__.__dict__["user_equipment_static_address_pool_prefixes"] = user_equipment_static_address_pool_prefixes
            __props__.__dict__["user_plane_access_ipv4_address"] = user_plane_access_ipv4_address
            __props__.__dict__["user_plane_access_ipv4_gateway"] = user_plane_access_ipv4_gateway
            __props__.__dict__["user_plane_access_ipv4_subnet"] = user_plane_access_ipv4_subnet
            __props__.__dict__["user_plane_access_name"] = user_plane_access_name
        super(NetworkAttachedDataNetwork, __self__).__init__(
            'azure:mobile/networkAttachedDataNetwork:NetworkAttachedDataNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mobile_network_data_network_name: Optional[pulumi.Input[_builtins.str]] = None,
            mobile_network_packet_core_data_plane_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_address_port_translation: Optional[pulumi.Input[Union['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs', 'NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_equipment_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_equipment_static_address_pool_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            user_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            user_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            user_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkAttachedDataNetwork':
        """
        Get an existing NetworkAttachedDataNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_addresses: Specifies the DNS servers to signal to UEs to use for this attached data network.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Attached Data Network should exist. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] mobile_network_data_network_name: Specifies the name of the `mobile.NetworkDataNetwork` which the Attached Data Network belongs to, Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[_builtins.str] mobile_network_packet_core_data_plane_id: Specifies the ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to. Changing this forces a new Mobile Network Attached Data Network to be created.
        :param pulumi.Input[Union['NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs', 'NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict']] network_address_port_translation: A `network_address_port_translation` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefix`. If you define both, they must be of the same size.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_equipment_static_address_pool_prefixes: Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource. At least one of `user_equipment_address_pool_prefix` and `user_equipment_static_address_pool_prefixes`. If you define both, they must be of the same size.
               
               > **Note:** At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefixes` must be specified.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_address: The IPv4 address for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_gateway: The default IPv4 gateway for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_ipv4_subnet: The IPv4 subnet for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] user_plane_access_name: Specifies the logical name for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAttachedDataNetworkState.__new__(_NetworkAttachedDataNetworkState)

        __props__.__dict__["dns_addresses"] = dns_addresses
        __props__.__dict__["location"] = location
        __props__.__dict__["mobile_network_data_network_name"] = mobile_network_data_network_name
        __props__.__dict__["mobile_network_packet_core_data_plane_id"] = mobile_network_packet_core_data_plane_id
        __props__.__dict__["network_address_port_translation"] = network_address_port_translation
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_equipment_address_pool_prefixes"] = user_equipment_address_pool_prefixes
        __props__.__dict__["user_equipment_static_address_pool_prefixes"] = user_equipment_static_address_pool_prefixes
        __props__.__dict__["user_plane_access_ipv4_address"] = user_plane_access_ipv4_address
        __props__.__dict__["user_plane_access_ipv4_gateway"] = user_plane_access_ipv4_gateway
        __props__.__dict__["user_plane_access_ipv4_subnet"] = user_plane_access_ipv4_subnet
        __props__.__dict__["user_plane_access_name"] = user_plane_access_name
        return NetworkAttachedDataNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the DNS servers to signal to UEs to use for this attached data network.
        """
        return pulumi.get(self, "dns_addresses")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Mobile Network Attached Data Network should exist. Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkDataNetworkName")
    def mobile_network_data_network_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the `mobile.NetworkDataNetwork` which the Attached Data Network belongs to, Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "mobile_network_data_network_name")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkPacketCoreDataPlaneId")
    def mobile_network_packet_core_data_plane_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the `mobile.NetworkPacketCoreDataPlane` which the Mobile Network Attached Data Network belongs to. Changing this forces a new Mobile Network Attached Data Network to be created.
        """
        return pulumi.get(self, "mobile_network_packet_core_data_plane_id")

    @_builtins.property
    @pulumi.getter(name="networkAddressPortTranslation")
    def network_address_port_translation(self) -> pulumi.Output[Optional['outputs.NetworkAttachedDataNetworkNetworkAddressPortTranslation']]:
        """
        A `network_address_port_translation` block as defined below.
        """
        return pulumi.get(self, "network_address_port_translation")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Attached Data Network.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userEquipmentAddressPoolPrefixes")
    def user_equipment_address_pool_prefixes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefix`. If you define both, they must be of the same size.
        """
        return pulumi.get(self, "user_equipment_address_pool_prefixes")

    @_builtins.property
    @pulumi.getter(name="userEquipmentStaticAddressPoolPrefixes")
    def user_equipment_static_address_pool_prefixes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs. The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource. At least one of `user_equipment_address_pool_prefix` and `user_equipment_static_address_pool_prefixes`. If you define both, they must be of the same size.

        > **Note:** At least one of `user_equipment_address_pool_prefixes` and `user_equipment_static_address_pool_prefixes` must be specified.
        """
        return pulumi.get(self, "user_equipment_static_address_pool_prefixes")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Address")
    def user_plane_access_ipv4_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 address for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Gateway")
    def user_plane_access_ipv4_gateway(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default IPv4 gateway for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Subnet")
    def user_plane_access_ipv4_subnet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 subnet for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_ipv4_subnet")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessName")
    def user_plane_access_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the logical name for the user data plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "user_plane_access_name")

