# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiagnosticSettingArgs', 'DiagnosticSetting']

@pulumi.input_type
class DiagnosticSettingArgs:
    def __init__(__self__, *,
                 target_resource_id: pulumi.Input[_builtins.str],
                 enabled_logs: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]]] = None,
                 eventhub_authorization_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_solution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DiagnosticSetting resource.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of an existing Resource on which to configure Diagnostic Settings. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]] enabled_logs: One or more `enabled_log` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified. At least one type of Log or Metric must be enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]] enabled_metrics: One or more `enabled_metric` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified.
        :param pulumi.Input[_builtins.str] eventhub_authorization_rule_id: Specifies the ID of an Event Hub Namespace Authorization Rule used to send Diagnostics Data. 
               
               > **NOTE:** This can be sourced from the `eventhub.EventHubNamespaceAuthorizationRule` resource and is different from a `eventhub.AuthorizationRule` resource.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] eventhub_name: Specifies the name of the Event Hub where Diagnostics Data should be sent.
               
               > **NOTE:** If this isn't specified then the default Event Hub will be used.
        :param pulumi.Input[_builtins.str] log_analytics_destination_type: Possible values are `AzureDiagnostics` and `Dedicated`. When set to `Dedicated`, logs sent to a Log Analytics workspace will go into resource specific tables, instead of the legacy `AzureDiagnostics` table.
               
               > **NOTE:** This setting will only have an effect if a `log_analytics_workspace_id` is provided. For some target resource type (e.g., Key Vault), this field is unconfigurable. Please see [resource types](https://learn.microsoft.com/en-us/azure/azure-monitor/reference/tables/azurediagnostics#resource-types) for services that use each method. Please [see the documentation](https://docs.microsoft.com/azure/azure-monitor/platform/diagnostic-logs-stream-log-store#azure-diagnostics-vs-resource-specific) for details on the differences between destination types.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of a Log Analytics Workspace where Diagnostics Data should be sent.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Diagnostic Setting. Changing this forces a new resource to be created.
               
               > **NOTE:** If the name is set to 'service' it will not be possible to fully delete the diagnostic setting. This is due to legacy API support.
        :param pulumi.Input[_builtins.str] partner_solution_id: The ID of the market partner solution where Diagnostics Data should be sent. For potential partner integrations, [click to learn more about partner integration](https://learn.microsoft.com/en-us/azure/partner-solutions/overview).
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where logs should be sent. 
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if enabled_logs is not None:
            pulumi.set(__self__, "enabled_logs", enabled_logs)
        if enabled_metrics is not None:
            pulumi.set(__self__, "enabled_metrics", enabled_metrics)
        if eventhub_authorization_rule_id is not None:
            pulumi.set(__self__, "eventhub_authorization_rule_id", eventhub_authorization_rule_id)
        if eventhub_name is not None:
            pulumi.set(__self__, "eventhub_name", eventhub_name)
        if log_analytics_destination_type is not None:
            pulumi.set(__self__, "log_analytics_destination_type", log_analytics_destination_type)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if metrics is not None:
            warnings.warn("""`metric` has been deprecated in favor of the `enabled_metric` property and will be removed in v5.0 of the AzureRM provider""", DeprecationWarning)
            pulumi.log.warn("""metrics is deprecated: `metric` has been deprecated in favor of the `enabled_metric` property and will be removed in v5.0 of the AzureRM provider""")
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partner_solution_id is not None:
            pulumi.set(__self__, "partner_solution_id", partner_solution_id)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of an existing Resource on which to configure Diagnostic Settings. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="enabledLogs")
    def enabled_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]]]:
        """
        One or more `enabled_log` blocks as defined below.

        > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified. At least one type of Log or Metric must be enabled.
        """
        return pulumi.get(self, "enabled_logs")

    @enabled_logs.setter
    def enabled_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]]]):
        pulumi.set(self, "enabled_logs", value)

    @_builtins.property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]]]:
        """
        One or more `enabled_metric` blocks as defined below.

        > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified.
        """
        return pulumi.get(self, "enabled_metrics")

    @enabled_metrics.setter
    def enabled_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]]]):
        pulumi.set(self, "enabled_metrics", value)

    @_builtins.property
    @pulumi.getter(name="eventhubAuthorizationRuleId")
    def eventhub_authorization_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of an Event Hub Namespace Authorization Rule used to send Diagnostics Data. 

        > **NOTE:** This can be sourced from the `eventhub.EventHubNamespaceAuthorizationRule` resource and is different from a `eventhub.AuthorizationRule` resource.

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "eventhub_authorization_rule_id")

    @eventhub_authorization_rule_id.setter
    def eventhub_authorization_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_authorization_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Event Hub where Diagnostics Data should be sent.

        > **NOTE:** If this isn't specified then the default Event Hub will be used.
        """
        return pulumi.get(self, "eventhub_name")

    @eventhub_name.setter
    def eventhub_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_name", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsDestinationType")
    def log_analytics_destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values are `AzureDiagnostics` and `Dedicated`. When set to `Dedicated`, logs sent to a Log Analytics workspace will go into resource specific tables, instead of the legacy `AzureDiagnostics` table.

        > **NOTE:** This setting will only have an effect if a `log_analytics_workspace_id` is provided. For some target resource type (e.g., Key Vault), this field is unconfigurable. Please see [resource types](https://learn.microsoft.com/en-us/azure/azure-monitor/reference/tables/azurediagnostics#resource-types) for services that use each method. Please [see the documentation](https://docs.microsoft.com/azure/azure-monitor/platform/diagnostic-logs-stream-log-store#azure-diagnostics-vs-resource-specific) for details on the differences between destination types.
        """
        return pulumi.get(self, "log_analytics_destination_type")

    @log_analytics_destination_type.setter
    def log_analytics_destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_destination_type", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a Log Analytics Workspace where Diagnostics Data should be sent.

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""`metric` has been deprecated in favor of the `enabled_metric` property and will be removed in v5.0 of the AzureRM provider""")
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingMetricArgs']]]]:
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Diagnostic Setting. Changing this forces a new resource to be created.

        > **NOTE:** If the name is set to 'service' it will not be possible to fully delete the diagnostic setting. This is due to legacy API support.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partnerSolutionId")
    def partner_solution_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the market partner solution where Diagnostics Data should be sent. For potential partner integrations, [click to learn more about partner integration](https://learn.microsoft.com/en-us/azure/partner-solutions/overview).

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "partner_solution_id")

    @partner_solution_id.setter
    def partner_solution_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partner_solution_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account where logs should be sent. 

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.input_type
class _DiagnosticSettingState:
    def __init__(__self__, *,
                 enabled_logs: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]]] = None,
                 eventhub_authorization_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_solution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DiagnosticSetting resources.
        :param pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]] enabled_logs: One or more `enabled_log` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified. At least one type of Log or Metric must be enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]] enabled_metrics: One or more `enabled_metric` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified.
        :param pulumi.Input[_builtins.str] eventhub_authorization_rule_id: Specifies the ID of an Event Hub Namespace Authorization Rule used to send Diagnostics Data. 
               
               > **NOTE:** This can be sourced from the `eventhub.EventHubNamespaceAuthorizationRule` resource and is different from a `eventhub.AuthorizationRule` resource.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] eventhub_name: Specifies the name of the Event Hub where Diagnostics Data should be sent.
               
               > **NOTE:** If this isn't specified then the default Event Hub will be used.
        :param pulumi.Input[_builtins.str] log_analytics_destination_type: Possible values are `AzureDiagnostics` and `Dedicated`. When set to `Dedicated`, logs sent to a Log Analytics workspace will go into resource specific tables, instead of the legacy `AzureDiagnostics` table.
               
               > **NOTE:** This setting will only have an effect if a `log_analytics_workspace_id` is provided. For some target resource type (e.g., Key Vault), this field is unconfigurable. Please see [resource types](https://learn.microsoft.com/en-us/azure/azure-monitor/reference/tables/azurediagnostics#resource-types) for services that use each method. Please [see the documentation](https://docs.microsoft.com/azure/azure-monitor/platform/diagnostic-logs-stream-log-store#azure-diagnostics-vs-resource-specific) for details on the differences between destination types.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of a Log Analytics Workspace where Diagnostics Data should be sent.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Diagnostic Setting. Changing this forces a new resource to be created.
               
               > **NOTE:** If the name is set to 'service' it will not be possible to fully delete the diagnostic setting. This is due to legacy API support.
        :param pulumi.Input[_builtins.str] partner_solution_id: The ID of the market partner solution where Diagnostics Data should be sent. For potential partner integrations, [click to learn more about partner integration](https://learn.microsoft.com/en-us/azure/partner-solutions/overview).
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where logs should be sent. 
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of an existing Resource on which to configure Diagnostic Settings. Changing this forces a new resource to be created.
        """
        if enabled_logs is not None:
            pulumi.set(__self__, "enabled_logs", enabled_logs)
        if enabled_metrics is not None:
            pulumi.set(__self__, "enabled_metrics", enabled_metrics)
        if eventhub_authorization_rule_id is not None:
            pulumi.set(__self__, "eventhub_authorization_rule_id", eventhub_authorization_rule_id)
        if eventhub_name is not None:
            pulumi.set(__self__, "eventhub_name", eventhub_name)
        if log_analytics_destination_type is not None:
            pulumi.set(__self__, "log_analytics_destination_type", log_analytics_destination_type)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if metrics is not None:
            warnings.warn("""`metric` has been deprecated in favor of the `enabled_metric` property and will be removed in v5.0 of the AzureRM provider""", DeprecationWarning)
            pulumi.log.warn("""metrics is deprecated: `metric` has been deprecated in favor of the `enabled_metric` property and will be removed in v5.0 of the AzureRM provider""")
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partner_solution_id is not None:
            pulumi.set(__self__, "partner_solution_id", partner_solution_id)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)

    @_builtins.property
    @pulumi.getter(name="enabledLogs")
    def enabled_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]]]:
        """
        One or more `enabled_log` blocks as defined below.

        > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified. At least one type of Log or Metric must be enabled.
        """
        return pulumi.get(self, "enabled_logs")

    @enabled_logs.setter
    def enabled_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledLogArgs']]]]):
        pulumi.set(self, "enabled_logs", value)

    @_builtins.property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]]]:
        """
        One or more `enabled_metric` blocks as defined below.

        > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified.
        """
        return pulumi.get(self, "enabled_metrics")

    @enabled_metrics.setter
    def enabled_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingEnabledMetricArgs']]]]):
        pulumi.set(self, "enabled_metrics", value)

    @_builtins.property
    @pulumi.getter(name="eventhubAuthorizationRuleId")
    def eventhub_authorization_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of an Event Hub Namespace Authorization Rule used to send Diagnostics Data. 

        > **NOTE:** This can be sourced from the `eventhub.EventHubNamespaceAuthorizationRule` resource and is different from a `eventhub.AuthorizationRule` resource.

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "eventhub_authorization_rule_id")

    @eventhub_authorization_rule_id.setter
    def eventhub_authorization_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_authorization_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Event Hub where Diagnostics Data should be sent.

        > **NOTE:** If this isn't specified then the default Event Hub will be used.
        """
        return pulumi.get(self, "eventhub_name")

    @eventhub_name.setter
    def eventhub_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_name", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsDestinationType")
    def log_analytics_destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values are `AzureDiagnostics` and `Dedicated`. When set to `Dedicated`, logs sent to a Log Analytics workspace will go into resource specific tables, instead of the legacy `AzureDiagnostics` table.

        > **NOTE:** This setting will only have an effect if a `log_analytics_workspace_id` is provided. For some target resource type (e.g., Key Vault), this field is unconfigurable. Please see [resource types](https://learn.microsoft.com/en-us/azure/azure-monitor/reference/tables/azurediagnostics#resource-types) for services that use each method. Please [see the documentation](https://docs.microsoft.com/azure/azure-monitor/platform/diagnostic-logs-stream-log-store#azure-diagnostics-vs-resource-specific) for details on the differences between destination types.
        """
        return pulumi.get(self, "log_analytics_destination_type")

    @log_analytics_destination_type.setter
    def log_analytics_destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_destination_type", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a Log Analytics Workspace where Diagnostics Data should be sent.

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""`metric` has been deprecated in favor of the `enabled_metric` property and will be removed in v5.0 of the AzureRM provider""")
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingMetricArgs']]]]:
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticSettingMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Diagnostic Setting. Changing this forces a new resource to be created.

        > **NOTE:** If the name is set to 'service' it will not be possible to fully delete the diagnostic setting. This is due to legacy API support.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partnerSolutionId")
    def partner_solution_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the market partner solution where Diagnostics Data should be sent. For potential partner integrations, [click to learn more about partner integration](https://learn.microsoft.com/en-us/azure/partner-solutions/overview).

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "partner_solution_id")

    @partner_solution_id.setter
    def partner_solution_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partner_solution_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account where logs should be sent. 

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Resource on which to configure Diagnostic Settings. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)


@pulumi.type_token("azure:monitoring/diagnosticSetting:DiagnosticSetting")
class DiagnosticSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled_logs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledLogArgs', 'DiagnosticSettingEnabledLogArgsDict']]]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledMetricArgs', 'DiagnosticSettingEnabledMetricArgsDict']]]]] = None,
                 eventhub_authorization_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingMetricArgs', 'DiagnosticSettingMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_solution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Diagnostic Setting for an existing Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard")
        example_diagnostic_setting = azure.monitoring.DiagnosticSetting("example",
            name="example",
            target_resource_id=example_key_vault.id,
            storage_account_id=example_account.id,
            enabled_logs=[{
                "category": "AuditEvent",
            }],
            enabled_metrics=[{
                "category": "AllMetrics",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2021-05-01-preview

        ## Import

        Diagnostic Settings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/diagnosticSetting:DiagnosticSetting example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.KeyVault/vaults/vault1|logMonitoring1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledLogArgs', 'DiagnosticSettingEnabledLogArgsDict']]]] enabled_logs: One or more `enabled_log` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified. At least one type of Log or Metric must be enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledMetricArgs', 'DiagnosticSettingEnabledMetricArgsDict']]]] enabled_metrics: One or more `enabled_metric` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified.
        :param pulumi.Input[_builtins.str] eventhub_authorization_rule_id: Specifies the ID of an Event Hub Namespace Authorization Rule used to send Diagnostics Data. 
               
               > **NOTE:** This can be sourced from the `eventhub.EventHubNamespaceAuthorizationRule` resource and is different from a `eventhub.AuthorizationRule` resource.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] eventhub_name: Specifies the name of the Event Hub where Diagnostics Data should be sent.
               
               > **NOTE:** If this isn't specified then the default Event Hub will be used.
        :param pulumi.Input[_builtins.str] log_analytics_destination_type: Possible values are `AzureDiagnostics` and `Dedicated`. When set to `Dedicated`, logs sent to a Log Analytics workspace will go into resource specific tables, instead of the legacy `AzureDiagnostics` table.
               
               > **NOTE:** This setting will only have an effect if a `log_analytics_workspace_id` is provided. For some target resource type (e.g., Key Vault), this field is unconfigurable. Please see [resource types](https://learn.microsoft.com/en-us/azure/azure-monitor/reference/tables/azurediagnostics#resource-types) for services that use each method. Please [see the documentation](https://docs.microsoft.com/azure/azure-monitor/platform/diagnostic-logs-stream-log-store#azure-diagnostics-vs-resource-specific) for details on the differences between destination types.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of a Log Analytics Workspace where Diagnostics Data should be sent.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Diagnostic Setting. Changing this forces a new resource to be created.
               
               > **NOTE:** If the name is set to 'service' it will not be possible to fully delete the diagnostic setting. This is due to legacy API support.
        :param pulumi.Input[_builtins.str] partner_solution_id: The ID of the market partner solution where Diagnostics Data should be sent. For potential partner integrations, [click to learn more about partner integration](https://learn.microsoft.com/en-us/azure/partner-solutions/overview).
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where logs should be sent. 
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of an existing Resource on which to configure Diagnostic Settings. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiagnosticSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Diagnostic Setting for an existing Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard")
        example_diagnostic_setting = azure.monitoring.DiagnosticSetting("example",
            name="example",
            target_resource_id=example_key_vault.id,
            storage_account_id=example_account.id,
            enabled_logs=[{
                "category": "AuditEvent",
            }],
            enabled_metrics=[{
                "category": "AllMetrics",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2021-05-01-preview

        ## Import

        Diagnostic Settings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/diagnosticSetting:DiagnosticSetting example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.KeyVault/vaults/vault1|logMonitoring1"
        ```

        :param str resource_name: The name of the resource.
        :param DiagnosticSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiagnosticSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled_logs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledLogArgs', 'DiagnosticSettingEnabledLogArgsDict']]]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledMetricArgs', 'DiagnosticSettingEnabledMetricArgsDict']]]]] = None,
                 eventhub_authorization_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingMetricArgs', 'DiagnosticSettingMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_solution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiagnosticSettingArgs.__new__(DiagnosticSettingArgs)

            __props__.__dict__["enabled_logs"] = enabled_logs
            __props__.__dict__["enabled_metrics"] = enabled_metrics
            __props__.__dict__["eventhub_authorization_rule_id"] = eventhub_authorization_rule_id
            __props__.__dict__["eventhub_name"] = eventhub_name
            __props__.__dict__["log_analytics_destination_type"] = log_analytics_destination_type
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["metrics"] = metrics
            __props__.__dict__["name"] = name
            __props__.__dict__["partner_solution_id"] = partner_solution_id
            __props__.__dict__["storage_account_id"] = storage_account_id
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
        super(DiagnosticSetting, __self__).__init__(
            'azure:monitoring/diagnosticSetting:DiagnosticSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled_logs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledLogArgs', 'DiagnosticSettingEnabledLogArgsDict']]]]] = None,
            enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledMetricArgs', 'DiagnosticSettingEnabledMetricArgsDict']]]]] = None,
            eventhub_authorization_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
            log_analytics_destination_type: Optional[pulumi.Input[_builtins.str]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingMetricArgs', 'DiagnosticSettingMetricArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partner_solution_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DiagnosticSetting':
        """
        Get an existing DiagnosticSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledLogArgs', 'DiagnosticSettingEnabledLogArgsDict']]]] enabled_logs: One or more `enabled_log` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified. At least one type of Log or Metric must be enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiagnosticSettingEnabledMetricArgs', 'DiagnosticSettingEnabledMetricArgsDict']]]] enabled_metrics: One or more `enabled_metric` blocks as defined below.
               
               > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified.
        :param pulumi.Input[_builtins.str] eventhub_authorization_rule_id: Specifies the ID of an Event Hub Namespace Authorization Rule used to send Diagnostics Data. 
               
               > **NOTE:** This can be sourced from the `eventhub.EventHubNamespaceAuthorizationRule` resource and is different from a `eventhub.AuthorizationRule` resource.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] eventhub_name: Specifies the name of the Event Hub where Diagnostics Data should be sent.
               
               > **NOTE:** If this isn't specified then the default Event Hub will be used.
        :param pulumi.Input[_builtins.str] log_analytics_destination_type: Possible values are `AzureDiagnostics` and `Dedicated`. When set to `Dedicated`, logs sent to a Log Analytics workspace will go into resource specific tables, instead of the legacy `AzureDiagnostics` table.
               
               > **NOTE:** This setting will only have an effect if a `log_analytics_workspace_id` is provided. For some target resource type (e.g., Key Vault), this field is unconfigurable. Please see [resource types](https://learn.microsoft.com/en-us/azure/azure-monitor/reference/tables/azurediagnostics#resource-types) for services that use each method. Please [see the documentation](https://docs.microsoft.com/azure/azure-monitor/platform/diagnostic-logs-stream-log-store#azure-diagnostics-vs-resource-specific) for details on the differences between destination types.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of a Log Analytics Workspace where Diagnostics Data should be sent.
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Diagnostic Setting. Changing this forces a new resource to be created.
               
               > **NOTE:** If the name is set to 'service' it will not be possible to fully delete the diagnostic setting. This is due to legacy API support.
        :param pulumi.Input[_builtins.str] partner_solution_id: The ID of the market partner solution where Diagnostics Data should be sent. For potential partner integrations, [click to learn more about partner integration](https://learn.microsoft.com/en-us/azure/partner-solutions/overview).
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where logs should be sent. 
               
               > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of an existing Resource on which to configure Diagnostic Settings. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiagnosticSettingState.__new__(_DiagnosticSettingState)

        __props__.__dict__["enabled_logs"] = enabled_logs
        __props__.__dict__["enabled_metrics"] = enabled_metrics
        __props__.__dict__["eventhub_authorization_rule_id"] = eventhub_authorization_rule_id
        __props__.__dict__["eventhub_name"] = eventhub_name
        __props__.__dict__["log_analytics_destination_type"] = log_analytics_destination_type
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["name"] = name
        __props__.__dict__["partner_solution_id"] = partner_solution_id
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["target_resource_id"] = target_resource_id
        return DiagnosticSetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enabledLogs")
    def enabled_logs(self) -> pulumi.Output[Optional[Sequence['outputs.DiagnosticSettingEnabledLog']]]:
        """
        One or more `enabled_log` blocks as defined below.

        > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified. At least one type of Log or Metric must be enabled.
        """
        return pulumi.get(self, "enabled_logs")

    @_builtins.property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> pulumi.Output[Sequence['outputs.DiagnosticSettingEnabledMetric']]:
        """
        One or more `enabled_metric` blocks as defined below.

        > **Note:** At least one `enabled_log` or `enabled_metric` block must be specified.
        """
        return pulumi.get(self, "enabled_metrics")

    @_builtins.property
    @pulumi.getter(name="eventhubAuthorizationRuleId")
    def eventhub_authorization_rule_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of an Event Hub Namespace Authorization Rule used to send Diagnostics Data. 

        > **NOTE:** This can be sourced from the `eventhub.EventHubNamespaceAuthorizationRule` resource and is different from a `eventhub.AuthorizationRule` resource.

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "eventhub_authorization_rule_id")

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the Event Hub where Diagnostics Data should be sent.

        > **NOTE:** If this isn't specified then the default Event Hub will be used.
        """
        return pulumi.get(self, "eventhub_name")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsDestinationType")
    def log_analytics_destination_type(self) -> pulumi.Output[_builtins.str]:
        """
        Possible values are `AzureDiagnostics` and `Dedicated`. When set to `Dedicated`, logs sent to a Log Analytics workspace will go into resource specific tables, instead of the legacy `AzureDiagnostics` table.

        > **NOTE:** This setting will only have an effect if a `log_analytics_workspace_id` is provided. For some target resource type (e.g., Key Vault), this field is unconfigurable. Please see [resource types](https://learn.microsoft.com/en-us/azure/azure-monitor/reference/tables/azurediagnostics#resource-types) for services that use each method. Please [see the documentation](https://docs.microsoft.com/azure/azure-monitor/platform/diagnostic-logs-stream-log-store#azure-diagnostics-vs-resource-specific) for details on the differences between destination types.
        """
        return pulumi.get(self, "log_analytics_destination_type")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of a Log Analytics Workspace where Diagnostics Data should be sent.

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""`metric` has been deprecated in favor of the `enabled_metric` property and will be removed in v5.0 of the AzureRM provider""")
    def metrics(self) -> pulumi.Output[Sequence['outputs.DiagnosticSettingMetric']]:
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Diagnostic Setting. Changing this forces a new resource to be created.

        > **NOTE:** If the name is set to 'service' it will not be possible to fully delete the diagnostic setting. This is due to legacy API support.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partnerSolutionId")
    def partner_solution_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the market partner solution where Diagnostics Data should be sent. For potential partner integrations, [click to learn more about partner integration](https://learn.microsoft.com/en-us/azure/partner-solutions/overview).

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "partner_solution_id")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Storage Account where logs should be sent. 

        > **NOTE:** At least one of `eventhub_authorization_rule_id`, `log_analytics_workspace_id`, `partner_solution_id` and `storage_account_id` must be specified.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of an existing Resource on which to configure Diagnostic Settings. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

