# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduledQueryRulesLogResult',
    'AwaitableGetScheduledQueryRulesLogResult',
    'get_scheduled_query_rules_log',
    'get_scheduled_query_rules_log_output',
]

@pulumi.output_type
class GetScheduledQueryRulesLogResult:
    """
    A collection of values returned by getScheduledQueryRulesLog.
    """
    def __init__(__self__, authorized_resource_ids=None, criterias=None, data_source_id=None, description=None, enabled=None, id=None, location=None, name=None, resource_group_name=None, tags=None):
        if authorized_resource_ids and not isinstance(authorized_resource_ids, list):
            raise TypeError("Expected argument 'authorized_resource_ids' to be a list")
        pulumi.set(__self__, "authorized_resource_ids", authorized_resource_ids)
        if criterias and not isinstance(criterias, list):
            raise TypeError("Expected argument 'criterias' to be a list")
        pulumi.set(__self__, "criterias", criterias)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> Sequence[_builtins.str]:
        """
        A list of IDs of Resources referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Sequence['outputs.GetScheduledQueryRulesLogCriteriaResult']:
        """
        A `criteria` block as defined below.
        """
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> _builtins.str:
        """
        The resource URI over which log search query is to be run.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether this scheduled query rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Specifies the Azure Region where the resource should exist.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetScheduledQueryRulesLogResult(GetScheduledQueryRulesLogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledQueryRulesLogResult(
            authorized_resource_ids=self.authorized_resource_ids,
            criterias=self.criterias,
            data_source_id=self.data_source_id,
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_scheduled_query_rules_log(name: Optional[_builtins.str] = None,
                                  resource_group_name: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledQueryRulesLogResult:
    """
    Use this data source to access the properties of a LogToMetricAction scheduled query rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_scheduled_query_rules_log(resource_group_name="example-rg",
        name="tfex-queryrule")
    pulumi.export("queryRuleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights` - 2018-04-16


    :param _builtins.str name: Specifies the name of the scheduled query rule.
    :param _builtins.str resource_group_name: Specifies the name of the resource group where the scheduled query rule is located.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:monitoring/getScheduledQueryRulesLog:getScheduledQueryRulesLog', __args__, opts=opts, typ=GetScheduledQueryRulesLogResult).value

    return AwaitableGetScheduledQueryRulesLogResult(
        authorized_resource_ids=pulumi.get(__ret__, 'authorized_resource_ids'),
        criterias=pulumi.get(__ret__, 'criterias'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_scheduled_query_rules_log_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                         resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledQueryRulesLogResult]:
    """
    Use this data source to access the properties of a LogToMetricAction scheduled query rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_scheduled_query_rules_log(resource_group_name="example-rg",
        name="tfex-queryrule")
    pulumi.export("queryRuleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights` - 2018-04-16


    :param _builtins.str name: Specifies the name of the scheduled query rule.
    :param _builtins.str resource_group_name: Specifies the name of the resource group where the scheduled query rule is located.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:monitoring/getScheduledQueryRulesLog:getScheduledQueryRulesLog', __args__, opts=opts, typ=GetScheduledQueryRulesLogResult)
    return __ret__.apply(lambda __response__: GetScheduledQueryRulesLogResult(
        authorized_resource_ids=pulumi.get(__response__, 'authorized_resource_ids'),
        criterias=pulumi.get(__response__, 'criterias'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
