# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduledQueryRulesAlertArgs', 'ScheduledQueryRulesAlert']

@pulumi.input_type
class ScheduledQueryRulesAlertArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['ScheduledQueryRulesAlertActionArgs'],
                 data_source_id: pulumi.Input[_builtins.str],
                 frequency: pulumi.Input[_builtins.int],
                 query: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 time_window: pulumi.Input[_builtins.int],
                 trigger: pulumi.Input['ScheduledQueryRulesAlertTriggerArgs'],
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_type: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throttling: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ScheduledQueryRulesAlert resource.
        :param pulumi.Input['ScheduledQueryRulesAlertActionArgs'] action: An `action` block as defined below.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] frequency: Frequency (in minutes) at which rule condition should be evaluated. Values must be between 5 and 1440 (inclusive).
        :param pulumi.Input[_builtins.str] query: Log search query.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] time_window: Time window for which data needs to be fetched for query (must be greater than or equal to `frequency`). Values must be between 5 and 2880 (inclusive).
        :param pulumi.Input['ScheduledQueryRulesAlertTriggerArgs'] trigger: A `trigger` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: List of Resource IDs referred into query.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Should the alerts in this Metric Alert be auto resolved? Defaults to `false`.
               > **Note:** `auto_mitigation_enabled` and `throttling` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_type: The type of query results. Possible values are `ResultCount` and `Number`. Default is `ResultCount`. If set to `ResultCount`, `query` must include an `AggregatedValue` column of a numeric type, for example, `Heartbeat | summarize AggregatedValue = count() by bin(TimeGenerated, 5m)`.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Possible values include: 0, 1, 2, 3, or 4.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] throttling: Time (in minutes) for which Alerts should be throttled or suppressed. Values must be between 0 and 10000 (inclusive).
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "data_source_id", data_source_id)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "time_window", time_window)
        pulumi.set(__self__, "trigger", trigger)
        if authorized_resource_ids is not None:
            pulumi.set(__self__, "authorized_resource_ids", authorized_resource_ids)
        if auto_mitigation_enabled is not None:
            pulumi.set(__self__, "auto_mitigation_enabled", auto_mitigation_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throttling is not None:
            pulumi.set(__self__, "throttling", throttling)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['ScheduledQueryRulesAlertActionArgs']:
        """
        An `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['ScheduledQueryRulesAlertActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[_builtins.int]:
        """
        Frequency (in minutes) at which rule condition should be evaluated. Values must be between 5 and 1440 (inclusive).
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        Log search query.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Input[_builtins.int]:
        """
        Time window for which data needs to be fetched for query (must be greater than or equal to `frequency`). Values must be between 5 and 2880 (inclusive).
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "time_window", value)

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> pulumi.Input['ScheduledQueryRulesAlertTriggerArgs']:
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input['ScheduledQueryRulesAlertTriggerArgs']):
        pulumi.set(self, "trigger", value)

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Resource IDs referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @authorized_resource_ids.setter
    def authorized_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_resource_ids", value)

    @_builtins.property
    @pulumi.getter(name="autoMitigationEnabled")
    def auto_mitigation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the alerts in this Metric Alert be auto resolved? Defaults to `false`.
        > **Note:** `auto_mitigation_enabled` and `throttling` are mutually exclusive and cannot both be set.
        """
        return pulumi.get(self, "auto_mitigation_enabled")

    @auto_mitigation_enabled.setter
    def auto_mitigation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_mitigation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this scheduled query rule is enabled. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the scheduled query rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of query results. Possible values are `ResultCount` and `Number`. Default is `ResultCount`. If set to `ResultCount`, `query` must include an `AggregatedValue` column of a numeric type, for example, `Heartbeat | summarize AggregatedValue = count() by bin(TimeGenerated, 5m)`.
        """
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_type", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Severity of the alert. Possible values include: 0, 1, 2, 3, or 4.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def throttling(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time (in minutes) for which Alerts should be throttled or suppressed. Values must be between 0 and 10000 (inclusive).
        """
        return pulumi.get(self, "throttling")

    @throttling.setter
    def throttling(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throttling", value)


@pulumi.input_type
class _ScheduledQueryRulesAlertState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['ScheduledQueryRulesAlertActionArgs']] = None,
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 query_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throttling: Optional[pulumi.Input[_builtins.int]] = None,
                 time_window: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger: Optional[pulumi.Input['ScheduledQueryRulesAlertTriggerArgs']] = None):
        """
        Input properties used for looking up and filtering ScheduledQueryRulesAlert resources.
        :param pulumi.Input['ScheduledQueryRulesAlertActionArgs'] action: An `action` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: List of Resource IDs referred into query.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Should the alerts in this Metric Alert be auto resolved? Defaults to `false`.
               > **Note:** `auto_mitigation_enabled` and `throttling` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.int] frequency: Frequency (in minutes) at which rule condition should be evaluated. Values must be between 5 and 1440 (inclusive).
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query: Log search query.
        :param pulumi.Input[_builtins.str] query_type: The type of query results. Possible values are `ResultCount` and `Number`. Default is `ResultCount`. If set to `ResultCount`, `query` must include an `AggregatedValue` column of a numeric type, for example, `Heartbeat | summarize AggregatedValue = count() by bin(TimeGenerated, 5m)`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Possible values include: 0, 1, 2, 3, or 4.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] throttling: Time (in minutes) for which Alerts should be throttled or suppressed. Values must be between 0 and 10000 (inclusive).
        :param pulumi.Input[_builtins.int] time_window: Time window for which data needs to be fetched for query (must be greater than or equal to `frequency`). Values must be between 5 and 2880 (inclusive).
        :param pulumi.Input['ScheduledQueryRulesAlertTriggerArgs'] trigger: A `trigger` block as defined below.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if authorized_resource_ids is not None:
            pulumi.set(__self__, "authorized_resource_ids", authorized_resource_ids)
        if auto_mitigation_enabled is not None:
            pulumi.set(__self__, "auto_mitigation_enabled", auto_mitigation_enabled)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throttling is not None:
            pulumi.set(__self__, "throttling", throttling)
        if time_window is not None:
            pulumi.set(__self__, "time_window", time_window)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['ScheduledQueryRulesAlertActionArgs']]:
        """
        An `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['ScheduledQueryRulesAlertActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Resource IDs referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @authorized_resource_ids.setter
    def authorized_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_resource_ids", value)

    @_builtins.property
    @pulumi.getter(name="autoMitigationEnabled")
    def auto_mitigation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the alerts in this Metric Alert be auto resolved? Defaults to `false`.
        > **Note:** `auto_mitigation_enabled` and `throttling` are mutually exclusive and cannot both be set.
        """
        return pulumi.get(self, "auto_mitigation_enabled")

    @auto_mitigation_enabled.setter
    def auto_mitigation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_mitigation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this scheduled query rule is enabled. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Frequency (in minutes) at which rule condition should be evaluated. Values must be between 5 and 1440 (inclusive).
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the scheduled query rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log search query.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of query results. Possible values are `ResultCount` and `Number`. Default is `ResultCount`. If set to `ResultCount`, `query` must include an `AggregatedValue` column of a numeric type, for example, `Heartbeat | summarize AggregatedValue = count() by bin(TimeGenerated, 5m)`.
        """
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Severity of the alert. Possible values include: 0, 1, 2, 3, or 4.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def throttling(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time (in minutes) for which Alerts should be throttled or suppressed. Values must be between 0 and 10000 (inclusive).
        """
        return pulumi.get(self, "throttling")

    @throttling.setter
    def throttling(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throttling", value)

    @_builtins.property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time window for which data needs to be fetched for query (must be greater than or equal to `frequency`). Values must be between 5 and 2880 (inclusive).
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_window", value)

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['ScheduledQueryRulesAlertTriggerArgs']]:
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['ScheduledQueryRulesAlertTriggerArgs']]):
        pulumi.set(self, "trigger", value)


@pulumi.type_token("azure:monitoring/scheduledQueryRulesAlert:ScheduledQueryRulesAlert")
class ScheduledQueryRulesAlert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertActionArgs', 'ScheduledQueryRulesAlertActionArgsDict']]] = None,
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 query_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throttling: Optional[pulumi.Input[_builtins.int]] = None,
                 time_window: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertTriggerArgs', 'ScheduledQueryRulesAlertTriggerArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AlertingAction Scheduled Query Rules resource within Azure Monitor.

        > **Note:** This resource is using an older AzureRM API version which is known to cause problems e.g. with custom webhook properties not included in triggered alerts. This resource is superseded by the monitoring.ScheduledQueryRulesAlertV2 resource using newer API versions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="monitoring-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example2 = azure.appinsights.Insights("example2",
            name="appinsights2",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        # Example: Alerting Action with result count trigger
        example_scheduled_query_rules_alert = azure.monitoring.ScheduledQueryRulesAlert("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            action={
                "action_groups": [],
                "email_subject": "Email Header",
                "custom_webhook_payload": "{}",
            },
            data_source_id=example_insights.id,
            description="Alert when total results cross threshold",
            enabled=True,
            query=\"\"\"requests
          | where tolong(resultCode) >= 500
          | summarize count() by bin(timestamp, 5m)
        \"\"\",
            severity=1,
            frequency=5,
            time_window=30,
            trigger={
                "operator": "GreaterThan",
                "threshold": 3,
            },
            tags={
                "foo": "bar",
            })
        # Example: Alerting Action Cross-Resource
        example2_scheduled_query_rules_alert = azure.monitoring.ScheduledQueryRulesAlert("example2",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            authorized_resource_ids=[example2.id],
            action={
                "action_groups": [],
                "email_subject": "Email Header",
                "custom_webhook_payload": "{}",
            },
            data_source_id=example_insights.id,
            description="Query may access data within multiple resources",
            enabled=True,
            query=std.format(input=\"\"\"let a=requests
          | where toint(resultCode) >= 500
          | extend fail=1; let b=app('%s').requests
          | where toint(resultCode) >= 500 | extend fail=1; a
          | join b on fail
        \"\"\",
                args=[example2.id]).result,
            severity=1,
            frequency=5,
            time_window=30,
            trigger={
                "operator": "GreaterThan",
                "threshold": 3,
            },
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2018-04-16

        ## Import

        Scheduled Query Rule Alerts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/scheduledQueryRulesAlert:ScheduledQueryRulesAlert example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/scheduledQueryRules/myrulename
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduledQueryRulesAlertActionArgs', 'ScheduledQueryRulesAlertActionArgsDict']] action: An `action` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: List of Resource IDs referred into query.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Should the alerts in this Metric Alert be auto resolved? Defaults to `false`.
               > **Note:** `auto_mitigation_enabled` and `throttling` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.int] frequency: Frequency (in minutes) at which rule condition should be evaluated. Values must be between 5 and 1440 (inclusive).
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query: Log search query.
        :param pulumi.Input[_builtins.str] query_type: The type of query results. Possible values are `ResultCount` and `Number`. Default is `ResultCount`. If set to `ResultCount`, `query` must include an `AggregatedValue` column of a numeric type, for example, `Heartbeat | summarize AggregatedValue = count() by bin(TimeGenerated, 5m)`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Possible values include: 0, 1, 2, 3, or 4.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] throttling: Time (in minutes) for which Alerts should be throttled or suppressed. Values must be between 0 and 10000 (inclusive).
        :param pulumi.Input[_builtins.int] time_window: Time window for which data needs to be fetched for query (must be greater than or equal to `frequency`). Values must be between 5 and 2880 (inclusive).
        :param pulumi.Input[Union['ScheduledQueryRulesAlertTriggerArgs', 'ScheduledQueryRulesAlertTriggerArgsDict']] trigger: A `trigger` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledQueryRulesAlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AlertingAction Scheduled Query Rules resource within Azure Monitor.

        > **Note:** This resource is using an older AzureRM API version which is known to cause problems e.g. with custom webhook properties not included in triggered alerts. This resource is superseded by the monitoring.ScheduledQueryRulesAlertV2 resource using newer API versions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="monitoring-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example2 = azure.appinsights.Insights("example2",
            name="appinsights2",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        # Example: Alerting Action with result count trigger
        example_scheduled_query_rules_alert = azure.monitoring.ScheduledQueryRulesAlert("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            action={
                "action_groups": [],
                "email_subject": "Email Header",
                "custom_webhook_payload": "{}",
            },
            data_source_id=example_insights.id,
            description="Alert when total results cross threshold",
            enabled=True,
            query=\"\"\"requests
          | where tolong(resultCode) >= 500
          | summarize count() by bin(timestamp, 5m)
        \"\"\",
            severity=1,
            frequency=5,
            time_window=30,
            trigger={
                "operator": "GreaterThan",
                "threshold": 3,
            },
            tags={
                "foo": "bar",
            })
        # Example: Alerting Action Cross-Resource
        example2_scheduled_query_rules_alert = azure.monitoring.ScheduledQueryRulesAlert("example2",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            authorized_resource_ids=[example2.id],
            action={
                "action_groups": [],
                "email_subject": "Email Header",
                "custom_webhook_payload": "{}",
            },
            data_source_id=example_insights.id,
            description="Query may access data within multiple resources",
            enabled=True,
            query=std.format(input=\"\"\"let a=requests
          | where toint(resultCode) >= 500
          | extend fail=1; let b=app('%s').requests
          | where toint(resultCode) >= 500 | extend fail=1; a
          | join b on fail
        \"\"\",
                args=[example2.id]).result,
            severity=1,
            frequency=5,
            time_window=30,
            trigger={
                "operator": "GreaterThan",
                "threshold": 3,
            },
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2018-04-16

        ## Import

        Scheduled Query Rule Alerts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/scheduledQueryRulesAlert:ScheduledQueryRulesAlert example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/scheduledQueryRules/myrulename
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledQueryRulesAlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledQueryRulesAlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertActionArgs', 'ScheduledQueryRulesAlertActionArgsDict']]] = None,
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 query_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throttling: Optional[pulumi.Input[_builtins.int]] = None,
                 time_window: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertTriggerArgs', 'ScheduledQueryRulesAlertTriggerArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledQueryRulesAlertArgs.__new__(ScheduledQueryRulesAlertArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["authorized_resource_ids"] = authorized_resource_ids
            __props__.__dict__["auto_mitigation_enabled"] = auto_mitigation_enabled
            if data_source_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_id'")
            __props__.__dict__["data_source_id"] = data_source_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["query_type"] = query_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["severity"] = severity
            __props__.__dict__["tags"] = tags
            __props__.__dict__["throttling"] = throttling
            if time_window is None and not opts.urn:
                raise TypeError("Missing required property 'time_window'")
            __props__.__dict__["time_window"] = time_window
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
        super(ScheduledQueryRulesAlert, __self__).__init__(
            'azure:monitoring/scheduledQueryRulesAlert:ScheduledQueryRulesAlert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertActionArgs', 'ScheduledQueryRulesAlertActionArgsDict']]] = None,
            authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            frequency: Optional[pulumi.Input[_builtins.int]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            query_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            throttling: Optional[pulumi.Input[_builtins.int]] = None,
            time_window: Optional[pulumi.Input[_builtins.int]] = None,
            trigger: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertTriggerArgs', 'ScheduledQueryRulesAlertTriggerArgsDict']]] = None) -> 'ScheduledQueryRulesAlert':
        """
        Get an existing ScheduledQueryRulesAlert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduledQueryRulesAlertActionArgs', 'ScheduledQueryRulesAlertActionArgsDict']] action: An `action` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: List of Resource IDs referred into query.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Should the alerts in this Metric Alert be auto resolved? Defaults to `false`.
               > **Note:** `auto_mitigation_enabled` and `throttling` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.int] frequency: Frequency (in minutes) at which rule condition should be evaluated. Values must be between 5 and 1440 (inclusive).
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query: Log search query.
        :param pulumi.Input[_builtins.str] query_type: The type of query results. Possible values are `ResultCount` and `Number`. Default is `ResultCount`. If set to `ResultCount`, `query` must include an `AggregatedValue` column of a numeric type, for example, `Heartbeat | summarize AggregatedValue = count() by bin(TimeGenerated, 5m)`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Possible values include: 0, 1, 2, 3, or 4.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] throttling: Time (in minutes) for which Alerts should be throttled or suppressed. Values must be between 0 and 10000 (inclusive).
        :param pulumi.Input[_builtins.int] time_window: Time window for which data needs to be fetched for query (must be greater than or equal to `frequency`). Values must be between 5 and 2880 (inclusive).
        :param pulumi.Input[Union['ScheduledQueryRulesAlertTriggerArgs', 'ScheduledQueryRulesAlertTriggerArgsDict']] trigger: A `trigger` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledQueryRulesAlertState.__new__(_ScheduledQueryRulesAlertState)

        __props__.__dict__["action"] = action
        __props__.__dict__["authorized_resource_ids"] = authorized_resource_ids
        __props__.__dict__["auto_mitigation_enabled"] = auto_mitigation_enabled
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["query_type"] = query_type
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["severity"] = severity
        __props__.__dict__["tags"] = tags
        __props__.__dict__["throttling"] = throttling
        __props__.__dict__["time_window"] = time_window
        __props__.__dict__["trigger"] = trigger
        return ScheduledQueryRulesAlert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.ScheduledQueryRulesAlertAction']:
        """
        An `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Resource IDs referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @_builtins.property
    @pulumi.getter(name="autoMitigationEnabled")
    def auto_mitigation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the alerts in this Metric Alert be auto resolved? Defaults to `false`.
        > **Note:** `auto_mitigation_enabled` and `throttling` are mutually exclusive and cannot both be set.
        """
        return pulumi.get(self, "auto_mitigation_enabled")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this scheduled query rule is enabled. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[_builtins.int]:
        """
        Frequency (in minutes) at which rule condition should be evaluated. Values must be between 5 and 1440 (inclusive).
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the scheduled query rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        Log search query.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of query results. Possible values are `ResultCount` and `Number`. Default is `ResultCount`. If set to `ResultCount`, `query` must include an `AggregatedValue` column of a numeric type, for example, `Heartbeat | summarize AggregatedValue = count() by bin(TimeGenerated, 5m)`.
        """
        return pulumi.get(self, "query_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Severity of the alert. Possible values include: 0, 1, 2, 3, or 4.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def throttling(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time (in minutes) for which Alerts should be throttled or suppressed. Values must be between 0 and 10000 (inclusive).
        """
        return pulumi.get(self, "throttling")

    @_builtins.property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Output[_builtins.int]:
        """
        Time window for which data needs to be fetched for query (must be greater than or equal to `frequency`). Values must be between 5 and 2880 (inclusive).
        """
        return pulumi.get(self, "time_window")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> pulumi.Output['outputs.ScheduledQueryRulesAlertTrigger']:
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "trigger")

