# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseResult',
    'AwaitableGetDatabaseResult',
    'get_database',
    'get_database_output',
]

@pulumi.output_type
class GetDatabaseResult:
    """
    A collection of values returned by getDatabase.
    """
    def __init__(__self__, collation=None, elastic_pool_id=None, enclave_type=None, id=None, identities=None, license_type=None, max_size_gb=None, name=None, read_replica_count=None, read_scale=None, server_id=None, sku_name=None, storage_account_type=None, tags=None, transparent_data_encryption_enabled=None, transparent_data_encryption_key_automatic_rotation_enabled=None, transparent_data_encryption_key_vault_key_id=None, zone_redundant=None):
        if collation and not isinstance(collation, str):
            raise TypeError("Expected argument 'collation' to be a str")
        pulumi.set(__self__, "collation", collation)
        if elastic_pool_id and not isinstance(elastic_pool_id, str):
            raise TypeError("Expected argument 'elastic_pool_id' to be a str")
        pulumi.set(__self__, "elastic_pool_id", elastic_pool_id)
        if enclave_type and not isinstance(enclave_type, str):
            raise TypeError("Expected argument 'enclave_type' to be a str")
        pulumi.set(__self__, "enclave_type", enclave_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if max_size_gb and not isinstance(max_size_gb, int):
            raise TypeError("Expected argument 'max_size_gb' to be a int")
        pulumi.set(__self__, "max_size_gb", max_size_gb)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if read_replica_count and not isinstance(read_replica_count, int):
            raise TypeError("Expected argument 'read_replica_count' to be a int")
        pulumi.set(__self__, "read_replica_count", read_replica_count)
        if read_scale and not isinstance(read_scale, bool):
            raise TypeError("Expected argument 'read_scale' to be a bool")
        pulumi.set(__self__, "read_scale", read_scale)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if storage_account_type and not isinstance(storage_account_type, str):
            raise TypeError("Expected argument 'storage_account_type' to be a str")
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if transparent_data_encryption_enabled and not isinstance(transparent_data_encryption_enabled, bool):
            raise TypeError("Expected argument 'transparent_data_encryption_enabled' to be a bool")
        pulumi.set(__self__, "transparent_data_encryption_enabled", transparent_data_encryption_enabled)
        if transparent_data_encryption_key_automatic_rotation_enabled and not isinstance(transparent_data_encryption_key_automatic_rotation_enabled, bool):
            raise TypeError("Expected argument 'transparent_data_encryption_key_automatic_rotation_enabled' to be a bool")
        pulumi.set(__self__, "transparent_data_encryption_key_automatic_rotation_enabled", transparent_data_encryption_key_automatic_rotation_enabled)
        if transparent_data_encryption_key_vault_key_id and not isinstance(transparent_data_encryption_key_vault_key_id, str):
            raise TypeError("Expected argument 'transparent_data_encryption_key_vault_key_id' to be a str")
        pulumi.set(__self__, "transparent_data_encryption_key_vault_key_id", transparent_data_encryption_key_vault_key_id)
        if zone_redundant and not isinstance(zone_redundant, bool):
            raise TypeError("Expected argument 'zone_redundant' to be a bool")
        pulumi.set(__self__, "zone_redundant", zone_redundant)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> _builtins.str:
        """
        The collation of the database.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> _builtins.str:
        """
        The id of the elastic pool containing this database.
        """
        return pulumi.get(self, "elastic_pool_id")

    @_builtins.property
    @pulumi.getter(name="enclaveType")
    def enclave_type(self) -> _builtins.str:
        """
        The type of enclave being used by the database.
        """
        return pulumi.get(self, "enclave_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetDatabaseIdentityResult']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> _builtins.str:
        """
        The license type to apply for this database.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter(name="maxSizeGb")
    def max_size_gb(self) -> _builtins.int:
        """
        The max size of the database in gigabytes.
        """
        return pulumi.get(self, "max_size_gb")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> _builtins.int:
        """
        The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed.
        """
        return pulumi.get(self, "read_replica_count")

    @_builtins.property
    @pulumi.getter(name="readScale")
    def read_scale(self) -> _builtins.bool:
        """
        If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica.
        """
        return pulumi.get(self, "read_scale")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The name of the SKU of the database.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The storage account type used to store backups for this database.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionEnabled")
    def transparent_data_encryption_enabled(self) -> _builtins.bool:
        """
        Whether or not Transparent Data Encryption is enabled.
        """
        return pulumi.get(self, "transparent_data_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyAutomaticRotationEnabled")
    def transparent_data_encryption_key_automatic_rotation_enabled(self) -> _builtins.bool:
        """
        Whether or not TDE automatically rotates the encryption Key to latest version.
        """
        return pulumi.get(self, "transparent_data_encryption_key_automatic_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> _builtins.str:
        """
        The Key Vault key URI to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> _builtins.bool:
        """
        Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
        """
        return pulumi.get(self, "zone_redundant")


class AwaitableGetDatabaseResult(GetDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseResult(
            collation=self.collation,
            elastic_pool_id=self.elastic_pool_id,
            enclave_type=self.enclave_type,
            id=self.id,
            identities=self.identities,
            license_type=self.license_type,
            max_size_gb=self.max_size_gb,
            name=self.name,
            read_replica_count=self.read_replica_count,
            read_scale=self.read_scale,
            server_id=self.server_id,
            sku_name=self.sku_name,
            storage_account_type=self.storage_account_type,
            tags=self.tags,
            transparent_data_encryption_enabled=self.transparent_data_encryption_enabled,
            transparent_data_encryption_key_automatic_rotation_enabled=self.transparent_data_encryption_key_automatic_rotation_enabled,
            transparent_data_encryption_key_vault_key_id=self.transparent_data_encryption_key_vault_key_id,
            zone_redundant=self.zone_redundant)


def get_database(name: Optional[_builtins.str] = None,
                 server_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseResult:
    """
    Use this data source to access information about an existing SQL database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    example_server = azure.mssql.Server("example",
        name="example",
        resource_group_name=example_resource_group.name,
        location=example_resource_group.location,
        version="12.0",
        administrator_login="4dm1n157r470r",
        administrator_login_password="4-v3ry-53cr37-p455w0rd")
    example = azure.mssql.get_database_output(name="example-mssql-db",
        server_id=example_server.id)
    pulumi.export("databaseId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql` - 2023-08-01-preview


    :param _builtins.str name: The name of the MS SQL Database.
    :param _builtins.str server_id: The id of the MS SQL Server on which to read the database.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mssql/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult).value

    return AwaitableGetDatabaseResult(
        collation=pulumi.get(__ret__, 'collation'),
        elastic_pool_id=pulumi.get(__ret__, 'elastic_pool_id'),
        enclave_type=pulumi.get(__ret__, 'enclave_type'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        license_type=pulumi.get(__ret__, 'license_type'),
        max_size_gb=pulumi.get(__ret__, 'max_size_gb'),
        name=pulumi.get(__ret__, 'name'),
        read_replica_count=pulumi.get(__ret__, 'read_replica_count'),
        read_scale=pulumi.get(__ret__, 'read_scale'),
        server_id=pulumi.get(__ret__, 'server_id'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        storage_account_type=pulumi.get(__ret__, 'storage_account_type'),
        tags=pulumi.get(__ret__, 'tags'),
        transparent_data_encryption_enabled=pulumi.get(__ret__, 'transparent_data_encryption_enabled'),
        transparent_data_encryption_key_automatic_rotation_enabled=pulumi.get(__ret__, 'transparent_data_encryption_key_automatic_rotation_enabled'),
        transparent_data_encryption_key_vault_key_id=pulumi.get(__ret__, 'transparent_data_encryption_key_vault_key_id'),
        zone_redundant=pulumi.get(__ret__, 'zone_redundant'))
def get_database_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                        server_id: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseResult]:
    """
    Use this data source to access information about an existing SQL database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    example_server = azure.mssql.Server("example",
        name="example",
        resource_group_name=example_resource_group.name,
        location=example_resource_group.location,
        version="12.0",
        administrator_login="4dm1n157r470r",
        administrator_login_password="4-v3ry-53cr37-p455w0rd")
    example = azure.mssql.get_database_output(name="example-mssql-db",
        server_id=example_server.id)
    pulumi.export("databaseId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql` - 2023-08-01-preview


    :param _builtins.str name: The name of the MS SQL Database.
    :param _builtins.str server_id: The id of the MS SQL Server on which to read the database.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mssql/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult)
    return __ret__.apply(lambda __response__: GetDatabaseResult(
        collation=pulumi.get(__response__, 'collation'),
        elastic_pool_id=pulumi.get(__response__, 'elastic_pool_id'),
        enclave_type=pulumi.get(__response__, 'enclave_type'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        license_type=pulumi.get(__response__, 'license_type'),
        max_size_gb=pulumi.get(__response__, 'max_size_gb'),
        name=pulumi.get(__response__, 'name'),
        read_replica_count=pulumi.get(__response__, 'read_replica_count'),
        read_scale=pulumi.get(__response__, 'read_scale'),
        server_id=pulumi.get(__response__, 'server_id'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        storage_account_type=pulumi.get(__response__, 'storage_account_type'),
        tags=pulumi.get(__response__, 'tags'),
        transparent_data_encryption_enabled=pulumi.get(__response__, 'transparent_data_encryption_enabled'),
        transparent_data_encryption_key_automatic_rotation_enabled=pulumi.get(__response__, 'transparent_data_encryption_key_automatic_rotation_enabled'),
        transparent_data_encryption_key_vault_key_id=pulumi.get(__response__, 'transparent_data_encryption_key_vault_key_id'),
        zone_redundant=pulumi.get(__response__, 'zone_redundant')))
