# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerTransparentDataEncryptionArgs', 'ServerTransparentDataEncryption']

@pulumi.input_type
class ServerTransparentDataEncryptionArgs:
    def __init__(__self__, *,
                 server_id: pulumi.Input[_builtins.str],
                 auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServerTransparentDataEncryption resource.
        :param pulumi.Input[_builtins.str] server_id: Specifies the name of the MS SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] auto_rotation_enabled: When enabled, the server will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the server will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[_builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL server must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `server_id` denotes a secondary server deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary server's transparent data encryption. Both primary and secondary servers should be encrypted with same key material.
        """
        pulumi.set(__self__, "server_id", server_id)
        if auto_rotation_enabled is not None:
            pulumi.set(__self__, "auto_rotation_enabled", auto_rotation_enabled)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRotationEnabled")
    def auto_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, the server will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the server will be automatically rotated to the latest key version within 60 minutes.
        """
        return pulumi.get(self, "auto_rotation_enabled")

    @auto_rotation_enabled.setter
    def auto_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.

        > **Note:** In order to use customer managed keys, the identity of the MSSQL server must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'

        > **Note:** If `server_id` denotes a secondary server deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary server's transparent data encryption. Both primary and secondary servers should be encrypted with same key material.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)


@pulumi.input_type
class _ServerTransparentDataEncryptionState:
    def __init__(__self__, *,
                 auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerTransparentDataEncryption resources.
        :param pulumi.Input[_builtins.bool] auto_rotation_enabled: When enabled, the server will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the server will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[_builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL server must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `server_id` denotes a secondary server deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary server's transparent data encryption. Both primary and secondary servers should be encrypted with same key material.
        :param pulumi.Input[_builtins.str] server_id: Specifies the name of the MS SQL Server. Changing this forces a new resource to be created.
        """
        if auto_rotation_enabled is not None:
            pulumi.set(__self__, "auto_rotation_enabled", auto_rotation_enabled)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter(name="autoRotationEnabled")
    def auto_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, the server will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the server will be automatically rotated to the latest key version within 60 minutes.
        """
        return pulumi.get(self, "auto_rotation_enabled")

    @auto_rotation_enabled.setter
    def auto_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.

        > **Note:** In order to use customer managed keys, the identity of the MSSQL server must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'

        > **Note:** If `server_id` denotes a secondary server deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary server's transparent data encryption. Both primary and secondary servers should be encrypted with same key material.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)


@pulumi.type_token("azure:mssql/serverTransparentDataEncryption:ServerTransparentDataEncryption")
class ServerTransparentDataEncryption(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the transparent data encryption configuration for a MSSQL Server

        !> **Note:** This resource can be used to configure Transparent Data Encryption for MS SQL instances with Customer Managed Keys. For MS SQL instances that are System Managed, it should only be used with pre-existing MS SQL Instances that are over 3 years old. For new System Managed MS SQL Instances that will be created through the use of the `mssql.Server` resource, please enable Transparent Data Encryption through `mssql.Server` resource itself by configuring an identity block. By default, all new MS SQL Instances are deployed with System Managed Transparent Data Encryption enabled.

        > **Note:** Once transparent data encryption is enabled on a MS SQL instance, it is not possible to remove TDE. You will be able to switch between 'ServiceManaged' and 'CustomerManaged' keys, but will not be able to remove encryption. For safety when this resource is deleted, the TDE mode will automatically be set to 'ServiceManaged'. See `key_vault_uri` for more information on how to specify the key types. As SQL Server only supports a single configuration for encryption settings, this resource will replace the current encryption settings on the server.

        > **Note:** See [documentation](https://docs.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview) for important information on how handle lifecycle management of the keys to prevent data lockout.

        ## Example Usage

        ### With Service Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_server = azure.mssql.Server("example",
            name="mssqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="thisIsKat11",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": "AzureAD Admin",
                "object_id": "00000000-0000-0000-0000-000000000000",
            },
            tags={
                "environment": "production",
            })
        example_server_transparent_data_encryption = azure.mssql.ServerTransparentDataEncryption("example", server_id=example_server.id)
        ```

        ### With Customer Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_server = azure.mssql.Server("example",
            name="mssqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="thisIsKat11",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": "AzureAD Admin",
                "object_id": "00000000-0000-0000-0000-000000000000",
            },
            tags={
                "environment": "production",
            },
            identity={
                "type": "SystemAssigned",
            })
        # Create a key vault with policies for the deployer to create a key & SQL Server to wrap/unwrap/get key
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_server.identity.tenant_id,
                    "object_id": example_server.identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="byok",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_server_transparent_data_encryption = azure.mssql.ServerTransparentDataEncryption("example",
            server_id=example_server.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql` - 2023-08-01-preview

        ## Import

        SQL Server Transparent Data Encryption can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:mssql/serverTransparentDataEncryption:ServerTransparentDataEncryption example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/encryptionProtector/current
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_rotation_enabled: When enabled, the server will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the server will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[_builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL server must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `server_id` denotes a secondary server deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary server's transparent data encryption. Both primary and secondary servers should be encrypted with same key material.
        :param pulumi.Input[_builtins.str] server_id: Specifies the name of the MS SQL Server. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerTransparentDataEncryptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the transparent data encryption configuration for a MSSQL Server

        !> **Note:** This resource can be used to configure Transparent Data Encryption for MS SQL instances with Customer Managed Keys. For MS SQL instances that are System Managed, it should only be used with pre-existing MS SQL Instances that are over 3 years old. For new System Managed MS SQL Instances that will be created through the use of the `mssql.Server` resource, please enable Transparent Data Encryption through `mssql.Server` resource itself by configuring an identity block. By default, all new MS SQL Instances are deployed with System Managed Transparent Data Encryption enabled.

        > **Note:** Once transparent data encryption is enabled on a MS SQL instance, it is not possible to remove TDE. You will be able to switch between 'ServiceManaged' and 'CustomerManaged' keys, but will not be able to remove encryption. For safety when this resource is deleted, the TDE mode will automatically be set to 'ServiceManaged'. See `key_vault_uri` for more information on how to specify the key types. As SQL Server only supports a single configuration for encryption settings, this resource will replace the current encryption settings on the server.

        > **Note:** See [documentation](https://docs.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview) for important information on how handle lifecycle management of the keys to prevent data lockout.

        ## Example Usage

        ### With Service Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_server = azure.mssql.Server("example",
            name="mssqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="thisIsKat11",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": "AzureAD Admin",
                "object_id": "00000000-0000-0000-0000-000000000000",
            },
            tags={
                "environment": "production",
            })
        example_server_transparent_data_encryption = azure.mssql.ServerTransparentDataEncryption("example", server_id=example_server.id)
        ```

        ### With Customer Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_server = azure.mssql.Server("example",
            name="mssqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="thisIsKat11",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": "AzureAD Admin",
                "object_id": "00000000-0000-0000-0000-000000000000",
            },
            tags={
                "environment": "production",
            },
            identity={
                "type": "SystemAssigned",
            })
        # Create a key vault with policies for the deployer to create a key & SQL Server to wrap/unwrap/get key
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_server.identity.tenant_id,
                    "object_id": example_server.identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="byok",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_server_transparent_data_encryption = azure.mssql.ServerTransparentDataEncryption("example",
            server_id=example_server.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql` - 2023-08-01-preview

        ## Import

        SQL Server Transparent Data Encryption can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:mssql/serverTransparentDataEncryption:ServerTransparentDataEncryption example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/encryptionProtector/current
        ```

        :param str resource_name: The name of the resource.
        :param ServerTransparentDataEncryptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerTransparentDataEncryptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerTransparentDataEncryptionArgs.__new__(ServerTransparentDataEncryptionArgs)

            __props__.__dict__["auto_rotation_enabled"] = auto_rotation_enabled
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
            __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
        super(ServerTransparentDataEncryption, __self__).__init__(
            'azure:mssql/serverTransparentDataEncryption:ServerTransparentDataEncryption',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerTransparentDataEncryption':
        """
        Get an existing ServerTransparentDataEncryption resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_rotation_enabled: When enabled, the server will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the server will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[_builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL server must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `server_id` denotes a secondary server deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary server's transparent data encryption. Both primary and secondary servers should be encrypted with same key material.
        :param pulumi.Input[_builtins.str] server_id: Specifies the name of the MS SQL Server. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerTransparentDataEncryptionState.__new__(_ServerTransparentDataEncryptionState)

        __props__.__dict__["auto_rotation_enabled"] = auto_rotation_enabled
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
        __props__.__dict__["server_id"] = server_id
        return ServerTransparentDataEncryption(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRotationEnabled")
    def auto_rotation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When enabled, the server will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the server will be automatically rotated to the latest key version within 60 minutes.
        """
        return pulumi.get(self, "auto_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.

        > **Note:** In order to use customer managed keys, the identity of the MSSQL server must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'

        > **Note:** If `server_id` denotes a secondary server deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary server's transparent data encryption. Both primary and secondary servers should be encrypted with same key material.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

