# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineAvailabilityGroupListenerArgs', 'VirtualMachineAvailabilityGroupListener']

@pulumi.input_type
class VirtualMachineAvailabilityGroupListenerArgs:
    def __init__(__self__, *,
                 replicas: pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]],
                 sql_virtual_machine_group_id: pulumi.Input[_builtins.str],
                 availability_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_configuration: Optional[pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs']] = None,
                 multi_subnet_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a VirtualMachineAvailabilityGroupListener resource.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]] replicas: One or more `replica` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sql_virtual_machine_group_id: The ID of the SQL Virtual Machine Group to create the listener. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] availability_group_name: The name of the Availability Group. Changing this forces a new resource to be created.
        :param pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs'] load_balancer_configuration: A `load_balancer_configuration` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Either one of `load_balancer_configuration` or `multi_subnet_ip_configuration` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]] multi_subnet_ip_configurations: One or more `multi_subnet_ip_configuration` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Availability Group Listener. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] port: The port of the listener. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "sql_virtual_machine_group_id", sql_virtual_machine_group_id)
        if availability_group_name is not None:
            pulumi.set(__self__, "availability_group_name", availability_group_name)
        if load_balancer_configuration is not None:
            pulumi.set(__self__, "load_balancer_configuration", load_balancer_configuration)
        if multi_subnet_ip_configurations is not None:
            pulumi.set(__self__, "multi_subnet_ip_configurations", multi_subnet_ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]]:
        """
        One or more `replica` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="sqlVirtualMachineGroupId")
    def sql_virtual_machine_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the SQL Virtual Machine Group to create the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_group_id")

    @sql_virtual_machine_group_id.setter
    def sql_virtual_machine_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sql_virtual_machine_group_id", value)

    @_builtins.property
    @pulumi.getter(name="availabilityGroupName")
    def availability_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Availability Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "availability_group_name")

    @availability_group_name.setter
    def availability_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_group_name", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerConfiguration")
    def load_balancer_configuration(self) -> Optional[pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs']]:
        """
        A `load_balancer_configuration` block as defined below. Changing this forces a new resource to be created.

        > **Note:** Either one of `load_balancer_configuration` or `multi_subnet_ip_configuration` must be specified.
        """
        return pulumi.get(self, "load_balancer_configuration")

    @load_balancer_configuration.setter
    def load_balancer_configuration(self, value: Optional[pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs']]):
        pulumi.set(self, "load_balancer_configuration", value)

    @_builtins.property
    @pulumi.getter(name="multiSubnetIpConfigurations")
    def multi_subnet_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]]]:
        """
        One or more `multi_subnet_ip_configuration` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "multi_subnet_ip_configurations")

    @multi_subnet_ip_configurations.setter
    def multi_subnet_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]]]):
        pulumi.set(self, "multi_subnet_ip_configurations", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for the Microsoft SQL Virtual Machine Availability Group Listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class _VirtualMachineAvailabilityGroupListenerState:
    def __init__(__self__, *,
                 availability_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_configuration: Optional[pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs']] = None,
                 multi_subnet_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]]] = None,
                 sql_virtual_machine_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineAvailabilityGroupListener resources.
        :param pulumi.Input[_builtins.str] availability_group_name: The name of the Availability Group. Changing this forces a new resource to be created.
        :param pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs'] load_balancer_configuration: A `load_balancer_configuration` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Either one of `load_balancer_configuration` or `multi_subnet_ip_configuration` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]] multi_subnet_ip_configurations: One or more `multi_subnet_ip_configuration` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Availability Group Listener. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] port: The port of the listener. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]] replicas: One or more `replica` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sql_virtual_machine_group_id: The ID of the SQL Virtual Machine Group to create the listener. Changing this forces a new resource to be created.
        """
        if availability_group_name is not None:
            pulumi.set(__self__, "availability_group_name", availability_group_name)
        if load_balancer_configuration is not None:
            pulumi.set(__self__, "load_balancer_configuration", load_balancer_configuration)
        if multi_subnet_ip_configurations is not None:
            pulumi.set(__self__, "multi_subnet_ip_configurations", multi_subnet_ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if sql_virtual_machine_group_id is not None:
            pulumi.set(__self__, "sql_virtual_machine_group_id", sql_virtual_machine_group_id)

    @_builtins.property
    @pulumi.getter(name="availabilityGroupName")
    def availability_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Availability Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "availability_group_name")

    @availability_group_name.setter
    def availability_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_group_name", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerConfiguration")
    def load_balancer_configuration(self) -> Optional[pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs']]:
        """
        A `load_balancer_configuration` block as defined below. Changing this forces a new resource to be created.

        > **Note:** Either one of `load_balancer_configuration` or `multi_subnet_ip_configuration` must be specified.
        """
        return pulumi.get(self, "load_balancer_configuration")

    @load_balancer_configuration.setter
    def load_balancer_configuration(self, value: Optional[pulumi.Input['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs']]):
        pulumi.set(self, "load_balancer_configuration", value)

    @_builtins.property
    @pulumi.getter(name="multiSubnetIpConfigurations")
    def multi_subnet_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]]]:
        """
        One or more `multi_subnet_ip_configuration` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "multi_subnet_ip_configurations")

    @multi_subnet_ip_configurations.setter
    def multi_subnet_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs']]]]):
        pulumi.set(self, "multi_subnet_ip_configurations", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for the Microsoft SQL Virtual Machine Availability Group Listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]]]:
        """
        One or more `replica` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineAvailabilityGroupListenerReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="sqlVirtualMachineGroupId")
    def sql_virtual_machine_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SQL Virtual Machine Group to create the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_group_id")

    @sql_virtual_machine_group_id.setter
    def sql_virtual_machine_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_virtual_machine_group_id", value)


@pulumi.type_token("azure:mssql/virtualMachineAvailabilityGroupListener:VirtualMachineAvailabilityGroupListener")
class VirtualMachineAvailabilityGroupListener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_configuration: Optional[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict']]] = None,
                 multi_subnet_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerReplicaArgs', 'VirtualMachineAvailabilityGroupListenerReplicaArgsDict']]]]] = None,
                 sql_virtual_machine_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Microsoft SQL Virtual Machine Availability Group Listener.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.network.get_subnet(name="examplesubnet",
            virtual_network_name="examplevnet",
            resource_group_name="example-resources")
        example_get_lb = azure.lb.get_lb(name="example-lb",
            resource_group_name="example-resources")
        example_get_virtual_machine = [azure.compute.get_virtual_machine(name="example-vm",
            resource_group_name="example-resources") for __index in range(2)]
        example_virtual_machine_group = azure.mssql.VirtualMachineGroup("example",
            name="examplegroup",
            resource_group_name="example-resources",
            location="West Europe",
            sql_image_offer="SQL2017-WS2016",
            sql_image_sku="Developer",
            wsfc_domain_profile={
                "fqdn": "testdomain.com",
                "cluster_subnet_type": "SingleSubnet",
            })
        example_virtual_machine = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_virtual_machine.append(azure.mssql.VirtualMachine(f"example-{range['value']}",
                virtual_machine_id=example_get_virtual_machine[range["value"]].id,
                sql_license_type="PAYG",
                sql_virtual_machine_group_id=example_virtual_machine_group.id,
                wsfc_domain_credential={
                    "cluster_bootstrap_account_password": "P@ssw0rd1234!",
                    "cluster_operator_account_password": "P@ssw0rd1234!",
                    "sql_service_account_password": "P@ssw0rd1234!",
                }))
        example_virtual_machine_availability_group_listener = azure.mssql.VirtualMachineAvailabilityGroupListener("example",
            name="listener1",
            availability_group_name="availabilitygroup1",
            port=1433,
            sql_virtual_machine_group_id=example_virtual_machine_group.id,
            load_balancer_configuration={
                "load_balancer_id": example_get_lb.id,
                "private_ip_address": "10.0.2.11",
                "probe_port": 51572,
                "subnet_id": example.id,
                "sql_virtual_machine_ids": [
                    example_virtual_machine[0].id,
                    example_virtual_machine[1].id,
                ],
            },
            replicas=[
                {
                    "sql_virtual_machine_id": example_virtual_machine[0].id,
                    "role": "Primary",
                    "commit": "Synchronous_Commit",
                    "failover": "Automatic",
                    "readable_secondary": "All",
                },
                {
                    "sql_virtual_machine_id": example_virtual_machine[1].id,
                    "role": "Secondary",
                    "commit": "Asynchronous_Commit",
                    "failover": "Manual",
                    "readable_secondary": "No",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SqlVirtualMachine` - 2023-10-01

        ## Import

        Microsoft SQL Virtual Machine Availability Group Listeners can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/virtualMachineAvailabilityGroupListener:VirtualMachineAvailabilityGroupListener example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/vmgroup1/availabilityGroupListeners/listener1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_group_name: The name of the Availability Group. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict']] load_balancer_configuration: A `load_balancer_configuration` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Either one of `load_balancer_configuration` or `multi_subnet_ip_configuration` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict']]]] multi_subnet_ip_configurations: One or more `multi_subnet_ip_configuration` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Availability Group Listener. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] port: The port of the listener. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerReplicaArgs', 'VirtualMachineAvailabilityGroupListenerReplicaArgsDict']]]] replicas: One or more `replica` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sql_virtual_machine_group_id: The ID of the SQL Virtual Machine Group to create the listener. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineAvailabilityGroupListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Microsoft SQL Virtual Machine Availability Group Listener.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.network.get_subnet(name="examplesubnet",
            virtual_network_name="examplevnet",
            resource_group_name="example-resources")
        example_get_lb = azure.lb.get_lb(name="example-lb",
            resource_group_name="example-resources")
        example_get_virtual_machine = [azure.compute.get_virtual_machine(name="example-vm",
            resource_group_name="example-resources") for __index in range(2)]
        example_virtual_machine_group = azure.mssql.VirtualMachineGroup("example",
            name="examplegroup",
            resource_group_name="example-resources",
            location="West Europe",
            sql_image_offer="SQL2017-WS2016",
            sql_image_sku="Developer",
            wsfc_domain_profile={
                "fqdn": "testdomain.com",
                "cluster_subnet_type": "SingleSubnet",
            })
        example_virtual_machine = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_virtual_machine.append(azure.mssql.VirtualMachine(f"example-{range['value']}",
                virtual_machine_id=example_get_virtual_machine[range["value"]].id,
                sql_license_type="PAYG",
                sql_virtual_machine_group_id=example_virtual_machine_group.id,
                wsfc_domain_credential={
                    "cluster_bootstrap_account_password": "P@ssw0rd1234!",
                    "cluster_operator_account_password": "P@ssw0rd1234!",
                    "sql_service_account_password": "P@ssw0rd1234!",
                }))
        example_virtual_machine_availability_group_listener = azure.mssql.VirtualMachineAvailabilityGroupListener("example",
            name="listener1",
            availability_group_name="availabilitygroup1",
            port=1433,
            sql_virtual_machine_group_id=example_virtual_machine_group.id,
            load_balancer_configuration={
                "load_balancer_id": example_get_lb.id,
                "private_ip_address": "10.0.2.11",
                "probe_port": 51572,
                "subnet_id": example.id,
                "sql_virtual_machine_ids": [
                    example_virtual_machine[0].id,
                    example_virtual_machine[1].id,
                ],
            },
            replicas=[
                {
                    "sql_virtual_machine_id": example_virtual_machine[0].id,
                    "role": "Primary",
                    "commit": "Synchronous_Commit",
                    "failover": "Automatic",
                    "readable_secondary": "All",
                },
                {
                    "sql_virtual_machine_id": example_virtual_machine[1].id,
                    "role": "Secondary",
                    "commit": "Asynchronous_Commit",
                    "failover": "Manual",
                    "readable_secondary": "No",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SqlVirtualMachine` - 2023-10-01

        ## Import

        Microsoft SQL Virtual Machine Availability Group Listeners can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/virtualMachineAvailabilityGroupListener:VirtualMachineAvailabilityGroupListener example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/vmgroup1/availabilityGroupListeners/listener1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineAvailabilityGroupListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineAvailabilityGroupListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_configuration: Optional[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict']]] = None,
                 multi_subnet_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerReplicaArgs', 'VirtualMachineAvailabilityGroupListenerReplicaArgsDict']]]]] = None,
                 sql_virtual_machine_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineAvailabilityGroupListenerArgs.__new__(VirtualMachineAvailabilityGroupListenerArgs)

            __props__.__dict__["availability_group_name"] = availability_group_name
            __props__.__dict__["load_balancer_configuration"] = load_balancer_configuration
            __props__.__dict__["multi_subnet_ip_configurations"] = multi_subnet_ip_configurations
            __props__.__dict__["name"] = name
            __props__.__dict__["port"] = port
            if replicas is None and not opts.urn:
                raise TypeError("Missing required property 'replicas'")
            __props__.__dict__["replicas"] = replicas
            if sql_virtual_machine_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'sql_virtual_machine_group_id'")
            __props__.__dict__["sql_virtual_machine_group_id"] = sql_virtual_machine_group_id
        super(VirtualMachineAvailabilityGroupListener, __self__).__init__(
            'azure:mssql/virtualMachineAvailabilityGroupListener:VirtualMachineAvailabilityGroupListener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_configuration: Optional[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict']]] = None,
            multi_subnet_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerReplicaArgs', 'VirtualMachineAvailabilityGroupListenerReplicaArgsDict']]]]] = None,
            sql_virtual_machine_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualMachineAvailabilityGroupListener':
        """
        Get an existing VirtualMachineAvailabilityGroupListener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_group_name: The name of the Availability Group. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict']] load_balancer_configuration: A `load_balancer_configuration` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Either one of `load_balancer_configuration` or `multi_subnet_ip_configuration` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs', 'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict']]]] multi_subnet_ip_configurations: One or more `multi_subnet_ip_configuration` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Availability Group Listener. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] port: The port of the listener. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineAvailabilityGroupListenerReplicaArgs', 'VirtualMachineAvailabilityGroupListenerReplicaArgsDict']]]] replicas: One or more `replica` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sql_virtual_machine_group_id: The ID of the SQL Virtual Machine Group to create the listener. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineAvailabilityGroupListenerState.__new__(_VirtualMachineAvailabilityGroupListenerState)

        __props__.__dict__["availability_group_name"] = availability_group_name
        __props__.__dict__["load_balancer_configuration"] = load_balancer_configuration
        __props__.__dict__["multi_subnet_ip_configurations"] = multi_subnet_ip_configurations
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["sql_virtual_machine_group_id"] = sql_virtual_machine_group_id
        return VirtualMachineAvailabilityGroupListener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityGroupName")
    def availability_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Availability Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "availability_group_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerConfiguration")
    def load_balancer_configuration(self) -> pulumi.Output[Optional['outputs.VirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration']]:
        """
        A `load_balancer_configuration` block as defined below. Changing this forces a new resource to be created.

        > **Note:** Either one of `load_balancer_configuration` or `multi_subnet_ip_configuration` must be specified.
        """
        return pulumi.get(self, "load_balancer_configuration")

    @_builtins.property
    @pulumi.getter(name="multiSubnetIpConfigurations")
    def multi_subnet_ip_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration']]]:
        """
        One or more `multi_subnet_ip_configuration` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "multi_subnet_ip_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for the Microsoft SQL Virtual Machine Availability Group Listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Sequence['outputs.VirtualMachineAvailabilityGroupListenerReplica']]:
        """
        One or more `replica` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="sqlVirtualMachineGroupId")
    def sql_virtual_machine_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the SQL Virtual Machine Group to create the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_group_id")

