# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSnapshotResult',
    'AwaitableGetSnapshotResult',
    'get_snapshot',
    'get_snapshot_output',
]

@pulumi.output_type
class GetSnapshotResult:
    """
    A collection of values returned by getSnapshot.
    """
    def __init__(__self__, account_name=None, id=None, location=None, name=None, pool_name=None, resource_group_name=None, volume_name=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pool_name and not isinstance(pool_name, str):
            raise TypeError("Expected argument 'pool_name' to be a str")
        pulumi.set(__self__, "pool_name", pool_name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if volume_name and not isinstance(volume_name, str):
            raise TypeError("Expected argument 'volume_name' to be a str")
        pulumi.set(__self__, "volume_name", volume_name)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the NetApp Snapshot exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> _builtins.str:
        return pulumi.get(self, "pool_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> _builtins.str:
        return pulumi.get(self, "volume_name")


class AwaitableGetSnapshotResult(GetSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotResult(
            account_name=self.account_name,
            id=self.id,
            location=self.location,
            name=self.name,
            pool_name=self.pool_name,
            resource_group_name=self.resource_group_name,
            volume_name=self.volume_name)


def get_snapshot(account_name: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 pool_name: Optional[_builtins.str] = None,
                 resource_group_name: Optional[_builtins.str] = None,
                 volume_name: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotResult:
    """
    Uses this data source to access information about an existing NetApp Snapshot.

    ## NetApp Snapshot Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.netapp.get_snapshot(resource_group_name="acctestRG",
        name="acctestnetappsnapshot",
        account_name="acctestnetappaccount",
        pool_name="acctestnetapppool",
        volume_name="acctestnetappvolume")
    pulumi.export("netappSnapshotId", example["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp` - 2025-06-01


    :param _builtins.str account_name: The name of the NetApp Account where the NetApp Pool exists.
    :param _builtins.str name: The name of the NetApp Snapshot.
    :param _builtins.str pool_name: The name of the NetApp Pool where the NetApp Volume exists.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the NetApp Snapshot exists.
    :param _builtins.str volume_name: The name of the NetApp Volume where the NetApp Snapshot exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['poolName'] = pool_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['volumeName'] = volume_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:netapp/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult).value

    return AwaitableGetSnapshotResult(
        account_name=pulumi.get(__ret__, 'account_name'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        pool_name=pulumi.get(__ret__, 'pool_name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        volume_name=pulumi.get(__ret__, 'volume_name'))
def get_snapshot_output(account_name: Optional[pulumi.Input[_builtins.str]] = None,
                        name: Optional[pulumi.Input[_builtins.str]] = None,
                        pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                        resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                        volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSnapshotResult]:
    """
    Uses this data source to access information about an existing NetApp Snapshot.

    ## NetApp Snapshot Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.netapp.get_snapshot(resource_group_name="acctestRG",
        name="acctestnetappsnapshot",
        account_name="acctestnetappaccount",
        pool_name="acctestnetapppool",
        volume_name="acctestnetappvolume")
    pulumi.export("netappSnapshotId", example["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp` - 2025-06-01


    :param _builtins.str account_name: The name of the NetApp Account where the NetApp Pool exists.
    :param _builtins.str name: The name of the NetApp Snapshot.
    :param _builtins.str pool_name: The name of the NetApp Pool where the NetApp Volume exists.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the NetApp Snapshot exists.
    :param _builtins.str volume_name: The name of the NetApp Volume where the NetApp Snapshot exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['poolName'] = pool_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['volumeName'] = volume_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:netapp/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult)
    return __ret__.apply(lambda __response__: GetSnapshotResult(
        account_name=pulumi.get(__response__, 'account_name'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        pool_name=pulumi.get(__response__, 'pool_name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        volume_name=pulumi.get(__response__, 'volume_name')))
