# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VolumeQuotaRuleArgs', 'VolumeQuotaRule']

@pulumi.input_type
class VolumeQuotaRuleArgs:
    def __init__(__self__, *,
                 quota_size_in_kib: pulumi.Input[_builtins.int],
                 quota_type: pulumi.Input[_builtins.str],
                 volume_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_target: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeQuotaRule resource.
        :param pulumi.Input[_builtins.int] quota_size_in_kib: Quota size in kibibytes.
        :param pulumi.Input[_builtins.str] quota_type: Quota type. Possible values are `DefaultGroupQuota`, `DefaultUserQuota`, `IndividualGroupQuota` and `IndividualUserQuota`. Please note that `IndividualGroupQuota` and `DefaultGroupQuota` are not applicable to SMB and dual-protocol volumes. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] volume_id: The NetApp volume ID where the Volume Quota Rule is assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Volume Quota Rule should exist. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Volume Quota Rule. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.str] quota_target: Quota Target. This can be Unix UID/GID for NFSv3/NFSv4.1 volumes and Windows User SID for CIFS based volumes. Changing this forces a new resource to be created.
               
               > **Note:** `quota_target ` must be used when `quota_type` is `IndividualGroupQuota` or `IndividualUserQuota`
               
               > **Note:** more information about this resource can be found at [Understand default and individual user and group quotas](https://learn.microsoft.com/en-us/azure/azure-netapp-files/default-individual-user-group-quotas-introduction)
        """
        pulumi.set(__self__, "quota_size_in_kib", quota_size_in_kib)
        pulumi.set(__self__, "quota_type", quota_type)
        pulumi.set(__self__, "volume_id", volume_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota_target is not None:
            pulumi.set(__self__, "quota_target", quota_target)

    @_builtins.property
    @pulumi.getter(name="quotaSizeInKib")
    def quota_size_in_kib(self) -> pulumi.Input[_builtins.int]:
        """
        Quota size in kibibytes.
        """
        return pulumi.get(self, "quota_size_in_kib")

    @quota_size_in_kib.setter
    def quota_size_in_kib(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "quota_size_in_kib", value)

    @_builtins.property
    @pulumi.getter(name="quotaType")
    def quota_type(self) -> pulumi.Input[_builtins.str]:
        """
        Quota type. Possible values are `DefaultGroupQuota`, `DefaultUserQuota`, `IndividualGroupQuota` and `IndividualUserQuota`. Please note that `IndividualGroupQuota` and `DefaultGroupQuota` are not applicable to SMB and dual-protocol volumes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "quota_type")

    @quota_type.setter
    def quota_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "quota_type", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[_builtins.str]:
        """
        The NetApp volume ID where the Volume Quota Rule is assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Volume Quota Rule should exist. Changing this forces a new Volume Quota Rule to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Volume Quota Rule. Changing this forces a new Volume Quota Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="quotaTarget")
    def quota_target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota Target. This can be Unix UID/GID for NFSv3/NFSv4.1 volumes and Windows User SID for CIFS based volumes. Changing this forces a new resource to be created.

        > **Note:** `quota_target ` must be used when `quota_type` is `IndividualGroupQuota` or `IndividualUserQuota`

        > **Note:** more information about this resource can be found at [Understand default and individual user and group quotas](https://learn.microsoft.com/en-us/azure/azure-netapp-files/default-individual-user-group-quotas-introduction)
        """
        return pulumi.get(self, "quota_target")

    @quota_target.setter
    def quota_target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_target", value)


@pulumi.input_type
class _VolumeQuotaRuleState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_size_in_kib: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_target: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeQuotaRule resources.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Volume Quota Rule should exist. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Volume Quota Rule. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.int] quota_size_in_kib: Quota size in kibibytes.
        :param pulumi.Input[_builtins.str] quota_target: Quota Target. This can be Unix UID/GID for NFSv3/NFSv4.1 volumes and Windows User SID for CIFS based volumes. Changing this forces a new resource to be created.
               
               > **Note:** `quota_target ` must be used when `quota_type` is `IndividualGroupQuota` or `IndividualUserQuota`
               
               > **Note:** more information about this resource can be found at [Understand default and individual user and group quotas](https://learn.microsoft.com/en-us/azure/azure-netapp-files/default-individual-user-group-quotas-introduction)
        :param pulumi.Input[_builtins.str] quota_type: Quota type. Possible values are `DefaultGroupQuota`, `DefaultUserQuota`, `IndividualGroupQuota` and `IndividualUserQuota`. Please note that `IndividualGroupQuota` and `DefaultGroupQuota` are not applicable to SMB and dual-protocol volumes. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] volume_id: The NetApp volume ID where the Volume Quota Rule is assigned to. Changing this forces a new resource to be created.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota_size_in_kib is not None:
            pulumi.set(__self__, "quota_size_in_kib", quota_size_in_kib)
        if quota_target is not None:
            pulumi.set(__self__, "quota_target", quota_target)
        if quota_type is not None:
            pulumi.set(__self__, "quota_type", quota_type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Volume Quota Rule should exist. Changing this forces a new Volume Quota Rule to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Volume Quota Rule. Changing this forces a new Volume Quota Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="quotaSizeInKib")
    def quota_size_in_kib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Quota size in kibibytes.
        """
        return pulumi.get(self, "quota_size_in_kib")

    @quota_size_in_kib.setter
    def quota_size_in_kib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "quota_size_in_kib", value)

    @_builtins.property
    @pulumi.getter(name="quotaTarget")
    def quota_target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota Target. This can be Unix UID/GID for NFSv3/NFSv4.1 volumes and Windows User SID for CIFS based volumes. Changing this forces a new resource to be created.

        > **Note:** `quota_target ` must be used when `quota_type` is `IndividualGroupQuota` or `IndividualUserQuota`

        > **Note:** more information about this resource can be found at [Understand default and individual user and group quotas](https://learn.microsoft.com/en-us/azure/azure-netapp-files/default-individual-user-group-quotas-introduction)
        """
        return pulumi.get(self, "quota_target")

    @quota_target.setter
    def quota_target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_target", value)

    @_builtins.property
    @pulumi.getter(name="quotaType")
    def quota_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota type. Possible values are `DefaultGroupQuota`, `DefaultUserQuota`, `IndividualGroupQuota` and `IndividualUserQuota`. Please note that `IndividualGroupQuota` and `DefaultGroupQuota` are not applicable to SMB and dual-protocol volumes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "quota_type")

    @quota_type.setter
    def quota_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_type", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NetApp volume ID where the Volume Quota Rule is assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.type_token("azure:netapp/volumeQuotaRule:VolumeQuotaRule")
class VolumeQuotaRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_size_in_kib: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_target: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Volume Quota Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtualnetwork",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "netapp",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        example_account = azure.netapp.Account("example",
            name="example-netappaccount",
            location=example.location,
            resource_group_name=example.name)
        example_pool = azure.netapp.Pool("example",
            name="example-netapppool",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            service_level="Premium",
            size_in_tb=4)
        example_volume = azure.netapp.Volume("example",
            name="example-netappvolume",
            location=example.location,
            zone="1",
            resource_group_name=example.name,
            account_name=example_account.name,
            pool_name=example_pool.name,
            volume_path="my-unique-file-path",
            service_level="Premium",
            subnet_id=example_subnet.id,
            network_features="Basic",
            protocols=["NFSv4.1"],
            security_style="unix",
            storage_quota_in_gb=100,
            snapshot_directory_visible=False)
        quota1 = azure.netapp.VolumeQuotaRule("quota1",
            name="example-quota-rule-1",
            location=example.location,
            volume_id=example_volume.id,
            quota_target="3001",
            quota_size_in_kib=1024,
            quota_type="IndividualGroupQuota")
        quota2 = azure.netapp.VolumeQuotaRule("quota2",
            name="example-quota-rule-2",
            location=example.location,
            volume_id=example_volume.id,
            quota_target="2001",
            quota_size_in_kib=1024,
            quota_type="IndividualUserQuota")
        quota3 = azure.netapp.VolumeQuotaRule("quota3",
            name="example-quota-rule-3",
            location=example.location,
            volume_id=example_volume.id,
            quota_size_in_kib=1024,
            quota_type="DefaultUserQuota")
        quota4 = azure.netapp.VolumeQuotaRule("quota4",
            name="example-quota-rule-4",
            location=example.location,
            volume_id=example_volume.id,
            quota_size_in_kib=1024,
            quota_type="DefaultGroupQuota")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp` - 2025-06-01

        ## Import

        Volume Quota Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volumeQuotaRule:VolumeQuotaRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/vol1/volumeQuotaRules/quota1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Volume Quota Rule should exist. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Volume Quota Rule. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.int] quota_size_in_kib: Quota size in kibibytes.
        :param pulumi.Input[_builtins.str] quota_target: Quota Target. This can be Unix UID/GID for NFSv3/NFSv4.1 volumes and Windows User SID for CIFS based volumes. Changing this forces a new resource to be created.
               
               > **Note:** `quota_target ` must be used when `quota_type` is `IndividualGroupQuota` or `IndividualUserQuota`
               
               > **Note:** more information about this resource can be found at [Understand default and individual user and group quotas](https://learn.microsoft.com/en-us/azure/azure-netapp-files/default-individual-user-group-quotas-introduction)
        :param pulumi.Input[_builtins.str] quota_type: Quota type. Possible values are `DefaultGroupQuota`, `DefaultUserQuota`, `IndividualGroupQuota` and `IndividualUserQuota`. Please note that `IndividualGroupQuota` and `DefaultGroupQuota` are not applicable to SMB and dual-protocol volumes. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] volume_id: The NetApp volume ID where the Volume Quota Rule is assigned to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeQuotaRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Volume Quota Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtualnetwork",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "netapp",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        example_account = azure.netapp.Account("example",
            name="example-netappaccount",
            location=example.location,
            resource_group_name=example.name)
        example_pool = azure.netapp.Pool("example",
            name="example-netapppool",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            service_level="Premium",
            size_in_tb=4)
        example_volume = azure.netapp.Volume("example",
            name="example-netappvolume",
            location=example.location,
            zone="1",
            resource_group_name=example.name,
            account_name=example_account.name,
            pool_name=example_pool.name,
            volume_path="my-unique-file-path",
            service_level="Premium",
            subnet_id=example_subnet.id,
            network_features="Basic",
            protocols=["NFSv4.1"],
            security_style="unix",
            storage_quota_in_gb=100,
            snapshot_directory_visible=False)
        quota1 = azure.netapp.VolumeQuotaRule("quota1",
            name="example-quota-rule-1",
            location=example.location,
            volume_id=example_volume.id,
            quota_target="3001",
            quota_size_in_kib=1024,
            quota_type="IndividualGroupQuota")
        quota2 = azure.netapp.VolumeQuotaRule("quota2",
            name="example-quota-rule-2",
            location=example.location,
            volume_id=example_volume.id,
            quota_target="2001",
            quota_size_in_kib=1024,
            quota_type="IndividualUserQuota")
        quota3 = azure.netapp.VolumeQuotaRule("quota3",
            name="example-quota-rule-3",
            location=example.location,
            volume_id=example_volume.id,
            quota_size_in_kib=1024,
            quota_type="DefaultUserQuota")
        quota4 = azure.netapp.VolumeQuotaRule("quota4",
            name="example-quota-rule-4",
            location=example.location,
            volume_id=example_volume.id,
            quota_size_in_kib=1024,
            quota_type="DefaultGroupQuota")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp` - 2025-06-01

        ## Import

        Volume Quota Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volumeQuotaRule:VolumeQuotaRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/vol1/volumeQuotaRules/quota1
        ```

        :param str resource_name: The name of the resource.
        :param VolumeQuotaRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeQuotaRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_size_in_kib: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_target: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeQuotaRuleArgs.__new__(VolumeQuotaRuleArgs)

            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if quota_size_in_kib is None and not opts.urn:
                raise TypeError("Missing required property 'quota_size_in_kib'")
            __props__.__dict__["quota_size_in_kib"] = quota_size_in_kib
            __props__.__dict__["quota_target"] = quota_target
            if quota_type is None and not opts.urn:
                raise TypeError("Missing required property 'quota_type'")
            __props__.__dict__["quota_type"] = quota_type
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
        super(VolumeQuotaRule, __self__).__init__(
            'azure:netapp/volumeQuotaRule:VolumeQuotaRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            quota_size_in_kib: Optional[pulumi.Input[_builtins.int]] = None,
            quota_target: Optional[pulumi.Input[_builtins.str]] = None,
            quota_type: Optional[pulumi.Input[_builtins.str]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeQuotaRule':
        """
        Get an existing VolumeQuotaRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Volume Quota Rule should exist. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Volume Quota Rule. Changing this forces a new Volume Quota Rule to be created.
        :param pulumi.Input[_builtins.int] quota_size_in_kib: Quota size in kibibytes.
        :param pulumi.Input[_builtins.str] quota_target: Quota Target. This can be Unix UID/GID for NFSv3/NFSv4.1 volumes and Windows User SID for CIFS based volumes. Changing this forces a new resource to be created.
               
               > **Note:** `quota_target ` must be used when `quota_type` is `IndividualGroupQuota` or `IndividualUserQuota`
               
               > **Note:** more information about this resource can be found at [Understand default and individual user and group quotas](https://learn.microsoft.com/en-us/azure/azure-netapp-files/default-individual-user-group-quotas-introduction)
        :param pulumi.Input[_builtins.str] quota_type: Quota type. Possible values are `DefaultGroupQuota`, `DefaultUserQuota`, `IndividualGroupQuota` and `IndividualUserQuota`. Please note that `IndividualGroupQuota` and `DefaultGroupQuota` are not applicable to SMB and dual-protocol volumes. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] volume_id: The NetApp volume ID where the Volume Quota Rule is assigned to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeQuotaRuleState.__new__(_VolumeQuotaRuleState)

        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["quota_size_in_kib"] = quota_size_in_kib
        __props__.__dict__["quota_target"] = quota_target
        __props__.__dict__["quota_type"] = quota_type
        __props__.__dict__["volume_id"] = volume_id
        return VolumeQuotaRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Volume Quota Rule should exist. Changing this forces a new Volume Quota Rule to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Volume Quota Rule. Changing this forces a new Volume Quota Rule to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="quotaSizeInKib")
    def quota_size_in_kib(self) -> pulumi.Output[_builtins.int]:
        """
        Quota size in kibibytes.
        """
        return pulumi.get(self, "quota_size_in_kib")

    @_builtins.property
    @pulumi.getter(name="quotaTarget")
    def quota_target(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Quota Target. This can be Unix UID/GID for NFSv3/NFSv4.1 volumes and Windows User SID for CIFS based volumes. Changing this forces a new resource to be created.

        > **Note:** `quota_target ` must be used when `quota_type` is `IndividualGroupQuota` or `IndividualUserQuota`

        > **Note:** more information about this resource can be found at [Understand default and individual user and group quotas](https://learn.microsoft.com/en-us/azure/azure-netapp-files/default-individual-user-group-quotas-introduction)
        """
        return pulumi.get(self, "quota_target")

    @_builtins.property
    @pulumi.getter(name="quotaType")
    def quota_type(self) -> pulumi.Output[_builtins.str]:
        """
        Quota type. Possible values are `DefaultGroupQuota`, `DefaultUserQuota`, `IndividualGroupQuota` and `IndividualUserQuota`. Please note that `IndividualGroupQuota` and `DefaultGroupQuota` are not applicable to SMB and dual-protocol volumes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "quota_type")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        The NetApp volume ID where the Volume Quota Rule is assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_id")

