# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BgpConnectionArgs', 'BgpConnection']

@pulumi.input_type
class BgpConnectionArgs:
    def __init__(__self__, *,
                 peer_asn: pulumi.Input[_builtins.int],
                 peer_ip: pulumi.Input[_builtins.str],
                 virtual_hub_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_connection_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BgpConnection resource.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer IP address for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this Bgp connection should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_connection_id: The ID of virtual network connection.
        """
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_ip", peer_ip)
        pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_network_connection_id is not None:
            pulumi.set(__self__, "virtual_network_connection_id", virtual_network_connection_id)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Input[_builtins.int]:
        """
        The peer autonomous system number for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The peer IP address for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_ip", value)

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Virtual Hub within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

    @virtual_hub_id.setter
    def virtual_hub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_hub_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConnectionId")
    def virtual_network_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of virtual network connection.
        """
        return pulumi.get(self, "virtual_network_connection_id")

    @virtual_network_connection_id.setter
    def virtual_network_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_connection_id", value)


@pulumi.input_type
class _BgpConnectionState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_connection_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BgpConnection resources.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer IP address for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this Bgp connection should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_connection_id: The ID of virtual network connection.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_ip is not None:
            pulumi.set(__self__, "peer_ip", peer_ip)
        if virtual_hub_id is not None:
            pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)
        if virtual_network_connection_id is not None:
            pulumi.set(__self__, "virtual_network_connection_id", virtual_network_connection_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The peer autonomous system number for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The peer IP address for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_ip", value)

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Hub within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

    @virtual_hub_id.setter
    def virtual_hub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_hub_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConnectionId")
    def virtual_network_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of virtual network connection.
        """
        return pulumi.get(self, "virtual_network_connection_id")

    @virtual_network_connection_id.setter
    def virtual_network_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_connection_id", value)


@pulumi.type_token("azure:network/bgpConnection:BgpConnection")
class BgpConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Bgp Connection for a Virtual Hub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard")
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.5.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"])
        example_virtual_hub_ip = azure.network.VirtualHubIp("example",
            name="example-vhubip",
            virtual_hub_id=example_virtual_hub.id,
            private_ip_address="10.5.1.18",
            private_ip_allocation_method="Static",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id)
        example_bgp_connection = azure.network.BgpConnection("example",
            name="example-vhub-bgpconnection",
            virtual_hub_id=example_virtual_hub.id,
            peer_asn=65514,
            peer_ip="169.254.21.5",
            opts = pulumi.ResourceOptions(depends_on=[example_virtual_hub_ip]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Virtual Hub Bgp Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/bgpConnection:BgpConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/virtualHub1/bgpConnections/connection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer IP address for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this Bgp connection should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_connection_id: The ID of virtual network connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BgpConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Bgp Connection for a Virtual Hub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard")
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.5.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"])
        example_virtual_hub_ip = azure.network.VirtualHubIp("example",
            name="example-vhubip",
            virtual_hub_id=example_virtual_hub.id,
            private_ip_address="10.5.1.18",
            private_ip_allocation_method="Static",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id)
        example_bgp_connection = azure.network.BgpConnection("example",
            name="example-vhub-bgpconnection",
            virtual_hub_id=example_virtual_hub.id,
            peer_asn=65514,
            peer_ip="169.254.21.5",
            opts = pulumi.ResourceOptions(depends_on=[example_virtual_hub_ip]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Virtual Hub Bgp Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/bgpConnection:BgpConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/virtualHub1/bgpConnections/connection1
        ```

        :param str resource_name: The name of the resource.
        :param BgpConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BgpConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BgpConnectionArgs.__new__(BgpConnectionArgs)

            __props__.__dict__["name"] = name
            if peer_asn is None and not opts.urn:
                raise TypeError("Missing required property 'peer_asn'")
            __props__.__dict__["peer_asn"] = peer_asn
            if peer_ip is None and not opts.urn:
                raise TypeError("Missing required property 'peer_ip'")
            __props__.__dict__["peer_ip"] = peer_ip
            if virtual_hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_hub_id'")
            __props__.__dict__["virtual_hub_id"] = virtual_hub_id
            __props__.__dict__["virtual_network_connection_id"] = virtual_network_connection_id
        super(BgpConnection, __self__).__init__(
            'azure:network/bgpConnection:BgpConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
            peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_connection_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BgpConnection':
        """
        Get an existing BgpConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer IP address for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The ID of the Virtual Hub within which this Bgp connection should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_connection_id: The ID of virtual network connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BgpConnectionState.__new__(_BgpConnectionState)

        __props__.__dict__["name"] = name
        __props__.__dict__["peer_asn"] = peer_asn
        __props__.__dict__["peer_ip"] = peer_ip
        __props__.__dict__["virtual_hub_id"] = virtual_hub_id
        __props__.__dict__["virtual_network_connection_id"] = virtual_network_connection_id
        return BgpConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Output[_builtins.int]:
        """
        The peer autonomous system number for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The peer IP address for the Virtual Hub Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_ip")

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Hub within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConnectionId")
    def virtual_network_connection_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of virtual network connection.
        """
        return pulumi.get(self, "virtual_network_connection_id")

