# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallArgs', 'Firewall']

@pulumi.input_type
class FirewallArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 sku_tier: pulumi.Input[_builtins.str],
                 dns_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_ip_configuration: Optional[pulumi.Input['FirewallManagementIpConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intel_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_hub: Optional[pulumi.Input['FirewallVirtualHubArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Firewall resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: SKU name of the Firewall. Possible values are `AZFW_Hub` and `AZFW_VNet`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: SKU tier of the Firewall. Possible values are `Premium`, `Standard` and `Basic`.
        :param pulumi.Input[_builtins.bool] dns_proxy_enabled: Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when set to `true`. It will be set to `true` if `dns_servers` provided with a not empty list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of DNS servers that the Azure Firewall will direct DNS traffic to the for name resolution.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy applied to this Firewall.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]] ip_configurations: An `ip_configuration` block as documented below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['FirewallManagementIpConfigurationArgs'] management_ip_configuration: A `management_ip_configuration` block as documented below, which allows force-tunnelling of traffic to be performed by the firewall. Adding or removing this block or changing the `subnet_id` in an existing block forces a new resource to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Firewall. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of SNAT private CIDR IP ranges, or the special string `IANAPrivateRanges`, which indicates Azure Firewall does not SNAT when the destination IP address is a private range per IANA RFC 1918.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] threat_intel_mode: The operation mode for threat intelligence-based filtering. Possible values are: `Off`, `Alert` and `Deny`. Defaults to `Alert`.
        :param pulumi.Input['FirewallVirtualHubArgs'] virtual_hub: A `virtual_hub` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Azure Firewall should be located. Changing this forces a new Azure Firewall to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "sku_tier", sku_tier)
        if dns_proxy_enabled is not None:
            pulumi.set(__self__, "dns_proxy_enabled", dns_proxy_enabled)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if firewall_policy_id is not None:
            pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_ip_configuration is not None:
            pulumi.set(__self__, "management_ip_configuration", management_ip_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_ranges is not None:
            pulumi.set(__self__, "private_ip_ranges", private_ip_ranges)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_intel_mode is not None:
            pulumi.set(__self__, "threat_intel_mode", threat_intel_mode)
        if virtual_hub is not None:
            pulumi.set(__self__, "virtual_hub", virtual_hub)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        SKU name of the Firewall. Possible values are `AZFW_Hub` and `AZFW_VNet`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> pulumi.Input[_builtins.str]:
        """
        SKU tier of the Firewall. Possible values are `Premium`, `Standard` and `Basic`.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_tier", value)

    @_builtins.property
    @pulumi.getter(name="dnsProxyEnabled")
    def dns_proxy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when set to `true`. It will be set to `true` if `dns_servers` provided with a not empty list.
        """
        return pulumi.get(self, "dns_proxy_enabled")

    @dns_proxy_enabled.setter
    def dns_proxy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dns_proxy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of DNS servers that the Azure Firewall will direct DNS traffic to the for name resolution.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Firewall Policy applied to this Firewall.
        """
        return pulumi.get(self, "firewall_policy_id")

    @firewall_policy_id.setter
    def firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]]]:
        """
        An `ip_configuration` block as documented below.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementIpConfiguration")
    def management_ip_configuration(self) -> Optional[pulumi.Input['FirewallManagementIpConfigurationArgs']]:
        """
        A `management_ip_configuration` block as documented below, which allows force-tunnelling of traffic to be performed by the firewall. Adding or removing this block or changing the `subnet_id` in an existing block forces a new resource to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_ip_configuration")

    @management_ip_configuration.setter
    def management_ip_configuration(self, value: Optional[pulumi.Input['FirewallManagementIpConfigurationArgs']]):
        pulumi.set(self, "management_ip_configuration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Firewall. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpRanges")
    def private_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SNAT private CIDR IP ranges, or the special string `IANAPrivateRanges`, which indicates Azure Firewall does not SNAT when the destination IP address is a private range per IANA RFC 1918.
        """
        return pulumi.get(self, "private_ip_ranges")

    @private_ip_ranges.setter
    def private_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_ranges", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatIntelMode")
    def threat_intel_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation mode for threat intelligence-based filtering. Possible values are: `Off`, `Alert` and `Deny`. Defaults to `Alert`.
        """
        return pulumi.get(self, "threat_intel_mode")

    @threat_intel_mode.setter
    def threat_intel_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_intel_mode", value)

    @_builtins.property
    @pulumi.getter(name="virtualHub")
    def virtual_hub(self) -> Optional[pulumi.Input['FirewallVirtualHubArgs']]:
        """
        A `virtual_hub` block as documented below.
        """
        return pulumi.get(self, "virtual_hub")

    @virtual_hub.setter
    def virtual_hub(self, value: Optional[pulumi.Input['FirewallVirtualHubArgs']]):
        pulumi.set(self, "virtual_hub", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Azure Firewall should be located. Changing this forces a new Azure Firewall to be created.

        > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _FirewallState:
    def __init__(__self__, *,
                 dns_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_ip_configuration: Optional[pulumi.Input['FirewallManagementIpConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intel_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_hub: Optional[pulumi.Input['FirewallVirtualHubArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Firewall resources.
        :param pulumi.Input[_builtins.bool] dns_proxy_enabled: Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when set to `true`. It will be set to `true` if `dns_servers` provided with a not empty list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of DNS servers that the Azure Firewall will direct DNS traffic to the for name resolution.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy applied to this Firewall.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]] ip_configurations: An `ip_configuration` block as documented below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['FirewallManagementIpConfigurationArgs'] management_ip_configuration: A `management_ip_configuration` block as documented below, which allows force-tunnelling of traffic to be performed by the firewall. Adding or removing this block or changing the `subnet_id` in an existing block forces a new resource to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Firewall. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of SNAT private CIDR IP ranges, or the special string `IANAPrivateRanges`, which indicates Azure Firewall does not SNAT when the destination IP address is a private range per IANA RFC 1918.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: SKU name of the Firewall. Possible values are `AZFW_Hub` and `AZFW_VNet`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: SKU tier of the Firewall. Possible values are `Premium`, `Standard` and `Basic`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] threat_intel_mode: The operation mode for threat intelligence-based filtering. Possible values are: `Off`, `Alert` and `Deny`. Defaults to `Alert`.
        :param pulumi.Input['FirewallVirtualHubArgs'] virtual_hub: A `virtual_hub` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Azure Firewall should be located. Changing this forces a new Azure Firewall to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        if dns_proxy_enabled is not None:
            pulumi.set(__self__, "dns_proxy_enabled", dns_proxy_enabled)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if firewall_policy_id is not None:
            pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_ip_configuration is not None:
            pulumi.set(__self__, "management_ip_configuration", management_ip_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_ranges is not None:
            pulumi.set(__self__, "private_ip_ranges", private_ip_ranges)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if sku_tier is not None:
            pulumi.set(__self__, "sku_tier", sku_tier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_intel_mode is not None:
            pulumi.set(__self__, "threat_intel_mode", threat_intel_mode)
        if virtual_hub is not None:
            pulumi.set(__self__, "virtual_hub", virtual_hub)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="dnsProxyEnabled")
    def dns_proxy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when set to `true`. It will be set to `true` if `dns_servers` provided with a not empty list.
        """
        return pulumi.get(self, "dns_proxy_enabled")

    @dns_proxy_enabled.setter
    def dns_proxy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dns_proxy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of DNS servers that the Azure Firewall will direct DNS traffic to the for name resolution.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Firewall Policy applied to this Firewall.
        """
        return pulumi.get(self, "firewall_policy_id")

    @firewall_policy_id.setter
    def firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]]]:
        """
        An `ip_configuration` block as documented below.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallIpConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementIpConfiguration")
    def management_ip_configuration(self) -> Optional[pulumi.Input['FirewallManagementIpConfigurationArgs']]:
        """
        A `management_ip_configuration` block as documented below, which allows force-tunnelling of traffic to be performed by the firewall. Adding or removing this block or changing the `subnet_id` in an existing block forces a new resource to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_ip_configuration")

    @management_ip_configuration.setter
    def management_ip_configuration(self, value: Optional[pulumi.Input['FirewallManagementIpConfigurationArgs']]):
        pulumi.set(self, "management_ip_configuration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Firewall. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpRanges")
    def private_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SNAT private CIDR IP ranges, or the special string `IANAPrivateRanges`, which indicates Azure Firewall does not SNAT when the destination IP address is a private range per IANA RFC 1918.
        """
        return pulumi.get(self, "private_ip_ranges")

    @private_ip_ranges.setter
    def private_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SKU name of the Firewall. Possible values are `AZFW_Hub` and `AZFW_VNet`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SKU tier of the Firewall. Possible values are `Premium`, `Standard` and `Basic`.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_tier", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatIntelMode")
    def threat_intel_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation mode for threat intelligence-based filtering. Possible values are: `Off`, `Alert` and `Deny`. Defaults to `Alert`.
        """
        return pulumi.get(self, "threat_intel_mode")

    @threat_intel_mode.setter
    def threat_intel_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_intel_mode", value)

    @_builtins.property
    @pulumi.getter(name="virtualHub")
    def virtual_hub(self) -> Optional[pulumi.Input['FirewallVirtualHubArgs']]:
        """
        A `virtual_hub` block as documented below.
        """
        return pulumi.get(self, "virtual_hub")

    @virtual_hub.setter
    def virtual_hub(self, value: Optional[pulumi.Input['FirewallVirtualHubArgs']]):
        pulumi.set(self, "virtual_hub", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Azure Firewall should be located. Changing this forces a new Azure Firewall to be created.

        > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:network/firewall:Firewall")
class Firewall(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallIpConfigurationArgs', 'FirewallIpConfigurationArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_ip_configuration: Optional[pulumi.Input[Union['FirewallManagementIpConfigurationArgs', 'FirewallManagementIpConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intel_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_hub: Optional[pulumi.Input[Union['FirewallVirtualHubArgs', 'FirewallVirtualHubArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Firewall.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="testvnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="AzureFirewallSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="testpip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_firewall = azure.network.Firewall("example",
            name="testfirewall",
            location=example.location,
            resource_group_name=example.name,
            sku_name="AZFW_VNet",
            sku_tier="Standard",
            ip_configurations=[{
                "name": "configuration",
                "subnet_id": example_subnet.id,
                "public_ip_address_id": example_public_ip.id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Azure Firewalls can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/firewall:Firewall example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/azureFirewalls/testfirewall
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dns_proxy_enabled: Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when set to `true`. It will be set to `true` if `dns_servers` provided with a not empty list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of DNS servers that the Azure Firewall will direct DNS traffic to the for name resolution.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy applied to this Firewall.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallIpConfigurationArgs', 'FirewallIpConfigurationArgsDict']]]] ip_configurations: An `ip_configuration` block as documented below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FirewallManagementIpConfigurationArgs', 'FirewallManagementIpConfigurationArgsDict']] management_ip_configuration: A `management_ip_configuration` block as documented below, which allows force-tunnelling of traffic to be performed by the firewall. Adding or removing this block or changing the `subnet_id` in an existing block forces a new resource to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Firewall. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of SNAT private CIDR IP ranges, or the special string `IANAPrivateRanges`, which indicates Azure Firewall does not SNAT when the destination IP address is a private range per IANA RFC 1918.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: SKU name of the Firewall. Possible values are `AZFW_Hub` and `AZFW_VNet`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: SKU tier of the Firewall. Possible values are `Premium`, `Standard` and `Basic`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] threat_intel_mode: The operation mode for threat intelligence-based filtering. Possible values are: `Off`, `Alert` and `Deny`. Defaults to `Alert`.
        :param pulumi.Input[Union['FirewallVirtualHubArgs', 'FirewallVirtualHubArgsDict']] virtual_hub: A `virtual_hub` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Azure Firewall should be located. Changing this forces a new Azure Firewall to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Firewall.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="testvnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="AzureFirewallSubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="testpip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_firewall = azure.network.Firewall("example",
            name="testfirewall",
            location=example.location,
            resource_group_name=example.name,
            sku_name="AZFW_VNet",
            sku_tier="Standard",
            ip_configurations=[{
                "name": "configuration",
                "subnet_id": example_subnet.id,
                "public_ip_address_id": example_public_ip.id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Azure Firewalls can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/firewall:Firewall example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/azureFirewalls/testfirewall
        ```

        :param str resource_name: The name of the resource.
        :param FirewallArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallIpConfigurationArgs', 'FirewallIpConfigurationArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_ip_configuration: Optional[pulumi.Input[Union['FirewallManagementIpConfigurationArgs', 'FirewallManagementIpConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intel_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_hub: Optional[pulumi.Input[Union['FirewallVirtualHubArgs', 'FirewallVirtualHubArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallArgs.__new__(FirewallArgs)

            __props__.__dict__["dns_proxy_enabled"] = dns_proxy_enabled
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["firewall_policy_id"] = firewall_policy_id
            __props__.__dict__["ip_configurations"] = ip_configurations
            __props__.__dict__["location"] = location
            __props__.__dict__["management_ip_configuration"] = management_ip_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["private_ip_ranges"] = private_ip_ranges
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            if sku_tier is None and not opts.urn:
                raise TypeError("Missing required property 'sku_tier'")
            __props__.__dict__["sku_tier"] = sku_tier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threat_intel_mode"] = threat_intel_mode
            __props__.__dict__["virtual_hub"] = virtual_hub
            __props__.__dict__["zones"] = zones
        super(Firewall, __self__).__init__(
            'azure:network/firewall:Firewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dns_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallIpConfigurationArgs', 'FirewallIpConfigurationArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            management_ip_configuration: Optional[pulumi.Input[Union['FirewallManagementIpConfigurationArgs', 'FirewallManagementIpConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            threat_intel_mode: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_hub: Optional[pulumi.Input[Union['FirewallVirtualHubArgs', 'FirewallVirtualHubArgsDict']]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Firewall':
        """
        Get an existing Firewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dns_proxy_enabled: Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when set to `true`. It will be set to `true` if `dns_servers` provided with a not empty list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of DNS servers that the Azure Firewall will direct DNS traffic to the for name resolution.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy applied to this Firewall.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallIpConfigurationArgs', 'FirewallIpConfigurationArgsDict']]]] ip_configurations: An `ip_configuration` block as documented below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FirewallManagementIpConfigurationArgs', 'FirewallManagementIpConfigurationArgsDict']] management_ip_configuration: A `management_ip_configuration` block as documented below, which allows force-tunnelling of traffic to be performed by the firewall. Adding or removing this block or changing the `subnet_id` in an existing block forces a new resource to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Firewall. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of SNAT private CIDR IP ranges, or the special string `IANAPrivateRanges`, which indicates Azure Firewall does not SNAT when the destination IP address is a private range per IANA RFC 1918.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: SKU name of the Firewall. Possible values are `AZFW_Hub` and `AZFW_VNet`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: SKU tier of the Firewall. Possible values are `Premium`, `Standard` and `Basic`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] threat_intel_mode: The operation mode for threat intelligence-based filtering. Possible values are: `Off`, `Alert` and `Deny`. Defaults to `Alert`.
        :param pulumi.Input[Union['FirewallVirtualHubArgs', 'FirewallVirtualHubArgsDict']] virtual_hub: A `virtual_hub` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Azure Firewall should be located. Changing this forces a new Azure Firewall to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallState.__new__(_FirewallState)

        __props__.__dict__["dns_proxy_enabled"] = dns_proxy_enabled
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["firewall_policy_id"] = firewall_policy_id
        __props__.__dict__["ip_configurations"] = ip_configurations
        __props__.__dict__["location"] = location
        __props__.__dict__["management_ip_configuration"] = management_ip_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip_ranges"] = private_ip_ranges
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["sku_tier"] = sku_tier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threat_intel_mode"] = threat_intel_mode
        __props__.__dict__["virtual_hub"] = virtual_hub
        __props__.__dict__["zones"] = zones
        return Firewall(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dnsProxyEnabled")
    def dns_proxy_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether DNS proxy is enabled. It will forward DNS requests to the DNS servers when set to `true`. It will be set to `true` if `dns_servers` provided with a not empty list.
        """
        return pulumi.get(self, "dns_proxy_enabled")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of DNS servers that the Azure Firewall will direct DNS traffic to the for name resolution.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Firewall Policy applied to this Firewall.
        """
        return pulumi.get(self, "firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallIpConfiguration']]]:
        """
        An `ip_configuration` block as documented below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementIpConfiguration")
    def management_ip_configuration(self) -> pulumi.Output[Optional['outputs.FirewallManagementIpConfiguration']]:
        """
        A `management_ip_configuration` block as documented below, which allows force-tunnelling of traffic to be performed by the firewall. Adding or removing this block or changing the `subnet_id` in an existing block forces a new resource to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_ip_configuration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Firewall. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIpRanges")
    def private_ip_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of SNAT private CIDR IP ranges, or the special string `IANAPrivateRanges`, which indicates Azure Firewall does not SNAT when the destination IP address is a private range per IANA RFC 1918.
        """
        return pulumi.get(self, "private_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        SKU name of the Firewall. Possible values are `AZFW_Hub` and `AZFW_VNet`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> pulumi.Output[_builtins.str]:
        """
        SKU tier of the Firewall. Possible values are `Premium`, `Standard` and `Basic`.
        """
        return pulumi.get(self, "sku_tier")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="threatIntelMode")
    def threat_intel_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The operation mode for threat intelligence-based filtering. Possible values are: `Off`, `Alert` and `Deny`. Defaults to `Alert`.
        """
        return pulumi.get(self, "threat_intel_mode")

    @_builtins.property
    @pulumi.getter(name="virtualHub")
    def virtual_hub(self) -> pulumi.Output[Optional['outputs.FirewallVirtualHub']]:
        """
        A `virtual_hub` block as documented below.
        """
        return pulumi.get(self, "virtual_hub")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Azure Firewall should be located. Changing this forces a new Azure Firewall to be created.

        > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

