# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallPolicyArgs', 'FirewallPolicy']

@pulumi.input_type
class FirewallPolicyArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 auto_learn_private_ranges_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 base_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input['FirewallPolicyDnsArgs']] = None,
                 explicit_proxy: Optional[pulumi.Input['FirewallPolicyExplicitProxyArgs']] = None,
                 identity: Optional[pulumi.Input['FirewallPolicyIdentityArgs']] = None,
                 insights: Optional[pulumi.Input['FirewallPolicyInsightsArgs']] = None,
                 intrusion_detection: Optional[pulumi.Input['FirewallPolicyIntrusionDetectionArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_redirect_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intelligence_allowlist: Optional[pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs']] = None,
                 threat_intelligence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_certificate: Optional[pulumi.Input['FirewallPolicyTlsCertificateArgs']] = None):
        """
        The set of arguments for constructing a FirewallPolicy resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.bool] auto_learn_private_ranges_enabled: Whether enable auto learn private ip range.
        :param pulumi.Input[_builtins.str] base_policy_id: The ID of the base Firewall Policy.
        :param pulumi.Input['FirewallPolicyDnsArgs'] dns: A `dns` block as defined below.
        :param pulumi.Input['FirewallPolicyExplicitProxyArgs'] explicit_proxy: A `explicit_proxy` block as defined below.
        :param pulumi.Input['FirewallPolicyIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['FirewallPolicyInsightsArgs'] insights: An `insights` block as defined below.
        :param pulumi.Input['FirewallPolicyIntrusionDetectionArgs'] intrusion_detection: A `intrusion_detection` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of private IP ranges to which traffic will not be SNAT.
        :param pulumi.Input[_builtins.str] sku: The SKU Tier of the Firewall Policy. Possible values are `Standard`, `Premium` and `Basic`. Defaults to `Standard`. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.bool] sql_redirect_allowed: Whether SQL Redirect traffic filtering is allowed. Enabling this flag requires no rule using ports between `11000`-`11999`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Firewall Policy.
        :param pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs'] threat_intelligence_allowlist: A `threat_intelligence_allowlist` block as defined below.
        :param pulumi.Input[_builtins.str] threat_intelligence_mode: The operation mode for Threat Intelligence. Possible values are `Alert`, `Deny` and `Off`. Defaults to `Alert`.
        :param pulumi.Input['FirewallPolicyTlsCertificateArgs'] tls_certificate: A `tls_certificate` block as defined below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if auto_learn_private_ranges_enabled is not None:
            pulumi.set(__self__, "auto_learn_private_ranges_enabled", auto_learn_private_ranges_enabled)
        if base_policy_id is not None:
            pulumi.set(__self__, "base_policy_id", base_policy_id)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if explicit_proxy is not None:
            pulumi.set(__self__, "explicit_proxy", explicit_proxy)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if insights is not None:
            pulumi.set(__self__, "insights", insights)
        if intrusion_detection is not None:
            pulumi.set(__self__, "intrusion_detection", intrusion_detection)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_ranges is not None:
            pulumi.set(__self__, "private_ip_ranges", private_ip_ranges)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if sql_redirect_allowed is not None:
            pulumi.set(__self__, "sql_redirect_allowed", sql_redirect_allowed)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_intelligence_allowlist is not None:
            pulumi.set(__self__, "threat_intelligence_allowlist", threat_intelligence_allowlist)
        if threat_intelligence_mode is not None:
            pulumi.set(__self__, "threat_intelligence_mode", threat_intelligence_mode)
        if tls_certificate is not None:
            pulumi.set(__self__, "tls_certificate", tls_certificate)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="autoLearnPrivateRangesEnabled")
    def auto_learn_private_ranges_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable auto learn private ip range.
        """
        return pulumi.get(self, "auto_learn_private_ranges_enabled")

    @auto_learn_private_ranges_enabled.setter
    def auto_learn_private_ranges_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_learn_private_ranges_enabled", value)

    @_builtins.property
    @pulumi.getter(name="basePolicyId")
    def base_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the base Firewall Policy.
        """
        return pulumi.get(self, "base_policy_id")

    @base_policy_id.setter
    def base_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['FirewallPolicyDnsArgs']]:
        """
        A `dns` block as defined below.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['FirewallPolicyDnsArgs']]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter(name="explicitProxy")
    def explicit_proxy(self) -> Optional[pulumi.Input['FirewallPolicyExplicitProxyArgs']]:
        """
        A `explicit_proxy` block as defined below.
        """
        return pulumi.get(self, "explicit_proxy")

    @explicit_proxy.setter
    def explicit_proxy(self, value: Optional[pulumi.Input['FirewallPolicyExplicitProxyArgs']]):
        pulumi.set(self, "explicit_proxy", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FirewallPolicyIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FirewallPolicyIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def insights(self) -> Optional[pulumi.Input['FirewallPolicyInsightsArgs']]:
        """
        An `insights` block as defined below.
        """
        return pulumi.get(self, "insights")

    @insights.setter
    def insights(self, value: Optional[pulumi.Input['FirewallPolicyInsightsArgs']]):
        pulumi.set(self, "insights", value)

    @_builtins.property
    @pulumi.getter(name="intrusionDetection")
    def intrusion_detection(self) -> Optional[pulumi.Input['FirewallPolicyIntrusionDetectionArgs']]:
        """
        A `intrusion_detection` block as defined below.
        """
        return pulumi.get(self, "intrusion_detection")

    @intrusion_detection.setter
    def intrusion_detection(self, value: Optional[pulumi.Input['FirewallPolicyIntrusionDetectionArgs']]):
        pulumi.set(self, "intrusion_detection", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Firewall Policy. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpRanges")
    def private_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of private IP ranges to which traffic will not be SNAT.
        """
        return pulumi.get(self, "private_ip_ranges")

    @private_ip_ranges.setter
    def private_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_ranges", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Tier of the Firewall Policy. Possible values are `Standard`, `Premium` and `Basic`. Defaults to `Standard`. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="sqlRedirectAllowed")
    def sql_redirect_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SQL Redirect traffic filtering is allowed. Enabling this flag requires no rule using ports between `11000`-`11999`.
        """
        return pulumi.get(self, "sql_redirect_allowed")

    @sql_redirect_allowed.setter
    def sql_redirect_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_redirect_allowed", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Firewall Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatIntelligenceAllowlist")
    def threat_intelligence_allowlist(self) -> Optional[pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs']]:
        """
        A `threat_intelligence_allowlist` block as defined below.
        """
        return pulumi.get(self, "threat_intelligence_allowlist")

    @threat_intelligence_allowlist.setter
    def threat_intelligence_allowlist(self, value: Optional[pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs']]):
        pulumi.set(self, "threat_intelligence_allowlist", value)

    @_builtins.property
    @pulumi.getter(name="threatIntelligenceMode")
    def threat_intelligence_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation mode for Threat Intelligence. Possible values are `Alert`, `Deny` and `Off`. Defaults to `Alert`.
        """
        return pulumi.get(self, "threat_intelligence_mode")

    @threat_intelligence_mode.setter
    def threat_intelligence_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_intelligence_mode", value)

    @_builtins.property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> Optional[pulumi.Input['FirewallPolicyTlsCertificateArgs']]:
        """
        A `tls_certificate` block as defined below.
        """
        return pulumi.get(self, "tls_certificate")

    @tls_certificate.setter
    def tls_certificate(self, value: Optional[pulumi.Input['FirewallPolicyTlsCertificateArgs']]):
        pulumi.set(self, "tls_certificate", value)


@pulumi.input_type
class _FirewallPolicyState:
    def __init__(__self__, *,
                 auto_learn_private_ranges_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 base_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 child_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns: Optional[pulumi.Input['FirewallPolicyDnsArgs']] = None,
                 explicit_proxy: Optional[pulumi.Input['FirewallPolicyExplicitProxyArgs']] = None,
                 firewalls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input['FirewallPolicyIdentityArgs']] = None,
                 insights: Optional[pulumi.Input['FirewallPolicyInsightsArgs']] = None,
                 intrusion_detection: Optional[pulumi.Input['FirewallPolicyIntrusionDetectionArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_collection_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_redirect_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intelligence_allowlist: Optional[pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs']] = None,
                 threat_intelligence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_certificate: Optional[pulumi.Input['FirewallPolicyTlsCertificateArgs']] = None):
        """
        Input properties used for looking up and filtering FirewallPolicy resources.
        :param pulumi.Input[_builtins.bool] auto_learn_private_ranges_enabled: Whether enable auto learn private ip range.
        :param pulumi.Input[_builtins.str] base_policy_id: The ID of the base Firewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] child_policies: A list of reference to child Firewall Policies of this Firewall Policy.
        :param pulumi.Input['FirewallPolicyDnsArgs'] dns: A `dns` block as defined below.
        :param pulumi.Input['FirewallPolicyExplicitProxyArgs'] explicit_proxy: A `explicit_proxy` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] firewalls: A list of references to Azure Firewalls that this Firewall Policy is associated with.
        :param pulumi.Input['FirewallPolicyIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['FirewallPolicyInsightsArgs'] insights: An `insights` block as defined below.
        :param pulumi.Input['FirewallPolicyIntrusionDetectionArgs'] intrusion_detection: A `intrusion_detection` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of private IP ranges to which traffic will not be SNAT.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_collection_groups: A list of references to Firewall Policy Rule Collection Groups that belongs to this Firewall Policy.
        :param pulumi.Input[_builtins.str] sku: The SKU Tier of the Firewall Policy. Possible values are `Standard`, `Premium` and `Basic`. Defaults to `Standard`. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.bool] sql_redirect_allowed: Whether SQL Redirect traffic filtering is allowed. Enabling this flag requires no rule using ports between `11000`-`11999`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Firewall Policy.
        :param pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs'] threat_intelligence_allowlist: A `threat_intelligence_allowlist` block as defined below.
        :param pulumi.Input[_builtins.str] threat_intelligence_mode: The operation mode for Threat Intelligence. Possible values are `Alert`, `Deny` and `Off`. Defaults to `Alert`.
        :param pulumi.Input['FirewallPolicyTlsCertificateArgs'] tls_certificate: A `tls_certificate` block as defined below.
        """
        if auto_learn_private_ranges_enabled is not None:
            pulumi.set(__self__, "auto_learn_private_ranges_enabled", auto_learn_private_ranges_enabled)
        if base_policy_id is not None:
            pulumi.set(__self__, "base_policy_id", base_policy_id)
        if child_policies is not None:
            pulumi.set(__self__, "child_policies", child_policies)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if explicit_proxy is not None:
            pulumi.set(__self__, "explicit_proxy", explicit_proxy)
        if firewalls is not None:
            pulumi.set(__self__, "firewalls", firewalls)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if insights is not None:
            pulumi.set(__self__, "insights", insights)
        if intrusion_detection is not None:
            pulumi.set(__self__, "intrusion_detection", intrusion_detection)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_ranges is not None:
            pulumi.set(__self__, "private_ip_ranges", private_ip_ranges)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rule_collection_groups is not None:
            pulumi.set(__self__, "rule_collection_groups", rule_collection_groups)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if sql_redirect_allowed is not None:
            pulumi.set(__self__, "sql_redirect_allowed", sql_redirect_allowed)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_intelligence_allowlist is not None:
            pulumi.set(__self__, "threat_intelligence_allowlist", threat_intelligence_allowlist)
        if threat_intelligence_mode is not None:
            pulumi.set(__self__, "threat_intelligence_mode", threat_intelligence_mode)
        if tls_certificate is not None:
            pulumi.set(__self__, "tls_certificate", tls_certificate)

    @_builtins.property
    @pulumi.getter(name="autoLearnPrivateRangesEnabled")
    def auto_learn_private_ranges_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable auto learn private ip range.
        """
        return pulumi.get(self, "auto_learn_private_ranges_enabled")

    @auto_learn_private_ranges_enabled.setter
    def auto_learn_private_ranges_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_learn_private_ranges_enabled", value)

    @_builtins.property
    @pulumi.getter(name="basePolicyId")
    def base_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the base Firewall Policy.
        """
        return pulumi.get(self, "base_policy_id")

    @base_policy_id.setter
    def base_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="childPolicies")
    def child_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of reference to child Firewall Policies of this Firewall Policy.
        """
        return pulumi.get(self, "child_policies")

    @child_policies.setter
    def child_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "child_policies", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['FirewallPolicyDnsArgs']]:
        """
        A `dns` block as defined below.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['FirewallPolicyDnsArgs']]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter(name="explicitProxy")
    def explicit_proxy(self) -> Optional[pulumi.Input['FirewallPolicyExplicitProxyArgs']]:
        """
        A `explicit_proxy` block as defined below.
        """
        return pulumi.get(self, "explicit_proxy")

    @explicit_proxy.setter
    def explicit_proxy(self, value: Optional[pulumi.Input['FirewallPolicyExplicitProxyArgs']]):
        pulumi.set(self, "explicit_proxy", value)

    @_builtins.property
    @pulumi.getter
    def firewalls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of references to Azure Firewalls that this Firewall Policy is associated with.
        """
        return pulumi.get(self, "firewalls")

    @firewalls.setter
    def firewalls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "firewalls", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FirewallPolicyIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FirewallPolicyIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def insights(self) -> Optional[pulumi.Input['FirewallPolicyInsightsArgs']]:
        """
        An `insights` block as defined below.
        """
        return pulumi.get(self, "insights")

    @insights.setter
    def insights(self, value: Optional[pulumi.Input['FirewallPolicyInsightsArgs']]):
        pulumi.set(self, "insights", value)

    @_builtins.property
    @pulumi.getter(name="intrusionDetection")
    def intrusion_detection(self) -> Optional[pulumi.Input['FirewallPolicyIntrusionDetectionArgs']]:
        """
        A `intrusion_detection` block as defined below.
        """
        return pulumi.get(self, "intrusion_detection")

    @intrusion_detection.setter
    def intrusion_detection(self, value: Optional[pulumi.Input['FirewallPolicyIntrusionDetectionArgs']]):
        pulumi.set(self, "intrusion_detection", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Firewall Policy. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpRanges")
    def private_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of private IP ranges to which traffic will not be SNAT.
        """
        return pulumi.get(self, "private_ip_ranges")

    @private_ip_ranges.setter
    def private_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="ruleCollectionGroups")
    def rule_collection_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of references to Firewall Policy Rule Collection Groups that belongs to this Firewall Policy.
        """
        return pulumi.get(self, "rule_collection_groups")

    @rule_collection_groups.setter
    def rule_collection_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rule_collection_groups", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Tier of the Firewall Policy. Possible values are `Standard`, `Premium` and `Basic`. Defaults to `Standard`. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="sqlRedirectAllowed")
    def sql_redirect_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SQL Redirect traffic filtering is allowed. Enabling this flag requires no rule using ports between `11000`-`11999`.
        """
        return pulumi.get(self, "sql_redirect_allowed")

    @sql_redirect_allowed.setter
    def sql_redirect_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_redirect_allowed", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Firewall Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatIntelligenceAllowlist")
    def threat_intelligence_allowlist(self) -> Optional[pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs']]:
        """
        A `threat_intelligence_allowlist` block as defined below.
        """
        return pulumi.get(self, "threat_intelligence_allowlist")

    @threat_intelligence_allowlist.setter
    def threat_intelligence_allowlist(self, value: Optional[pulumi.Input['FirewallPolicyThreatIntelligenceAllowlistArgs']]):
        pulumi.set(self, "threat_intelligence_allowlist", value)

    @_builtins.property
    @pulumi.getter(name="threatIntelligenceMode")
    def threat_intelligence_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation mode for Threat Intelligence. Possible values are `Alert`, `Deny` and `Off`. Defaults to `Alert`.
        """
        return pulumi.get(self, "threat_intelligence_mode")

    @threat_intelligence_mode.setter
    def threat_intelligence_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_intelligence_mode", value)

    @_builtins.property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> Optional[pulumi.Input['FirewallPolicyTlsCertificateArgs']]:
        """
        A `tls_certificate` block as defined below.
        """
        return pulumi.get(self, "tls_certificate")

    @tls_certificate.setter
    def tls_certificate(self, value: Optional[pulumi.Input['FirewallPolicyTlsCertificateArgs']]):
        pulumi.set(self, "tls_certificate", value)


@pulumi.type_token("azure:network/firewallPolicy:FirewallPolicy")
class FirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_learn_private_ranges_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 base_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input[Union['FirewallPolicyDnsArgs', 'FirewallPolicyDnsArgsDict']]] = None,
                 explicit_proxy: Optional[pulumi.Input[Union['FirewallPolicyExplicitProxyArgs', 'FirewallPolicyExplicitProxyArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FirewallPolicyIdentityArgs', 'FirewallPolicyIdentityArgsDict']]] = None,
                 insights: Optional[pulumi.Input[Union['FirewallPolicyInsightsArgs', 'FirewallPolicyInsightsArgsDict']]] = None,
                 intrusion_detection: Optional[pulumi.Input[Union['FirewallPolicyIntrusionDetectionArgs', 'FirewallPolicyIntrusionDetectionArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_redirect_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intelligence_allowlist: Optional[pulumi.Input[Union['FirewallPolicyThreatIntelligenceAllowlistArgs', 'FirewallPolicyThreatIntelligenceAllowlistArgsDict']]] = None,
                 threat_intelligence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_certificate: Optional[pulumi.Input[Union['FirewallPolicyTlsCertificateArgs', 'FirewallPolicyTlsCertificateArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_firewall_policy = azure.network.FirewallPolicy("example",
            name="example-policy",
            resource_group_name=example.name,
            location=example.location)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Firewall Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/firewallPolicy:FirewallPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/firewallPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_learn_private_ranges_enabled: Whether enable auto learn private ip range.
        :param pulumi.Input[_builtins.str] base_policy_id: The ID of the base Firewall Policy.
        :param pulumi.Input[Union['FirewallPolicyDnsArgs', 'FirewallPolicyDnsArgsDict']] dns: A `dns` block as defined below.
        :param pulumi.Input[Union['FirewallPolicyExplicitProxyArgs', 'FirewallPolicyExplicitProxyArgsDict']] explicit_proxy: A `explicit_proxy` block as defined below.
        :param pulumi.Input[Union['FirewallPolicyIdentityArgs', 'FirewallPolicyIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['FirewallPolicyInsightsArgs', 'FirewallPolicyInsightsArgsDict']] insights: An `insights` block as defined below.
        :param pulumi.Input[Union['FirewallPolicyIntrusionDetectionArgs', 'FirewallPolicyIntrusionDetectionArgsDict']] intrusion_detection: A `intrusion_detection` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of private IP ranges to which traffic will not be SNAT.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU Tier of the Firewall Policy. Possible values are `Standard`, `Premium` and `Basic`. Defaults to `Standard`. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.bool] sql_redirect_allowed: Whether SQL Redirect traffic filtering is allowed. Enabling this flag requires no rule using ports between `11000`-`11999`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Firewall Policy.
        :param pulumi.Input[Union['FirewallPolicyThreatIntelligenceAllowlistArgs', 'FirewallPolicyThreatIntelligenceAllowlistArgsDict']] threat_intelligence_allowlist: A `threat_intelligence_allowlist` block as defined below.
        :param pulumi.Input[_builtins.str] threat_intelligence_mode: The operation mode for Threat Intelligence. Possible values are `Alert`, `Deny` and `Off`. Defaults to `Alert`.
        :param pulumi.Input[Union['FirewallPolicyTlsCertificateArgs', 'FirewallPolicyTlsCertificateArgsDict']] tls_certificate: A `tls_certificate` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_firewall_policy = azure.network.FirewallPolicy("example",
            name="example-policy",
            resource_group_name=example.name,
            location=example.location)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Firewall Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/firewallPolicy:FirewallPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/firewallPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param FirewallPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_learn_private_ranges_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 base_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input[Union['FirewallPolicyDnsArgs', 'FirewallPolicyDnsArgsDict']]] = None,
                 explicit_proxy: Optional[pulumi.Input[Union['FirewallPolicyExplicitProxyArgs', 'FirewallPolicyExplicitProxyArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FirewallPolicyIdentityArgs', 'FirewallPolicyIdentityArgsDict']]] = None,
                 insights: Optional[pulumi.Input[Union['FirewallPolicyInsightsArgs', 'FirewallPolicyInsightsArgsDict']]] = None,
                 intrusion_detection: Optional[pulumi.Input[Union['FirewallPolicyIntrusionDetectionArgs', 'FirewallPolicyIntrusionDetectionArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_redirect_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_intelligence_allowlist: Optional[pulumi.Input[Union['FirewallPolicyThreatIntelligenceAllowlistArgs', 'FirewallPolicyThreatIntelligenceAllowlistArgsDict']]] = None,
                 threat_intelligence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_certificate: Optional[pulumi.Input[Union['FirewallPolicyTlsCertificateArgs', 'FirewallPolicyTlsCertificateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallPolicyArgs.__new__(FirewallPolicyArgs)

            __props__.__dict__["auto_learn_private_ranges_enabled"] = auto_learn_private_ranges_enabled
            __props__.__dict__["base_policy_id"] = base_policy_id
            __props__.__dict__["dns"] = dns
            __props__.__dict__["explicit_proxy"] = explicit_proxy
            __props__.__dict__["identity"] = identity
            __props__.__dict__["insights"] = insights
            __props__.__dict__["intrusion_detection"] = intrusion_detection
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["private_ip_ranges"] = private_ip_ranges
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku"] = sku
            __props__.__dict__["sql_redirect_allowed"] = sql_redirect_allowed
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threat_intelligence_allowlist"] = threat_intelligence_allowlist
            __props__.__dict__["threat_intelligence_mode"] = threat_intelligence_mode
            __props__.__dict__["tls_certificate"] = tls_certificate
            __props__.__dict__["child_policies"] = None
            __props__.__dict__["firewalls"] = None
            __props__.__dict__["rule_collection_groups"] = None
        super(FirewallPolicy, __self__).__init__(
            'azure:network/firewallPolicy:FirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_learn_private_ranges_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            base_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            child_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dns: Optional[pulumi.Input[Union['FirewallPolicyDnsArgs', 'FirewallPolicyDnsArgsDict']]] = None,
            explicit_proxy: Optional[pulumi.Input[Union['FirewallPolicyExplicitProxyArgs', 'FirewallPolicyExplicitProxyArgsDict']]] = None,
            firewalls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            identity: Optional[pulumi.Input[Union['FirewallPolicyIdentityArgs', 'FirewallPolicyIdentityArgsDict']]] = None,
            insights: Optional[pulumi.Input[Union['FirewallPolicyInsightsArgs', 'FirewallPolicyInsightsArgsDict']]] = None,
            intrusion_detection: Optional[pulumi.Input[Union['FirewallPolicyIntrusionDetectionArgs', 'FirewallPolicyIntrusionDetectionArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_collection_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            sql_redirect_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            threat_intelligence_allowlist: Optional[pulumi.Input[Union['FirewallPolicyThreatIntelligenceAllowlistArgs', 'FirewallPolicyThreatIntelligenceAllowlistArgsDict']]] = None,
            threat_intelligence_mode: Optional[pulumi.Input[_builtins.str]] = None,
            tls_certificate: Optional[pulumi.Input[Union['FirewallPolicyTlsCertificateArgs', 'FirewallPolicyTlsCertificateArgsDict']]] = None) -> 'FirewallPolicy':
        """
        Get an existing FirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_learn_private_ranges_enabled: Whether enable auto learn private ip range.
        :param pulumi.Input[_builtins.str] base_policy_id: The ID of the base Firewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] child_policies: A list of reference to child Firewall Policies of this Firewall Policy.
        :param pulumi.Input[Union['FirewallPolicyDnsArgs', 'FirewallPolicyDnsArgsDict']] dns: A `dns` block as defined below.
        :param pulumi.Input[Union['FirewallPolicyExplicitProxyArgs', 'FirewallPolicyExplicitProxyArgsDict']] explicit_proxy: A `explicit_proxy` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] firewalls: A list of references to Azure Firewalls that this Firewall Policy is associated with.
        :param pulumi.Input[Union['FirewallPolicyIdentityArgs', 'FirewallPolicyIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['FirewallPolicyInsightsArgs', 'FirewallPolicyInsightsArgsDict']] insights: An `insights` block as defined below.
        :param pulumi.Input[Union['FirewallPolicyIntrusionDetectionArgs', 'FirewallPolicyIntrusionDetectionArgsDict']] intrusion_detection: A `intrusion_detection` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_ranges: A list of private IP ranges to which traffic will not be SNAT.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_collection_groups: A list of references to Firewall Policy Rule Collection Groups that belongs to this Firewall Policy.
        :param pulumi.Input[_builtins.str] sku: The SKU Tier of the Firewall Policy. Possible values are `Standard`, `Premium` and `Basic`. Defaults to `Standard`. Changing this forces a new Firewall Policy to be created.
        :param pulumi.Input[_builtins.bool] sql_redirect_allowed: Whether SQL Redirect traffic filtering is allowed. Enabling this flag requires no rule using ports between `11000`-`11999`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Firewall Policy.
        :param pulumi.Input[Union['FirewallPolicyThreatIntelligenceAllowlistArgs', 'FirewallPolicyThreatIntelligenceAllowlistArgsDict']] threat_intelligence_allowlist: A `threat_intelligence_allowlist` block as defined below.
        :param pulumi.Input[_builtins.str] threat_intelligence_mode: The operation mode for Threat Intelligence. Possible values are `Alert`, `Deny` and `Off`. Defaults to `Alert`.
        :param pulumi.Input[Union['FirewallPolicyTlsCertificateArgs', 'FirewallPolicyTlsCertificateArgsDict']] tls_certificate: A `tls_certificate` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallPolicyState.__new__(_FirewallPolicyState)

        __props__.__dict__["auto_learn_private_ranges_enabled"] = auto_learn_private_ranges_enabled
        __props__.__dict__["base_policy_id"] = base_policy_id
        __props__.__dict__["child_policies"] = child_policies
        __props__.__dict__["dns"] = dns
        __props__.__dict__["explicit_proxy"] = explicit_proxy
        __props__.__dict__["firewalls"] = firewalls
        __props__.__dict__["identity"] = identity
        __props__.__dict__["insights"] = insights
        __props__.__dict__["intrusion_detection"] = intrusion_detection
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip_ranges"] = private_ip_ranges
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rule_collection_groups"] = rule_collection_groups
        __props__.__dict__["sku"] = sku
        __props__.__dict__["sql_redirect_allowed"] = sql_redirect_allowed
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threat_intelligence_allowlist"] = threat_intelligence_allowlist
        __props__.__dict__["threat_intelligence_mode"] = threat_intelligence_mode
        __props__.__dict__["tls_certificate"] = tls_certificate
        return FirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoLearnPrivateRangesEnabled")
    def auto_learn_private_ranges_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable auto learn private ip range.
        """
        return pulumi.get(self, "auto_learn_private_ranges_enabled")

    @_builtins.property
    @pulumi.getter(name="basePolicyId")
    def base_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the base Firewall Policy.
        """
        return pulumi.get(self, "base_policy_id")

    @_builtins.property
    @pulumi.getter(name="childPolicies")
    def child_policies(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of reference to child Firewall Policies of this Firewall Policy.
        """
        return pulumi.get(self, "child_policies")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> pulumi.Output[Optional['outputs.FirewallPolicyDns']]:
        """
        A `dns` block as defined below.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="explicitProxy")
    def explicit_proxy(self) -> pulumi.Output[Optional['outputs.FirewallPolicyExplicitProxy']]:
        """
        A `explicit_proxy` block as defined below.
        """
        return pulumi.get(self, "explicit_proxy")

    @_builtins.property
    @pulumi.getter
    def firewalls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of references to Azure Firewalls that this Firewall Policy is associated with.
        """
        return pulumi.get(self, "firewalls")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.FirewallPolicyIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def insights(self) -> pulumi.Output[Optional['outputs.FirewallPolicyInsights']]:
        """
        An `insights` block as defined below.
        """
        return pulumi.get(self, "insights")

    @_builtins.property
    @pulumi.getter(name="intrusionDetection")
    def intrusion_detection(self) -> pulumi.Output[Optional['outputs.FirewallPolicyIntrusionDetection']]:
        """
        A `intrusion_detection` block as defined below.
        """
        return pulumi.get(self, "intrusion_detection")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Firewall Policy. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIpRanges")
    def private_ip_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of private IP ranges to which traffic will not be SNAT.
        """
        return pulumi.get(self, "private_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Firewall Policy should exist. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="ruleCollectionGroups")
    def rule_collection_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of references to Firewall Policy Rule Collection Groups that belongs to this Firewall Policy.
        """
        return pulumi.get(self, "rule_collection_groups")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SKU Tier of the Firewall Policy. Possible values are `Standard`, `Premium` and `Basic`. Defaults to `Standard`. Changing this forces a new Firewall Policy to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="sqlRedirectAllowed")
    def sql_redirect_allowed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether SQL Redirect traffic filtering is allowed. Enabling this flag requires no rule using ports between `11000`-`11999`.
        """
        return pulumi.get(self, "sql_redirect_allowed")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Firewall Policy.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="threatIntelligenceAllowlist")
    def threat_intelligence_allowlist(self) -> pulumi.Output[Optional['outputs.FirewallPolicyThreatIntelligenceAllowlist']]:
        """
        A `threat_intelligence_allowlist` block as defined below.
        """
        return pulumi.get(self, "threat_intelligence_allowlist")

    @_builtins.property
    @pulumi.getter(name="threatIntelligenceMode")
    def threat_intelligence_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operation mode for Threat Intelligence. Possible values are `Alert`, `Deny` and `Off`. Defaults to `Alert`.
        """
        return pulumi.get(self, "threat_intelligence_mode")

    @_builtins.property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> pulumi.Output[Optional['outputs.FirewallPolicyTlsCertificate']]:
        """
        A `tls_certificate` block as defined below.
        """
        return pulumi.get(self, "tls_certificate")

