# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallPolicyRuleCollectionGroupArgs', 'FirewallPolicyRuleCollectionGroup']

@pulumi.input_type
class FirewallPolicyRuleCollectionGroupArgs:
    def __init__(__self__, *,
                 firewall_policy_id: pulumi.Input[_builtins.str],
                 priority: pulumi.Input[_builtins.int],
                 application_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]]] = None,
                 network_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]]] = None):
        """
        The set of arguments for constructing a FirewallPolicyRuleCollectionGroup resource.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy where the Firewall Policy Rule Collection Group should exist. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[_builtins.int] priority: The priority of the Firewall Policy Rule Collection Group. The range is 100-65000.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]] application_rule_collections: One or more `application_rule_collection` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy Rule Collection Group. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]] nat_rule_collections: One or more `nat_rule_collection` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]] network_rule_collections: One or more `network_rule_collection` blocks as defined below.
        """
        pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        pulumi.set(__self__, "priority", priority)
        if application_rule_collections is not None:
            pulumi.set(__self__, "application_rule_collections", application_rule_collections)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_rule_collections is not None:
            pulumi.set(__self__, "nat_rule_collections", nat_rule_collections)
        if network_rule_collections is not None:
            pulumi.set(__self__, "network_rule_collections", network_rule_collections)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Firewall Policy where the Firewall Policy Rule Collection Group should exist. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        """
        return pulumi.get(self, "firewall_policy_id")

    @firewall_policy_id.setter
    def firewall_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        The priority of the Firewall Policy Rule Collection Group. The range is 100-65000.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="applicationRuleCollections")
    def application_rule_collections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]]]:
        """
        One or more `application_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "application_rule_collections")

    @application_rule_collections.setter
    def application_rule_collections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]]]):
        pulumi.set(self, "application_rule_collections", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Firewall Policy Rule Collection Group. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natRuleCollections")
    def nat_rule_collections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]]]:
        """
        One or more `nat_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "nat_rule_collections")

    @nat_rule_collections.setter
    def nat_rule_collections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]]]):
        pulumi.set(self, "nat_rule_collections", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleCollections")
    def network_rule_collections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]]]:
        """
        One or more `network_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "network_rule_collections")

    @network_rule_collections.setter
    def network_rule_collections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]]]):
        pulumi.set(self, "network_rule_collections", value)


@pulumi.input_type
class _FirewallPolicyRuleCollectionGroupState:
    def __init__(__self__, *,
                 application_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]]] = None,
                 network_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering FirewallPolicyRuleCollectionGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]] application_rule_collections: One or more `application_rule_collection` blocks as defined below.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy where the Firewall Policy Rule Collection Group should exist. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy Rule Collection Group. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]] nat_rule_collections: One or more `nat_rule_collection` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]] network_rule_collections: One or more `network_rule_collection` blocks as defined below.
        :param pulumi.Input[_builtins.int] priority: The priority of the Firewall Policy Rule Collection Group. The range is 100-65000.
        """
        if application_rule_collections is not None:
            pulumi.set(__self__, "application_rule_collections", application_rule_collections)
        if firewall_policy_id is not None:
            pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_rule_collections is not None:
            pulumi.set(__self__, "nat_rule_collections", nat_rule_collections)
        if network_rule_collections is not None:
            pulumi.set(__self__, "network_rule_collections", network_rule_collections)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter(name="applicationRuleCollections")
    def application_rule_collections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]]]:
        """
        One or more `application_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "application_rule_collections")

    @application_rule_collections.setter
    def application_rule_collections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs']]]]):
        pulumi.set(self, "application_rule_collections", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Firewall Policy where the Firewall Policy Rule Collection Group should exist. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        """
        return pulumi.get(self, "firewall_policy_id")

    @firewall_policy_id.setter
    def firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Firewall Policy Rule Collection Group. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natRuleCollections")
    def nat_rule_collections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]]]:
        """
        One or more `nat_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "nat_rule_collections")

    @nat_rule_collections.setter
    def nat_rule_collections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs']]]]):
        pulumi.set(self, "nat_rule_collections", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleCollections")
    def network_rule_collections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]]]:
        """
        One or more `network_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "network_rule_collections")

    @network_rule_collections.setter
    def network_rule_collections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs']]]]):
        pulumi.set(self, "network_rule_collections", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the Firewall Policy Rule Collection Group. The range is 100-65000.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)


@pulumi.type_token("azure:network/firewallPolicyRuleCollectionGroup:FirewallPolicyRuleCollectionGroup")
class FirewallPolicyRuleCollectionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgsDict']]]]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNatRuleCollectionArgsDict']]]]] = None,
                 network_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgsDict']]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Firewall Policy Rule Collection Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_firewall_policy = azure.network.FirewallPolicy("example",
            name="example-fwpolicy",
            resource_group_name=example.name,
            location=example.location)
        example_firewall_policy_rule_collection_group = azure.network.FirewallPolicyRuleCollectionGroup("example",
            name="example-fwpolicy-rcg",
            firewall_policy_id=example_firewall_policy.id,
            priority=500,
            application_rule_collections=[{
                "name": "app_rule_collection1",
                "priority": 500,
                "action": "Deny",
                "rules": [{
                    "name": "app_rule_collection1_rule1",
                    "protocols": [
                        {
                            "type": "Http",
                            "port": 80,
                        },
                        {
                            "type": "Https",
                            "port": 443,
                        },
                    ],
                    "source_addresses": ["10.0.0.1"],
                    "destination_fqdns": ["*.microsoft.com"],
                }],
            }],
            network_rule_collections=[{
                "name": "network_rule_collection1",
                "priority": 400,
                "action": "Deny",
                "rules": [{
                    "name": "network_rule_collection1_rule1",
                    "protocols": [
                        "TCP",
                        "UDP",
                    ],
                    "source_addresses": ["10.0.0.1"],
                    "destination_addresses": [
                        "192.168.1.1",
                        "192.168.1.2",
                    ],
                    "destination_ports": [
                        "80",
                        "1000-2000",
                    ],
                }],
            }],
            nat_rule_collections=[{
                "name": "nat_rule_collection1",
                "priority": 300,
                "action": "Dnat",
                "rules": [{
                    "name": "nat_rule_collection1_rule1",
                    "protocols": [
                        "TCP",
                        "UDP",
                    ],
                    "source_addresses": [
                        "10.0.0.1",
                        "10.0.0.2",
                    ],
                    "destination_address": "192.168.1.1",
                    "destination_ports": "80",
                    "translated_address": "192.168.0.1",
                    "translated_port": 8080,
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Firewall Policy Rule Collection Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/firewallPolicyRuleCollectionGroup:FirewallPolicyRuleCollectionGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/firewallPolicies/policy1/ruleCollectionGroups/gruop1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgsDict']]]] application_rule_collections: One or more `application_rule_collection` blocks as defined below.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy where the Firewall Policy Rule Collection Group should exist. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy Rule Collection Group. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNatRuleCollectionArgsDict']]]] nat_rule_collections: One or more `nat_rule_collection` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgsDict']]]] network_rule_collections: One or more `network_rule_collection` blocks as defined below.
        :param pulumi.Input[_builtins.int] priority: The priority of the Firewall Policy Rule Collection Group. The range is 100-65000.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallPolicyRuleCollectionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Firewall Policy Rule Collection Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_firewall_policy = azure.network.FirewallPolicy("example",
            name="example-fwpolicy",
            resource_group_name=example.name,
            location=example.location)
        example_firewall_policy_rule_collection_group = azure.network.FirewallPolicyRuleCollectionGroup("example",
            name="example-fwpolicy-rcg",
            firewall_policy_id=example_firewall_policy.id,
            priority=500,
            application_rule_collections=[{
                "name": "app_rule_collection1",
                "priority": 500,
                "action": "Deny",
                "rules": [{
                    "name": "app_rule_collection1_rule1",
                    "protocols": [
                        {
                            "type": "Http",
                            "port": 80,
                        },
                        {
                            "type": "Https",
                            "port": 443,
                        },
                    ],
                    "source_addresses": ["10.0.0.1"],
                    "destination_fqdns": ["*.microsoft.com"],
                }],
            }],
            network_rule_collections=[{
                "name": "network_rule_collection1",
                "priority": 400,
                "action": "Deny",
                "rules": [{
                    "name": "network_rule_collection1_rule1",
                    "protocols": [
                        "TCP",
                        "UDP",
                    ],
                    "source_addresses": ["10.0.0.1"],
                    "destination_addresses": [
                        "192.168.1.1",
                        "192.168.1.2",
                    ],
                    "destination_ports": [
                        "80",
                        "1000-2000",
                    ],
                }],
            }],
            nat_rule_collections=[{
                "name": "nat_rule_collection1",
                "priority": 300,
                "action": "Dnat",
                "rules": [{
                    "name": "nat_rule_collection1_rule1",
                    "protocols": [
                        "TCP",
                        "UDP",
                    ],
                    "source_addresses": [
                        "10.0.0.1",
                        "10.0.0.2",
                    ],
                    "destination_address": "192.168.1.1",
                    "destination_ports": "80",
                    "translated_address": "192.168.0.1",
                    "translated_port": 8080,
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Firewall Policy Rule Collection Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/firewallPolicyRuleCollectionGroup:FirewallPolicyRuleCollectionGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/firewallPolicies/policy1/ruleCollectionGroups/gruop1
        ```

        :param str resource_name: The name of the resource.
        :param FirewallPolicyRuleCollectionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallPolicyRuleCollectionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgsDict']]]]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNatRuleCollectionArgsDict']]]]] = None,
                 network_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgsDict']]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallPolicyRuleCollectionGroupArgs.__new__(FirewallPolicyRuleCollectionGroupArgs)

            __props__.__dict__["application_rule_collections"] = application_rule_collections
            if firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_policy_id'")
            __props__.__dict__["firewall_policy_id"] = firewall_policy_id
            __props__.__dict__["name"] = name
            __props__.__dict__["nat_rule_collections"] = nat_rule_collections
            __props__.__dict__["network_rule_collections"] = network_rule_collections
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
        super(FirewallPolicyRuleCollectionGroup, __self__).__init__(
            'azure:network/firewallPolicyRuleCollectionGroup:FirewallPolicyRuleCollectionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgsDict']]]]] = None,
            firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNatRuleCollectionArgsDict']]]]] = None,
            network_rule_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgsDict']]]]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None) -> 'FirewallPolicyRuleCollectionGroup':
        """
        Get an existing FirewallPolicyRuleCollectionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupApplicationRuleCollectionArgsDict']]]] application_rule_collections: One or more `application_rule_collection` blocks as defined below.
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Firewall Policy where the Firewall Policy Rule Collection Group should exist. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Firewall Policy Rule Collection Group. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNatRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNatRuleCollectionArgsDict']]]] nat_rule_collections: One or more `nat_rule_collection` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgs', 'FirewallPolicyRuleCollectionGroupNetworkRuleCollectionArgsDict']]]] network_rule_collections: One or more `network_rule_collection` blocks as defined below.
        :param pulumi.Input[_builtins.int] priority: The priority of the Firewall Policy Rule Collection Group. The range is 100-65000.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallPolicyRuleCollectionGroupState.__new__(_FirewallPolicyRuleCollectionGroupState)

        __props__.__dict__["application_rule_collections"] = application_rule_collections
        __props__.__dict__["firewall_policy_id"] = firewall_policy_id
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_rule_collections"] = nat_rule_collections
        __props__.__dict__["network_rule_collections"] = network_rule_collections
        __props__.__dict__["priority"] = priority
        return FirewallPolicyRuleCollectionGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationRuleCollections")
    def application_rule_collections(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyRuleCollectionGroupApplicationRuleCollection']]]:
        """
        One or more `application_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "application_rule_collections")

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Firewall Policy where the Firewall Policy Rule Collection Group should exist. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        """
        return pulumi.get(self, "firewall_policy_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Firewall Policy Rule Collection Group. Changing this forces a new Firewall Policy Rule Collection Group to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natRuleCollections")
    def nat_rule_collections(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyRuleCollectionGroupNatRuleCollection']]]:
        """
        One or more `nat_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "nat_rule_collections")

    @_builtins.property
    @pulumi.getter(name="networkRuleCollections")
    def network_rule_collections(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyRuleCollectionGroupNetworkRuleCollection']]]:
        """
        One or more `network_rule_collection` blocks as defined below.
        """
        return pulumi.get(self, "network_rule_collections")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of the Firewall Policy Rule Collection Group. The range is 100-65000.
        """
        return pulumi.get(self, "priority")

