# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLocalNetworkGatewayResult',
    'AwaitableGetLocalNetworkGatewayResult',
    'get_local_network_gateway',
    'get_local_network_gateway_output',
]

@pulumi.output_type
class GetLocalNetworkGatewayResult:
    """
    A collection of values returned by getLocalNetworkGateway.
    """
    def __init__(__self__, address_spaces=None, bgp_settings=None, gateway_address=None, gateway_fqdn=None, id=None, location=None, name=None, resource_group_name=None, tags=None):
        if address_spaces and not isinstance(address_spaces, list):
            raise TypeError("Expected argument 'address_spaces' to be a list")
        pulumi.set(__self__, "address_spaces", address_spaces)
        if bgp_settings and not isinstance(bgp_settings, list):
            raise TypeError("Expected argument 'bgp_settings' to be a list")
        pulumi.set(__self__, "bgp_settings", bgp_settings)
        if gateway_address and not isinstance(gateway_address, str):
            raise TypeError("Expected argument 'gateway_address' to be a str")
        pulumi.set(__self__, "gateway_address", gateway_address)
        if gateway_fqdn and not isinstance(gateway_fqdn, str):
            raise TypeError("Expected argument 'gateway_fqdn' to be a str")
        pulumi.set(__self__, "gateway_fqdn", gateway_fqdn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressSpaces")
    def address_spaces(self) -> Sequence[_builtins.str]:
        """
        The list of string CIDRs representing the address spaces the gateway exposes.
        """
        return pulumi.get(self, "address_spaces")

    @_builtins.property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Sequence['outputs.GetLocalNetworkGatewayBgpSettingResult']:
        """
        A `bgp_settings` block as defined below containing the Local Network Gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @_builtins.property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> _builtins.str:
        """
        The gateway IP address the Local Network Gateway uses.
        """
        return pulumi.get(self, "gateway_address")

    @_builtins.property
    @pulumi.getter(name="gatewayFqdn")
    def gateway_fqdn(self) -> _builtins.str:
        """
        The gateway FQDN the Local Network Gateway uses.
        """
        return pulumi.get(self, "gateway_fqdn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Local Network Gateway exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Local Network Gateway.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLocalNetworkGatewayResult(GetLocalNetworkGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocalNetworkGatewayResult(
            address_spaces=self.address_spaces,
            bgp_settings=self.bgp_settings,
            gateway_address=self.gateway_address,
            gateway_fqdn=self.gateway_fqdn,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_local_network_gateway(name: Optional[_builtins.str] = None,
                              resource_group_name: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocalNetworkGatewayResult:
    """
    Use this data source to access information about an existing Local Network Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_local_network_gateway(name="existing-local-network-gateway",
        resource_group_name="existing-resources")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Local Network Gateway.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Local Network Gateway exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getLocalNetworkGateway:getLocalNetworkGateway', __args__, opts=opts, typ=GetLocalNetworkGatewayResult).value

    return AwaitableGetLocalNetworkGatewayResult(
        address_spaces=pulumi.get(__ret__, 'address_spaces'),
        bgp_settings=pulumi.get(__ret__, 'bgp_settings'),
        gateway_address=pulumi.get(__ret__, 'gateway_address'),
        gateway_fqdn=pulumi.get(__ret__, 'gateway_fqdn'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_local_network_gateway_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                     resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocalNetworkGatewayResult]:
    """
    Use this data source to access information about an existing Local Network Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_local_network_gateway(name="existing-local-network-gateway",
        resource_group_name="existing-resources")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Local Network Gateway.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Local Network Gateway exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getLocalNetworkGateway:getLocalNetworkGateway', __args__, opts=opts, typ=GetLocalNetworkGatewayResult)
    return __ret__.apply(lambda __response__: GetLocalNetworkGatewayResult(
        address_spaces=pulumi.get(__response__, 'address_spaces'),
        bgp_settings=pulumi.get(__response__, 'bgp_settings'),
        gateway_address=pulumi.get(__response__, 'gateway_address'),
        gateway_fqdn=pulumi.get(__response__, 'gateway_fqdn'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
