# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkInterfaceResult',
    'AwaitableGetNetworkInterfaceResult',
    'get_network_interface',
    'get_network_interface_output',
]

@pulumi.output_type
class GetNetworkInterfaceResult:
    """
    A collection of values returned by getNetworkInterface.
    """
    def __init__(__self__, accelerated_networking_enabled=None, applied_dns_servers=None, dns_servers=None, id=None, internal_dns_name_label=None, ip_configurations=None, ip_forwarding_enabled=None, location=None, mac_address=None, name=None, network_security_group_id=None, private_ip_address=None, private_ip_addresses=None, resource_group_name=None, tags=None, virtual_machine_id=None):
        if accelerated_networking_enabled and not isinstance(accelerated_networking_enabled, bool):
            raise TypeError("Expected argument 'accelerated_networking_enabled' to be a bool")
        pulumi.set(__self__, "accelerated_networking_enabled", accelerated_networking_enabled)
        if applied_dns_servers and not isinstance(applied_dns_servers, list):
            raise TypeError("Expected argument 'applied_dns_servers' to be a list")
        pulumi.set(__self__, "applied_dns_servers", applied_dns_servers)
        if dns_servers and not isinstance(dns_servers, list):
            raise TypeError("Expected argument 'dns_servers' to be a list")
        pulumi.set(__self__, "dns_servers", dns_servers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_dns_name_label and not isinstance(internal_dns_name_label, str):
            raise TypeError("Expected argument 'internal_dns_name_label' to be a str")
        pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)
        if ip_configurations and not isinstance(ip_configurations, list):
            raise TypeError("Expected argument 'ip_configurations' to be a list")
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        if ip_forwarding_enabled and not isinstance(ip_forwarding_enabled, bool):
            raise TypeError("Expected argument 'ip_forwarding_enabled' to be a bool")
        pulumi.set(__self__, "ip_forwarding_enabled", ip_forwarding_enabled)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mac_address and not isinstance(mac_address, str):
            raise TypeError("Expected argument 'mac_address' to be a str")
        pulumi.set(__self__, "mac_address", mac_address)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_security_group_id and not isinstance(network_security_group_id, str):
            raise TypeError("Expected argument 'network_security_group_id' to be a str")
        pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if private_ip_address and not isinstance(private_ip_address, str):
            raise TypeError("Expected argument 'private_ip_address' to be a str")
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_addresses and not isinstance(private_ip_addresses, list):
            raise TypeError("Expected argument 'private_ip_addresses' to be a list")
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if virtual_machine_id and not isinstance(virtual_machine_id, str):
            raise TypeError("Expected argument 'virtual_machine_id' to be a str")
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> _builtins.bool:
        """
        Indicates if accelerated networking is set on the specified Network Interface.
        """
        return pulumi.get(self, "accelerated_networking_enabled")

    @_builtins.property
    @pulumi.getter(name="appliedDnsServers")
    def applied_dns_servers(self) -> Sequence[_builtins.str]:
        """
        List of DNS servers applied to the specified Network Interface.
        """
        return pulumi.get(self, "applied_dns_servers")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[_builtins.str]:
        """
        The list of DNS servers used by the specified Network Interface.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> _builtins.str:
        """
        The internal DNS name label of the specified Network Interface.
        """
        return pulumi.get(self, "internal_dns_name_label")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetNetworkInterfaceIpConfigurationResult']:
        """
        One or more `ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter(name="ipForwardingEnabled")
    def ip_forwarding_enabled(self) -> _builtins.bool:
        """
        Indicate if IP forwarding is set on the specified Network Interface.
        """
        return pulumi.get(self, "ip_forwarding_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location of the specified Network Interface.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        The MAC address used by the specified Network Interface.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the IP Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> _builtins.str:
        """
        The ID of the network security group associated to the specified Network Interface.
        """
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        """
        The Private IP Address assigned to this Network Interface.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        The list of private IP addresses associates to the specified Network Interface.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        List the tags associated to the specified Network Interface.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> _builtins.str:
        """
        The ID of the virtual machine that the specified Network Interface is attached to.
        """
        return pulumi.get(self, "virtual_machine_id")


class AwaitableGetNetworkInterfaceResult(GetNetworkInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkInterfaceResult(
            accelerated_networking_enabled=self.accelerated_networking_enabled,
            applied_dns_servers=self.applied_dns_servers,
            dns_servers=self.dns_servers,
            id=self.id,
            internal_dns_name_label=self.internal_dns_name_label,
            ip_configurations=self.ip_configurations,
            ip_forwarding_enabled=self.ip_forwarding_enabled,
            location=self.location,
            mac_address=self.mac_address,
            name=self.name,
            network_security_group_id=self.network_security_group_id,
            private_ip_address=self.private_ip_address,
            private_ip_addresses=self.private_ip_addresses,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            virtual_machine_id=self.virtual_machine_id)


def get_network_interface(name: Optional[_builtins.str] = None,
                          resource_group_name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkInterfaceResult:
    """
    Use this data source to access information about an existing Network Interface.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_network_interface(name="acctest-nic",
        resource_group_name="networking")
    pulumi.export("networkInterfaceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: Specifies the name of the Network Interface.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Network Interface is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getNetworkInterface:getNetworkInterface', __args__, opts=opts, typ=GetNetworkInterfaceResult).value

    return AwaitableGetNetworkInterfaceResult(
        accelerated_networking_enabled=pulumi.get(__ret__, 'accelerated_networking_enabled'),
        applied_dns_servers=pulumi.get(__ret__, 'applied_dns_servers'),
        dns_servers=pulumi.get(__ret__, 'dns_servers'),
        id=pulumi.get(__ret__, 'id'),
        internal_dns_name_label=pulumi.get(__ret__, 'internal_dns_name_label'),
        ip_configurations=pulumi.get(__ret__, 'ip_configurations'),
        ip_forwarding_enabled=pulumi.get(__ret__, 'ip_forwarding_enabled'),
        location=pulumi.get(__ret__, 'location'),
        mac_address=pulumi.get(__ret__, 'mac_address'),
        name=pulumi.get(__ret__, 'name'),
        network_security_group_id=pulumi.get(__ret__, 'network_security_group_id'),
        private_ip_address=pulumi.get(__ret__, 'private_ip_address'),
        private_ip_addresses=pulumi.get(__ret__, 'private_ip_addresses'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        virtual_machine_id=pulumi.get(__ret__, 'virtual_machine_id'))
def get_network_interface_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkInterfaceResult]:
    """
    Use this data source to access information about an existing Network Interface.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_network_interface(name="acctest-nic",
        resource_group_name="networking")
    pulumi.export("networkInterfaceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: Specifies the name of the Network Interface.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Network Interface is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getNetworkInterface:getNetworkInterface', __args__, opts=opts, typ=GetNetworkInterfaceResult)
    return __ret__.apply(lambda __response__: GetNetworkInterfaceResult(
        accelerated_networking_enabled=pulumi.get(__response__, 'accelerated_networking_enabled'),
        applied_dns_servers=pulumi.get(__response__, 'applied_dns_servers'),
        dns_servers=pulumi.get(__response__, 'dns_servers'),
        id=pulumi.get(__response__, 'id'),
        internal_dns_name_label=pulumi.get(__response__, 'internal_dns_name_label'),
        ip_configurations=pulumi.get(__response__, 'ip_configurations'),
        ip_forwarding_enabled=pulumi.get(__response__, 'ip_forwarding_enabled'),
        location=pulumi.get(__response__, 'location'),
        mac_address=pulumi.get(__response__, 'mac_address'),
        name=pulumi.get(__response__, 'name'),
        network_security_group_id=pulumi.get(__response__, 'network_security_group_id'),
        private_ip_address=pulumi.get(__response__, 'private_ip_address'),
        private_ip_addresses=pulumi.get(__response__, 'private_ip_addresses'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        virtual_machine_id=pulumi.get(__response__, 'virtual_machine_id')))
