# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkManagerResult',
    'AwaitableGetNetworkManagerResult',
    'get_network_manager',
    'get_network_manager_output',
]

@pulumi.output_type
class GetNetworkManagerResult:
    """
    A collection of values returned by getNetworkManager.
    """
    def __init__(__self__, cross_tenant_scopes=None, description=None, id=None, location=None, name=None, resource_group_name=None, scope_accesses=None, scopes=None, tags=None):
        if cross_tenant_scopes and not isinstance(cross_tenant_scopes, list):
            raise TypeError("Expected argument 'cross_tenant_scopes' to be a list")
        pulumi.set(__self__, "cross_tenant_scopes", cross_tenant_scopes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scope_accesses and not isinstance(scope_accesses, list):
            raise TypeError("Expected argument 'scope_accesses' to be a list")
        pulumi.set(__self__, "scope_accesses", scope_accesses)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="crossTenantScopes")
    def cross_tenant_scopes(self) -> Sequence['outputs.GetNetworkManagerCrossTenantScopeResult']:
        """
        One or more `cross_tenant_scopes` blocks as defined below.
        """
        return pulumi.get(self, "cross_tenant_scopes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the Network Manager.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Network Manager exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scopeAccesses")
    def scope_accesses(self) -> Sequence[_builtins.str]:
        """
        A list of configuration deployment type configured on the Network Manager.
        """
        return pulumi.get(self, "scope_accesses")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.GetNetworkManagerScopeResult']:
        """
        A `scope` block as defined below.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Network Manager.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkManagerResult(GetNetworkManagerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkManagerResult(
            cross_tenant_scopes=self.cross_tenant_scopes,
            description=self.description,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            scope_accesses=self.scope_accesses,
            scopes=self.scopes,
            tags=self.tags)


def get_network_manager(name: Optional[_builtins.str] = None,
                        resource_group_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkManagerResult:
    """
    Use this data source to access information about a Network Manager.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    current = azure.core.get_subscription()
    example_network_manager = azure.network.NetworkManager("example",
        name="example-network-manager",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        scope={
            "subscription_ids": [current.id],
        },
        scope_accesses=[
            "Connectivity",
            "SecurityAdmin",
        ],
        description="example network manager")
    example = azure.network.get_network_manager_output(name=example_network_manager.name,
        resource_group_name=example_network_manager.resource_group_name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Network Manager.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Network Manager exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getNetworkManager:getNetworkManager', __args__, opts=opts, typ=GetNetworkManagerResult).value

    return AwaitableGetNetworkManagerResult(
        cross_tenant_scopes=pulumi.get(__ret__, 'cross_tenant_scopes'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        scope_accesses=pulumi.get(__ret__, 'scope_accesses'),
        scopes=pulumi.get(__ret__, 'scopes'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_manager_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkManagerResult]:
    """
    Use this data source to access information about a Network Manager.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    current = azure.core.get_subscription()
    example_network_manager = azure.network.NetworkManager("example",
        name="example-network-manager",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        scope={
            "subscription_ids": [current.id],
        },
        scope_accesses=[
            "Connectivity",
            "SecurityAdmin",
        ],
        description="example network manager")
    example = azure.network.get_network_manager_output(name=example_network_manager.name,
        resource_group_name=example_network_manager.resource_group_name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Network Manager.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Network Manager exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getNetworkManager:getNetworkManager', __args__, opts=opts, typ=GetNetworkManagerResult)
    return __ret__.apply(lambda __response__: GetNetworkManagerResult(
        cross_tenant_scopes=pulumi.get(__response__, 'cross_tenant_scopes'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        scope_accesses=pulumi.get(__response__, 'scope_accesses'),
        scopes=pulumi.get(__response__, 'scopes'),
        tags=pulumi.get(__response__, 'tags')))
