# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkManagerIpamPoolResult',
    'AwaitableGetNetworkManagerIpamPoolResult',
    'get_network_manager_ipam_pool',
    'get_network_manager_ipam_pool_output',
]

@pulumi.output_type
class GetNetworkManagerIpamPoolResult:
    """
    A collection of values returned by getNetworkManagerIpamPool.
    """
    def __init__(__self__, address_prefixes=None, description=None, display_name=None, id=None, location=None, name=None, network_manager_id=None, parent_pool_name=None, tags=None):
        if address_prefixes and not isinstance(address_prefixes, list):
            raise TypeError("Expected argument 'address_prefixes' to be a list")
        pulumi.set(__self__, "address_prefixes", address_prefixes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_manager_id and not isinstance(network_manager_id, str):
            raise TypeError("Expected argument 'network_manager_id' to be a str")
        pulumi.set(__self__, "network_manager_id", network_manager_id)
        if parent_pool_name and not isinstance(parent_pool_name, str):
            raise TypeError("Expected argument 'parent_pool_name' to be a str")
        pulumi.set(__self__, "parent_pool_name", parent_pool_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Sequence[_builtins.str]:
        """
        A list of IPv4 or IPv6 IP address prefixes assigned to the Network Manager IPAM Pool.
        """
        return pulumi.get(self, "address_prefixes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Network Manager IPAM Pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the Network Manager IPAM Pool.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Network Manager IPAM Pool exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> _builtins.str:
        return pulumi.get(self, "network_manager_id")

    @_builtins.property
    @pulumi.getter(name="parentPoolName")
    def parent_pool_name(self) -> _builtins.str:
        """
        The name of the parent IPAM Pool.
        """
        return pulumi.get(self, "parent_pool_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Network Manager IPAM Pool.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkManagerIpamPoolResult(GetNetworkManagerIpamPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkManagerIpamPoolResult(
            address_prefixes=self.address_prefixes,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            location=self.location,
            name=self.name,
            network_manager_id=self.network_manager_id,
            parent_pool_name=self.parent_pool_name,
            tags=self.tags)


def get_network_manager_ipam_pool(name: Optional[_builtins.str] = None,
                                  network_manager_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkManagerIpamPoolResult:
    """
    Use this data source to access information about an existing Network Manager IPAM Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    current = azure.core.get_subscription()
    example_network_manager = azure.network.NetworkManager("example",
        name="example-network-manager",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        scope={
            "subscription_ids": [current.id],
        })
    example_network_manager_ipam_pool = azure.network.NetworkManagerIpamPool("example",
        name="example-ipam-pool",
        location="West Europe",
        network_manager_id=example_network_manager.id,
        display_name="example-pool",
        address_prefixes=["10.0.0.0/24"])
    example = azure.network.get_network_manager_ipam_pool_output(name=example_network_manager_ipam_pool.name,
        network_manager_id=example_network_manager.id)
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of this Network Manager IPAM Pool.
    :param _builtins.str network_manager_id: The ID of the parent Network Manager.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkManagerId'] = network_manager_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getNetworkManagerIpamPool:getNetworkManagerIpamPool', __args__, opts=opts, typ=GetNetworkManagerIpamPoolResult).value

    return AwaitableGetNetworkManagerIpamPoolResult(
        address_prefixes=pulumi.get(__ret__, 'address_prefixes'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        network_manager_id=pulumi.get(__ret__, 'network_manager_id'),
        parent_pool_name=pulumi.get(__ret__, 'parent_pool_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_manager_ipam_pool_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                         network_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkManagerIpamPoolResult]:
    """
    Use this data source to access information about an existing Network Manager IPAM Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    current = azure.core.get_subscription()
    example_network_manager = azure.network.NetworkManager("example",
        name="example-network-manager",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        scope={
            "subscription_ids": [current.id],
        })
    example_network_manager_ipam_pool = azure.network.NetworkManagerIpamPool("example",
        name="example-ipam-pool",
        location="West Europe",
        network_manager_id=example_network_manager.id,
        display_name="example-pool",
        address_prefixes=["10.0.0.0/24"])
    example = azure.network.get_network_manager_ipam_pool_output(name=example_network_manager_ipam_pool.name,
        network_manager_id=example_network_manager.id)
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of this Network Manager IPAM Pool.
    :param _builtins.str network_manager_id: The ID of the parent Network Manager.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkManagerId'] = network_manager_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getNetworkManagerIpamPool:getNetworkManagerIpamPool', __args__, opts=opts, typ=GetNetworkManagerIpamPoolResult)
    return __ret__.apply(lambda __response__: GetNetworkManagerIpamPoolResult(
        address_prefixes=pulumi.get(__response__, 'address_prefixes'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        network_manager_id=pulumi.get(__response__, 'network_manager_id'),
        parent_pool_name=pulumi.get(__response__, 'parent_pool_name'),
        tags=pulumi.get(__response__, 'tags')))
