# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVirtualHubResult',
    'AwaitableGetVirtualHubResult',
    'get_virtual_hub',
    'get_virtual_hub_output',
]

@pulumi.output_type
class GetVirtualHubResult:
    """
    A collection of values returned by getVirtualHub.
    """
    def __init__(__self__, address_prefix=None, default_route_table_id=None, id=None, location=None, name=None, resource_group_name=None, tags=None, virtual_router_asn=None, virtual_router_ips=None, virtual_wan_id=None):
        if address_prefix and not isinstance(address_prefix, str):
            raise TypeError("Expected argument 'address_prefix' to be a str")
        pulumi.set(__self__, "address_prefix", address_prefix)
        if default_route_table_id and not isinstance(default_route_table_id, str):
            raise TypeError("Expected argument 'default_route_table_id' to be a str")
        pulumi.set(__self__, "default_route_table_id", default_route_table_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if virtual_router_asn and not isinstance(virtual_router_asn, int):
            raise TypeError("Expected argument 'virtual_router_asn' to be a int")
        pulumi.set(__self__, "virtual_router_asn", virtual_router_asn)
        if virtual_router_ips and not isinstance(virtual_router_ips, list):
            raise TypeError("Expected argument 'virtual_router_ips' to be a list")
        pulumi.set(__self__, "virtual_router_ips", virtual_router_ips)
        if virtual_wan_id and not isinstance(virtual_wan_id, str):
            raise TypeError("Expected argument 'virtual_wan_id' to be a str")
        pulumi.set(__self__, "virtual_wan_id", virtual_wan_id)

    @_builtins.property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> _builtins.str:
        """
        The Address Prefix used for this Virtual Hub.
        """
        return pulumi.get(self, "address_prefix")

    @_builtins.property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> _builtins.str:
        """
        The ID of the default Route Table in the Virtual Hub.
        """
        return pulumi.get(self, "default_route_table_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Virtual Hub exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Virtual Hub.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualRouterAsn")
    def virtual_router_asn(self) -> _builtins.int:
        """
        The Autonomous System Number of the Virtual Hub BGP router.
        """
        return pulumi.get(self, "virtual_router_asn")

    @_builtins.property
    @pulumi.getter(name="virtualRouterIps")
    def virtual_router_ips(self) -> Sequence[_builtins.str]:
        """
        The IP addresses of the Virtual Hub BGP router.
        """
        return pulumi.get(self, "virtual_router_ips")

    @_builtins.property
    @pulumi.getter(name="virtualWanId")
    def virtual_wan_id(self) -> _builtins.str:
        """
        The ID of the Virtual WAN within which the Virtual Hub exists.
        """
        return pulumi.get(self, "virtual_wan_id")


class AwaitableGetVirtualHubResult(GetVirtualHubResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualHubResult(
            address_prefix=self.address_prefix,
            default_route_table_id=self.default_route_table_id,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            virtual_router_asn=self.virtual_router_asn,
            virtual_router_ips=self.virtual_router_ips,
            virtual_wan_id=self.virtual_wan_id)


def get_virtual_hub(name: Optional[_builtins.str] = None,
                    resource_group_name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualHubResult:
    """
    Uses this data source to access information about an existing Virtual Hub.

    ## Virtual Hub Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_hub(name="example-hub",
        resource_group_name="example-resources")
    pulumi.export("virtualHubId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Virtual Hub.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Virtual Hub exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getVirtualHub:getVirtualHub', __args__, opts=opts, typ=GetVirtualHubResult).value

    return AwaitableGetVirtualHubResult(
        address_prefix=pulumi.get(__ret__, 'address_prefix'),
        default_route_table_id=pulumi.get(__ret__, 'default_route_table_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        virtual_router_asn=pulumi.get(__ret__, 'virtual_router_asn'),
        virtual_router_ips=pulumi.get(__ret__, 'virtual_router_ips'),
        virtual_wan_id=pulumi.get(__ret__, 'virtual_wan_id'))
def get_virtual_hub_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualHubResult]:
    """
    Uses this data source to access information about an existing Virtual Hub.

    ## Virtual Hub Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_hub(name="example-hub",
        resource_group_name="example-resources")
    pulumi.export("virtualHubId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Virtual Hub.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Virtual Hub exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getVirtualHub:getVirtualHub', __args__, opts=opts, typ=GetVirtualHubResult)
    return __ret__.apply(lambda __response__: GetVirtualHubResult(
        address_prefix=pulumi.get(__response__, 'address_prefix'),
        default_route_table_id=pulumi.get(__response__, 'default_route_table_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        virtual_router_asn=pulumi.get(__response__, 'virtual_router_asn'),
        virtual_router_ips=pulumi.get(__response__, 'virtual_router_ips'),
        virtual_wan_id=pulumi.get(__response__, 'virtual_wan_id')))
