# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualHubRouteTableResult',
    'AwaitableGetVirtualHubRouteTableResult',
    'get_virtual_hub_route_table',
    'get_virtual_hub_route_table_output',
]

@pulumi.output_type
class GetVirtualHubRouteTableResult:
    """
    A collection of values returned by getVirtualHubRouteTable.
    """
    def __init__(__self__, id=None, labels=None, name=None, resource_group_name=None, routes=None, virtual_hub_id=None, virtual_hub_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, list):
            raise TypeError("Expected argument 'labels' to be a list")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if virtual_hub_id and not isinstance(virtual_hub_id, str):
            raise TypeError("Expected argument 'virtual_hub_id' to be a str")
        pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)
        if virtual_hub_name and not isinstance(virtual_hub_name, str):
            raise TypeError("Expected argument 'virtual_hub_name' to be a str")
        pulumi.set(__self__, "virtual_hub_name", virtual_hub_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Sequence[_builtins.str]:
        """
        List of labels associated with this route table.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which is used for this route.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetVirtualHubRouteTableRouteResult']:
        """
        A `route` block as defined below.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> _builtins.str:
        """
        The ID of the Virtual Hub within which this route table is created
        """
        return pulumi.get(self, "virtual_hub_id")

    @_builtins.property
    @pulumi.getter(name="virtualHubName")
    def virtual_hub_name(self) -> _builtins.str:
        return pulumi.get(self, "virtual_hub_name")


class AwaitableGetVirtualHubRouteTableResult(GetVirtualHubRouteTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualHubRouteTableResult(
            id=self.id,
            labels=self.labels,
            name=self.name,
            resource_group_name=self.resource_group_name,
            routes=self.routes,
            virtual_hub_id=self.virtual_hub_id,
            virtual_hub_name=self.virtual_hub_name)


def get_virtual_hub_route_table(name: Optional[_builtins.str] = None,
                                resource_group_name: Optional[_builtins.str] = None,
                                virtual_hub_name: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualHubRouteTableResult:
    """
    Uses this data source to access information about an existing Virtual Hub Route Table.

    ## Virtual Hub Route Table Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_hub_route_table(name="example-hub-route-table",
        resource_group_name="example-resources",
        virtual_hub_name="example-hub-name")
    pulumi.export("virtualHubRouteTableId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Virtual Hub Route Table.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Virtual Hub Route Table exists.
    :param _builtins.str virtual_hub_name: The name which should be used for Virtual Hub Route Table.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualHubName'] = virtual_hub_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getVirtualHubRouteTable:getVirtualHubRouteTable', __args__, opts=opts, typ=GetVirtualHubRouteTableResult).value

    return AwaitableGetVirtualHubRouteTableResult(
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        routes=pulumi.get(__ret__, 'routes'),
        virtual_hub_id=pulumi.get(__ret__, 'virtual_hub_id'),
        virtual_hub_name=pulumi.get(__ret__, 'virtual_hub_name'))
def get_virtual_hub_route_table_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                       virtual_hub_name: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualHubRouteTableResult]:
    """
    Uses this data source to access information about an existing Virtual Hub Route Table.

    ## Virtual Hub Route Table Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_hub_route_table(name="example-hub-route-table",
        resource_group_name="example-resources",
        virtual_hub_name="example-hub-name")
    pulumi.export("virtualHubRouteTableId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The name of the Virtual Hub Route Table.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Virtual Hub Route Table exists.
    :param _builtins.str virtual_hub_name: The name which should be used for Virtual Hub Route Table.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualHubName'] = virtual_hub_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getVirtualHubRouteTable:getVirtualHubRouteTable', __args__, opts=opts, typ=GetVirtualHubRouteTableResult)
    return __ret__.apply(lambda __response__: GetVirtualHubRouteTableResult(
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        routes=pulumi.get(__response__, 'routes'),
        virtual_hub_id=pulumi.get(__response__, 'virtual_hub_id'),
        virtual_hub_name=pulumi.get(__response__, 'virtual_hub_name')))
