# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualNetworkGatewayResult',
    'AwaitableGetVirtualNetworkGatewayResult',
    'get_virtual_network_gateway',
    'get_virtual_network_gateway_output',
]

@pulumi.output_type
class GetVirtualNetworkGatewayResult:
    """
    A collection of values returned by getVirtualNetworkGateway.
    """
    def __init__(__self__, active_active=None, bgp_settings=None, custom_routes=None, default_local_network_gateway_id=None, enable_bgp=None, generation=None, id=None, ip_configurations=None, location=None, name=None, private_ip_address_enabled=None, resource_group_name=None, sku=None, tags=None, type=None, vpn_client_configurations=None, vpn_type=None):
        if active_active and not isinstance(active_active, bool):
            raise TypeError("Expected argument 'active_active' to be a bool")
        pulumi.set(__self__, "active_active", active_active)
        if bgp_settings and not isinstance(bgp_settings, list):
            raise TypeError("Expected argument 'bgp_settings' to be a list")
        pulumi.set(__self__, "bgp_settings", bgp_settings)
        if custom_routes and not isinstance(custom_routes, list):
            raise TypeError("Expected argument 'custom_routes' to be a list")
        pulumi.set(__self__, "custom_routes", custom_routes)
        if default_local_network_gateway_id and not isinstance(default_local_network_gateway_id, str):
            raise TypeError("Expected argument 'default_local_network_gateway_id' to be a str")
        pulumi.set(__self__, "default_local_network_gateway_id", default_local_network_gateway_id)
        if enable_bgp and not isinstance(enable_bgp, bool):
            raise TypeError("Expected argument 'enable_bgp' to be a bool")
        pulumi.set(__self__, "enable_bgp", enable_bgp)
        if generation and not isinstance(generation, str):
            raise TypeError("Expected argument 'generation' to be a str")
        pulumi.set(__self__, "generation", generation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_configurations and not isinstance(ip_configurations, list):
            raise TypeError("Expected argument 'ip_configurations' to be a list")
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_ip_address_enabled and not isinstance(private_ip_address_enabled, bool):
            raise TypeError("Expected argument 'private_ip_address_enabled' to be a bool")
        pulumi.set(__self__, "private_ip_address_enabled", private_ip_address_enabled)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vpn_client_configurations and not isinstance(vpn_client_configurations, list):
            raise TypeError("Expected argument 'vpn_client_configurations' to be a list")
        pulumi.set(__self__, "vpn_client_configurations", vpn_client_configurations)
        if vpn_type and not isinstance(vpn_type, str):
            raise TypeError("Expected argument 'vpn_type' to be a str")
        pulumi.set(__self__, "vpn_type", vpn_type)

    @_builtins.property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> _builtins.bool:
        """
        Is this an Active-Active Gateway?
        """
        return pulumi.get(self, "active_active")

    @_builtins.property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Sequence['outputs.GetVirtualNetworkGatewayBgpSettingResult']:
        return pulumi.get(self, "bgp_settings")

    @_builtins.property
    @pulumi.getter(name="customRoutes")
    def custom_routes(self) -> Sequence['outputs.GetVirtualNetworkGatewayCustomRouteResult']:
        return pulumi.get(self, "custom_routes")

    @_builtins.property
    @pulumi.getter(name="defaultLocalNetworkGatewayId")
    def default_local_network_gateway_id(self) -> _builtins.str:
        """
        The ID of the local network gateway
        through which outbound Internet traffic from the virtual network in which the
        gateway is created will be routed (*forced tunneling*). Refer to the
        [Azure documentation on forced tunneling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm).
        """
        return pulumi.get(self, "default_local_network_gateway_id")

    @_builtins.property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> _builtins.bool:
        """
        Will BGP (Border Gateway Protocol) will be enabled
        for this Virtual Network Gateway.
        """
        return pulumi.get(self, "enable_bgp")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> _builtins.str:
        """
        The Generation of the Virtual Network Gateway.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetVirtualNetworkGatewayIpConfigurationResult']:
        """
        One or two `ip_configuration` blocks documented below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location/region where the Virtual Network Gateway is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The user-defined name of the root certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIpAddressEnabled")
    def private_ip_address_enabled(self) -> _builtins.bool:
        """
        Whether a private IP will be used for this  gateway for connections.
        """
        return pulumi.get(self, "private_ip_address_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        Configuration of the size and capacity of the Virtual Network Gateway.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Virtual Network Gateway.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpnClientConfigurations")
    def vpn_client_configurations(self) -> Sequence['outputs.GetVirtualNetworkGatewayVpnClientConfigurationResult']:
        """
        A `vpn_client_configuration` block which is documented below.
        """
        return pulumi.get(self, "vpn_client_configurations")

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> _builtins.str:
        """
        The routing type of the Virtual Network Gateway.
        """
        return pulumi.get(self, "vpn_type")


class AwaitableGetVirtualNetworkGatewayResult(GetVirtualNetworkGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualNetworkGatewayResult(
            active_active=self.active_active,
            bgp_settings=self.bgp_settings,
            custom_routes=self.custom_routes,
            default_local_network_gateway_id=self.default_local_network_gateway_id,
            enable_bgp=self.enable_bgp,
            generation=self.generation,
            id=self.id,
            ip_configurations=self.ip_configurations,
            location=self.location,
            name=self.name,
            private_ip_address_enabled=self.private_ip_address_enabled,
            resource_group_name=self.resource_group_name,
            sku=self.sku,
            tags=self.tags,
            type=self.type,
            vpn_client_configurations=self.vpn_client_configurations,
            vpn_type=self.vpn_type)


def get_virtual_network_gateway(name: Optional[_builtins.str] = None,
                                resource_group_name: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualNetworkGatewayResult:
    """
    Use this data source to access information about an existing Virtual Network Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_network_gateway(name="production",
        resource_group_name="networking")
    pulumi.export("virtualNetworkGatewayId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: Specifies the name of the Virtual Network Gateway.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Virtual Network Gateway is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getVirtualNetworkGateway:getVirtualNetworkGateway', __args__, opts=opts, typ=GetVirtualNetworkGatewayResult).value

    return AwaitableGetVirtualNetworkGatewayResult(
        active_active=pulumi.get(__ret__, 'active_active'),
        bgp_settings=pulumi.get(__ret__, 'bgp_settings'),
        custom_routes=pulumi.get(__ret__, 'custom_routes'),
        default_local_network_gateway_id=pulumi.get(__ret__, 'default_local_network_gateway_id'),
        enable_bgp=pulumi.get(__ret__, 'enable_bgp'),
        generation=pulumi.get(__ret__, 'generation'),
        id=pulumi.get(__ret__, 'id'),
        ip_configurations=pulumi.get(__ret__, 'ip_configurations'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        private_ip_address_enabled=pulumi.get(__ret__, 'private_ip_address_enabled'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku=pulumi.get(__ret__, 'sku'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        vpn_client_configurations=pulumi.get(__ret__, 'vpn_client_configurations'),
        vpn_type=pulumi.get(__ret__, 'vpn_type'))
def get_virtual_network_gateway_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualNetworkGatewayResult]:
    """
    Use this data source to access information about an existing Virtual Network Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_network_gateway(name="production",
        resource_group_name="networking")
    pulumi.export("virtualNetworkGatewayId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: Specifies the name of the Virtual Network Gateway.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Virtual Network Gateway is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getVirtualNetworkGateway:getVirtualNetworkGateway', __args__, opts=opts, typ=GetVirtualNetworkGatewayResult)
    return __ret__.apply(lambda __response__: GetVirtualNetworkGatewayResult(
        active_active=pulumi.get(__response__, 'active_active'),
        bgp_settings=pulumi.get(__response__, 'bgp_settings'),
        custom_routes=pulumi.get(__response__, 'custom_routes'),
        default_local_network_gateway_id=pulumi.get(__response__, 'default_local_network_gateway_id'),
        enable_bgp=pulumi.get(__response__, 'enable_bgp'),
        generation=pulumi.get(__response__, 'generation'),
        id=pulumi.get(__response__, 'id'),
        ip_configurations=pulumi.get(__response__, 'ip_configurations'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        private_ip_address_enabled=pulumi.get(__response__, 'private_ip_address_enabled'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku=pulumi.get(__response__, 'sku'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        vpn_client_configurations=pulumi.get(__response__, 'vpn_client_configurations'),
        vpn_type=pulumi.get(__response__, 'vpn_type')))
