# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpnServerConfigurationResult',
    'AwaitableGetVpnServerConfigurationResult',
    'get_vpn_server_configuration',
    'get_vpn_server_configuration_output',
]

@pulumi.output_type
class GetVpnServerConfigurationResult:
    """
    A collection of values returned by getVpnServerConfiguration.
    """
    def __init__(__self__, azure_active_directory_authentications=None, client_revoked_certificates=None, client_root_certificates=None, id=None, ipsec_policies=None, location=None, name=None, radii=None, resource_group_name=None, tags=None, vpn_authentication_types=None, vpn_protocols=None):
        if azure_active_directory_authentications and not isinstance(azure_active_directory_authentications, list):
            raise TypeError("Expected argument 'azure_active_directory_authentications' to be a list")
        pulumi.set(__self__, "azure_active_directory_authentications", azure_active_directory_authentications)
        if client_revoked_certificates and not isinstance(client_revoked_certificates, list):
            raise TypeError("Expected argument 'client_revoked_certificates' to be a list")
        pulumi.set(__self__, "client_revoked_certificates", client_revoked_certificates)
        if client_root_certificates and not isinstance(client_root_certificates, list):
            raise TypeError("Expected argument 'client_root_certificates' to be a list")
        pulumi.set(__self__, "client_root_certificates", client_root_certificates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipsec_policies and not isinstance(ipsec_policies, list):
            raise TypeError("Expected argument 'ipsec_policies' to be a list")
        pulumi.set(__self__, "ipsec_policies", ipsec_policies)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if radii and not isinstance(radii, list):
            raise TypeError("Expected argument 'radii' to be a list")
        pulumi.set(__self__, "radii", radii)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpn_authentication_types and not isinstance(vpn_authentication_types, list):
            raise TypeError("Expected argument 'vpn_authentication_types' to be a list")
        pulumi.set(__self__, "vpn_authentication_types", vpn_authentication_types)
        if vpn_protocols and not isinstance(vpn_protocols, list):
            raise TypeError("Expected argument 'vpn_protocols' to be a list")
        pulumi.set(__self__, "vpn_protocols", vpn_protocols)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryAuthentications")
    def azure_active_directory_authentications(self) -> Sequence['outputs.GetVpnServerConfigurationAzureActiveDirectoryAuthenticationResult']:
        """
        A `azure_active_directory_authentication` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory_authentications")

    @_builtins.property
    @pulumi.getter(name="clientRevokedCertificates")
    def client_revoked_certificates(self) -> Sequence['outputs.GetVpnServerConfigurationClientRevokedCertificateResult']:
        """
        One or more `client_revoked_certificate` blocks as defined below.
        """
        return pulumi.get(self, "client_revoked_certificates")

    @_builtins.property
    @pulumi.getter(name="clientRootCertificates")
    def client_root_certificates(self) -> Sequence['outputs.GetVpnServerConfigurationClientRootCertificateResult']:
        """
        One or more `client_root_certificate` blocks as defined below.
        """
        return pulumi.get(self, "client_root_certificates")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipsecPolicies")
    def ipsec_policies(self) -> Sequence['outputs.GetVpnServerConfigurationIpsecPolicyResult']:
        """
        The `bgp_settings` block as defined below.
        """
        return pulumi.get(self, "ipsec_policies")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the VPN Server Configuration exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name used to uniquely identify this certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def radii(self) -> Sequence['outputs.GetVpnServerConfigurationRadiusResult']:
        """
        A `radius` block as defined below.
        """
        return pulumi.get(self, "radii")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the VPN Server Configuration.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpnAuthenticationTypes")
    def vpn_authentication_types(self) -> Sequence[_builtins.str]:
        """
        The list of Authentication Types applicable for the VPN Server Configuration.
        """
        return pulumi.get(self, "vpn_authentication_types")

    @_builtins.property
    @pulumi.getter(name="vpnProtocols")
    def vpn_protocols(self) -> Sequence[_builtins.str]:
        """
        The list of VPN Protocols to use for the VPN Server Configuration.
        """
        return pulumi.get(self, "vpn_protocols")


class AwaitableGetVpnServerConfigurationResult(GetVpnServerConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpnServerConfigurationResult(
            azure_active_directory_authentications=self.azure_active_directory_authentications,
            client_revoked_certificates=self.client_revoked_certificates,
            client_root_certificates=self.client_root_certificates,
            id=self.id,
            ipsec_policies=self.ipsec_policies,
            location=self.location,
            name=self.name,
            radii=self.radii,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            vpn_authentication_types=self.vpn_authentication_types,
            vpn_protocols=self.vpn_protocols)


def get_vpn_server_configuration(name: Optional[_builtins.str] = None,
                                 resource_group_name: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpnServerConfigurationResult:
    """
    Use this data source to access information about an existing VPN Server Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_vpn_server_configuration(name="existing-local-vpn-server-configuration",
        resource_group_name="existing-resource-group")
    pulumi.export("azurermVpnServerConfiguration", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The Name of the VPN Server Configuration.
    :param _builtins.str resource_group_name: The name of the Resource Group where the VPN Server Configuration exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getVpnServerConfiguration:getVpnServerConfiguration', __args__, opts=opts, typ=GetVpnServerConfigurationResult).value

    return AwaitableGetVpnServerConfigurationResult(
        azure_active_directory_authentications=pulumi.get(__ret__, 'azure_active_directory_authentications'),
        client_revoked_certificates=pulumi.get(__ret__, 'client_revoked_certificates'),
        client_root_certificates=pulumi.get(__ret__, 'client_root_certificates'),
        id=pulumi.get(__ret__, 'id'),
        ipsec_policies=pulumi.get(__ret__, 'ipsec_policies'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        radii=pulumi.get(__ret__, 'radii'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        vpn_authentication_types=pulumi.get(__ret__, 'vpn_authentication_types'),
        vpn_protocols=pulumi.get(__ret__, 'vpn_protocols'))
def get_vpn_server_configuration_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                        resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpnServerConfigurationResult]:
    """
    Use this data source to access information about an existing VPN Server Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_vpn_server_configuration(name="existing-local-vpn-server-configuration",
        resource_group_name="existing-resource-group")
    pulumi.export("azurermVpnServerConfiguration", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2025-01-01


    :param _builtins.str name: The Name of the VPN Server Configuration.
    :param _builtins.str resource_group_name: The name of the Resource Group where the VPN Server Configuration exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getVpnServerConfiguration:getVpnServerConfiguration', __args__, opts=opts, typ=GetVpnServerConfigurationResult)
    return __ret__.apply(lambda __response__: GetVpnServerConfigurationResult(
        azure_active_directory_authentications=pulumi.get(__response__, 'azure_active_directory_authentications'),
        client_revoked_certificates=pulumi.get(__response__, 'client_revoked_certificates'),
        client_root_certificates=pulumi.get(__response__, 'client_root_certificates'),
        id=pulumi.get(__response__, 'id'),
        ipsec_policies=pulumi.get(__response__, 'ipsec_policies'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        radii=pulumi.get(__response__, 'radii'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        vpn_authentication_types=pulumi.get(__response__, 'vpn_authentication_types'),
        vpn_protocols=pulumi.get(__response__, 'vpn_protocols')))
