# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IPGroupCIDRArgs', 'IPGroupCIDR']

@pulumi.input_type
class IPGroupCIDRArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[_builtins.str],
                 ip_group_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a IPGroupCIDR resource.
        :param pulumi.Input[_builtins.str] ip_group_id: The ID of the destination IP Group.
               Changing this forces a new IP Group CIDR to be created.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "ip_group_id", ip_group_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="ipGroupId")
    def ip_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the destination IP Group.
        Changing this forces a new IP Group CIDR to be created.
        """
        return pulumi.get(self, "ip_group_id")

    @ip_group_id.setter
    def ip_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_group_id", value)


@pulumi.input_type
class _IPGroupCIDRState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IPGroupCIDR resources.
        :param pulumi.Input[_builtins.str] ip_group_id: The ID of the destination IP Group.
               Changing this forces a new IP Group CIDR to be created.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if ip_group_id is not None:
            pulumi.set(__self__, "ip_group_id", ip_group_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="ipGroupId")
    def ip_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the destination IP Group.
        Changing this forces a new IP Group CIDR to be created.
        """
        return pulumi.get(self, "ip_group_id")

    @ip_group_id.setter
    def ip_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_group_id", value)


@pulumi.type_token("azure:network/iPGroupCIDR:IPGroupCIDR")
class IPGroupCIDR(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages IP Group CIDR records.

        > **Note:** Warning Do not use this resource at the same time as the `cidrs` property of the
        `network.IPGroup` resource for the same IP Group. Doing so will cause a conflict and
        CIDRS will be removed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="test-rg",
            location="West Europe")
        example_ip_group = azure.network.IPGroup("example",
            name="test-ipgroup",
            location=example.location,
            resource_group_name=example.name)
        example_ip_group_cidr = azure.network.IPGroupCIDR("example",
            ip_group_id=example_ip_group.id,
            cidr="10.10.10.0/24")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        IP Group CIDRs can be imported using the `resource id` of the IP Group and

        the CIDR value (`/` characters have to be replaced by `_`), e.g.

        ```sh
        $ pulumi import azure:network/iPGroupCIDR:IPGroupCIDR example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/ipGroups/test-ipgroup/cidrs/10.1.0.0_24
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip_group_id: The ID of the destination IP Group.
               Changing this forces a new IP Group CIDR to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IPGroupCIDRArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages IP Group CIDR records.

        > **Note:** Warning Do not use this resource at the same time as the `cidrs` property of the
        `network.IPGroup` resource for the same IP Group. Doing so will cause a conflict and
        CIDRS will be removed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="test-rg",
            location="West Europe")
        example_ip_group = azure.network.IPGroup("example",
            name="test-ipgroup",
            location=example.location,
            resource_group_name=example.name)
        example_ip_group_cidr = azure.network.IPGroupCIDR("example",
            ip_group_id=example_ip_group.id,
            cidr="10.10.10.0/24")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        IP Group CIDRs can be imported using the `resource id` of the IP Group and

        the CIDR value (`/` characters have to be replaced by `_`), e.g.

        ```sh
        $ pulumi import azure:network/iPGroupCIDR:IPGroupCIDR example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/ipGroups/test-ipgroup/cidrs/10.1.0.0_24
        ```

        :param str resource_name: The name of the resource.
        :param IPGroupCIDRArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IPGroupCIDRArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IPGroupCIDRArgs.__new__(IPGroupCIDRArgs)

            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            if ip_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'ip_group_id'")
            __props__.__dict__["ip_group_id"] = ip_group_id
        super(IPGroupCIDR, __self__).__init__(
            'azure:network/iPGroupCIDR:IPGroupCIDR',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            ip_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'IPGroupCIDR':
        """
        Get an existing IPGroupCIDR resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip_group_id: The ID of the destination IP Group.
               Changing this forces a new IP Group CIDR to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IPGroupCIDRState.__new__(_IPGroupCIDRState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["ip_group_id"] = ip_group_id
        return IPGroupCIDR(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="ipGroupId")
    def ip_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the destination IP Group.
        Changing this forces a new IP Group CIDR to be created.
        """
        return pulumi.get(self, "ip_group_id")

