# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkManagerConnectivityConfigurationArgs', 'NetworkManagerConnectivityConfiguration']

@pulumi.input_type
class NetworkManagerConnectivityConfigurationArgs:
    def __init__(__self__, *,
                 applies_to_groups: pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]],
                 connectivity_topology: pulumi.Input[_builtins.str],
                 network_manager_id: pulumi.Input[_builtins.str],
                 delete_existing_peering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 global_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub: Optional[pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerConnectivityConfiguration resource.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]] applies_to_groups: One or more `applies_to_group` blocks as defined below.
        :param pulumi.Input[_builtins.str] connectivity_topology: Specifies the connectivity topology type. Possible values are `HubAndSpoke` and `Mesh`.
        :param pulumi.Input[_builtins.str] network_manager_id: Specifies the ID of the Network Manager. Changing this forces a new Network Manager Connectivity Configuration to be created.
        :param pulumi.Input[_builtins.bool] delete_existing_peering_enabled: Indicates whether to remove current existing Virtual Network Peering in the Connectivity Configuration affected scope. Possible values are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: A description of the Connectivity Configuration.
        :param pulumi.Input[_builtins.bool] global_mesh_enabled: Indicates whether to global mesh is supported. Possible values are `true` and `false`.
        :param pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs'] hub: A `hub` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Connectivity Configuration. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        pulumi.set(__self__, "applies_to_groups", applies_to_groups)
        pulumi.set(__self__, "connectivity_topology", connectivity_topology)
        pulumi.set(__self__, "network_manager_id", network_manager_id)
        if delete_existing_peering_enabled is not None:
            pulumi.set(__self__, "delete_existing_peering_enabled", delete_existing_peering_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if global_mesh_enabled is not None:
            pulumi.set(__self__, "global_mesh_enabled", global_mesh_enabled)
        if hub is not None:
            pulumi.set(__self__, "hub", hub)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="appliesToGroups")
    def applies_to_groups(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]]:
        """
        One or more `applies_to_group` blocks as defined below.
        """
        return pulumi.get(self, "applies_to_groups")

    @applies_to_groups.setter
    def applies_to_groups(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]]):
        pulumi.set(self, "applies_to_groups", value)

    @_builtins.property
    @pulumi.getter(name="connectivityTopology")
    def connectivity_topology(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the connectivity topology type. Possible values are `HubAndSpoke` and `Mesh`.
        """
        return pulumi.get(self, "connectivity_topology")

    @connectivity_topology.setter
    def connectivity_topology(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connectivity_topology", value)

    @_builtins.property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Network Manager. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        return pulumi.get(self, "network_manager_id")

    @network_manager_id.setter
    def network_manager_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_manager_id", value)

    @_builtins.property
    @pulumi.getter(name="deleteExistingPeeringEnabled")
    def delete_existing_peering_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to remove current existing Virtual Network Peering in the Connectivity Configuration affected scope. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "delete_existing_peering_enabled")

    @delete_existing_peering_enabled.setter
    def delete_existing_peering_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_existing_peering_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the Connectivity Configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="globalMeshEnabled")
    def global_mesh_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to global mesh is supported. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "global_mesh_enabled")

    @global_mesh_enabled.setter
    def global_mesh_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "global_mesh_enabled", value)

    @_builtins.property
    @pulumi.getter
    def hub(self) -> Optional[pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs']]:
        """
        A `hub` block as defined below.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: Optional[pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs']]):
        pulumi.set(self, "hub", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Connectivity Configuration. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkManagerConnectivityConfigurationState:
    def __init__(__self__, *,
                 applies_to_groups: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]]] = None,
                 connectivity_topology: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_existing_peering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 global_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub: Optional[pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_manager_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerConnectivityConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]] applies_to_groups: One or more `applies_to_group` blocks as defined below.
        :param pulumi.Input[_builtins.str] connectivity_topology: Specifies the connectivity topology type. Possible values are `HubAndSpoke` and `Mesh`.
        :param pulumi.Input[_builtins.bool] delete_existing_peering_enabled: Indicates whether to remove current existing Virtual Network Peering in the Connectivity Configuration affected scope. Possible values are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: A description of the Connectivity Configuration.
        :param pulumi.Input[_builtins.bool] global_mesh_enabled: Indicates whether to global mesh is supported. Possible values are `true` and `false`.
        :param pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs'] hub: A `hub` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Connectivity Configuration. Changing this forces a new Network Manager Connectivity Configuration to be created.
        :param pulumi.Input[_builtins.str] network_manager_id: Specifies the ID of the Network Manager. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        if applies_to_groups is not None:
            pulumi.set(__self__, "applies_to_groups", applies_to_groups)
        if connectivity_topology is not None:
            pulumi.set(__self__, "connectivity_topology", connectivity_topology)
        if delete_existing_peering_enabled is not None:
            pulumi.set(__self__, "delete_existing_peering_enabled", delete_existing_peering_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if global_mesh_enabled is not None:
            pulumi.set(__self__, "global_mesh_enabled", global_mesh_enabled)
        if hub is not None:
            pulumi.set(__self__, "hub", hub)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_manager_id is not None:
            pulumi.set(__self__, "network_manager_id", network_manager_id)

    @_builtins.property
    @pulumi.getter(name="appliesToGroups")
    def applies_to_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]]]:
        """
        One or more `applies_to_group` blocks as defined below.
        """
        return pulumi.get(self, "applies_to_groups")

    @applies_to_groups.setter
    def applies_to_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagerConnectivityConfigurationAppliesToGroupArgs']]]]):
        pulumi.set(self, "applies_to_groups", value)

    @_builtins.property
    @pulumi.getter(name="connectivityTopology")
    def connectivity_topology(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the connectivity topology type. Possible values are `HubAndSpoke` and `Mesh`.
        """
        return pulumi.get(self, "connectivity_topology")

    @connectivity_topology.setter
    def connectivity_topology(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connectivity_topology", value)

    @_builtins.property
    @pulumi.getter(name="deleteExistingPeeringEnabled")
    def delete_existing_peering_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to remove current existing Virtual Network Peering in the Connectivity Configuration affected scope. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "delete_existing_peering_enabled")

    @delete_existing_peering_enabled.setter
    def delete_existing_peering_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_existing_peering_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the Connectivity Configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="globalMeshEnabled")
    def global_mesh_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to global mesh is supported. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "global_mesh_enabled")

    @global_mesh_enabled.setter
    def global_mesh_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "global_mesh_enabled", value)

    @_builtins.property
    @pulumi.getter
    def hub(self) -> Optional[pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs']]:
        """
        A `hub` block as defined below.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: Optional[pulumi.Input['NetworkManagerConnectivityConfigurationHubArgs']]):
        pulumi.set(self, "hub", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Connectivity Configuration. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Network Manager. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        return pulumi.get(self, "network_manager_id")

    @network_manager_id.setter
    def network_manager_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_manager_id", value)


@pulumi.type_token("azure:network/networkManagerConnectivityConfiguration:NetworkManagerConnectivityConfiguration")
class NetworkManagerConnectivityConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applies_to_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerConnectivityConfigurationAppliesToGroupArgs', 'NetworkManagerConnectivityConfigurationAppliesToGroupArgsDict']]]]] = None,
                 connectivity_topology: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_existing_peering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 global_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub: Optional[pulumi.Input[Union['NetworkManagerConnectivityConfigurationHubArgs', 'NetworkManagerConnectivityConfigurationHubArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager Connectivity Configuration.

        > **Note:** The `network.NetworkManagerConnectivityConfiguration` deployment may modify or delete existing Network Peering resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-group",
            network_manager_id=example_network_manager.id)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-net",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            flow_timeout_in_minutes=10)
        example2 = azure.network.NetworkManagerNetworkGroup("example2",
            name="example-group2",
            network_manager_id=example_network_manager.id)
        example_network_manager_connectivity_configuration = azure.network.NetworkManagerConnectivityConfiguration("example",
            name="example-connectivity-conf",
            network_manager_id=example_network_manager.id,
            connectivity_topology="HubAndSpoke",
            applies_to_groups=[
                {
                    "group_connectivity": "DirectlyConnected",
                    "network_group_id": example_network_manager_network_group.id,
                },
                {
                    "group_connectivity": "DirectlyConnected",
                    "network_group_id": example2.id,
                },
            ],
            hub={
                "resource_id": example_virtual_network.id,
                "resource_type": "Microsoft.Network/virtualNetworks",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Connectivity Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerConnectivityConfiguration:NetworkManagerConnectivityConfiguration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/connectivityConfigurations/configuration1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerConnectivityConfigurationAppliesToGroupArgs', 'NetworkManagerConnectivityConfigurationAppliesToGroupArgsDict']]]] applies_to_groups: One or more `applies_to_group` blocks as defined below.
        :param pulumi.Input[_builtins.str] connectivity_topology: Specifies the connectivity topology type. Possible values are `HubAndSpoke` and `Mesh`.
        :param pulumi.Input[_builtins.bool] delete_existing_peering_enabled: Indicates whether to remove current existing Virtual Network Peering in the Connectivity Configuration affected scope. Possible values are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: A description of the Connectivity Configuration.
        :param pulumi.Input[_builtins.bool] global_mesh_enabled: Indicates whether to global mesh is supported. Possible values are `true` and `false`.
        :param pulumi.Input[Union['NetworkManagerConnectivityConfigurationHubArgs', 'NetworkManagerConnectivityConfigurationHubArgsDict']] hub: A `hub` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Connectivity Configuration. Changing this forces a new Network Manager Connectivity Configuration to be created.
        :param pulumi.Input[_builtins.str] network_manager_id: Specifies the ID of the Network Manager. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerConnectivityConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Connectivity Configuration.

        > **Note:** The `network.NetworkManagerConnectivityConfiguration` deployment may modify or delete existing Network Peering resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-group",
            network_manager_id=example_network_manager.id)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-net",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            flow_timeout_in_minutes=10)
        example2 = azure.network.NetworkManagerNetworkGroup("example2",
            name="example-group2",
            network_manager_id=example_network_manager.id)
        example_network_manager_connectivity_configuration = azure.network.NetworkManagerConnectivityConfiguration("example",
            name="example-connectivity-conf",
            network_manager_id=example_network_manager.id,
            connectivity_topology="HubAndSpoke",
            applies_to_groups=[
                {
                    "group_connectivity": "DirectlyConnected",
                    "network_group_id": example_network_manager_network_group.id,
                },
                {
                    "group_connectivity": "DirectlyConnected",
                    "network_group_id": example2.id,
                },
            ],
            hub={
                "resource_id": example_virtual_network.id,
                "resource_type": "Microsoft.Network/virtualNetworks",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Connectivity Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerConnectivityConfiguration:NetworkManagerConnectivityConfiguration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/connectivityConfigurations/configuration1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerConnectivityConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerConnectivityConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applies_to_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerConnectivityConfigurationAppliesToGroupArgs', 'NetworkManagerConnectivityConfigurationAppliesToGroupArgsDict']]]]] = None,
                 connectivity_topology: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_existing_peering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 global_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub: Optional[pulumi.Input[Union['NetworkManagerConnectivityConfigurationHubArgs', 'NetworkManagerConnectivityConfigurationHubArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerConnectivityConfigurationArgs.__new__(NetworkManagerConnectivityConfigurationArgs)

            if applies_to_groups is None and not opts.urn:
                raise TypeError("Missing required property 'applies_to_groups'")
            __props__.__dict__["applies_to_groups"] = applies_to_groups
            if connectivity_topology is None and not opts.urn:
                raise TypeError("Missing required property 'connectivity_topology'")
            __props__.__dict__["connectivity_topology"] = connectivity_topology
            __props__.__dict__["delete_existing_peering_enabled"] = delete_existing_peering_enabled
            __props__.__dict__["description"] = description
            __props__.__dict__["global_mesh_enabled"] = global_mesh_enabled
            __props__.__dict__["hub"] = hub
            __props__.__dict__["name"] = name
            if network_manager_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_manager_id'")
            __props__.__dict__["network_manager_id"] = network_manager_id
        super(NetworkManagerConnectivityConfiguration, __self__).__init__(
            'azure:network/networkManagerConnectivityConfiguration:NetworkManagerConnectivityConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applies_to_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerConnectivityConfigurationAppliesToGroupArgs', 'NetworkManagerConnectivityConfigurationAppliesToGroupArgsDict']]]]] = None,
            connectivity_topology: Optional[pulumi.Input[_builtins.str]] = None,
            delete_existing_peering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            global_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            hub: Optional[pulumi.Input[Union['NetworkManagerConnectivityConfigurationHubArgs', 'NetworkManagerConnectivityConfigurationHubArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_manager_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkManagerConnectivityConfiguration':
        """
        Get an existing NetworkManagerConnectivityConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagerConnectivityConfigurationAppliesToGroupArgs', 'NetworkManagerConnectivityConfigurationAppliesToGroupArgsDict']]]] applies_to_groups: One or more `applies_to_group` blocks as defined below.
        :param pulumi.Input[_builtins.str] connectivity_topology: Specifies the connectivity topology type. Possible values are `HubAndSpoke` and `Mesh`.
        :param pulumi.Input[_builtins.bool] delete_existing_peering_enabled: Indicates whether to remove current existing Virtual Network Peering in the Connectivity Configuration affected scope. Possible values are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: A description of the Connectivity Configuration.
        :param pulumi.Input[_builtins.bool] global_mesh_enabled: Indicates whether to global mesh is supported. Possible values are `true` and `false`.
        :param pulumi.Input[Union['NetworkManagerConnectivityConfigurationHubArgs', 'NetworkManagerConnectivityConfigurationHubArgsDict']] hub: A `hub` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Connectivity Configuration. Changing this forces a new Network Manager Connectivity Configuration to be created.
        :param pulumi.Input[_builtins.str] network_manager_id: Specifies the ID of the Network Manager. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerConnectivityConfigurationState.__new__(_NetworkManagerConnectivityConfigurationState)

        __props__.__dict__["applies_to_groups"] = applies_to_groups
        __props__.__dict__["connectivity_topology"] = connectivity_topology
        __props__.__dict__["delete_existing_peering_enabled"] = delete_existing_peering_enabled
        __props__.__dict__["description"] = description
        __props__.__dict__["global_mesh_enabled"] = global_mesh_enabled
        __props__.__dict__["hub"] = hub
        __props__.__dict__["name"] = name
        __props__.__dict__["network_manager_id"] = network_manager_id
        return NetworkManagerConnectivityConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appliesToGroups")
    def applies_to_groups(self) -> pulumi.Output[Sequence['outputs.NetworkManagerConnectivityConfigurationAppliesToGroup']]:
        """
        One or more `applies_to_group` blocks as defined below.
        """
        return pulumi.get(self, "applies_to_groups")

    @_builtins.property
    @pulumi.getter(name="connectivityTopology")
    def connectivity_topology(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the connectivity topology type. Possible values are `HubAndSpoke` and `Mesh`.
        """
        return pulumi.get(self, "connectivity_topology")

    @_builtins.property
    @pulumi.getter(name="deleteExistingPeeringEnabled")
    def delete_existing_peering_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether to remove current existing Virtual Network Peering in the Connectivity Configuration affected scope. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "delete_existing_peering_enabled")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the Connectivity Configuration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="globalMeshEnabled")
    def global_mesh_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether to global mesh is supported. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "global_mesh_enabled")

    @_builtins.property
    @pulumi.getter
    def hub(self) -> pulumi.Output[Optional['outputs.NetworkManagerConnectivityConfigurationHub']]:
        """
        A `hub` block as defined below.
        """
        return pulumi.get(self, "hub")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Network Manager Connectivity Configuration. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Network Manager. Changing this forces a new Network Manager Connectivity Configuration to be created.
        """
        return pulumi.get(self, "network_manager_id")

