# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkManagerIpamPoolStaticCidrArgs', 'NetworkManagerIpamPoolStaticCidr']

@pulumi.input_type
class NetworkManagerIpamPoolStaticCidrArgs:
    def __init__(__self__, *,
                 ipam_pool_id: pulumi.Input[_builtins.str],
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_ip_addresses_to_allocate: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerIpamPoolStaticCidr resource.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the Network Manager IP Address Management (IPAM) Pool. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_prefixes: Specifies a list of IPv4 or IPv6 IP address prefixes which will be allocated to the Static CIDR.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager IPAM Pool Static CIDR. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[_builtins.str] number_of_ip_addresses_to_allocate: The number of IP addresses to allocate to the Static CIDR. The value must be a string representing a positive integer which is a positive power of 2, e.g., `"16"`.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_ip_addresses_to_allocate is not None:
            pulumi.set(__self__, "number_of_ip_addresses_to_allocate", number_of_ip_addresses_to_allocate)

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Network Manager IP Address Management (IPAM) Pool. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of IPv4 or IPv6 IP address prefixes which will be allocated to the Static CIDR.

        > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "address_prefixes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Network Manager IPAM Pool Static CIDR. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfIpAddressesToAllocate")
    def number_of_ip_addresses_to_allocate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of IP addresses to allocate to the Static CIDR. The value must be a string representing a positive integer which is a positive power of 2, e.g., `"16"`.

        > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        return pulumi.get(self, "number_of_ip_addresses_to_allocate")

    @number_of_ip_addresses_to_allocate.setter
    def number_of_ip_addresses_to_allocate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "number_of_ip_addresses_to_allocate", value)


@pulumi.input_type
class _NetworkManagerIpamPoolStaticCidrState:
    def __init__(__self__, *,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_ip_addresses_to_allocate: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerIpamPoolStaticCidr resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_prefixes: Specifies a list of IPv4 or IPv6 IP address prefixes which will be allocated to the Static CIDR.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the Network Manager IP Address Management (IPAM) Pool. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager IPAM Pool Static CIDR. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[_builtins.str] number_of_ip_addresses_to_allocate: The number of IP addresses to allocate to the Static CIDR. The value must be a string representing a positive integer which is a positive power of 2, e.g., `"16"`.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if ipam_pool_id is not None:
            pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_ip_addresses_to_allocate is not None:
            pulumi.set(__self__, "number_of_ip_addresses_to_allocate", number_of_ip_addresses_to_allocate)

    @_builtins.property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of IPv4 or IPv6 IP address prefixes which will be allocated to the Static CIDR.

        > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        return pulumi.get(self, "address_prefixes")

    @address_prefixes.setter
    def address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "address_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Network Manager IP Address Management (IPAM) Pool. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Network Manager IPAM Pool Static CIDR. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfIpAddressesToAllocate")
    def number_of_ip_addresses_to_allocate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of IP addresses to allocate to the Static CIDR. The value must be a string representing a positive integer which is a positive power of 2, e.g., `"16"`.

        > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        return pulumi.get(self, "number_of_ip_addresses_to_allocate")

    @number_of_ip_addresses_to_allocate.setter
    def number_of_ip_addresses_to_allocate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "number_of_ip_addresses_to_allocate", value)


@pulumi.type_token("azure:network/networkManagerIpamPoolStaticCidr:NetworkManagerIpamPoolStaticCidr")
class NetworkManagerIpamPoolStaticCidr(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_ip_addresses_to_allocate: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager IPAM Pool Static CIDR.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-nm",
            resource_group_name=example.name,
            location=example.location,
            scope={
                "subscription_ids": [current.id],
            })
        example_network_manager_ipam_pool = azure.network.NetworkManagerIpamPool("example",
            name="example-ipampool",
            network_manager_id=example_network_manager.id,
            location=example.location,
            display_name="ipampool1",
            address_prefixes=["10.0.0.0/24"])
        example_network_manager_ipam_pool_static_cidr = azure.network.NetworkManagerIpamPoolStaticCidr("example",
            name="example-ipsc",
            ipam_pool_id=example_network_manager_ipam_pool.id,
            address_prefixes=[
                "10.0.0.0/26",
                "10.0.0.128/27",
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager IPAM Pool Static CIDRs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerIpamPoolStaticCidr:NetworkManagerIpamPoolStaticCidr example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/ipamPools/pool1/staticCidrs/cidr1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_prefixes: Specifies a list of IPv4 or IPv6 IP address prefixes which will be allocated to the Static CIDR.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the Network Manager IP Address Management (IPAM) Pool. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager IPAM Pool Static CIDR. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[_builtins.str] number_of_ip_addresses_to_allocate: The number of IP addresses to allocate to the Static CIDR. The value must be a string representing a positive integer which is a positive power of 2, e.g., `"16"`.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerIpamPoolStaticCidrArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager IPAM Pool Static CIDR.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-nm",
            resource_group_name=example.name,
            location=example.location,
            scope={
                "subscription_ids": [current.id],
            })
        example_network_manager_ipam_pool = azure.network.NetworkManagerIpamPool("example",
            name="example-ipampool",
            network_manager_id=example_network_manager.id,
            location=example.location,
            display_name="ipampool1",
            address_prefixes=["10.0.0.0/24"])
        example_network_manager_ipam_pool_static_cidr = azure.network.NetworkManagerIpamPoolStaticCidr("example",
            name="example-ipsc",
            ipam_pool_id=example_network_manager_ipam_pool.id,
            address_prefixes=[
                "10.0.0.0/26",
                "10.0.0.128/27",
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager IPAM Pool Static CIDRs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerIpamPoolStaticCidr:NetworkManagerIpamPoolStaticCidr example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/ipamPools/pool1/staticCidrs/cidr1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerIpamPoolStaticCidrArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerIpamPoolStaticCidrArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_ip_addresses_to_allocate: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerIpamPoolStaticCidrArgs.__new__(NetworkManagerIpamPoolStaticCidrArgs)

            __props__.__dict__["address_prefixes"] = address_prefixes
            if ipam_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_pool_id'")
            __props__.__dict__["ipam_pool_id"] = ipam_pool_id
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_ip_addresses_to_allocate"] = number_of_ip_addresses_to_allocate
        super(NetworkManagerIpamPoolStaticCidr, __self__).__init__(
            'azure:network/networkManagerIpamPoolStaticCidr:NetworkManagerIpamPoolStaticCidr',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_ip_addresses_to_allocate: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkManagerIpamPoolStaticCidr':
        """
        Get an existing NetworkManagerIpamPoolStaticCidr resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_prefixes: Specifies a list of IPv4 or IPv6 IP address prefixes which will be allocated to the Static CIDR.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the Network Manager IP Address Management (IPAM) Pool. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager IPAM Pool Static CIDR. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        :param pulumi.Input[_builtins.str] number_of_ip_addresses_to_allocate: The number of IP addresses to allocate to the Static CIDR. The value must be a string representing a positive integer which is a positive power of 2, e.g., `"16"`.
               
               > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerIpamPoolStaticCidrState.__new__(_NetworkManagerIpamPoolStaticCidrState)

        __props__.__dict__["address_prefixes"] = address_prefixes
        __props__.__dict__["ipam_pool_id"] = ipam_pool_id
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_ip_addresses_to_allocate"] = number_of_ip_addresses_to_allocate
        return NetworkManagerIpamPoolStaticCidr(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of IPv4 or IPv6 IP address prefixes which will be allocated to the Static CIDR.

        > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        return pulumi.get(self, "address_prefixes")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Network Manager IP Address Management (IPAM) Pool. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Network Manager IPAM Pool Static CIDR. Changing this forces a new Network Manager IPAM Pool Static CIDR to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numberOfIpAddressesToAllocate")
    def number_of_ip_addresses_to_allocate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The number of IP addresses to allocate to the Static CIDR. The value must be a string representing a positive integer which is a positive power of 2, e.g., `"16"`.

        > **Note:** Exactly one of `address_prefixes` or `number_of_ip_addresses_to_allocate` must be specified.
        """
        return pulumi.get(self, "number_of_ip_addresses_to_allocate")

