# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkManagerRoutingRuleArgs', 'NetworkManagerRoutingRule']

@pulumi.input_type
class NetworkManagerRoutingRuleArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['NetworkManagerRoutingRuleDestinationArgs'],
                 next_hop: pulumi.Input['NetworkManagerRoutingRuleNextHopArgs'],
                 rule_collection_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerRoutingRule resource.
        :param pulumi.Input['NetworkManagerRoutingRuleDestinationArgs'] destination: A `destination` block as defined below.
        :param pulumi.Input['NetworkManagerRoutingRuleNextHopArgs'] next_hop: A `next_hop` block as defined below.
        :param pulumi.Input[_builtins.str] rule_collection_id: The ID of the Network Manager Routing Rule Collection to which this rule belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: A description for the routing rule.
        :param pulumi.Input[_builtins.str] name: The name of the Network Manager Routing Rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "rule_collection_id", rule_collection_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['NetworkManagerRoutingRuleDestinationArgs']:
        """
        A `destination` block as defined below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['NetworkManagerRoutingRuleDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input['NetworkManagerRoutingRuleNextHopArgs']:
        """
        A `next_hop` block as defined below.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input['NetworkManagerRoutingRuleNextHopArgs']):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="ruleCollectionId")
    def rule_collection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Network Manager Routing Rule Collection to which this rule belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rule_collection_id")

    @rule_collection_id.setter
    def rule_collection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_collection_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the routing rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network Manager Routing Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkManagerRoutingRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['NetworkManagerRoutingRuleDestinationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input['NetworkManagerRoutingRuleNextHopArgs']] = None,
                 rule_collection_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerRoutingRule resources.
        :param pulumi.Input[_builtins.str] description: A description for the routing rule.
        :param pulumi.Input['NetworkManagerRoutingRuleDestinationArgs'] destination: A `destination` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Network Manager Routing Rule. Changing this forces a new resource to be created.
        :param pulumi.Input['NetworkManagerRoutingRuleNextHopArgs'] next_hop: A `next_hop` block as defined below.
        :param pulumi.Input[_builtins.str] rule_collection_id: The ID of the Network Manager Routing Rule Collection to which this rule belongs. Changing this forces a new resource to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if rule_collection_id is not None:
            pulumi.set(__self__, "rule_collection_id", rule_collection_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the routing rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['NetworkManagerRoutingRuleDestinationArgs']]:
        """
        A `destination` block as defined below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['NetworkManagerRoutingRuleDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network Manager Routing Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input['NetworkManagerRoutingRuleNextHopArgs']]:
        """
        A `next_hop` block as defined below.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input['NetworkManagerRoutingRuleNextHopArgs']]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="ruleCollectionId")
    def rule_collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Network Manager Routing Rule Collection to which this rule belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rule_collection_id")

    @rule_collection_id.setter
    def rule_collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_collection_id", value)


@pulumi.type_token("azure:network/networkManagerRoutingRule:NetworkManagerRoutingRule")
class NetworkManagerRoutingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['NetworkManagerRoutingRuleDestinationArgs', 'NetworkManagerRoutingRuleDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[Union['NetworkManagerRoutingRuleNextHopArgs', 'NetworkManagerRoutingRuleNextHopArgsDict']]] = None,
                 rule_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            resource_group_name=example.name,
            location=example.location,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=["Routing"])
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_configuration = azure.network.NetworkManagerRoutingConfiguration("example",
            name="example-routing-configuration",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_rule_collection = azure.network.NetworkManagerRoutingRuleCollection("example",
            name="example-routing-rule-collection",
            routing_configuration_id=example_network_manager_routing_configuration.id,
            network_group_ids=[example_network_manager_network_group.id],
            description="example routing rule collection")
        example_network_manager_routing_rule = azure.network.NetworkManagerRoutingRule("example",
            name="example-routing-rule",
            rule_collection_id=example_network_manager_routing_rule_collection.id,
            description="example routing rule",
            destination={
                "type": "AddressPrefix",
                "address": "10.0.0.0/24",
            },
            next_hop={
                "type": "VirtualNetworkGateway",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Routing Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerRoutingRule:NetworkManagerRoutingRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/routingConfigurations/conf1/ruleCollections/collection1/rules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the routing rule.
        :param pulumi.Input[Union['NetworkManagerRoutingRuleDestinationArgs', 'NetworkManagerRoutingRuleDestinationArgsDict']] destination: A `destination` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Network Manager Routing Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['NetworkManagerRoutingRuleNextHopArgs', 'NetworkManagerRoutingRuleNextHopArgsDict']] next_hop: A `next_hop` block as defined below.
        :param pulumi.Input[_builtins.str] rule_collection_id: The ID of the Network Manager Routing Rule Collection to which this rule belongs. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerRoutingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            resource_group_name=example.name,
            location=example.location,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=["Routing"])
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_configuration = azure.network.NetworkManagerRoutingConfiguration("example",
            name="example-routing-configuration",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_rule_collection = azure.network.NetworkManagerRoutingRuleCollection("example",
            name="example-routing-rule-collection",
            routing_configuration_id=example_network_manager_routing_configuration.id,
            network_group_ids=[example_network_manager_network_group.id],
            description="example routing rule collection")
        example_network_manager_routing_rule = azure.network.NetworkManagerRoutingRule("example",
            name="example-routing-rule",
            rule_collection_id=example_network_manager_routing_rule_collection.id,
            description="example routing rule",
            destination={
                "type": "AddressPrefix",
                "address": "10.0.0.0/24",
            },
            next_hop={
                "type": "VirtualNetworkGateway",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Routing Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerRoutingRule:NetworkManagerRoutingRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/routingConfigurations/conf1/ruleCollections/collection1/rules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerRoutingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerRoutingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['NetworkManagerRoutingRuleDestinationArgs', 'NetworkManagerRoutingRuleDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[Union['NetworkManagerRoutingRuleNextHopArgs', 'NetworkManagerRoutingRuleNextHopArgsDict']]] = None,
                 rule_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerRoutingRuleArgs.__new__(NetworkManagerRoutingRuleArgs)

            __props__.__dict__["description"] = description
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["name"] = name
            if next_hop is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop'")
            __props__.__dict__["next_hop"] = next_hop
            if rule_collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_collection_id'")
            __props__.__dict__["rule_collection_id"] = rule_collection_id
        super(NetworkManagerRoutingRule, __self__).__init__(
            'azure:network/networkManagerRoutingRule:NetworkManagerRoutingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['NetworkManagerRoutingRuleDestinationArgs', 'NetworkManagerRoutingRuleDestinationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            next_hop: Optional[pulumi.Input[Union['NetworkManagerRoutingRuleNextHopArgs', 'NetworkManagerRoutingRuleNextHopArgsDict']]] = None,
            rule_collection_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkManagerRoutingRule':
        """
        Get an existing NetworkManagerRoutingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the routing rule.
        :param pulumi.Input[Union['NetworkManagerRoutingRuleDestinationArgs', 'NetworkManagerRoutingRuleDestinationArgsDict']] destination: A `destination` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Network Manager Routing Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['NetworkManagerRoutingRuleNextHopArgs', 'NetworkManagerRoutingRuleNextHopArgsDict']] next_hop: A `next_hop` block as defined below.
        :param pulumi.Input[_builtins.str] rule_collection_id: The ID of the Network Manager Routing Rule Collection to which this rule belongs. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerRoutingRuleState.__new__(_NetworkManagerRoutingRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["name"] = name
        __props__.__dict__["next_hop"] = next_hop
        __props__.__dict__["rule_collection_id"] = rule_collection_id
        return NetworkManagerRoutingRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for the routing rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.NetworkManagerRoutingRuleDestination']:
        """
        A `destination` block as defined below.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Network Manager Routing Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Output['outputs.NetworkManagerRoutingRuleNextHop']:
        """
        A `next_hop` block as defined below.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="ruleCollectionId")
    def rule_collection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Network Manager Routing Rule Collection to which this rule belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rule_collection_id")

