# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkManagerStaticMemberArgs', 'NetworkManagerStaticMember']

@pulumi.input_type
class NetworkManagerStaticMemberArgs:
    def __init__(__self__, *,
                 network_group_id: pulumi.Input[_builtins.str],
                 target_virtual_network_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerStaticMember resource.
        :param pulumi.Input[_builtins.str] network_group_id: Specifies the ID of the Network Manager Group. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] target_virtual_network_id: Specifies the Resource ID of the Virtual Network using as the Static Member. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        pulumi.set(__self__, "network_group_id", network_group_id)
        pulumi.set(__self__, "target_virtual_network_id", target_virtual_network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkGroupId")
    def network_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Network Manager Group. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "network_group_id")

    @network_group_id.setter
    def network_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_group_id", value)

    @_builtins.property
    @pulumi.getter(name="targetVirtualNetworkId")
    def target_virtual_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Resource ID of the Virtual Network using as the Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "target_virtual_network_id")

    @target_virtual_network_id.setter
    def target_virtual_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_virtual_network_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkManagerStaticMemberState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerStaticMember resources.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Static Member. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] network_group_id: Specifies the ID of the Network Manager Group. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] region: The region of the Network Manager Static Member.
        :param pulumi.Input[_builtins.str] target_virtual_network_id: Specifies the Resource ID of the Virtual Network using as the Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_group_id is not None:
            pulumi.set(__self__, "network_group_id", network_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_virtual_network_id is not None:
            pulumi.set(__self__, "target_virtual_network_id", target_virtual_network_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkGroupId")
    def network_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Network Manager Group. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "network_group_id")

    @network_group_id.setter
    def network_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_group_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the Network Manager Static Member.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetVirtualNetworkId")
    def target_virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Resource ID of the Virtual Network using as the Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "target_virtual_network_id")

    @target_virtual_network_id.setter
    def target_virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_virtual_network_id", value)


@pulumi.type_token("azure:network/networkManagerStaticMember:NetworkManagerStaticMember")
class NetworkManagerStaticMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager Static Member.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-group",
            network_manager_id=example_network_manager.id,
            description="example network group")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            resource_group_name=example.name,
            address_spaces=["192.168.1.0/24"],
            location=example.location)
        example_network_manager_static_member = azure.network.NetworkManagerStaticMember("example",
            name="example-nmsm",
            network_group_id=example_network_manager_network_group.id,
            target_virtual_network_id=example_virtual_network.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Static Member can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerStaticMember:NetworkManagerStaticMember example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/networkGroups/networkGroup1/staticMembers/staticMember1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Static Member. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] network_group_id: Specifies the ID of the Network Manager Group. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] target_virtual_network_id: Specifies the Resource ID of the Virtual Network using as the Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerStaticMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Static Member.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-group",
            network_manager_id=example_network_manager.id,
            description="example network group")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            resource_group_name=example.name,
            address_spaces=["192.168.1.0/24"],
            location=example.location)
        example_network_manager_static_member = azure.network.NetworkManagerStaticMember("example",
            name="example-nmsm",
            network_group_id=example_network_manager_network_group.id,
            target_virtual_network_id=example_virtual_network.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Static Member can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerStaticMember:NetworkManagerStaticMember example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/networkGroups/networkGroup1/staticMembers/staticMember1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerStaticMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerStaticMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerStaticMemberArgs.__new__(NetworkManagerStaticMemberArgs)

            __props__.__dict__["name"] = name
            if network_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_group_id'")
            __props__.__dict__["network_group_id"] = network_group_id
            if target_virtual_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_virtual_network_id'")
            __props__.__dict__["target_virtual_network_id"] = target_virtual_network_id
            __props__.__dict__["region"] = None
        super(NetworkManagerStaticMember, __self__).__init__(
            'azure:network/networkManagerStaticMember:NetworkManagerStaticMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            target_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkManagerStaticMember':
        """
        Get an existing NetworkManagerStaticMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Static Member. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] network_group_id: Specifies the ID of the Network Manager Group. Changing this forces a new Network Manager Static Member to be created.
        :param pulumi.Input[_builtins.str] region: The region of the Network Manager Static Member.
        :param pulumi.Input[_builtins.str] target_virtual_network_id: Specifies the Resource ID of the Virtual Network using as the Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerStaticMemberState.__new__(_NetworkManagerStaticMemberState)

        __props__.__dict__["name"] = name
        __props__.__dict__["network_group_id"] = network_group_id
        __props__.__dict__["region"] = region
        __props__.__dict__["target_virtual_network_id"] = target_virtual_network_id
        return NetworkManagerStaticMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Network Manager Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkGroupId")
    def network_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Network Manager Group. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "network_group_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the Network Manager Static Member.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="targetVirtualNetworkId")
    def target_virtual_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Resource ID of the Virtual Network using as the Static Member. Changing this forces a new Network Manager Static Member to be created.
        """
        return pulumi.get(self, "target_virtual_network_id")

