# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentArgs', 'NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent']

@pulumi.input_type
class NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentArgs:
    def __init__(__self__, *,
                 destination_resource_id: pulumi.Input[_builtins.str],
                 ip_traffic: pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs'],
                 source_resource_id: pulumi.Input[_builtins.str],
                 verifier_workspace_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent resource.
        :param pulumi.Input[_builtins.str] destination_resource_id: The ID of the destination resource. The value can be the ID of either Public internet, Cosmos DB, Storage Account, SQL Server, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs'] ip_traffic: An `ip_traffic` block as defined below. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of the source resource. The value can be the ID of either Public internet, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] verifier_workspace_id: The ID of the Network Manager Verifier Workspace. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] description: The description of the resource. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Verifier Workspace Reachability Analysis Intent. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        pulumi.set(__self__, "destination_resource_id", destination_resource_id)
        pulumi.set(__self__, "ip_traffic", ip_traffic)
        pulumi.set(__self__, "source_resource_id", source_resource_id)
        pulumi.set(__self__, "verifier_workspace_id", verifier_workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the destination resource. The value can be the ID of either Public internet, Cosmos DB, Storage Account, SQL Server, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "destination_resource_id")

    @destination_resource_id.setter
    def destination_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="ipTraffic")
    def ip_traffic(self) -> pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs']:
        """
        An `ip_traffic` block as defined below. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "ip_traffic")

    @ip_traffic.setter
    def ip_traffic(self, value: pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs']):
        pulumi.set(self, "ip_traffic", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the source resource. The value can be the ID of either Public internet, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="verifierWorkspaceId")
    def verifier_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Network Manager Verifier Workspace. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "verifier_workspace_id")

    @verifier_workspace_id.setter
    def verifier_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "verifier_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the resource. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Network Manager Verifier Workspace Reachability Analysis Intent. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_traffic: Optional[pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 verifier_workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent resources.
        :param pulumi.Input[_builtins.str] description: The description of the resource. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] destination_resource_id: The ID of the destination resource. The value can be the ID of either Public internet, Cosmos DB, Storage Account, SQL Server, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs'] ip_traffic: An `ip_traffic` block as defined below. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Verifier Workspace Reachability Analysis Intent. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of the source resource. The value can be the ID of either Public internet, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] verifier_workspace_id: The ID of the Network Manager Verifier Workspace. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_resource_id is not None:
            pulumi.set(__self__, "destination_resource_id", destination_resource_id)
        if ip_traffic is not None:
            pulumi.set(__self__, "ip_traffic", ip_traffic)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if verifier_workspace_id is not None:
            pulumi.set(__self__, "verifier_workspace_id", verifier_workspace_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the resource. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the destination resource. The value can be the ID of either Public internet, Cosmos DB, Storage Account, SQL Server, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "destination_resource_id")

    @destination_resource_id.setter
    def destination_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="ipTraffic")
    def ip_traffic(self) -> Optional[pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs']]:
        """
        An `ip_traffic` block as defined below. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "ip_traffic")

    @ip_traffic.setter
    def ip_traffic(self, value: Optional[pulumi.Input['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs']]):
        pulumi.set(self, "ip_traffic", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Network Manager Verifier Workspace Reachability Analysis Intent. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source resource. The value can be the ID of either Public internet, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="verifierWorkspaceId")
    def verifier_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Network Manager Verifier Workspace. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "verifier_workspace_id")

    @verifier_workspace_id.setter
    def verifier_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verifier_workspace_id", value)


@pulumi.type_token("azure:network/networkManagerVerifierWorkspaceReachabilityAnalysisIntent:NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent")
class NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_traffic: Optional[pulumi.Input[Union['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs', 'NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 verifier_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager Verifier Workspace Reachability Analysis Intent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-nm",
            resource_group_name=example.name,
            location=example.location,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=["Connectivity"])
        example_network_manager_verifier_workspace = azure.network.NetworkManagerVerifierWorkspace("example",
            name="example",
            network_manager_id=example_network_manager.id,
            location=example.location)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_B1ls",
            admin_username="adminuser",
            admin_password="P@ssw0rd1234!",
            disable_password_authentication=False,
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_network_manager_verifier_workspace_reachability_analysis_intent = azure.network.NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent("example",
            name="example-intent",
            verifier_workspace_id=example_network_manager_verifier_workspace.id,
            source_resource_id=example_linux_virtual_machine.id,
            destination_resource_id=example_linux_virtual_machine.id,
            description="example",
            ip_traffic={
                "source_ips": ["10.0.2.1"],
                "source_ports": ["80"],
                "destination_ips": ["10.0.2.2"],
                "destination_ports": ["*"],
                "protocols": ["Any"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Verifier Workspace Reachability Analysis Intents can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerVerifierWorkspaceReachabilityAnalysisIntent:NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/verifierWorkspaces/workspace1/reachabilityAnalysisIntents/intent1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the resource. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] destination_resource_id: The ID of the destination resource. The value can be the ID of either Public internet, Cosmos DB, Storage Account, SQL Server, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[Union['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs', 'NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgsDict']] ip_traffic: An `ip_traffic` block as defined below. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Verifier Workspace Reachability Analysis Intent. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of the source resource. The value can be the ID of either Public internet, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] verifier_workspace_id: The ID of the Network Manager Verifier Workspace. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Verifier Workspace Reachability Analysis Intent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-nm",
            resource_group_name=example.name,
            location=example.location,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=["Connectivity"])
        example_network_manager_verifier_workspace = azure.network.NetworkManagerVerifierWorkspace("example",
            name="example",
            network_manager_id=example_network_manager.id,
            location=example.location)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_B1ls",
            admin_username="adminuser",
            admin_password="P@ssw0rd1234!",
            disable_password_authentication=False,
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_network_manager_verifier_workspace_reachability_analysis_intent = azure.network.NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent("example",
            name="example-intent",
            verifier_workspace_id=example_network_manager_verifier_workspace.id,
            source_resource_id=example_linux_virtual_machine.id,
            destination_resource_id=example_linux_virtual_machine.id,
            description="example",
            ip_traffic={
                "source_ips": ["10.0.2.1"],
                "source_ports": ["80"],
                "destination_ips": ["10.0.2.2"],
                "destination_ports": ["*"],
                "protocols": ["Any"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Manager Verifier Workspace Reachability Analysis Intents can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerVerifierWorkspaceReachabilityAnalysisIntent:NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/verifierWorkspaces/workspace1/reachabilityAnalysisIntents/intent1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_traffic: Optional[pulumi.Input[Union['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs', 'NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 verifier_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentArgs.__new__(NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentArgs)

            __props__.__dict__["description"] = description
            if destination_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_resource_id'")
            __props__.__dict__["destination_resource_id"] = destination_resource_id
            if ip_traffic is None and not opts.urn:
                raise TypeError("Missing required property 'ip_traffic'")
            __props__.__dict__["ip_traffic"] = ip_traffic
            __props__.__dict__["name"] = name
            if source_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_resource_id'")
            __props__.__dict__["source_resource_id"] = source_resource_id
            if verifier_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'verifier_workspace_id'")
            __props__.__dict__["verifier_workspace_id"] = verifier_workspace_id
        super(NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent, __self__).__init__(
            'azure:network/networkManagerVerifierWorkspaceReachabilityAnalysisIntent:NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_traffic: Optional[pulumi.Input[Union['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs', 'NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            verifier_workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent':
        """
        Get an existing NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the resource. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] destination_resource_id: The ID of the destination resource. The value can be the ID of either Public internet, Cosmos DB, Storage Account, SQL Server, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[Union['NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgs', 'NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficArgsDict']] ip_traffic: An `ip_traffic` block as defined below. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Verifier Workspace Reachability Analysis Intent. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of the source resource. The value can be the ID of either Public internet, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        :param pulumi.Input[_builtins.str] verifier_workspace_id: The ID of the Network Manager Verifier Workspace. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentState.__new__(_NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_resource_id"] = destination_resource_id
        __props__.__dict__["ip_traffic"] = ip_traffic
        __props__.__dict__["name"] = name
        __props__.__dict__["source_resource_id"] = source_resource_id
        __props__.__dict__["verifier_workspace_id"] = verifier_workspace_id
        return NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the resource. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the destination resource. The value can be the ID of either Public internet, Cosmos DB, Storage Account, SQL Server, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "destination_resource_id")

    @_builtins.property
    @pulumi.getter(name="ipTraffic")
    def ip_traffic(self) -> pulumi.Output['outputs.NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic']:
        """
        An `ip_traffic` block as defined below. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "ip_traffic")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Network Manager Verifier Workspace Reachability Analysis Intent. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the source resource. The value can be the ID of either Public internet, Virtual machines, or Subnet. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @_builtins.property
    @pulumi.getter(name="verifierWorkspaceId")
    def verifier_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Network Manager Verifier Workspace. Changing this forces a new Network Manager Verifier Workspace Reachability Analysis Intent to be created.
        """
        return pulumi.get(self, "verifier_workspace_id")

