# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkWatcherFlowLogArgs', 'NetworkWatcherFlowLog']

@pulumi.input_type
class NetworkWatcherFlowLogArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 network_watcher_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 retention_policy: pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs'],
                 storage_account_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_analytics: Optional[pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NetworkWatcherFlowLog resource.
        :param pulumi.Input[_builtins.bool] enabled: Should Network Flow Logging be Enabled?
        :param pulumi.Input[_builtins.str] network_watcher_name: The name of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Network Watcher was deployed. Changing this forces a new resource to be created.
        :param pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs'] retention_policy: A `retention_policy` block as documented below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where flow logs are stored.
        :param pulumi.Input[_builtins.str] location: The location where the Network Watcher Flow Log resides. Changing this forces a new resource to be created. Defaults to the `location` of the Network Watcher.
        :param pulumi.Input[_builtins.str] name: The name of the Network Watcher Flow Log. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Network Watcher Flow Log.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Resource for which to enable flow logs for.
               
               > **Note:** As of July 30, 2025, it is no longer possible to create new flow logs for Network Security Groups.
        :param pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs'] traffic_analytics: A `traffic_analytics` block as documented below.
        :param pulumi.Input[_builtins.int] version: The version (revision) of the flow log. Possible values are `1` and `2`. Defaults to `1`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "network_watcher_name", network_watcher_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "retention_policy", retention_policy)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group_id is not None:
            warnings.warn("""The property `network_security_group_id` has been superseded by `target_resource_id` and will be removed in version 5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""network_security_group_id is deprecated: The property `network_security_group_id` has been superseded by `target_resource_id` and will be removed in version 5.0 of the AzureRM Provider.""")
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if traffic_analytics is not None:
            pulumi.set(__self__, "traffic_analytics", traffic_analytics)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Should Network Flow Logging be Enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkWatcherName")
    def network_watcher_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Network Watcher. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_watcher_name")

    @network_watcher_name.setter
    def network_watcher_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_watcher_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Network Watcher was deployed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs']:
        """
        A `retention_policy` block as documented below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs']):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Storage Account where flow logs are stored.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Network Watcher Flow Log resides. Changing this forces a new resource to be created. Defaults to the `location` of the Network Watcher.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network Watcher Flow Log. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    @_utilities.deprecated("""The property `network_security_group_id` has been superseded by `target_resource_id` and will be removed in version 5.0 of the AzureRM Provider.""")
    def network_security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "network_security_group_id")

    @network_security_group_id.setter
    def network_security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Network Watcher Flow Log.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Resource for which to enable flow logs for.

        > **Note:** As of July 30, 2025, it is no longer possible to create new flow logs for Network Security Groups.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="trafficAnalytics")
    def traffic_analytics(self) -> Optional[pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs']]:
        """
        A `traffic_analytics` block as documented below.
        """
        return pulumi.get(self, "traffic_analytics")

    @traffic_analytics.setter
    def traffic_analytics(self, value: Optional[pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs']]):
        pulumi.set(self, "traffic_analytics", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version (revision) of the flow log. Possible values are `1` and `2`. Defaults to `1`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _NetworkWatcherFlowLogState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_watcher_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs']] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_analytics: Optional[pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NetworkWatcherFlowLog resources.
        :param pulumi.Input[_builtins.bool] enabled: Should Network Flow Logging be Enabled?
        :param pulumi.Input[_builtins.str] location: The location where the Network Watcher Flow Log resides. Changing this forces a new resource to be created. Defaults to the `location` of the Network Watcher.
        :param pulumi.Input[_builtins.str] name: The name of the Network Watcher Flow Log. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_watcher_name: The name of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Network Watcher was deployed. Changing this forces a new resource to be created.
        :param pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs'] retention_policy: A `retention_policy` block as documented below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where flow logs are stored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Network Watcher Flow Log.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Resource for which to enable flow logs for.
               
               > **Note:** As of July 30, 2025, it is no longer possible to create new flow logs for Network Security Groups.
        :param pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs'] traffic_analytics: A `traffic_analytics` block as documented below.
        :param pulumi.Input[_builtins.int] version: The version (revision) of the flow log. Possible values are `1` and `2`. Defaults to `1`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group_id is not None:
            warnings.warn("""The property `network_security_group_id` has been superseded by `target_resource_id` and will be removed in version 5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""network_security_group_id is deprecated: The property `network_security_group_id` has been superseded by `target_resource_id` and will be removed in version 5.0 of the AzureRM Provider.""")
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if network_watcher_name is not None:
            pulumi.set(__self__, "network_watcher_name", network_watcher_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if traffic_analytics is not None:
            pulumi.set(__self__, "traffic_analytics", traffic_analytics)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Network Flow Logging be Enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Network Watcher Flow Log resides. Changing this forces a new resource to be created. Defaults to the `location` of the Network Watcher.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network Watcher Flow Log. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    @_utilities.deprecated("""The property `network_security_group_id` has been superseded by `target_resource_id` and will be removed in version 5.0 of the AzureRM Provider.""")
    def network_security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "network_security_group_id")

    @network_security_group_id.setter
    def network_security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="networkWatcherName")
    def network_watcher_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network Watcher. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_watcher_name")

    @network_watcher_name.setter
    def network_watcher_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_watcher_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Network Watcher was deployed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs']]:
        """
        A `retention_policy` block as documented below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['NetworkWatcherFlowLogRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account where flow logs are stored.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Network Watcher Flow Log.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Resource for which to enable flow logs for.

        > **Note:** As of July 30, 2025, it is no longer possible to create new flow logs for Network Security Groups.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="trafficAnalytics")
    def traffic_analytics(self) -> Optional[pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs']]:
        """
        A `traffic_analytics` block as documented below.
        """
        return pulumi.get(self, "traffic_analytics")

    @traffic_analytics.setter
    def traffic_analytics(self, value: Optional[pulumi.Input['NetworkWatcherFlowLogTrafficAnalyticsArgs']]):
        pulumi.set(self, "traffic_analytics", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version (revision) of the flow log. Possible values are `1` and `2`. Defaults to `1`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:network/networkWatcherFlowLog:NetworkWatcherFlowLog")
class NetworkWatcherFlowLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_watcher_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[Union['NetworkWatcherFlowLogRetentionPolicyArgs', 'NetworkWatcherFlowLogRetentionPolicyArgsDict']]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_analytics: Optional[pulumi.Input[Union['NetworkWatcherFlowLogTrafficAnalyticsArgs', 'NetworkWatcherFlowLogTrafficAnalyticsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Network Watcher Flow Log.

        > **Note:** The `network.NetworkWatcherFlowLog` creates a new storage lifecyle management rule that overwrites existing rules. Please make sure to use a `storage_account` with no existing management rules, until the issue is fixed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.network.NetworkSecurityGroup("test",
            name="acctestnsg",
            location=example.location,
            resource_group_name=example.name)
        test_network_watcher = azure.network.NetworkWatcher("test",
            name="acctestnw",
            location=example.location,
            resource_group_name=example.name)
        test_account = azure.storage.Account("test",
            name="acctestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_kind="StorageV2",
            account_replication_type="LRS",
            https_traffic_only_enabled=True)
        test_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("test",
            name="acctestlaw",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        test_network_watcher_flow_log = azure.network.NetworkWatcherFlowLog("test",
            network_watcher_name=test_network_watcher.name,
            resource_group_name=example.name,
            name="example-log",
            target_resource_id=test.id,
            storage_account_id=test_account.id,
            enabled=True,
            retention_policy={
                "enabled": True,
                "days": 7,
            },
            traffic_analytics={
                "enabled": True,
                "workspace_id": test_analytics_workspace.workspace_id,
                "workspace_region": test_analytics_workspace.location,
                "workspace_resource_id": test_analytics_workspace.id,
                "interval_in_minutes": 10,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Watcher Flow Logs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkWatcherFlowLog:NetworkWatcherFlowLog watcher1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkWatchers/watcher1/flowLogs/log1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Should Network Flow Logging be Enabled?
        :param pulumi.Input[_builtins.str] location: The location where the Network Watcher Flow Log resides. Changing this forces a new resource to be created. Defaults to the `location` of the Network Watcher.
        :param pulumi.Input[_builtins.str] name: The name of the Network Watcher Flow Log. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_watcher_name: The name of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Network Watcher was deployed. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['NetworkWatcherFlowLogRetentionPolicyArgs', 'NetworkWatcherFlowLogRetentionPolicyArgsDict']] retention_policy: A `retention_policy` block as documented below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where flow logs are stored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Network Watcher Flow Log.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Resource for which to enable flow logs for.
               
               > **Note:** As of July 30, 2025, it is no longer possible to create new flow logs for Network Security Groups.
        :param pulumi.Input[Union['NetworkWatcherFlowLogTrafficAnalyticsArgs', 'NetworkWatcherFlowLogTrafficAnalyticsArgsDict']] traffic_analytics: A `traffic_analytics` block as documented below.
        :param pulumi.Input[_builtins.int] version: The version (revision) of the flow log. Possible values are `1` and `2`. Defaults to `1`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkWatcherFlowLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Watcher Flow Log.

        > **Note:** The `network.NetworkWatcherFlowLog` creates a new storage lifecyle management rule that overwrites existing rules. Please make sure to use a `storage_account` with no existing management rules, until the issue is fixed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.network.NetworkSecurityGroup("test",
            name="acctestnsg",
            location=example.location,
            resource_group_name=example.name)
        test_network_watcher = azure.network.NetworkWatcher("test",
            name="acctestnw",
            location=example.location,
            resource_group_name=example.name)
        test_account = azure.storage.Account("test",
            name="acctestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_kind="StorageV2",
            account_replication_type="LRS",
            https_traffic_only_enabled=True)
        test_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("test",
            name="acctestlaw",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        test_network_watcher_flow_log = azure.network.NetworkWatcherFlowLog("test",
            network_watcher_name=test_network_watcher.name,
            resource_group_name=example.name,
            name="example-log",
            target_resource_id=test.id,
            storage_account_id=test_account.id,
            enabled=True,
            retention_policy={
                "enabled": True,
                "days": 7,
            },
            traffic_analytics={
                "enabled": True,
                "workspace_id": test_analytics_workspace.workspace_id,
                "workspace_region": test_analytics_workspace.location,
                "workspace_resource_id": test_analytics_workspace.id,
                "interval_in_minutes": 10,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Network Watcher Flow Logs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkWatcherFlowLog:NetworkWatcherFlowLog watcher1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkWatchers/watcher1/flowLogs/log1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkWatcherFlowLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkWatcherFlowLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_watcher_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[Union['NetworkWatcherFlowLogRetentionPolicyArgs', 'NetworkWatcherFlowLogRetentionPolicyArgsDict']]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_analytics: Optional[pulumi.Input[Union['NetworkWatcherFlowLogTrafficAnalyticsArgs', 'NetworkWatcherFlowLogTrafficAnalyticsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkWatcherFlowLogArgs.__new__(NetworkWatcherFlowLogArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_security_group_id"] = network_security_group_id
            if network_watcher_name is None and not opts.urn:
                raise TypeError("Missing required property 'network_watcher_name'")
            __props__.__dict__["network_watcher_name"] = network_watcher_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if retention_policy is None and not opts.urn:
                raise TypeError("Missing required property 'retention_policy'")
            __props__.__dict__["retention_policy"] = retention_policy
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_resource_id"] = target_resource_id
            __props__.__dict__["traffic_analytics"] = traffic_analytics
            __props__.__dict__["version"] = version
        super(NetworkWatcherFlowLog, __self__).__init__(
            'azure:network/networkWatcherFlowLog:NetworkWatcherFlowLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_watcher_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_policy: Optional[pulumi.Input[Union['NetworkWatcherFlowLogRetentionPolicyArgs', 'NetworkWatcherFlowLogRetentionPolicyArgsDict']]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_analytics: Optional[pulumi.Input[Union['NetworkWatcherFlowLogTrafficAnalyticsArgs', 'NetworkWatcherFlowLogTrafficAnalyticsArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'NetworkWatcherFlowLog':
        """
        Get an existing NetworkWatcherFlowLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Should Network Flow Logging be Enabled?
        :param pulumi.Input[_builtins.str] location: The location where the Network Watcher Flow Log resides. Changing this forces a new resource to be created. Defaults to the `location` of the Network Watcher.
        :param pulumi.Input[_builtins.str] name: The name of the Network Watcher Flow Log. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_watcher_name: The name of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Network Watcher was deployed. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['NetworkWatcherFlowLogRetentionPolicyArgs', 'NetworkWatcherFlowLogRetentionPolicyArgsDict']] retention_policy: A `retention_policy` block as documented below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where flow logs are stored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Network Watcher Flow Log.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Resource for which to enable flow logs for.
               
               > **Note:** As of July 30, 2025, it is no longer possible to create new flow logs for Network Security Groups.
        :param pulumi.Input[Union['NetworkWatcherFlowLogTrafficAnalyticsArgs', 'NetworkWatcherFlowLogTrafficAnalyticsArgsDict']] traffic_analytics: A `traffic_analytics` block as documented below.
        :param pulumi.Input[_builtins.int] version: The version (revision) of the flow log. Possible values are `1` and `2`. Defaults to `1`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkWatcherFlowLogState.__new__(_NetworkWatcherFlowLogState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_security_group_id"] = network_security_group_id
        __props__.__dict__["network_watcher_name"] = network_watcher_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_policy"] = retention_policy
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["traffic_analytics"] = traffic_analytics
        __props__.__dict__["version"] = version
        return NetworkWatcherFlowLog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Should Network Flow Logging be Enabled?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the Network Watcher Flow Log resides. Changing this forces a new resource to be created. Defaults to the `location` of the Network Watcher.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Network Watcher Flow Log. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    @_utilities.deprecated("""The property `network_security_group_id` has been superseded by `target_resource_id` and will be removed in version 5.0 of the AzureRM Provider.""")
    def network_security_group_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter(name="networkWatcherName")
    def network_watcher_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Network Watcher. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_watcher_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Network Watcher was deployed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output['outputs.NetworkWatcherFlowLogRetentionPolicy']:
        """
        A `retention_policy` block as documented below.
        """
        return pulumi.get(self, "retention_policy")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Storage Account where flow logs are stored.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Network Watcher Flow Log.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Resource for which to enable flow logs for.

        > **Note:** As of July 30, 2025, it is no longer possible to create new flow logs for Network Security Groups.
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="trafficAnalytics")
    def traffic_analytics(self) -> pulumi.Output[Optional['outputs.NetworkWatcherFlowLogTrafficAnalytics']]:
        """
        A `traffic_analytics` block as documented below.
        """
        return pulumi.get(self, "traffic_analytics")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version (revision) of the flow log. Possible values are `1` and `2`. Defaults to `1`.
        """
        return pulumi.get(self, "version")

