# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubnetRouteTableAssociationArgs', 'SubnetRouteTableAssociation']

@pulumi.input_type
class SubnetRouteTableAssociationArgs:
    def __init__(__self__, *,
                 route_table_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SubnetRouteTableAssociation resource.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Route Table which should be associated with the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _SubnetRouteTableAssociationState:
    def __init__(__self__, *,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SubnetRouteTableAssociation resources.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Route Table which should be associated with the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("azure:network/subnetRouteTableAssociation:SubnetRouteTableAssociation")
class SubnetRouteTableAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Associates a Route Table with a Subnet within a Virtual Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="frontend",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_route_table = azure.network.RouteTable("example",
            name="example-routetable",
            location=example.location,
            resource_group_name=example.name,
            routes=[{
                "name": "example",
                "address_prefix": "10.100.0.0/14",
                "next_hop_type": "VirtualAppliance",
                "next_hop_in_ip_address": "10.10.1.1",
            }])
        example_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("example",
            subnet_id=example_subnet.id,
            route_table_id=example_route_table.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Subnet Route Table Associations can be imported using the `resource id` of the Subnet, e.g.

        ```sh
        $ pulumi import azure:network/subnetRouteTableAssociation:SubnetRouteTableAssociation association1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/subnets/mysubnet1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetRouteTableAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a Route Table with a Subnet within a Virtual Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="frontend",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_route_table = azure.network.RouteTable("example",
            name="example-routetable",
            location=example.location,
            resource_group_name=example.name,
            routes=[{
                "name": "example",
                "address_prefix": "10.100.0.0/14",
                "next_hop_type": "VirtualAppliance",
                "next_hop_in_ip_address": "10.10.1.1",
            }])
        example_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("example",
            subnet_id=example_subnet.id,
            route_table_id=example_route_table.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Subnet Route Table Associations can be imported using the `resource id` of the Subnet, e.g.

        ```sh
        $ pulumi import azure:network/subnetRouteTableAssociation:SubnetRouteTableAssociation association1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1/subnets/mysubnet1
        ```

        :param str resource_name: The name of the resource.
        :param SubnetRouteTableAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetRouteTableAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetRouteTableAssociationArgs.__new__(SubnetRouteTableAssociationArgs)

            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
        super(SubnetRouteTableAssociation, __self__).__init__(
            'azure:network/subnetRouteTableAssociation:SubnetRouteTableAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SubnetRouteTableAssociation':
        """
        Get an existing SubnetRouteTableAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table which should be associated with the Subnet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetRouteTableAssociationState.__new__(_SubnetRouteTableAssociationState)

        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["subnet_id"] = subnet_id
        return SubnetRouteTableAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Route Table which should be associated with the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

