# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpnGatewayConnectionArgs', 'VpnGatewayConnection']

@pulumi.input_type
class VpnGatewayConnectionArgs:
    def __init__(__self__, *,
                 remote_vpn_site_id: pulumi.Input[_builtins.str],
                 vpn_gateway_id: pulumi.Input[_builtins.str],
                 vpn_links: pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]],
                 internet_security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing: Optional[pulumi.Input['VpnGatewayConnectionRoutingArgs']] = None,
                 traffic_selector_policies: Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]]] = None):
        """
        The set of arguments for constructing a VpnGatewayConnection resource.
        :param pulumi.Input[_builtins.str] remote_vpn_site_id: The ID of the remote VPN Site, which will connect to the VPN Gateway. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway Connection belongs to. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]] vpn_links: One or more `vpn_link` blocks as defined below.
        :param pulumi.Input[_builtins.bool] internet_security_enabled: Whether Internet Security is enabled for this VPN Connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this VPN Gateway Connection. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input['VpnGatewayConnectionRoutingArgs'] routing: A `routing` block as defined below. If this is not specified, there will be a default route table created implicitly.
        :param pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]] traffic_selector_policies: One or more `traffic_selector_policy` blocks as defined below.
        """
        pulumi.set(__self__, "remote_vpn_site_id", remote_vpn_site_id)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        pulumi.set(__self__, "vpn_links", vpn_links)
        if internet_security_enabled is not None:
            pulumi.set(__self__, "internet_security_enabled", internet_security_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if traffic_selector_policies is not None:
            pulumi.set(__self__, "traffic_selector_policies", traffic_selector_policies)

    @_builtins.property
    @pulumi.getter(name="remoteVpnSiteId")
    def remote_vpn_site_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the remote VPN Site, which will connect to the VPN Gateway. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "remote_vpn_site_id")

    @remote_vpn_site_id.setter
    def remote_vpn_site_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_vpn_site_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPN Gateway that this VPN Gateway Connection belongs to. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpn_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnLinks")
    def vpn_links(self) -> pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]]:
        """
        One or more `vpn_link` blocks as defined below.
        """
        return pulumi.get(self, "vpn_links")

    @vpn_links.setter
    def vpn_links(self, value: pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]]):
        pulumi.set(self, "vpn_links", value)

    @_builtins.property
    @pulumi.getter(name="internetSecurityEnabled")
    def internet_security_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Internet Security is enabled for this VPN Connection. Defaults to `false`.
        """
        return pulumi.get(self, "internet_security_enabled")

    @internet_security_enabled.setter
    def internet_security_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_security_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this VPN Gateway Connection. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['VpnGatewayConnectionRoutingArgs']]:
        """
        A `routing` block as defined below. If this is not specified, there will be a default route table created implicitly.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['VpnGatewayConnectionRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter(name="trafficSelectorPolicies")
    def traffic_selector_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]]]:
        """
        One or more `traffic_selector_policy` blocks as defined below.
        """
        return pulumi.get(self, "traffic_selector_policies")

    @traffic_selector_policies.setter
    def traffic_selector_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]]]):
        pulumi.set(self, "traffic_selector_policies", value)


@pulumi.input_type
class _VpnGatewayConnectionState:
    def __init__(__self__, *,
                 internet_security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_vpn_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 routing: Optional[pulumi.Input['VpnGatewayConnectionRoutingArgs']] = None,
                 traffic_selector_policies: Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_links: Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]]] = None):
        """
        Input properties used for looking up and filtering VpnGatewayConnection resources.
        :param pulumi.Input[_builtins.bool] internet_security_enabled: Whether Internet Security is enabled for this VPN Connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this VPN Gateway Connection. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[_builtins.str] remote_vpn_site_id: The ID of the remote VPN Site, which will connect to the VPN Gateway. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input['VpnGatewayConnectionRoutingArgs'] routing: A `routing` block as defined below. If this is not specified, there will be a default route table created implicitly.
        :param pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]] traffic_selector_policies: One or more `traffic_selector_policy` blocks as defined below.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway Connection belongs to. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]] vpn_links: One or more `vpn_link` blocks as defined below.
        """
        if internet_security_enabled is not None:
            pulumi.set(__self__, "internet_security_enabled", internet_security_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_vpn_site_id is not None:
            pulumi.set(__self__, "remote_vpn_site_id", remote_vpn_site_id)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if traffic_selector_policies is not None:
            pulumi.set(__self__, "traffic_selector_policies", traffic_selector_policies)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if vpn_links is not None:
            pulumi.set(__self__, "vpn_links", vpn_links)

    @_builtins.property
    @pulumi.getter(name="internetSecurityEnabled")
    def internet_security_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Internet Security is enabled for this VPN Connection. Defaults to `false`.
        """
        return pulumi.get(self, "internet_security_enabled")

    @internet_security_enabled.setter
    def internet_security_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_security_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this VPN Gateway Connection. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remoteVpnSiteId")
    def remote_vpn_site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the remote VPN Site, which will connect to the VPN Gateway. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "remote_vpn_site_id")

    @remote_vpn_site_id.setter
    def remote_vpn_site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_vpn_site_id", value)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['VpnGatewayConnectionRoutingArgs']]:
        """
        A `routing` block as defined below. If this is not specified, there will be a default route table created implicitly.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['VpnGatewayConnectionRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter(name="trafficSelectorPolicies")
    def traffic_selector_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]]]:
        """
        One or more `traffic_selector_policy` blocks as defined below.
        """
        return pulumi.get(self, "traffic_selector_policies")

    @traffic_selector_policies.setter
    def traffic_selector_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionTrafficSelectorPolicyArgs']]]]):
        pulumi.set(self, "traffic_selector_policies", value)

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPN Gateway that this VPN Gateway Connection belongs to. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnLinks")
    def vpn_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]]]:
        """
        One or more `vpn_link` blocks as defined below.
        """
        return pulumi.get(self, "vpn_links")

    @vpn_links.setter
    def vpn_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnGatewayConnectionVpnLinkArgs']]]]):
        pulumi.set(self, "vpn_links", value)


@pulumi.type_token("azure:network/vpnGatewayConnection:VpnGatewayConnection")
class VpnGatewayConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_vpn_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 routing: Optional[pulumi.Input[Union['VpnGatewayConnectionRoutingArgs', 'VpnGatewayConnectionRoutingArgsDict']]] = None,
                 traffic_selector_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionTrafficSelectorPolicyArgs', 'VpnGatewayConnectionTrafficSelectorPolicyArgsDict']]]]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionVpnLinkArgs', 'VpnGatewayConnectionVpnLinkArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a VPN Gateway Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-hub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.0.0/24")
        example_vpn_gateway = azure.network.VpnGateway("example",
            name="example-vpng",
            location=example.location,
            resource_group_name=example.name,
            virtual_hub_id=example_virtual_hub.id)
        example_vpn_site = azure.network.VpnSite("example",
            name="example-vpn-site",
            location=example.location,
            resource_group_name=example.name,
            virtual_wan_id=example_virtual_wan.id,
            links=[
                {
                    "name": "link1",
                    "ip_address": "10.1.0.0",
                },
                {
                    "name": "link2",
                    "ip_address": "10.2.0.0",
                },
            ])
        example_vpn_gateway_connection = azure.network.VpnGatewayConnection("example",
            name="example",
            vpn_gateway_id=example_vpn_gateway.id,
            remote_vpn_site_id=example_vpn_site.id,
            vpn_links=[
                {
                    "name": "link1",
                    "vpn_site_link_id": example_vpn_site.links[0].id,
                },
                {
                    "name": "link2",
                    "vpn_site_link_id": example_vpn_site.links[1].id,
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        VPN Gateway Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/vpnGatewayConnection:VpnGatewayConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/conn1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] internet_security_enabled: Whether Internet Security is enabled for this VPN Connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this VPN Gateway Connection. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[_builtins.str] remote_vpn_site_id: The ID of the remote VPN Site, which will connect to the VPN Gateway. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[Union['VpnGatewayConnectionRoutingArgs', 'VpnGatewayConnectionRoutingArgsDict']] routing: A `routing` block as defined below. If this is not specified, there will be a default route table created implicitly.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionTrafficSelectorPolicyArgs', 'VpnGatewayConnectionTrafficSelectorPolicyArgsDict']]]] traffic_selector_policies: One or more `traffic_selector_policy` blocks as defined below.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway Connection belongs to. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionVpnLinkArgs', 'VpnGatewayConnectionVpnLinkArgsDict']]]] vpn_links: One or more `vpn_link` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnGatewayConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPN Gateway Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-hub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.0.0/24")
        example_vpn_gateway = azure.network.VpnGateway("example",
            name="example-vpng",
            location=example.location,
            resource_group_name=example.name,
            virtual_hub_id=example_virtual_hub.id)
        example_vpn_site = azure.network.VpnSite("example",
            name="example-vpn-site",
            location=example.location,
            resource_group_name=example.name,
            virtual_wan_id=example_virtual_wan.id,
            links=[
                {
                    "name": "link1",
                    "ip_address": "10.1.0.0",
                },
                {
                    "name": "link2",
                    "ip_address": "10.2.0.0",
                },
            ])
        example_vpn_gateway_connection = azure.network.VpnGatewayConnection("example",
            name="example",
            vpn_gateway_id=example_vpn_gateway.id,
            remote_vpn_site_id=example_vpn_site.id,
            vpn_links=[
                {
                    "name": "link1",
                    "vpn_site_link_id": example_vpn_site.links[0].id,
                },
                {
                    "name": "link2",
                    "vpn_site_link_id": example_vpn_site.links[1].id,
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        VPN Gateway Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/vpnGatewayConnection:VpnGatewayConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/vpnGateways/gateway1/vpnConnections/conn1
        ```

        :param str resource_name: The name of the resource.
        :param VpnGatewayConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnGatewayConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_vpn_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 routing: Optional[pulumi.Input[Union['VpnGatewayConnectionRoutingArgs', 'VpnGatewayConnectionRoutingArgsDict']]] = None,
                 traffic_selector_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionTrafficSelectorPolicyArgs', 'VpnGatewayConnectionTrafficSelectorPolicyArgsDict']]]]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionVpnLinkArgs', 'VpnGatewayConnectionVpnLinkArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnGatewayConnectionArgs.__new__(VpnGatewayConnectionArgs)

            __props__.__dict__["internet_security_enabled"] = internet_security_enabled
            __props__.__dict__["name"] = name
            if remote_vpn_site_id is None and not opts.urn:
                raise TypeError("Missing required property 'remote_vpn_site_id'")
            __props__.__dict__["remote_vpn_site_id"] = remote_vpn_site_id
            __props__.__dict__["routing"] = routing
            __props__.__dict__["traffic_selector_policies"] = traffic_selector_policies
            if vpn_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_gateway_id'")
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
            if vpn_links is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_links'")
            __props__.__dict__["vpn_links"] = vpn_links
        super(VpnGatewayConnection, __self__).__init__(
            'azure:network/vpnGatewayConnection:VpnGatewayConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            internet_security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            remote_vpn_site_id: Optional[pulumi.Input[_builtins.str]] = None,
            routing: Optional[pulumi.Input[Union['VpnGatewayConnectionRoutingArgs', 'VpnGatewayConnectionRoutingArgsDict']]] = None,
            traffic_selector_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionTrafficSelectorPolicyArgs', 'VpnGatewayConnectionTrafficSelectorPolicyArgsDict']]]]] = None,
            vpn_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionVpnLinkArgs', 'VpnGatewayConnectionVpnLinkArgsDict']]]]] = None) -> 'VpnGatewayConnection':
        """
        Get an existing VpnGatewayConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] internet_security_enabled: Whether Internet Security is enabled for this VPN Connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this VPN Gateway Connection. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[_builtins.str] remote_vpn_site_id: The ID of the remote VPN Site, which will connect to the VPN Gateway. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[Union['VpnGatewayConnectionRoutingArgs', 'VpnGatewayConnectionRoutingArgsDict']] routing: A `routing` block as defined below. If this is not specified, there will be a default route table created implicitly.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionTrafficSelectorPolicyArgs', 'VpnGatewayConnectionTrafficSelectorPolicyArgsDict']]]] traffic_selector_policies: One or more `traffic_selector_policy` blocks as defined below.
        :param pulumi.Input[_builtins.str] vpn_gateway_id: The ID of the VPN Gateway that this VPN Gateway Connection belongs to. Changing this forces a new VPN Gateway Connection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnGatewayConnectionVpnLinkArgs', 'VpnGatewayConnectionVpnLinkArgsDict']]]] vpn_links: One or more `vpn_link` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnGatewayConnectionState.__new__(_VpnGatewayConnectionState)

        __props__.__dict__["internet_security_enabled"] = internet_security_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["remote_vpn_site_id"] = remote_vpn_site_id
        __props__.__dict__["routing"] = routing
        __props__.__dict__["traffic_selector_policies"] = traffic_selector_policies
        __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        __props__.__dict__["vpn_links"] = vpn_links
        return VpnGatewayConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="internetSecurityEnabled")
    def internet_security_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether Internet Security is enabled for this VPN Connection. Defaults to `false`.
        """
        return pulumi.get(self, "internet_security_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this VPN Gateway Connection. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="remoteVpnSiteId")
    def remote_vpn_site_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the remote VPN Site, which will connect to the VPN Gateway. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "remote_vpn_site_id")

    @_builtins.property
    @pulumi.getter
    def routing(self) -> pulumi.Output['outputs.VpnGatewayConnectionRouting']:
        """
        A `routing` block as defined below. If this is not specified, there will be a default route table created implicitly.
        """
        return pulumi.get(self, "routing")

    @_builtins.property
    @pulumi.getter(name="trafficSelectorPolicies")
    def traffic_selector_policies(self) -> pulumi.Output[Optional[Sequence['outputs.VpnGatewayConnectionTrafficSelectorPolicy']]]:
        """
        One or more `traffic_selector_policy` blocks as defined below.
        """
        return pulumi.get(self, "traffic_selector_policies")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPN Gateway that this VPN Gateway Connection belongs to. Changing this forces a new VPN Gateway Connection to be created.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @_builtins.property
    @pulumi.getter(name="vpnLinks")
    def vpn_links(self) -> pulumi.Output[Sequence['outputs.VpnGatewayConnectionVpnLink']]:
        """
        One or more `vpn_link` blocks as defined below.
        """
        return pulumi.get(self, "vpn_links")

